/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.propelling.runtime.model.xunt;

import com.kingdee.eas.rpts.ctrlreport.propelling.runtime.model.xunt.XuntExtMessage;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.util.StringUtil;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XuntMessageAdapter
implements IMessageAdapter {
    public static SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private XuntExtMessage rptMessage;
    private URL hyperlink;
    private String appId;
    private String eid;
    private String type;

    public XuntMessageAdapter(XuntExtMessage rptMessage, URL hyperlink) {
        this.rptMessage = rptMessage;
        this.hyperlink = hyperlink;
    }

    public void clearTemporary() {
    }

    public Map<String, Object> getContent() {
        String url = this.hyperlink.toString();
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("date", FORMATTER.format(this.getUpdateTime()));
        message.put("title", this.rptMessage.title());
        message.put("text", this.rptMessage.text());
        if (this.appId != null) {
            url = url + "&appid=" + this.appId + "&storeEid=3650173";
            message.put("todo", "0");
            message.put("appid", this.appId);
        }
        if (this.eid != null) {
            url = url + "&eid=" + this.eid;
            message.put("eid", this.eid);
        }
        message.put("url", url);
        if (this.rptMessage.pic() != null) {
            message.put("pic", StringUtil.getBase64FromByte((byte[])this.rptMessage.pic()));
        }
        message.put("name", "tip.png");
        return message;
    }

    public MessageModelEnum getModel() {
        return this.rptMessage.pic() == null ? MessageModelEnum.SINGLETEXT : MessageModelEnum.SINGLEGRAPHIC;
    }

    public MessageTypeEnum getType() {
        if (StringUtil.isEmpty((String)this.type)) {
            return MessageTypeEnum.GRAPHIC;
        }
        if ("TEXT".equalsIgnoreCase(this.type)) {
            return MessageTypeEnum.TEXT;
        }
        if ("IMAGE".equalsIgnoreCase(this.type)) {
            return MessageTypeEnum.IMAGE;
        }
        if ("LINK".equalsIgnoreCase(this.type)) {
            return MessageTypeEnum.LINK;
        }
        return MessageTypeEnum.GRAPHIC;
    }

    public Date getUpdateTime() {
        return this.rptMessage.date();
    }

    public List<String> getUsers() {
        return this.rptMessage.getUsers();
    }

    public boolean isNeedSendXT() {
        return true;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setEid(String eid) {
        this.eid = eid;
    }

    public void setType(String type) {
        this.type = type;
    }
}

