/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.recycle.server;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.reportmeta.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.recycle.DeletedReportInfo;
import com.kingdee.eas.rpts.ctrlreport.recycle.ReportRecycleBinException;
import com.kingdee.eas.rpts.ctrlreport.recycle.server.IReportRecycleBinController;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class ReportRecycleBinControllerBean
extends AbstractBOSObject
implements IReportRecycleBinController {
    private static final Logger log = CommonLogger.getLogger(ReportRecycleBinControllerBean.class);
    private static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"ReportRecycleBinControllerBean");
    private boolean isMobile;

    public ReportRecycleBinControllerBean() {
    }

    public ReportRecycleBinControllerBean(Context easCtx) {
        super(easCtx);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    @Override
    public boolean isMobile() {
        return this.isMobile;
    }

    @Override
    public void setMobile(boolean isMobile) {
        this.isMobile = isMobile;
    }

    private String getMobileWhere() {
        return this.getMobileWhere("");
    }

    private String getMobileWhere(String tableAlias) {
        if (!StringUtil.isEmptyString((String)tableAlias)) {
            tableAlias = tableAlias + ".";
        }
        return this.isMobile ? " and " + tableAlias + "FTempletType = " + 2 : " and " + tableAlias + "FTempletType <> " + 2;
    }

    @Override
    public boolean copyDeletedReportInfo(List<String> idList) throws ReportRecycleBinException {
        if (idList == null || idList.size() == 0) {
            throw new IllegalArgumentException("idList can not be empty!");
        }
        String strId = this.createIdString(idList);
        StringBuffer sqlInsertBuf = new StringBuffer();
        sqlInsertBuf.append("INSERT INTO T_EXT_DELETEREPORT");
        sqlInsertBuf.append(" (FID,FReportID,FName_l1,FName_l2,FName_l3,FSystemID,FContent,FLength,FCreatorID,FCreateTime,FOrgID,FCloudRptCenterId,FTempletType,FDeleteTime, fDeleterId)");
        sqlInsertBuf.append(" SELECT CONCAT('DEL_', FID),FID,FName_l1,FName_l2,FName_l3,FSystemID,FContent,FLength,FCreatorID,FCreateTime,FOrgID,FCloudRptCenterId,FTempletType,now(),'" + this.getContext().getCaller().toString() + "'");
        sqlInsertBuf.append(" FROM T_BAS_DEFINEREPORT where fid in (").append(strId).append(")");
        boolean success = false;
        try {
            DbUtil.executeUpdate(sqlInsertBuf.toString(), null);
            success = true;
        }
        catch (SQLException e) {
            String msgInfo = "\u5c06\u62a5\u8868\u653e\u5165\u62a5\u8868\u56de\u6536\u7ad9\u5931\u8d25!";
            log.error((Object)msgInfo, (Throwable)e);
            throw new ReportRecycleBinException(msgInfo, e);
        }
        return success;
    }

    private String createIdString(List<String> idList) {
        StringBuffer strBufId = new StringBuffer();
        for (String id : idList) {
            strBufId.append("'").append(id).append("',");
        }
        return strBufId.substring(0, strBufId.length() - 1);
    }

    @Override
    public List<DeletedReportInfo> getAllDeletedReports() throws ReportRecycleBinException {
        String selectSql = this.getSelectSql();
        selectSql = selectSql + " order by r.fDeleteTime desc";
        Object[] p = new Object[]{this.getCurrentOrgId()};
        List<DeletedReportInfo> infoList = this.selectReportInfoList(selectSql, p);
        return infoList;
    }

    private String getSelectSql() {
        return "select r.fid, r.fName_l2 as reportName, r.fSystemId, r.fDeleteTime, ud.fName_l2 as deleterName, r.fCreateTime, uc.fName_l2 as creatorName, org.fName_l2 as orgName, r.FTempletType from T_EXT_DELETEREPORT r left join t_pm_user ud on ud.fid = r.fDeleterId left join t_pm_user uc on uc.fid = r.fCreatorId left join T_ORG_BaseUnit org on r.FOrgID = org.fid where r.FOrgID = ?" + this.getMobileWhere("r");
    }

    private String getCurrentOrgId() {
        return BISystem.getCurrentOrgUnitID((Context)this.getContext());
    }

    private List<DeletedReportInfo> selectReportInfoList(String selectSql, Object[] params) throws ReportRecycleBinException {
        IRowSet rs = null;
        ArrayList<DeletedReportInfo> infoList = null;
        try {
            rs = DbUtil.executeQuery(selectSql, params);
            infoList = new ArrayList<DeletedReportInfo>();
            while (rs.next()) {
                DeletedReportInfo reportInfo = new DeletedReportInfo();
                reportInfo.setId(rs.getString("fid"));
                reportInfo.setReportName(rs.getString("reportName"));
                reportInfo.setSystemId(rs.getString("fsystemId"));
                reportInfo.setDeleteTime(rs.getDate("fDeleteTime"));
                reportInfo.setDeleterName(rs.getString("deleterName"));
                reportInfo.setCreateTime(rs.getDate("fCreateTime"));
                reportInfo.setCreatorName(rs.getString("creatorName"));
                reportInfo.setOrgName(rs.getString("orgName"));
                reportInfo.setTemplateType(rs.getString("FTempletType"));
                infoList.add(reportInfo);
            }
        }
        catch (SQLException e) {
            String msgInfo = "\u83b7\u53d6\u62a5\u8868\u56de\u6536\u7ad9\u7684\u62a5\u8868\u4fe1\u606f\u5931\u8d25\uff01";
            log.error((Object)msgInfo, (Throwable)e);
            throw new ReportRecycleBinException(msgInfo, e);
        }
        finally {
            this.closeRS(rs);
        }
        return infoList;
    }

    private void closeRS(IRowSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.error((Object)"rs close fail!", (Throwable)e);
            }
        }
    }

    @Override
    public int deleteAllReportInfo() throws ReportRecycleBinException {
        int count = 0;
        String deleteSql = "delete T_EXT_DELETEREPORT where forgId = '" + this.getCurrentOrgId() + "'" + this.getMobileWhere();
        try {
            count = DbUtil.executeUpdate(deleteSql, null);
        }
        catch (SQLException e) {
            String msgInfo = "\u5220\u9664\u62a5\u8868\u56de\u6536\u7ad9\u7684\u62a5\u8868\u4fe1\u606f\u5931\u8d25\uff01";
            log.error((Object)msgInfo, (Throwable)e);
            throw new ReportRecycleBinException(msgInfo, e);
        }
        return count;
    }

    @Override
    public int deleteReportInfoByIds(List<String> idList) throws ReportRecycleBinException {
        if (idList == null || idList.size() == 0) {
            throw new IllegalArgumentException("idList can not be empty!");
        }
        String strId = this.createIdString(idList);
        int count = 0;
        String deleteSql = "delete T_EXT_DELETEREPORT where fid in (" + strId + ")";
        try {
            count = DbUtil.executeUpdate(deleteSql, null);
        }
        catch (SQLException e) {
            String msgInfo = "\u5220\u9664\u62a5\u8868\u56de\u6536\u7ad9\u7684\u62a5\u8868\u4fe1\u606f\u5931\u8d25\uff01";
            log.error((Object)msgInfo, (Throwable)e);
            throw new ReportRecycleBinException(msgInfo, e);
        }
        return count;
    }

    @Override
    public List<DeletedReportInfo> filterDeletedReportInfo(DeletedReportInfo reportInfo) throws ReportRecycleBinException {
        if (reportInfo == null) {
            throw new IllegalArgumentException("reportInfo can not be null!");
        }
        String selectSql = this.getSelectSql();
        ArrayList<Object> pList = new ArrayList<Object>();
        pList.add(this.getCurrentOrgId());
        selectSql = this.appendFilterSqlWhere(selectSql, reportInfo, pList);
        selectSql = selectSql + " order by r.fDeleteTime desc";
        Object[] p = pList.toArray();
        List<DeletedReportInfo> infoList = this.selectReportInfoList(selectSql, p);
        return infoList;
    }

    private String appendFilterSqlWhere(String selectSql, DeletedReportInfo reportInfo, List<Object> pList) {
        Date createTimeTo;
        Date createTime;
        String creatorName;
        String creatorAccount;
        Date deleteTimeTo;
        Date deleteTime;
        String deleterName;
        String deleterAccount;
        String templateType;
        String reportName = reportInfo.getReportName();
        if (!StringUtil.isEmptyString((String)reportName)) {
            selectSql = selectSql + " and r.fName_l2 like '%" + reportName + "%'";
        }
        if (!StringUtil.isEmptyString((String)(templateType = reportInfo.getTemplateType()))) {
            selectSql = selectSql + " and r.FTempletType = ?";
            pList.add((int)Integer.valueOf(templateType));
        }
        if (!StringUtil.isEmptyString((String)(deleterAccount = reportInfo.getDeleterAccount()))) {
            selectSql = selectSql + " and ud.fNumber like '%" + deleterAccount + "%'";
        }
        if (!StringUtil.isEmptyString((String)(deleterName = reportInfo.getDeleterName()))) {
            selectSql = selectSql + " and ud.fName_l2 like '%" + deleterName + "%'";
        }
        if ((deleteTime = reportInfo.getDeleteTime()) != null) {
            selectSql = selectSql + " and r.fDeleteTime >= {ts'" + CtrlReportUtil.formatDate((Date)deleteTime) + "'}";
        }
        if ((deleteTimeTo = reportInfo.getDeleteTimeTo()) != null) {
            selectSql = selectSql + " and r.fDeleteTime <= {ts'" + CtrlReportUtil.formatDate((Date)deleteTimeTo) + " 23:59:59'}";
        }
        if (!StringUtil.isEmptyString((String)(creatorAccount = reportInfo.getCreatorAccount()))) {
            selectSql = selectSql + " and uc.fNumber like '%" + creatorAccount + "%'";
        }
        if (!StringUtil.isEmptyString((String)(creatorName = reportInfo.getCreatorName()))) {
            selectSql = selectSql + " and uc.fName_l2 like '%" + creatorName + "%'";
        }
        if ((createTime = reportInfo.getCreateTime()) != null) {
            selectSql = selectSql + " and r.fCreateTime >= {ts'" + CtrlReportUtil.formatDate((Date)createTime) + "'}";
        }
        if ((createTimeTo = reportInfo.getCreateTimeTo()) != null) {
            selectSql = selectSql + " and r.fCreateTime <= {ts'" + CtrlReportUtil.formatDate((Date)createTimeTo) + " 23:59:59'}";
        }
        return selectSql;
    }

    @Override
    public void restoreAllReportInfo() throws ReportRecycleBinException {
        String orgId = this.getCurrentOrgId();
        String strWhere = " where d.forgId = '" + orgId + "' " + this.getMobileWhere("d");
        String deleteSql = "delete from T_EXT_DELETEREPORT where forgId in ('" + orgId + "')" + this.getMobileWhere();
        this.deleteReportInfoByWhere(strWhere, deleteSql);
    }

    @Override
    public void restoreReportInfoByIds(List<String> idList) throws ReportRecycleBinException {
        if (idList == null || idList.size() == 0) {
            throw new IllegalArgumentException("idList can not be empty!");
        }
        String strId = this.createIdString(idList);
        String strWhere = " where d.fid in (" + strId + ") ";
        String deleteSql = "delete from T_EXT_DELETEREPORT where fid in (" + strId + ")";
        this.deleteReportInfoByWhere(strWhere, deleteSql);
    }

    private void deleteReportInfoByWhere(String strWhere, String deleteSql) throws ReportRecycleBinException {
        Context ctx = this.getContext();
        ArrayList<String> listSql = new ArrayList<String>();
        StringBuffer sqlInsertBuf = new StringBuffer();
        sqlInsertBuf.append("INSERT INTO T_BAS_DEFINEREPORT");
        sqlInsertBuf.append(" (FID,FName_l1,FName_l2,FName_l3,FSystemID,FContent,FLength,FCreatorID,FCreateTime,FOrgID,FCloudRptCenterId,FTempletType,FLastUpdateTime,FLastUpdateUserID,fisStdProduct,fControlUnitID)");
        sqlInsertBuf.append(" SELECT FReportID,FName_l1,FName_l2,FName_l3,FSystemID,FContent,FLength,FCreatorID,FCreateTime,FOrgID,FCloudRptCenterId,FTempletType,now(), '" + ctx.getCaller().toString() + "',0,fOrgID");
        sqlInsertBuf.append(" FROM T_EXT_DELETEREPORT d ").append(strWhere);
        listSql.add(sqlInsertBuf.toString());
        ArrayList<TempName> listName = this.handleSameName(ctx, strWhere);
        if (listName != null) {
            for (TempName tName : listName) {
                String updateNameSql = this.getUpdateNameSql(tName);
                listSql.add(updateNameSql);
            }
        }
        listSql.add(deleteSql);
        String[] sqls = new String[listSql.size()];
        listSql.toArray(sqls);
        try {
            DbUtil.executeBatchUpdateTx(ctx, sqls);
        }
        catch (SQLException e) {
            String msgInfo = "\u8fd8\u539f\u62a5\u8868\u4fe1\u606f\u5931\u8d25\uff01";
            log.error((Object)msgInfo, (Throwable)e);
            throw new ReportRecycleBinException(msgInfo, e);
        }
    }

    private String getUpdateNameSql(TempName tName) {
        String updateNameSql = "update T_BAS_DEFINEREPORT set";
        if (!StringUtil.isEmptyString((String)tName.name_l1)) {
            updateNameSql = updateNameSql + " fname_l1 = '" + tName.name_l1 + "',";
        }
        if (!StringUtil.isEmptyString((String)tName.name_l2)) {
            updateNameSql = updateNameSql + " fname_l2 = '" + tName.name_l2 + "'";
        }
        if (!StringUtil.isEmptyString((String)tName.name_l3)) {
            updateNameSql = updateNameSql + ", fname_l3 = '" + tName.name_l3 + "'";
        }
        updateNameSql = updateNameSql + " where fid = '" + tName.reportId + "'";
        return updateNameSql;
    }

    private ArrayList<TempName> handleSameName(Context ctx, String strWhere) throws ReportRecycleBinException {
        String selectDef = "select distinct r.fid, r.fname_l1, r.fname_l2, r.fname_l3, r.fsystemid, r.forgid from T_EXT_DELETEREPORT d left join T_BAS_DEFINEREPORT r on d.fsystemid = r.fsystemid and d.forgid = r.forgid" + strWhere + " and d.fname_l2 is not null order by r.fsystemid";
        String selectDel = "select freportid, fname_l1, fname_l2, fname_l3, fsystemid, forgid from T_EXT_DELETEREPORT d" + strWhere + " order by fsystemid, fname_l2";
        IRowSet rs = null;
        ArrayList<String> listKey = new ArrayList<String>();
        ArrayList<TempName> listName = new ArrayList<TempName>();
        try {
            String orgId;
            String systemId;
            rs = DbUtil.executeQuery(selectDef, null);
            if (rs != null) {
                while (rs.next()) {
                    String name_l2 = rs.getString("fname_l2");
                    systemId = rs.getString("fsystemid");
                    orgId = rs.getString("forgid");
                    if (StringUtil.isEmptyString((String)name_l2)) continue;
                    listKey.add(name_l2 + systemId + orgId);
                }
            }
            if ((rs = DbUtil.executeQuery(selectDel, null)) != null) {
                while (rs.next()) {
                    TempName tName = new TempName();
                    tName.reportId = rs.getString("freportid");
                    tName.name_l1 = rs.getString("fname_l1");
                    tName.name_l2 = rs.getString("fname_l2");
                    tName.name_l3 = rs.getString("fname_l3");
                    systemId = rs.getString("fsystemid");
                    orgId = rs.getString("forgid");
                    String key = tName.name_l2 + systemId + orgId;
                    int iSameName = 0;
                    String name_l2 = null;
                    while (listKey.contains(key)) {
                        name_l2 = tName.name_l2;
                        name_l2 = name_l2 + "\uff08" + ++iSameName + "\uff09";
                        key = name_l2 + systemId + orgId;
                    }
                    listKey.add(key);
                    if (iSameName <= 0) continue;
                    tName.name_l2 = name_l2;
                    listName.add(tName);
                }
            }
        }
        catch (SQLException e) {
            String msgInfo = "\u83b7\u53d6\u9700\u8981\u8fd8\u539f\u7684\u62a5\u8868\u4fe1\u606f\u5931\u8d25\uff01";
            log.error((Object)msgInfo, (Throwable)e);
            throw new ReportRecycleBinException(msgInfo, e);
        }
        finally {
            this.closeRS(rs);
        }
        return listName;
    }

    @Override
    public void restoreReportInfoBySystemId(List<String> idList, String systemId) throws ReportRecycleBinException {
        if (idList == null || idList.isEmpty() || StringUtil.isEmptyString((String)systemId)) {
            throw new ReportRecycleBinException("idList or systemId can not be empty!");
        }
        String strIdList = this.createIdString(idList);
        String updateSql = "update T_EXT_DELETEREPORT set fSystemId='" + systemId + "' where fid in(" + strIdList + ")";
        try {
            DbUtil.executeUpdate(updateSql, null);
            this.restoreReportInfoByIds(idList);
        }
        catch (SQLException e) {
            String msgInfo = "\u62a5\u8868\u8fd8\u539f\u5931\u8d25!";
            log.error((Object)msgInfo, (Throwable)e);
            throw new ReportRecycleBinException(msgInfo, e);
        }
    }

    private class TempName {
        String reportId;
        String name_l1;
        String name_l2;
        String name_l3;

        private TempName() {
        }
    }
}

