/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.util.fi;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.rpts.ctrlreport.util.fi.FIParam;
import com.kingdee.eas.rpts.ctrlreport.util.fi.FIParamIO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class FIParamEditUI
extends KDDialog {
    private static final long serialVersionUID = 1L;
    private KDTable table = new KDTable(4, 1, 0);
    private KDButton confirm = new KDButton("\u786e\u5b9a");
    private boolean isCanceled = true;

    private FIParamEditUI(KDFrame frame, Book template) {
        super((Frame)frame);
        this.setTitle("\u4e1a\u52a1\u51fd\u6570\u53d8\u91cf");
        this.setModal(true);
        this.setSize(500, 480);
        this.setResizable(false);
        KDPanel content = new KDPanel((LayoutManager)new BorderLayout());
        IRow head = this.table.getHeadRow(0);
        head.getCell(0).setValue((Object)"\u8303\u56f4");
        head.getCell(1).setValue((Object)"\u63cf\u8ff0");
        head.getCell(2).setValue((Object)"\u53d8\u91cf\u540d\u79f0");
        head.getCell(3).setValue((Object)"\u503c");
        IColumn col = this.table.getColumn(0);
        col.setWidth(40);
        col.getStyleAttributes().setLocked(true);
        col = this.table.getColumn(1);
        col.getStyleAttributes().setLocked(true);
        col = this.table.getColumn(2);
        col.getStyleAttributes().setLocked(true);
        this.table.setAutoResize(true);
        content.add((Component)this.table);
        KDPanel controller = new KDPanel((LayoutManager)new FlowLayout(2, 6, 12));
        controller.add((Component)this.confirm);
        content.add((Component)controller, (Object)"South");
        this.setContentPane((Container)content);
        this.confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FIParamEditUI.this.isCanceled = false;
                FIParamEditUI.this.dispose();
            }
        });
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo((Component)frame);
        KDTSelectManager selectManager = this.table.getSelectManager();
        selectManager.setSelectMode(1);
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                Object v;
                IRow row = FIParamEditUI.this.table.getRow(e.getRowIndex());
                FIParam p = (FIParam)row.getUserObject();
                String name = p.getName();
                if (("IncludeSub".equals(name) || "IncludeSubAccount".equals(name) || "IncludeLeaf".equals(name) || "IncludeLeafAccount".equals(name) || "IncludeAllAssistItems".equals(name)) && (v = e.getValue()) instanceof Boolean && ((Boolean)v).booleanValue()) {
                    for (int i = 0; i < FIParamEditUI.this.table.getRowCount(); ++i) {
                        row = FIParamEditUI.this.table.getRow(i);
                        p = (FIParam)row.getUserObject();
                        String name2 = p.getName();
                        if (!"IncludeSub".equals(name2) && !"IncludeSubAccount".equals(name2) && !"IncludeLeaf".equals(name2) && !"IncludeLeafAccount".equals(name2) && !"IncludeAllAssistItems".equals(name2) || name.equals(name2)) continue;
                        row.getCell(3).setValue((Object)false);
                    }
                    FIParamEditUI.this.table.repaint();
                }
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke(65, 704), "INSERTNEWPARAM");
        this.table.getActionMap().put("INSERTNEWPARAM", new AbstractAction(){
            private static final long serialVersionUID = 1L;
            private boolean isCanceled = true;

            @Override
            public void actionPerformed(ActionEvent e) {
                final KDDialog paramAddDialog = new KDDialog((Dialog)((Object)FIParamEditUI.this), "\u6dfb\u52a0\u4e1a\u52a1\u51fd\u6570\u53d8\u91cf");
                paramAddDialog.setSize(400, 300);
                paramAddDialog.setResizable(false);
                paramAddDialog.setModal(true);
                paramAddDialog.setLocationRelativeTo((Component)((Object)FIParamEditUI.this));
                paramAddDialog.setDefaultCloseOperation(2);
                KDPanel panel = new KDPanel();
                panel.setLayout(null);
                KDTextField nameField = new KDTextField();
                KDTextField descField = new KDTextField();
                Object[] item = new ComboItem[]{new ComboItem("\u5de5\u4f5c\u7c3f", "sheet1")};
                Object[] item1 = new ComboItem[]{new ComboItem("\u5e03\u5c14", 1), new ComboItem("\u65e5\u671f", 2), new ComboItem("\u901a\u7528", 0), new ComboItem("\u6570\u503c", 3)};
                KDComboBox rangeCombo = new KDComboBox(item);
                KDComboBox valueTypeCombo = new KDComboBox(item1);
                KDLabelContainer lc = new KDLabelContainer("\u540d\u79f0\uff1a     ", (JComponent)nameField);
                lc.setBoundLabelUnderline(true);
                lc.setBounds(12, 20, 376, 21);
                panel.add((Component)lc);
                lc = new KDLabelContainer("\u63cf\u8ff0\uff1a     ", (JComponent)descField);
                lc.setBoundLabelUnderline(true);
                lc.setBounds(12, 50, 376, 21);
                panel.add((Component)lc);
                lc = new KDLabelContainer("\u8303\u56f4\uff1a     ", (JComponent)rangeCombo);
                lc.setBoundLabelUnderline(true);
                lc.setBounds(12, 80, 376, 21);
                panel.add((Component)lc);
                lc = new KDLabelContainer("\u503c\u7c7b\u578b\uff1a", (JComponent)valueTypeCombo);
                lc.setBoundLabelUnderline(true);
                lc.setBounds(12, 110, 376, 21);
                panel.add((Component)lc);
                KDButton button = new KDButton("\u786e\u5b9a");
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        isCanceled = false;
                        paramAddDialog.dispose();
                    }
                });
                button.setBounds(308, 239, 80, 21);
                panel.add((Component)button);
                paramAddDialog.setContentPane((Container)panel);
                paramAddDialog.show();
                if (this.isCanceled) {
                    return;
                }
                FIParam p = new FIParam();
                p.setSheetName("sheet1").setDesc(descField.getText()).setName(nameField.getText()).setDataType(Integer.parseInt(((ComboItem)valueTypeCombo.getSelectedItem()).data.toString()));
                IRow row = FIParamEditUI.this.table.addRow();
                row.getCell(0).setValue((Object)"\u5de5\u4f5c\u7c3f");
                row.getCell(1).setValue((Object)p.getDesc());
                row.getCell(2).setValue((Object)p.getName());
                row.getCell(3).setValue(FIParamEditUI.parseValue(p));
                row.setUserObject((Object)p);
            }
        });
        this.table.getInputMap().put(KeyStroke.getKeyStroke(68, 704), "DELETEPARAM");
        this.table.getActionMap().put("DELETEPARAM", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FIParamEditUI.this.table.removeRow(FIParamEditUI.this.table.getSelectManager().getActiveRowIndex());
            }
        });
    }

    public static void showEditDialog(KDFrame frame, Book template) {
        FIParamEditUI editUI = new FIParamEditUI(frame, template);
        List<FIParam> params = FIParamIO.load(template);
        for (FIParam p : params) {
            IRow row = editUI.table.addRow();
            row.getCell(0).setValue((Object)"\u5de5\u4f5c\u7c3f");
            row.getCell(1).setValue((Object)p.getDesc());
            row.getCell(2).setValue((Object)p.getName());
            ICell cll = row.getCell(3);
            cll.setValue(FIParamEditUI.parseValue(p));
            FIParamEditUI.configCellEditor(cll, p.getName());
            row.setUserObject((Object)p);
        }
        editUI.show();
        if (!editUI.isCanceled) {
            for (int i = 0; i < editUI.table.getRowCount(); ++i) {
                IRow row = editUI.table.getRow(i);
                FIParam p = (FIParam)row.getUserObject();
                p.setValue(FIParamEditUI.serializeValue(row.getCell(3).getValue(), p.getDataType()));
            }
            FIParamIO.serialize(params, template);
        }
    }

    private static void configCellEditor(ICell cell, String variableName) {
        if ("Currency".equals(variableName)) {
            CurrencyCollection initCurrencyCollection;
            KDComboBox cb = new KDComboBox();
            try {
                initCurrencyCollection = InitDataFacadaFactory.getRemoteInstance().getCurrency();
            }
            catch (BOSException e) {
                e.printStackTrace();
                return;
            }
            int size = initCurrencyCollection.size();
            for (int i = 0; i < size; ++i) {
                cb.addItem((Object)initCurrencyCollection.get(i));
            }
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cb));
        } else if ("StartYear".equals(variableName) || "EndYear".equals(variableName) || "StartPeriod".equals(variableName) || "EndPeriod".equals(variableName)) {
            cell.setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)new KDFormattedTextField(0)));
        }
    }

    private static Object parseValue(FIParam p) {
        int dataType;
        String value;
        block12: {
            value = p.getValue();
            dataType = p.getDataType();
            if ("Currency".equals(p.getName())) {
                try {
                    CurrencyCollection collection = InitDataFacadaFactory.getRemoteInstance().getCurrency();
                    if (!StringUtil.isEmptyString((String)value)) {
                        int size = collection.size();
                        for (int i = 0; i < size; ++i) {
                            CurrencyInfo currency = collection.get(i);
                            if (!currency.getId().toString().equals(p.getValue())) continue;
                            return currency;
                        }
                        break block12;
                    }
                    return collection.get(0);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        if (dataType == 1) {
            return "Y".equals(value);
        }
        if (dataType == 2) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse(value);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return new Date();
            }
        }
        if (dataType == 3) {
            try {
                return new BigDecimal(value);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return new BigDecimal(0);
            }
        }
        return value;
    }

    private static String serializeValue(Object value, int dataType) {
        if (value instanceof CurrencyInfo) {
            return ((CurrencyInfo)value).getId().toString();
        }
        if (dataType == 1) {
            return Boolean.valueOf(String.valueOf(value)) != false ? "Y" : "N";
        }
        if (dataType == 2) {
            return new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format((Date)value);
        }
        if (dataType == 3) {
            return new BigDecimal(value.toString()).toPlainString();
        }
        return String.valueOf(value);
    }

    private class ComboItem {
        String name;
        Object data;

        ComboItem(String name, Object data) {
            this.name = name;
            this.data = data;
        }

        public String toString() {
            return this.name;
        }
    }
}

