/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.sql.DbType;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.bo.BlobBO;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

public class ExtDBUtil {
    public static final IRowSet executeQuery(Context ctx, String sql, String otherDataCenter) throws BOSException {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getDBPageSizeInfoBySQL");
        pr.setString("sql", sql);
        pr.setInt("start", 0);
        pr.setInt("rows", -1);
        pr.setString("outDB", otherDataCenter);
        RptParams ps_r = FacadeFactory.commonExecute(ctx, pr);
        IRowSet irs = (IRowSet)ps_r.getObject("object");
        return irs;
    }

    public static ArrayList setDataToList(ResultSet rs) throws SQLException {
        ArrayList lst = new ArrayList();
        ResultSetMetaData rsmd = rs.getMetaData();
        int len = rsmd.getColumnCount();
        while (rs.next()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int i = 1; i <= len; ++i) {
                Object obj = rs.getObject(i);
                if (rsmd.getColumnType(i) == 2004) {
                    obj = BlobBO.readBlob(rs, i);
                }
                map.put(rsmd.getColumnName(i).toLowerCase(), obj);
            }
            lst.add(map);
        }
        return lst;
    }

    public static ArrayList getResultListBySql(Context ctx, String sql, ArrayList queryValue) throws BOSException {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoListBySQL");
        pr.setString("sql", sql);
        pr.setObject("lstValue", (Object)queryValue);
        RptParams ps_r = FacadeFactory.commonExecute(ctx, pr);
        ArrayList dataList = (ArrayList)ps_r.getObject("object");
        return dataList;
    }

    public static ArrayList getResultListBySql1(Context ctx, String sql, ArrayList queryValue) throws BOSException {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoListBySQL");
        pr.setString("sql", sql);
        pr.setObject("lstValue", (Object)queryValue);
        RptParams ps_r = FacadeFactory.commonExecute(ctx, pr);
        ArrayList dataList = (ArrayList)ps_r.getObject("object");
        return dataList;
    }

    public static HashMap getResultMapBySql(Context ctx, String sql, ArrayList queryValue) throws BOSException {
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoMapBySQL");
        pr.setString("sql", sql);
        pr.setObject("lstValue", (Object)queryValue);
        RptParams ps_r = FacadeFactory.commonExecute(ctx, pr);
        HashMap map = (HashMap)ps_r.getObject("object");
        return map;
    }

    public static final void maintainRecord(Context ctx, String sql, ArrayList queryValue) throws BOSException {
        RptParams pr = new RptParams();
        pr.setString("sql", sql);
        pr.setObject("lstValue", (Object)queryValue);
        pr.setString("MethodName", "maintainRecord");
        FacadeFactory.commonExecute(ctx, pr);
    }

    public static final void executeBatch(Context ctx, ArrayList sqlList) throws BOSException {
        RptParams pr = new RptParams();
        pr.setObject("sqlList", (Object)sqlList);
        pr.setString("MethodName", "executeBatch");
        FacadeFactory.commonExecute(ctx, pr);
    }

    public static final int getDBType(Context ctx) {
        String dbTypeName = null;
        if (ctx != null) {
            if (ctx.get((Object)"dbType") != null) {
                dbTypeName = ctx.get((Object)"dbType").toString();
            }
        } else {
            RptParams pr = new RptParams();
            pr.setString("MethodName", "getInfoFromServer");
            try {
                RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
                dbTypeName = ps_r.getString("dbTypeName");
            }
            catch (BOSException e) {
                try {
                    RptParams ps_r = FacadeFactory.commonExecute(ctx, pr);
                    dbTypeName = ps_r.getString("dbTypeName");
                }
                catch (BOSException e1) {
                    return -1;
                }
            }
        }
        int bosDbtype = 2;
        if (!StringUtil.isEmptyString(dbTypeName)) {
            bosDbtype = DbType.getValue((String)dbTypeName);
        } else {
            System.out.println("\u83b7\u53d6\u6570\u636e\u5e93\u7c7b\u578b\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u7c7b\u578bOracle.");
            System.out.println("Context.toString():" + ctx);
        }
        switch (bosDbtype) {
            case 3: {
                return 3;
            }
            case 2: 
            case 7: 
            case 8: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 5: {
                return 5;
            }
            case 12: {
                return 12;
            }
        }
        return -1;
    }
}

