/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.modal.Outputs;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumns;
import com.kingdee.bos.ctrl.kds.model.util.ObjectStack;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.rpts.ctrlreport.macro.exception.MacroRuntimeException;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.ExtRptMacroControllerFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.facade.IExtRptMacroController;
import com.kingdee.eas.rpts.ctrlreport.macro.model.ExtRptMacroIOFactory;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.CycleException;
import com.kingdee.eas.rpts.ctrlsqldesign.exception.NoFoundQueryException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignFinal;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignInputStream;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.eas.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.KsqlObjectSelector;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPath;

public class SqlDSModelDrill {
    private static Logger logger = LogUtil.getPackageLogger(SqlDSModelDrill.class);
    private static final String META_SPLIT = "#@META_SPLIT@#";
    private static final String KEY_VALUE_SPLIT = "#@#@#";
    private static final String ID_NAME_SPLIT = "#";
    private static final String SQL_DS_PATTERN;
    private static final String SQL_DS_ID_PATTERN;
    private String _orgID;
    private String _systemID;
    private String _name;

    private SqlDSModelDrill(String orgID, String systemID, String name) {
        this._orgID = orgID;
        this._systemID = systemID;
        this._name = name;
    }

    public static SqlDSModelDrill getInst(String orgID, String systemID, String name) {
        return new SqlDSModelDrill(orgID, systemID, name);
    }

    public String drill(String xmlMeta) throws CycleException, BOSException {
        return SqlDSModelDrill.drillOnly(xmlMeta, this._orgID);
    }

    public static String drillOnly(String xmlMeta, String OrgId) throws CycleException, BOSException {
        return SqlDSModelDrill.drillOnly(null, xmlMeta, OrgId);
    }

    public static String drillOnly(Context easCtx, String xmlMeta, String OrgId) throws CycleException, BOSException {
        if (StringUtil.isEmptyString((String)xmlMeta)) {
            return xmlMeta;
        }
        StringBuffer metaBuf = new StringBuffer(xmlMeta.length() * 2);
        metaBuf.append(xmlMeta);
        StringBuffer out = new StringBuffer(100);
        SqlDSModelDrill.analysis(easCtx, xmlMeta, out, OrgId);
        if (!StringUtil.isEmptyString((String)out.toString())) {
            metaBuf.append(META_SPLIT);
            metaBuf.append(out.toString());
        }
        return metaBuf.toString();
    }

    public String drillRetainInnerDataset(String xmlMeta) throws CycleException, BOSException {
        return this.drillRetainInnerDataset(null, xmlMeta, this._orgID);
    }

    public String drillRetainInnerDataset(Context easCtx, String xmlMeta, String orgId) throws CycleException, BOSException {
        if (StringUtil.isEmptyString((String)xmlMeta)) {
            return xmlMeta;
        }
        String[] metas = xmlMeta.split(META_SPLIT);
        if (metas.length == 2) {
            StringBuffer result = new StringBuffer(metas[0].length() + xmlMeta.length());
            result.append(xmlMeta);
            StringBuffer out = new StringBuffer(100);
            SqlDSModelDrill.analysis(easCtx, metas[0], out, orgId);
            if (!StringUtil.isEmptyString((String)out.toString())) {
                result.append(out.toString());
            }
            return result.toString();
        }
        return this.drill(metas[0]);
    }

    public static Object[] split(String xmlMeta) {
        String[] metas = xmlMeta.split(META_SPLIT);
        HashMap<String, String> map = null;
        if (metas.length == 2) {
            String[] metaKVs = metas[1].split(KEY_VALUE_SPLIT);
            int len = metaKVs.length / 2 * 2;
            map = new HashMap<String, String>(len / 2);
            for (int i = 0; i < len; i += 2) {
                map.put(metaKVs[i], metaKVs[i + 1]);
            }
        }
        return new Object[]{metas[0], map};
    }

    public static String split2(String xmlMeta) {
        String[] metas = xmlMeta.split(META_SPLIT);
        return metas[0];
    }

    public static String replaceMainMeta(String xmlMeta, String mainMeta) {
        String[] metas = xmlMeta.split(META_SPLIT);
        if (metas.length == 1) {
            return mainMeta;
        }
        return mainMeta + META_SPLIT + metas[1];
    }

    public static String appendToMainMeta(String mainMeta, String xmlMeta) {
        return mainMeta + META_SPLIT + xmlMeta;
    }

    public static String mergeSubMeta(List<String> strList) {
        if (strList == null || strList.size() == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < strList.size(); ++i) {
            str.append(strList.get(i));
            str.append(KEY_VALUE_SPLIT);
        }
        return str.toString();
    }

    public static String mergeMeta(String mainMeta, List<String> strList) {
        return SqlDSModelDrill.appendToMainMeta(mainMeta, SqlDSModelDrill.mergeSubMeta(strList));
    }

    public static String mergeMeta(String mainMeta, Map<String, String> map) {
        StringBuffer metaSB = new StringBuffer();
        metaSB.append(mainMeta);
        if (map != null && !map.isEmpty()) {
            metaSB.append(META_SPLIT);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                metaSB.append(entry.getKey());
                metaSB.append(KEY_VALUE_SPLIT);
                metaSB.append(entry.getValue());
                metaSB.append(KEY_VALUE_SPLIT);
            }
        }
        return metaSB.toString();
    }

    public static String getName(String idMName) {
        return idMName.split(ID_NAME_SPLIT)[0];
    }

    public static String getID(String idMName) {
        return idMName.split(ID_NAME_SPLIT)[1];
    }

    public static String getKey(String name, String systemID) {
        return name + ID_NAME_SPLIT + systemID;
    }

    public static String[] splitKey(String key) {
        if (key == null) {
            return null;
        }
        return key.split(ID_NAME_SPLIT);
    }

    public static String replaceMacroNameInDataset(String datasetXml, Map<String, String> old2NewNameMap) throws IOException, JDOMException {
        if (old2NewNameMap.isEmpty()) {
            return datasetXml;
        }
        StringReader reader = new StringReader(datasetXml);
        SAXBuilder sb = new SAXBuilder();
        Document doc = sb.build((Reader)reader);
        Element root = doc.getRootElement();
        RunReportParam.closeReader(reader);
        root = SqlDSModelDrill.replaceMacroNameInDataset(root, old2NewNameMap);
        Format format = Format.getCompactFormat();
        format.setIndent("\t");
        format.setEncoding("UTF-8");
        XMLOutputter outter = new XMLOutputter(format);
        return outter.outputString(root);
    }

    public static Element replaceMacroNameInDataset(Element root, Map<String, String> old2NewNameMap) throws IOException, JDOMException {
        if (old2NewNameMap == null || old2NewNameMap.isEmpty()) {
            return root;
        }
        List inputCtrlDomList = XPath.selectNodes((Object)root, (String)"/CommonQuery/Parameters/Parameter/InputCtrl");
        if (inputCtrlDomList != null) {
            for (int j = 0; j < inputCtrlDomList.size(); ++j) {
                String macroNewName;
                int dataBind;
                Element inputCtrlDom = (Element)inputCtrlDomList.get(j);
                Attribute attr = inputCtrlDom.getAttribute("defDbsourceName");
                if (attr == null || (dataBind = Integer.valueOf(inputCtrlDom.getAttributeValue("dataBind")).intValue()) != 7 || (macroNewName = old2NewNameMap.get(attr.getValue())) == null) continue;
                attr.setValue(macroNewName);
                attr = inputCtrlDom.getAttribute("defDbsourceAlias");
                if (attr == null) continue;
                attr.setValue("$" + macroNewName);
            }
        }
        return root;
    }

    public static String convertQueryToSQLInDataset(String datasetXml, List<String> queryNames) throws IOException, JDOMException {
        if (queryNames == null || queryNames.isEmpty()) {
            return datasetXml;
        }
        StringReader reader = new StringReader(datasetXml);
        SAXBuilder sb = new SAXBuilder();
        Document doc = sb.build((Reader)reader);
        Element root = doc.getRootElement();
        RunReportParam.closeReader(reader);
        root = SqlDSModelDrill.convertQueryToSQLInDataset(root, queryNames);
        Format format = Format.getCompactFormat();
        format.setIndent("\t");
        format.setEncoding("UTF-8");
        XMLOutputter outter = new XMLOutputter(format);
        return outter.outputString(root);
    }

    public static Element convertQueryToSQLInDataset(Element root, List<String> queryNames) throws IOException, JDOMException {
        if (queryNames == null || queryNames.isEmpty()) {
            return root;
        }
        HashMap<String, String> queryNameMap = new HashMap<String, String>(queryNames.size());
        for (String name : queryNames) {
            queryNameMap.put(name, name);
        }
        List inputCtrlDomList = XPath.selectNodes((Object)root, (String)"/CommonQuery/Parameters/Parameter/InputCtrl");
        if (inputCtrlDomList != null) {
            for (int j = 0; j < inputCtrlDomList.size(); ++j) {
                String queryName;
                int dataBind;
                Element inputCtrlDom = (Element)inputCtrlDomList.get(j);
                Attribute dataBindAttr = inputCtrlDom.getAttribute("dataBind");
                if (dataBindAttr == null || (dataBind = Integer.valueOf(dataBindAttr.getValue()).intValue()) != 3 || (queryName = (String)queryNameMap.get(inputCtrlDom.getAttributeValue("defDbsourceName"))) == null) continue;
                dataBindAttr.setValue("4");
                Attribute attr = inputCtrlDom.getAttribute("tableFlag");
                if (attr != null) {
                    attr.setValue("2");
                }
                if ((attr = inputCtrlDom.getAttribute("defDbsourceAlias")) != null) {
                    attr.setValue(inputCtrlDom.getAttributeValue("defDbsourceName"));
                }
                if ((attr = inputCtrlDom.getAttribute("defDbsourceName")) == null) continue;
                attr.setValue("qUvvbL4yQsyQYFIDSlvngID2+FI=");
            }
        }
        return root;
    }

    private static void analysis(Context easCtx, String xmlMeta, StringBuffer out, String orgId) throws CycleException, BOSException {
        int size;
        ArrayList list = new ArrayList(10);
        SqlDSModelDrill.miningKeys(xmlMeta, list);
        int lastIndex = 0;
        for (int times = 0; times < 10 && (size = list.size()) > lastIndex; ++times) {
            for (int i = lastIndex; i < size; ++i) {
                String meta = null;
                String key = (String)list.get(i);
                String[] keySplited = SqlDSModelDrill.splitKey(key);
                if (keySplited.length < 3) continue;
                int dataBind = Integer.valueOf(keySplited[2]);
                switch (dataBind) {
                    case 3: {
                        meta = SqlDSModelDrill.retrieveCommonQuery(easCtx, keySplited[0]);
                        break;
                    }
                    case 4: {
                        meta = SqlDSModelDrill.retrieve(easCtx, keySplited, orgId);
                        break;
                    }
                    case 7: {
                        try {
                            meta = SqlDSModelDrill.retrieveMacro(easCtx, keySplited[0]);
                            break;
                        }
                        catch (MacroRuntimeException e) {
                            logger.error((Object)("\u4ece\u6570\u636e\u5e93\u83b7\u53d6\u5b8f\u51fa\u9519\uff01\u5b8f\u540d\u79f0\uff1a" + keySplited[0]), (Throwable)e);
                        }
                    }
                }
                if (StringUtil.isEmptyString(meta)) continue;
                if (dataBind == 4) {
                    out.append(SqlDSModelDrill.getKey(keySplited[0], keySplited[1]));
                } else {
                    out.append(key);
                }
                out.append(KEY_VALUE_SPLIT);
                out.append(meta);
                out.append(KEY_VALUE_SPLIT);
                if (dataBind != 4) continue;
                SqlDSModelDrill.miningKeys(meta, list);
            }
            lastIndex = size;
        }
    }

    private void cycleCheck(ObjectStack os, String elem) throws CycleException {
        int size = os.size();
        for (int i = 0; i < size; ++i) {
            if (!elem.equals(os.getAt(i))) continue;
            os.push((Object)elem);
            ArrayList<String> objs = new ArrayList<String>(os.size());
            int jsize = os.size();
            for (int j = 0; j < jsize; ++j) {
                objs.add("\u6570\u636e\u96c6" + SqlDSModelDrill.getName((String)os.getAt(j)));
            }
            throw new CycleException(objs.toArray());
        }
    }

    private static String retrieve(Context easCtx, String[] keys, String orgId) {
        CtrlDesignInputStream in = new CtrlDesignInputStream(easCtx, keys[1], keys[0], orgId, orgId);
        if (in.isFound()) {
            return in.getXmlString();
        }
        return null;
    }

    private static String retrieveCommonQuery(Context easCtx, String queryFullName) throws BOSException {
        MetaDataPK pk = MetaDataPK.create((String)queryFullName);
        IQueryExecutor qe = easCtx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk) : QueryExecutorFactory.getLocalInstance((Context)easCtx, (IMetaDataPK)pk);
        if (qe == null) {
            return "";
        }
        String sql = qe.getSQL();
        if (sql == null || sql.length() == 0) {
            return "";
        }
        CtrlDesignQueryModel model = new CtrlDesignQueryModel();
        model.setObjectSelector(new KsqlObjectSelector());
        CtrlDesignKsqlQuery ksqlQuery = new CtrlDesignKsqlQuery(true);
        ksqlQuery.setRegular(false);
        ksqlQuery.setDistinct(false);
        ksqlQuery.setContent(sql);
        model.setQuery((IQuery)ksqlQuery);
        CtrlDesignCommonQuery commonQuery = model.getCommonQuery();
        Outputs outputsDef = new Outputs();
        KsqlObjectSelector selector = model.getObjectSelector();
        try {
            MetaClass mc = selector.createMetaClass(CtrlDesignFinal.getMetaDataType("jqye"), queryFullName);
            if (mc != null) {
                OutputColumns columnList = new OutputColumns();
                for (Object field : mc.getFields()) {
                    MetaField mf = (MetaField)field;
                    OutputColumn oc = new OutputColumn();
                    oc.setName(mf.getName());
                    oc.setAlias(mf.getAlias());
                    oc.setAlias(mf.getAlias(Locale.TAIWAN), Locale.TAIWAN);
                    oc.setAlias(mf.getAlias(Locale.US), Locale.US);
                    oc.setDataType(mf.getType());
                    oc.setExpr(mf.getExpr());
                    columnList.add((Object)oc);
                }
                outputsDef.add((Object)columnList);
            }
            commonQuery.setOutputs(outputsDef);
        }
        catch (NoFoundQueryException e) {
            throw new BOSException((Throwable)e);
        }
        Element root = CtrlDesignUtil.toXml(easCtx, model.getCommonQuery(), model.getQuery());
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setEncoding("UTF-8");
        XMLOutputter outter = new XMLOutputter(format);
        return outter.outputString(root);
    }

    private static String retrieveMacro(Context easCtx, String macroName) throws MacroRuntimeException {
        MacroVO macroVO = null;
        try {
            IExtRptMacroController controller = easCtx != null ? ExtRptMacroControllerFacade.getLocalInst(easCtx) : ExtRptMacroControllerFacade.getRemoteInst();
            macroVO = controller.r(macroName);
            controller = null;
        }
        catch (BOSException e) {
            throw MacroRuntimeException.newStubFetchException(e);
        }
        return ExtRptMacroIOFactory.macro2MetaString(macroVO);
    }

    private static int miningKeys(String xmlMeta, List keys) {
        int lastIndex = keys.size();
        SAXBuilder builder = new SAXBuilder(false);
        StringReader read = new StringReader(xmlMeta);
        Document doc = null;
        List metas = null;
        try {
            doc = builder.build((Reader)read);
            Element root = doc.getRootElement();
            metas = XPath.selectNodes((Object)root, (String)"/CommonQuery/Parameters/Parameter/InputCtrl");
            read.close();
            read = null;
            doc = null;
            builder = null;
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (null != metas && !metas.isEmpty()) {
            StringBuffer keySB = new StringBuffer();
            for (Element node : metas) {
                String key;
                int dataBind;
                String dsName;
                String dataBindStr = node.getAttributeValue("dataBind");
                if (dataBindStr == null || null == (dsName = node.getAttributeValue("defDbsourceName")) || (dataBind = Integer.valueOf(dataBindStr).intValue()) != 3 && dataBind != 4 && dataBind != 7 && !dsName.matches("[0-9A-Za-z+/=]{10,28}")) continue;
                keySB.setLength(0);
                switch (dataBind) {
                    case 3: {
                        keySB.append(node.getAttributeValue("defDbsourceName"));
                        keySB.append(ID_NAME_SPLIT);
                        keySB.append(node.getAttributeValue("defDbsourceSystemID"));
                        keySB.append(ID_NAME_SPLIT);
                        keySB.append(dataBind);
                        break;
                    }
                    case 4: {
                        keySB.append(node.getAttributeValue("defDbsourceAlias"));
                        keySB.append(ID_NAME_SPLIT);
                        keySB.append(node.getAttributeValue("defDbsourceSystemID"));
                        keySB.append(ID_NAME_SPLIT);
                        keySB.append(dataBind);
                        break;
                    }
                    case 7: {
                        keySB.append(node.getAttributeValue("defDbsourceName"));
                        keySB.append(ID_NAME_SPLIT);
                        keySB.append(node.getAttributeValue("defDbsourceAlias"));
                        keySB.append(ID_NAME_SPLIT);
                        keySB.append(dataBind);
                    }
                }
                if ((key = keySB.toString()).length() <= 0 || keys.contains(key)) continue;
                keys.add(key);
            }
        }
        return lastIndex;
    }

    static {
        StringBuffer pBuf = new StringBuffer(50);
        pBuf.append('<').append("InputCtrl").append("([^>]*?)");
        pBuf.append("dataBind").append("=\"4\"([^>]*?)((>.*?</");
        pBuf.append("InputCtrl").append(">)|(/>))");
        SQL_DS_PATTERN = pBuf.toString();
        pBuf = new StringBuffer(30);
        pBuf.append('(');
        pBuf.append("defDbsourceAlias").append("=\"([^> ]+)\"([^>]+)");
        pBuf.append("defDbsourceSystemID").append("=\"([^> ]+)\"");
        pBuf.append(')');
        SQL_DS_ID_PATTERN = pBuf.toString();
    }
}

