/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.model.pr;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputState;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputType;
import java.util.HashSet;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class ParamRelationDesignModel {
    public static final String ROOT_NAME = "ParamRelationRoot";
    public static final String REALATION_MARK = "RelationMark";
    private Element _root;
    private HashSet paramRelationSet = new HashSet();
    private boolean isRelationMark = false;

    public void registerValue(DesignParameter paramName, DesignParameter relatedDSParamName, DesignParameter value) {
        this.addRelation(paramName, relatedDSParamName, value);
    }

    public Element save() {
        if (!this.paramRelationSet.isEmpty()) {
            this._root = new Element(ROOT_NAME);
            this._root.setAttribute(REALATION_MARK, "true");
            for (RelationDef def : this.paramRelationSet) {
                Element relation = new Element("Relation");
                relation.addContent((Content)this.serializeDesignParameter(new Element("param"), def.param));
                relation.addContent((Content)this.serializeDesignParameter(new Element("relatedDSParam"), def.relatedDSParam));
                if (def.value != null) {
                    relation.addContent((Content)this.serializeDesignParameter(new Element("value"), def.value));
                }
                this._root.addContent((Content)relation);
            }
        } else {
            this._root = null;
        }
        return this._root;
    }

    public void load(Element root) {
        this._root = root;
        if (this._root != null) {
            this.isRelationMark = Boolean.valueOf(this._root.getAttributeValue(REALATION_MARK, "false"));
            List relations = this._root.getChildren("Relation");
            if (relations != null && !relations.isEmpty()) {
                int len = relations.size();
                for (int i = 0; i < len; ++i) {
                    Element relation = (Element)relations.get(i);
                    RelationDef def = new RelationDef();
                    def.param = this.deSeializeDesignParameter(relation.getChild("param"));
                    def.relatedDSParam = this.deSeializeDesignParameter(relation.getChild("relatedDSParam"));
                    def.value = this.deSeializeDesignParameter(relation.getChild("value"));
                    this.paramRelationSet.add(def);
                }
            }
        }
    }

    public boolean hasRelationMark() {
        return this.isRelationMark;
    }

    public DesignParameter[][] fetchSupplierParams(String paramName) {
        HashSet<DesignParameter[]> container = new HashSet<DesignParameter[]>();
        for (RelationDef def : this.paramRelationSet) {
            if (!StringUtil.equalsIgnoreCase((String)paramName, (String)def.param.getName())) continue;
            DesignParameter[] set = new DesignParameter[]{def.relatedDSParam, def.value};
            container.add(set);
        }
        return (DesignParameter[][])container.toArray((T[])new DesignParameter[0][]);
    }

    public DesignParameter[] fetchRelatedParams(String paramName) {
        HashSet<DesignParameter> container = new HashSet<DesignParameter>();
        for (RelationDef def : this.paramRelationSet) {
            if (def.value == null || !StringUtil.equalsIgnoreCase((String)paramName, (String)def.value.getName())) continue;
            container.add(def.param);
        }
        return container.toArray(new DesignParameter[0]);
    }

    private void addRelation(DesignParameter paramName, DesignParameter relatedDSParamName, DesignParameter value) {
        RelationDef def = new RelationDef();
        def.param = paramName;
        def.relatedDSParam = relatedDSParamName;
        def.value = value;
        this.paramRelationSet.add(def);
    }

    private Element serializeDesignParameter(Element ele, DesignParameter dp) {
        ele.setAttribute("name", dp.getName());
        ele.setAttribute("alias", dp.getAlias() == null ? "" : dp.getAlias());
        ele.setAttribute("dataType", String.valueOf(dp.getDesignDataType().intValue()));
        ele.setAttribute("inputType", String.valueOf(dp.getInputType().intValue()));
        ele.setAttribute("defaultValue", "");
        ele.setAttribute("nullable", String.valueOf(dp.isAllowNull()));
        ele.setAttribute("state", String.valueOf(dp.getInputState().intValue()));
        ele.setAttribute("description", dp.getDesc() == null ? "" : dp.getDesc());
        return ele;
    }

    private DesignParameter deSeializeDesignParameter(Element ele) {
        if (ele == null) {
            return null;
        }
        DesignParameter dp = new DesignParameter();
        dp.setName(ele.getAttributeValue("name"));
        dp.setAlias(ele.getAttributeValue("alias"));
        dp.setDesignDataType(DesignDataType.getDataType(Integer.parseInt(ele.getAttributeValue("dataType"))));
        dp.setInputType(InputType.getInputType(Integer.parseInt(ele.getAttributeValue("inputType"))));
        dp.setAllowNull(Boolean.parseBoolean(ele.getAttributeValue("nullable")));
        dp.setInputState(InputState.getInputState(Integer.parseInt(ele.getAttributeValue("state"))));
        dp.setDesc(ele.getAttributeValue("description"));
        return dp;
    }

    private class RelationDef {
        DesignParameter param;
        DesignParameter relatedDSParam;
        DesignParameter value;

        private RelationDef() {
        }

        public boolean equals(Object another) {
            if (another instanceof RelationDef) {
                RelationDef o = (RelationDef)another;
                return StringUtil.equalsIgnoreCase((String)this.param.getName(), (String)o.param.getName()) && StringUtil.equalsIgnoreCase((String)this.relatedDSParam.getName(), (String)o.relatedDSParam.getName()) && (this.value == null ? o.value == null : o.value != null && StringUtil.equalsIgnoreCase((String)this.value.getName(), (String)o.value.getName()));
            }
            return false;
        }

        public int hashCode() {
            return (this.param.getName() + "." + this.relatedDSParam.getName() + "." + (this.value == null ? "nullValue" : this.value.getName())).hashCode();
        }
    }
}

