/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.param;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.macro.exec.ExtRptMacroExecuteFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputState;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputType;
import com.kingdee.eas.rpts.ctrlsqldesign.industry.InnerParam;
import com.kingdee.eas.rpts.ctrlsqldesign.param.arg.component.KDComboBoxCreator;
import com.kingdee.eas.rpts.ctrlsqldesign.param.arg.component.KDPromptBoxCreator;
import com.kingdee.eas.rpts.ctrlsqldesign.param.arg.component.KDSpinnerCreator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ArgInputComponentFactory {
    public static DesignParameter[] fetchSuppliers(DesignParameter p) {
        return ArgInputComponentFactory.fetchSuppliers(null, p, null);
    }

    public static DesignParameter[] fetchSuppliers(Context easCtx, DesignParameter p, Map<String, DesignParameter> srcAll) {
        DesignParameter[][] suppliers = p.getSupplierParams(easCtx);
        if (suppliers != null) {
            ArrayList<DesignParameter> params = new ArrayList<DesignParameter>();
            for (int i = 0; i < suppliers.length; ++i) {
                if (p == suppliers[i][1]) continue;
                DesignParameter dp = new DesignParameter();
                dp.setName(suppliers[i][0].getName());
                String currentValue = suppliers[i][1] == null ? null : (suppliers[i][1].getCurentValue() == null ? suppliers[i][1].getDefaultValue() : suppliers[i][1].getCurentValue());
                dp.setCurentValue(currentValue);
                dp.setDesignDataType(suppliers[i][0].getDesignDataType());
                params.add(dp);
            }
            return params.toArray(new DesignParameter[0]);
        }
        return null;
    }

    public static KDComboBox getComboBoxCtrl(DesignParameter p, String sourceReportOrgID, int runtimeType, ExecutionContext exeCtx, List<DesignParameter> srcParams) throws Exception {
        ArgInputComponentFactory.parseFirstData(srcParams, runtimeType, sourceReportOrgID, exeCtx);
        return KDComboBoxCreator.getComboBoxCtrl(p, sourceReportOrgID, runtimeType, exeCtx, ArgInputComponentFactory.fetchSuppliers(null, p, ArgInputComponentFactory.list2Map(srcParams)));
    }

    public static KDComboBox getComboBoxCtrl(DesignParameter p, String sourceReportOrgID, int runtimeType, ExecutionContext exeCtx) throws Exception {
        return KDComboBoxCreator.getComboBoxCtrl(p, sourceReportOrgID, runtimeType, exeCtx, ArgInputComponentFactory.fetchSuppliers(p));
    }

    public static KDSpinner createSpinner(DesignParameter p, String defaultLimitString) throws Exception {
        return KDSpinnerCreator.getSpinnerCtrl(p, defaultLimitString);
    }

    public static KDBizPromptBox createKDPromptBox(DesignParameter p, String sourceReportOrgID, int runtimeType, ExecutionContext exeCtx) {
        return ArgInputComponentFactory.createKDPromptBox(p, sourceReportOrgID, runtimeType, exeCtx, null);
    }

    public static KDBizPromptBox createKDPromptBox(DesignParameter p, String sourceReportOrgID, int runtimeType, ExecutionContext exeCtx, List<DesignParameter> parameters) {
        ArgInputComponentFactory.parseFirstData(parameters, runtimeType, sourceReportOrgID, exeCtx);
        return KDPromptBoxCreator.getPromptBoxCtrl(p, sourceReportOrgID, exeCtx, runtimeType, ArgInputComponentFactory.fetchSuppliers(null, p, ArgInputComponentFactory.list2Map(parameters)));
    }

    public static Map<String, DesignParameter> list2Map(List<DesignParameter> srcParams) {
        HashMap<String, DesignParameter> params = new HashMap<String, DesignParameter>();
        if (srcParams != null) {
            for (DesignParameter dp : srcParams) {
                params.put(dp.getName(), dp);
            }
        }
        return params;
    }

    public static String getCurrentOrgId(String expectId) {
        String orgId = StringUtils.isEmpty((String)expectId) ? SysContext.getSysContext().getCurrentOrgUnit().getId().toString() : expectId;
        return StringUtils.isEmpty((String)orgId) ? "" : orgId;
    }

    public static String getCurrentOrgName() {
        String orgName = SysContext.getSysContext().getCurrentOrgUnit().getName().toString();
        return StringUtils.isEmpty((String)orgName) ? "" : orgName;
    }

    public static void setCommonProperties(IKDTextComponent ic, DesignParameter p) {
        boolean required = !p.isAllowNull();
        boolean enable = !InputState.READONLY.equals(p.getInputState());
        boolean editable = p.getInputCtrl() != null ? p.getInputCtrl().isAllowEdit() : false;
        ic.setRequired(required);
        ic.setEnabled(enable);
        ic.setEditable(editable);
    }

    public static String pertreateParameter(Map<String, MacroVO> innerMacroDefineMap, String value, int runtimeType) {
        if (runtimeType == 1 || runtimeType == 2 || null == value) {
            return value;
        }
        String[] values = value.split("0xx1xx");
        StringBuffer result = new StringBuffer();
        String currentValue = null;
        int length = values.length;
        HashMap defaultSystemPreParameters = new HashMap();
        ArgInputComponentFactory.putClientDefalutListParamsMap(defaultSystemPreParameters);
        for (int i = 0; i < length; ++i) {
            currentValue = values[i];
            if (currentValue.startsWith("@ExtRpt")) {
                DesignParameter parameters_Default = (DesignParameter)((Object)defaultSystemPreParameters.get(currentValue.substring(1)));
                if (parameters_Default != null) {
                    currentValue = parameters_Default.getCurentValue();
                }
            } else {
                currentValue = ExtRptMacroExecuteFacade.evaluateMacro(innerMacroDefineMap, currentValue);
            }
            result.append(currentValue);
            if (i >= length - 1) continue;
            result.append("0xx1xx");
        }
        return result.toString();
    }

    public static final void putClientDefalutListParamsMap(HashMap mapDesignParma) {
        SysContext sysContext = SysContext.getSysContext();
        List params = InnerParam.getInnerParams(sysContext);
        for (InnerParam param : params) {
            ArgInputComponentFactory.putParamsMap(mapDesignParma, param.getId(), param.getAlias(), param.getValue());
        }
    }

    private static final void putParamsMap(HashMap mapDesignParam, String paramName, String paramAlias, Object objValue) {
        paramAlias = ExtStringUtil.replace(paramAlias, "@", "");
        paramAlias = ExtStringUtil.replace(paramAlias, "'", "");
        String value = CtrlReportUtil.getObjectString(objValue);
        DesignParameter dp = new DesignParameter();
        dp.setName(paramName);
        dp.setAlias(paramAlias);
        dp.setCurentValue(value);
        dp.setDesignDataType(DesignDataType.getDataType(0));
        mapDesignParam.put(paramName, dp);
    }

    public static void parseFirstData(List<DesignParameter> parameters, int runtimeType, String sourceReportOrgID, ExecutionContext exeCtx) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        try {
            for (DesignParameter dp : parameters) {
                String currentValue = dp.getCurentValue();
                if (currentValue != null && !"#@$firstData$@#".equals(currentValue) || dp.getInputType() != InputType.LIST || !"#@$firstData$@#".equals(dp.getDefaultValue())) continue;
                KDComboBox box = KDComboBoxCreator.getComboBoxCtrl(dp, sourceReportOrgID, runtimeType, exeCtx, ArgInputComponentFactory.fetchSuppliers(null, dp, ArgInputComponentFactory.list2Map(parameters)));
                String firstValue = ((DefObj)box.getItemAt(1)).getName();
                dp.setCurentValue(firstValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

