/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.param;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialog;
import com.kingdee.eas.rpts.ctrlsqldesign.client.ReportCommonFilterUI;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.FilterUIType;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.param.DefaultArgInput;
import com.kingdee.eas.rpts.ctrlsqldesign.param.LayoutWorkButton;
import com.kingdee.eas.rpts.ctrlsqldesign.param.SortWorkButton;
import com.kingdee.eas.rpts.ctrlsqldesign.xml.LayoutParameterIO;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LayoutFilterUIWizard
extends KDDialog
implements ISpreadWizzard {
    public static final String COMMA_SEPARATOR = ",";
    public static final String FILTERUI_SIZE = "REPORTCOMMONFILTERUI_SIZE";
    public static final String FILTERUI_ARGS_COLSPAN = "REPORTCOMMONFILTERUI_ARGS_COLSPAN";
    private static final int DEFAULT_WIDTH = 685;
    private static final int DEFAULT_HEIGHT = 435;
    private static final int PANEL_WIDTH = 405;
    private Book book;
    private KDSpinner wSpinner;
    private KDSpinner hSpinner;
    private LayoutWorkButton[] btns;
    private KDButton saveBtn;
    private KDButton previewBtn;
    private KDButton defaultLytBtn;
    private KDButton exitBtn;
    private boolean isDirty;
    private boolean isBackToDefault;
    private KDPanel panelParams;
    private KDPanel panelSort;
    private KDPanel mainLayoutPanel;
    private ArrayList<DesignParameter> allParams;
    private SortWorkButton[] sortBtns;
    private static int PANEL_HEIGHT = 0;

    public LayoutFilterUIWizard(KDExt ext) {
        super((Frame)ext);
        this.book = MiscUtil.getActiveSpreadContext((KDExt)ext).getBook();
        this.initComponents();
        this.initListeners();
        this.setDefaultCloseOperation(2);
    }

    private void initListeners() {
        this.saveBtn.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    LayoutFilterUIWizard.this.wSpinner.commitEdit();
                    LayoutFilterUIWizard.this.hSpinner.commitEdit();
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
                LayoutFilterUIWizard.this.saveLayoutParams();
            }
        });
        this.previewBtn.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    LayoutFilterUIWizard.this.wSpinner.commitEdit();
                    LayoutFilterUIWizard.this.hSpinner.commitEdit();
                    LayoutFilterUIWizard.this.previewLayout();
                }
                catch (Exception e1) {
                    System.out.println("\u9884\u89c8\u53c2\u6570\u5e03\u5c40\u5931\u8d25\uff01");
                    e1.printStackTrace();
                }
            }
        });
        this.defaultLytBtn.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LayoutFilterUIWizard.this.backToDefault();
            }
        });
        this.exitBtn.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    LayoutFilterUIWizard.this.wSpinner.commitEdit();
                    LayoutFilterUIWizard.this.hSpinner.commitEdit();
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
                LayoutFilterUIWizard.this.closeWindow();
            }
        });
        this.wSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LayoutFilterUIWizard.this.isDirty = true;
            }
        });
        this.hSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LayoutFilterUIWizard.this.isDirty = true;
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LayoutFilterUIWizard.this.closeWindow();
            }
        });
    }

    private void backToDefault() {
        switch (MessageDialog.show((Component)((Object)this), (Object)"\u786e\u5b9a\u6062\u590d\u5230\u7cfb\u7edf\u81ea\u52a8\u5e03\u5c40\uff1f", (String)"\u63d0\u793a\u4fe1\u606f", (int)2)) {
            case 0: {
                this.isBackToDefault = true;
                if (685 != this.wSpinner.getIntegerVlaue()) {
                    this.wSpinner.setValue((Object)685);
                    this.isDirty = true;
                }
                if (435 != this.hSpinner.getIntegerVlaue()) {
                    this.hSpinner.setValue((Object)435);
                    this.isDirty = true;
                }
                if (this.btns == null || this.btns.length <= 0) {
                    return;
                }
                int len = this.btns.length;
                for (int i = 0; i < len; ++i) {
                    if (this.btns[i] == null || this.btns[i].isAlone()) continue;
                    this.isDirty = true;
                    this.btns[i].setColSpan(2, 405);
                }
                this.saveLayoutParams();
                this.closeWindow();
                break;
            }
            case 1: {
                this.setVisible(false);
                this.dispose();
                break;
            }
            case 2: {
                return;
            }
        }
    }

    private void previewLayout() throws Exception {
        if (this.allParams == null || this.allParams.isEmpty()) {
            return;
        }
        KDPanel panel = new KDPanel();
        panel.setPreferredSize(new Dimension(this.wSpinner.getIntegerVlaue() - 265, 320));
        String sourceReportOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        DefaultArgInput argInput = new DefaultArgInput("", sourceReportOrgID);
        LayoutFilterUIWizard.sortAllParams(this.allParams, LayoutParameterIO.fromXml(this.getColSpans()));
        argInput.setArgsLayout(panel, this.allParams, LayoutParameterIO.fromXml(this.getColSpans()));
        ReportCommonFilterUI commonFilterUI = new ReportCommonFilterUI((JPanel)panel, null, null, null, 0, FilterUIType.REPORT);
        commonFilterUI.setSize(this.wSpinner.getIntegerVlaue().intValue(), this.hSpinner.getIntegerVlaue().intValue());
        ReportDialog.showDialog((CoreUIObject)commonFilterUI, (String)com.kingdee.eas.rpts.ctrlreport.util.MessageUtil.getMsgInfo("label35"), (boolean)true, (boolean)true, (Window)((Object)this));
    }

    private void initComponents() {
        KDPanel panel = new KDPanel();
        panel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(10, 10, 500, 450));
        panel.setLayout((LayoutManager)new KDLayout());
        panel.setPreferredSize(new Dimension(500, 520));
        KDLayout.Constraints cons = null;
        KDLabel label = new KDLabel();
        label.setText("\u8fc7\u6ee4\u7a97\u53e3\u9ed8\u8ba4\u5927\u5c0f\uff1a");
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 10, 120, 20);
        cons.anchor = 5;
        label.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        int[] wh = LayoutFilterUIWizard.getFilterDialogSize(this.book);
        KDLabelContainer cWidth = new KDLabelContainer();
        cWidth.setBoundLabel((JLabel)new KDLabel("\u5bbd\u5ea6 "));
        cWidth.setBoundLabelUnderline(true);
        this.wSpinner = new KDSpinner();
        ((SpinnerNumberModel)this.wSpinner.getModel()).setMinimum(Integer.valueOf(460));
        this.wSpinner.setValue((Object)(wh == null ? 685 : wh[0]));
        cWidth.setBoundEditor((JComponent)this.wSpinner);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(120, 10, 125, 20);
        cons.anchor = 5;
        cWidth.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        KDLabelContainer cHeight = new KDLabelContainer();
        cHeight.setBoundLabel((JLabel)new KDLabel("\u9ad8\u5ea6 "));
        cHeight.setBoundLabelUnderline(true);
        this.hSpinner = new KDSpinner();
        ((SpinnerNumberModel)this.hSpinner.getModel()).setMinimum(Integer.valueOf(1));
        this.hSpinner.setValue((Object)(wh == null ? 435 : wh[1]));
        cHeight.setBoundEditor((JComponent)this.hSpinner);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(255, 10, 125, 20);
        cons.anchor = 5;
        cHeight.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        KDLabel labelParams = new KDLabel();
        labelParams.setText("\u70b9\u51fb\u6309\u94ae\u6392\u5217\u53c2\u6570\uff1a");
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 35, 125, 20);
        cons.anchor = 5;
        labelParams.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.panelParams = this.createParamsPanel();
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(0, 0, 415, 325);
        cons.anchor = 7;
        this.panelParams.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.panelParams.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.panelSort = this.createSortPanel();
        this.panelSort.setPreferredSize(new Dimension(70, PANEL_HEIGHT));
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(415, 0, 70, 325);
        cons.anchor = 7;
        this.panelSort.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.mainLayoutPanel = new KDPanel();
        this.mainLayoutPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(10, 10, 485, 330));
        this.mainLayoutPanel.setLayout((LayoutManager)new KDLayout());
        this.mainLayoutPanel.setPreferredSize(new Dimension(485, PANEL_HEIGHT + 10));
        this.mainLayoutPanel.add((Component)this.panelParams);
        this.mainLayoutPanel.add((Component)this.panelSort);
        KDScrollPane scrollPanel = new KDScrollPane((Component)this.mainLayoutPanel);
        scrollPanel.setHorizontalScrollBarPolicy(31);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 55, 505, 320);
        cons.anchor = 7;
        scrollPanel.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        KDLabel labelTips = new KDLabel();
        labelTips.setText("\u63d0\u793a\uff1a\u4fee\u6539\u6570\u636e\u96c6\u7684\u53c2\u6570\u540e\uff0c\u8bf7\u91cd\u65b0\u5728\u6b64\u4fdd\u5b58\u53c2\u6570\u5e03\u5c40\u7684\u8bbe\u7f6e\uff01");
        labelTips.setForeground(Color.BLUE);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 385, 400, 20);
        cons.anchor = 6;
        labelTips.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        panel.add((Component)label);
        panel.add((Component)cWidth);
        panel.add((Component)cHeight);
        panel.add((Component)labelParams);
        panel.add((Component)scrollPanel);
        panel.add((Component)labelTips);
        if (this.saveBtn == null) {
            this.saveBtn = new KDButton("\u4fdd\u5b58");
        }
        if (this.previewBtn == null) {
            this.previewBtn = new KDButton("\u9884\u89c8");
        }
        if (this.defaultLytBtn == null) {
            this.defaultLytBtn = new KDButton("\u6062\u590d\u5230\u7cfb\u7edf\u81ea\u52a8\u5e03\u5c40");
        }
        if (this.exitBtn == null) {
            this.exitBtn = new KDButton("\u53d6\u6d88");
        }
        KDSeparator separator = new KDSeparator();
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(0, 410, 540, 5);
        cons.anchor = 14;
        separator.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 420, 150, 22);
        cons.anchor = 6;
        this.defaultLytBtn.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(266, 420, 60, 22);
        cons.anchor = 10;
        this.previewBtn.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(343, 420, 60, 22);
        cons.anchor = 10;
        this.saveBtn.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(420, 420, 60, 22);
        cons.anchor = 10;
        this.exitBtn.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        panel.add((Component)separator);
        panel.add((Component)this.defaultLytBtn);
        panel.add((Component)this.previewBtn);
        panel.add((Component)this.saveBtn);
        panel.add((Component)this.exitBtn);
        this.setSize(515, 485);
        this.setMinimumSize(new Dimension(515, 485));
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setTitle("\u5ba2\u6237\u7aef\u62a5\u8868\u8fc7\u6ee4\u754c\u9762\u8bbe\u7f6e");
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
    }

    private KDPanel createParamsPanel() {
        this.allParams = this.getAllUnionParam();
        KDPanel panelParams = new KDPanel();
        int panelPreHeight = 0;
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(0);
        panelParams.setLayout((LayoutManager)layout);
        if (this.allParams != null && !this.allParams.isEmpty()) {
            this.btns = new LayoutWorkButton[this.allParams.size()];
            HashMap<String, Integer> colSpanMap = LayoutFilterUIWizard.getColSpans(this.book);
            LayoutFilterUIWizard.sortAllParams(this.allParams, colSpanMap);
            int paramCount = 0;
            int hideParam = 0;
            int i = 0;
            int nextColSpan = 0;
            Integer colSpan = 2;
            int len = this.allParams.size();
            for (int j = 0; j < len; ++j) {
                DesignParameter designParam = this.allParams.get(j);
                if (designParam.getInputState().intValue() == 2) {
                    ++hideParam;
                    continue;
                }
                i = hideParam != 0 ? j - hideParam : j;
                this.btns[i] = new LayoutWorkButton(designParam.getAlias() + "(" + designParam.getInputType().getName() + ")");
                this.btns[i].setName("" + i);
                this.btns[i].setParamName(designParam.getName());
                this.btns[i].setInputType(designParam.getInputType().intValue());
                panelParams.add((Component)((Object)this.btns[i]));
                this.btns[i].addActionListener(new ButtonLayoutListener());
                if (nextColSpan != 0) {
                    this.btns[i].setColSpan(nextColSpan, 405);
                    paramCount = nextColSpan == 2 ? 0 : 1;
                    nextColSpan = 0;
                    continue;
                }
                colSpan = colSpanMap == null ? Integer.valueOf(2) : colSpanMap.get(designParam.getName());
                if (colSpan == null || colSpan <= 0 || this.isSpanAllCols(this.btns[i])) {
                    if (colSpan == null) {
                        this.isDirty = true;
                    } else if (paramCount == 0 && colSpan != null && colSpan == 1) {
                        this.isDirty = true;
                        nextColSpan = 2;
                    }
                    colSpan = 2;
                }
                this.btns[i].setColSpan(colSpan, 405);
                if (paramCount == 1) {
                    if (colSpan == 2) {
                        this.btns[i - 1].setColSpan(colSpan, 405);
                        panelPreHeight += this.btns[i].getPreferredSize().height + layout.getVgap();
                    }
                    paramCount = 0;
                    panelPreHeight += this.btns[i].getPreferredSize().height + layout.getVgap();
                    continue;
                }
                if (colSpan == 1) {
                    ++paramCount;
                    continue;
                }
                panelPreHeight += this.btns[i].getPreferredSize().height + layout.getVgap();
            }
            LayoutWorkButton[] destBtns = new LayoutWorkButton[this.btns.length - hideParam];
            System.arraycopy(this.btns, 0, destBtns, 0, this.btns.length - hideParam);
            this.btns = destBtns;
            if (paramCount == 1) {
                this.btns[this.btns.length - 1].setColSpan(2, 405);
            }
        }
        PANEL_HEIGHT = panelPreHeight;
        panelParams.setPreferredSize(new Dimension(405, panelPreHeight));
        return panelParams;
    }

    private ArrayList<DesignParameter> getAllUnionParam() {
        ExtDataSet[] datasets = MiscUtil.collectExtDataSets((Book)this.book);
        ArrayList<DesignParameter> allUnionParam = new ArrayList<DesignParameter>();
        String sourceReportOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        try {
            RunReportParam.cacheDbSourceModel(null, datasets, new ArrayList(), allUnionParam, null, sourceReportOrgID, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return allUnionParam;
    }

    private void saveLayoutParams() {
        if (this.btns == null || this.btns.length <= 0) {
            return;
        }
        this.book.setUserObject(FILTERUI_SIZE, (Object)(this.wSpinner.getIntegerVlaue() + COMMA_SEPARATOR + this.hSpinner.getIntegerVlaue()));
        this.book.setUserObject(FILTERUI_ARGS_COLSPAN, (Object)(this.isBackToDefault ? null : this.getColSpans()));
        MessageUtil.msgboxInfo((Component)((Object)this), (String)"\u4fdd\u5b58\u6210\u529f\uff01");
        this.isDirty = false;
        this.closeWindow();
    }

    private String getColSpans() {
        return LayoutParameterIO.toXml(this.btns);
    }

    private void closeWindow() {
        if (this.isDirty) {
            switch (MessageUtil.msgboxYesNoCancel((Component)((Object)this), (Object)"\u8fc7\u6ee4\u754c\u9762\u5927\u5c0f\u6216\u53c2\u6570\u5e03\u5c40\u53d1\u751f\u53d8\u5316\uff0c\u662f\u5426\u4fdd\u5b58\uff1f")) {
                case 0: {
                    this.saveLayoutParams();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    public boolean prepare() {
        return true;
    }

    public void commit() {
    }

    public static int[] getFilterDialogSize(Book book) {
        String widthHeight = (String)book.getUserObjectValue(FILTERUI_SIZE);
        if (!StringUtil.isEmptyString((String)widthHeight)) {
            String[] wh = widthHeight.split(COMMA_SEPARATOR);
            return new int[]{Integer.valueOf(wh[0]), Integer.valueOf(wh[1])};
        }
        return null;
    }

    public static HashMap<String, Integer> getColSpans(Book book) {
        String colSpan = (String)book.getUserObjectValue(FILTERUI_ARGS_COLSPAN);
        if (StringUtil.isEmptyString((String)colSpan)) {
            return null;
        }
        try {
            return LayoutParameterIO.fromXml(colSpan);
        }
        catch (Exception e) {
            System.out.println("\u83b7\u53d6\u53c2\u6570\u5e03\u5c40\u4fe1\u606f\u5931\u8d25\uff01");
            e.printStackTrace();
            return null;
        }
    }

    private boolean isSpanAllCols(LayoutWorkButton btn) {
        return btn.getInputType() == 3 || btn.getInputType() == 8 || btn.getInputType() == 10;
    }

    private void refreshParamsPanel() {
        if (this.panelParams == null) {
            return;
        }
        this.panelParams.removeAll();
        for (LayoutWorkButton btn : this.btns) {
            this.panelParams.add((Component)((Object)btn));
        }
        this.panelParams.validate();
    }

    private void addSortBtn(KDPanel panelSort) {
        if (this.btns == null) {
            return;
        }
        int index = 0;
        this.sortBtns = new SortWorkButton[this.btns.length * 2];
        for (int i = 0; i < this.btns.length; ++i) {
            LayoutWorkButton btn = this.btns[i];
            SortWorkButton upWorkButton = new SortWorkButton(ResourceManager.getImageIcon((String)"tbtn_moveup.gif"));
            SortWorkButton downWorkButton = new SortWorkButton(ResourceManager.getImageIcon((String)"tbtn_movedown.gif"));
            upWorkButton.setMargin(new Insets(2, 4, 1, 4));
            downWorkButton.setMargin(new Insets(2, 4, 1, 4));
            upWorkButton.setContentAreaFilled(false);
            downWorkButton.setContentAreaFilled(false);
            upWorkButton.setName("" + i);
            downWorkButton.setName("" + i);
            upWorkButton.setSortType("UP");
            downWorkButton.setSortType("DOWN");
            if (!btn.isAlone()) {
                upWorkButton.setColSpan(1);
                downWorkButton.setColSpan(1);
                ++i;
            }
            this.sortBtns[index++] = upWorkButton;
            this.sortBtns[index++] = downWorkButton;
            panelSort.add((Component)((Object)upWorkButton));
            panelSort.add((Component)((Object)downWorkButton));
            upWorkButton.addActionListener(new SortButtonActionListener());
            downWorkButton.addActionListener(new SortButtonActionListener());
            upWorkButton.addMouseListener(new SortButtonMouseListener());
            downWorkButton.addMouseListener(new SortButtonMouseListener());
        }
    }

    public static void sortAllParams(List<DesignParameter> allParams, Book book) {
        HashMap<String, Integer> layoutInfo = LayoutFilterUIWizard.getColSpans(book);
        if (layoutInfo == null || layoutInfo.size() == 0 || allParams == null || allParams.size() == 0) {
            return;
        }
        int addCount = 0;
        int layoutChangeCount = 0;
        int hideCount = 0;
        boolean isNewVersion = false;
        int len = allParams.size();
        for (int j = 0; j < len; ++j) {
            DesignParameter designParameter = allParams.get(j);
            if (designParameter.getInputState().intValue() == 2) {
                ++hideCount;
            }
            Integer colSpan = layoutInfo.get(designParameter.getName());
            Integer index = layoutInfo.get(designParameter.getName() + "_index");
            if (index != null) {
                isNewVersion = true;
            }
            if (colSpan != null || designParameter.getInputState().intValue() == 2) continue;
            ++addCount;
        }
        layoutChangeCount = layoutInfo.size() - (allParams.size() - addCount - hideCount);
        if (isNewVersion) {
            layoutChangeCount = layoutInfo.size() / 2 - (allParams.size() - addCount - hideCount);
        }
        if (layoutChangeCount > 0) {
            book.setUserObject(FILTERUI_ARGS_COLSPAN, null);
            allParams = LayoutFilterUIWizard.getAllUnionParam(book);
            return;
        }
        LayoutFilterUIWizard.sortAllParams(allParams, layoutInfo);
    }

    private static void sortAllParams(List<DesignParameter> allParams, HashMap<String, Integer> colSpanMap) {
        if (colSpanMap == null) {
            return;
        }
        for (int i = 0; i < allParams.size(); ++i) {
            DesignParameter designParameter = allParams.get(i);
            Integer index = colSpanMap.get(designParameter.getName() + "_index");
            if (index == null || index == i) continue;
            DesignParameter temp = allParams.get(index);
            allParams.set(index, designParameter);
            allParams.set(i, temp);
            --i;
        }
    }

    private static ArrayList<DesignParameter> getAllUnionParam(Book book) {
        ExtDataSet[] datasets = MiscUtil.collectExtDataSets((Book)book);
        ArrayList<DesignParameter> allUnionParam = new ArrayList<DesignParameter>();
        String sourceReportOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        try {
            RunReportParam.cacheDbSourceModel(null, datasets, new ArrayList(), allUnionParam, null, sourceReportOrgID, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return allUnionParam;
    }

    private KDPanel createSortPanel() {
        KDPanel panelSort = new KDPanel();
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(0);
        panelSort.setLayout((LayoutManager)layout);
        this.addSortBtn(panelSort);
        return panelSort;
    }

    private void refreshSortPanel() {
        if (this.panelSort == null) {
            return;
        }
        this.panelSort.removeAll();
        this.addSortBtn(this.panelSort);
        this.panelSort.setPreferredSize(new Dimension(70, this.btns[this.btns.length - 1].getY() + this.btns[this.btns.length - 1].getHeight()));
        this.panelSort.revalidate();
        this.panelSort.getParent().repaint();
        this.mainLayoutPanel.setPreferredSize(new Dimension(485, this.btns[this.btns.length - 1].getY() + this.btns[this.btns.length - 1].getHeight() + 10));
    }

    class SortButtonActionListener
    implements ActionListener {
        SortButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (LayoutFilterUIWizard.this.btns == null || LayoutFilterUIWizard.this.btns.length <= 0) {
                return;
            }
            SortWorkButton sortBtn = (SortWorkButton)((Object)e.getSource());
            Integer index = Integer.valueOf(sortBtn.getName());
            if (index == null) {
                return;
            }
            String sortType = sortBtn.getSortType();
            int colSpan = sortBtn.getColSpan();
            if ("UP".equals(sortType)) {
                if (index == 0) {
                    return;
                }
                LayoutWorkButton preBtn = LayoutFilterUIWizard.this.btns[index - 1];
                LayoutWorkButton btn = LayoutFilterUIWizard.this.btns[index];
                if (colSpan == 2) {
                    if (preBtn.isAlone()) {
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue()] = preBtn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() - 1] = btn;
                        btn.setName(index - 1 + "");
                        preBtn.setName(index + "");
                    } else {
                        LayoutWorkButton prePreBtn = LayoutFilterUIWizard.this.btns[index - 2];
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() - 2] = btn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() - 1] = prePreBtn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue()] = preBtn;
                        btn.setName(index - 2 + "");
                        prePreBtn.setName(index - 1 + "");
                        preBtn.setName(index + "");
                    }
                } else {
                    LayoutWorkButton nextBtn = LayoutFilterUIWizard.this.btns[index + 1];
                    if (preBtn.isAlone()) {
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() - 1] = btn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue()] = nextBtn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() + 1] = preBtn;
                        btn.setName(index - 1 + "");
                        nextBtn.setName(index + "");
                        preBtn.setName(index + 1 + "");
                    } else {
                        LayoutWorkButton prePreBtn = LayoutFilterUIWizard.this.btns[index - 2];
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() - 2] = btn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() - 1] = nextBtn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue()] = preBtn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() + 1] = prePreBtn;
                        btn.setName(index - 2 + "");
                        nextBtn.setName(index - 1 + "");
                        preBtn.setName(index + "");
                        prePreBtn.setName(index + 1 + "");
                    }
                }
            } else if ("DOWN".equals(sortType)) {
                if (index == LayoutFilterUIWizard.this.btns.length - 1) {
                    return;
                }
                LayoutWorkButton btn = LayoutFilterUIWizard.this.btns[index];
                LayoutWorkButton nextBtn = LayoutFilterUIWizard.this.btns[index + 1];
                if (colSpan == 2) {
                    if (nextBtn.isAlone()) {
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue()] = nextBtn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() + 1] = btn;
                        btn.setName(index + 1 + "");
                        nextBtn.setName(index + "");
                    } else {
                        LayoutWorkButton nextNextBtn = LayoutFilterUIWizard.this.btns[index + 2];
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue()] = nextBtn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() + 1] = nextNextBtn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() + 2] = btn;
                        btn.setName(index + 2 + "");
                        nextNextBtn.setName(index + 1 + "");
                        nextBtn.setName(index + "");
                    }
                } else {
                    LayoutWorkButton nextNextBtn = LayoutFilterUIWizard.this.btns[index + 2];
                    if (nextNextBtn.isAlone()) {
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue()] = nextNextBtn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() + 1] = btn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() + 2] = nextBtn;
                        btn.setName(index + 1 + "");
                        nextBtn.setName(index + 2 + "");
                        nextNextBtn.setName(index + "");
                    } else {
                        LayoutWorkButton nextNextNextBtn = LayoutFilterUIWizard.this.btns[index + 3];
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue()] = nextNextBtn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() + 1] = nextNextNextBtn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() + 2] = btn;
                        ((LayoutFilterUIWizard)LayoutFilterUIWizard.this).btns[index.intValue() + 3] = nextBtn;
                        nextNextBtn.setName(index + "");
                        nextNextNextBtn.setName(index + 1 + "");
                        btn.setName(index + 2 + "");
                        nextBtn.setName(index + 3 + "");
                    }
                }
            }
            LayoutFilterUIWizard.this.refreshParamsPanel();
            LayoutFilterUIWizard.this.refreshSortPanel();
            LayoutFilterUIWizard.this.isDirty = true;
        }
    }

    class SortButtonMouseListener
    implements MouseListener {
        SortButtonMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SortWorkButton btn = (SortWorkButton)((Object)e.getSource());
            btn.setContentAreaFilled(true);
            btn.setContentAreaFilled(true);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SortWorkButton btn = (SortWorkButton)((Object)e.getSource());
            btn.setContentAreaFilled(false);
            btn.setContentAreaFilled(false);
        }
    }

    private class ButtonLayoutListener
    implements ActionListener {
        private ButtonLayoutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LayoutFilterUIWizard.this.isBackToDefault = false;
            if (LayoutFilterUIWizard.this.btns == null || LayoutFilterUIWizard.this.btns.length <= 0) {
                return;
            }
            LayoutWorkButton btn = (LayoutWorkButton)((Object)e.getSource());
            if (LayoutFilterUIWizard.this.isSpanAllCols(btn)) {
                return;
            }
            int index = Integer.valueOf(btn.getName());
            if (index + 1 < LayoutFilterUIWizard.this.btns.length && btn.isAlone() && LayoutFilterUIWizard.this.isSpanAllCols(LayoutFilterUIWizard.this.btns[index + 1])) {
                return;
            }
            KDPanel panel = (KDPanel)btn.getParent();
            this.layoutFilterCtrl(btn, panel);
            LayoutFilterUIWizard.this.refreshSortPanel();
            panel.doLayout();
            LayoutFilterUIWizard.this.panelParams.setPreferredSize(new Dimension(410, LayoutFilterUIWizard.this.btns[LayoutFilterUIWizard.this.btns.length - 1].getY() + LayoutFilterUIWizard.this.btns[LayoutFilterUIWizard.this.btns.length - 1].getHeight()));
            panel.getParent().doLayout();
            LayoutFilterUIWizard.this.isDirty = true;
        }

        private void layoutFilterCtrl(LayoutWorkButton btn, KDPanel panel) {
            int index = Integer.valueOf(btn.getName());
            if (btn.isAlone()) {
                if (index - 1 >= 0 && LayoutFilterUIWizard.this.btns[index - 1].getY() == btn.getY()) {
                    LayoutFilterUIWizard.this.btns[index - 1].setColSpan(1, 405);
                }
                if (index < LayoutFilterUIWizard.this.btns.length - 1) {
                    btn.setColSpan(1, 405);
                }
                if (index + 1 < LayoutFilterUIWizard.this.btns.length) {
                    if (!LayoutFilterUIWizard.this.btns[index + 1].isAlone()) {
                        LayoutFilterUIWizard.this.btns[index + 2].setColSpan(2, 405);
                    }
                    LayoutFilterUIWizard.this.btns[index + 1].setColSpan(1, 405);
                }
            } else {
                if (index - 1 >= 0 && LayoutFilterUIWizard.this.btns[index - 1].getY() == btn.getY()) {
                    LayoutFilterUIWizard.this.btns[index - 1].setColSpan(2, 405);
                }
                btn.setColSpan(2, 405);
                if (index + 1 < LayoutFilterUIWizard.this.btns.length && LayoutFilterUIWizard.this.btns[index + 1].getY() == btn.getY()) {
                    LayoutFilterUIWizard.this.btns[index + 1].setColSpan(2, 405);
                }
            }
        }
    }
}

