/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlsqldesign.param.arg.component;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.macro.exec.ExtRptMacroExecuteFacade;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroVO;
import com.kingdee.eas.rpts.ctrlreport.macro.model.MacroValue;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.client.DesignUI;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.rpts.ctrlsqldesign.model.OrgRangeManage;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.SqlDSModelDrill;
import com.kingdee.eas.rpts.ctrlsqldesign.param.ArgInputComponentFactory;
import com.kingdee.eas.rpts.statistics.dynamic.DefaultExtStatisticsRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class KDComboBoxCreator {
    private static Logger log = LogUtil.getPackageLogger(KDComboBoxCreator.class);

    public static KDComboBox getComboBoxCtrl(DesignParameter p, String sourceReportOrgID, int runtimeType, ExecutionContext exeCtx, DesignParameter[] relatedParams) throws Exception {
        KDComboBox kDComboBox = new KDComboBox();
        IInputCtrl inputCtrl = p.getInputCtrl();
        if (null == inputCtrl) {
            return kDComboBox;
        }
        ArgInputComponentFactory.setCommonProperties((IKDTextComponent)kDComboBox, p);
        int bind = inputCtrl.getDataBind();
        if (bind == 0) {
            KDComboBoxCreator.getComboBoxCtrl_INTDB(kDComboBox, inputCtrl, sourceReportOrgID, exeCtx, relatedParams);
        } else if (bind == 6) {
            KDComboBoxCreator.getComboBoxCtrl_INTSYSTEM(kDComboBox, inputCtrl, exeCtx);
        } else if (bind == 7) {
            Map<String, MacroVO> innerMacros = null;
            if (exeCtx == null) {
                if (DesignUI.getInstance() != null && DesignUI.getInstance().getDataset() != null) {
                    innerMacros = DefaultExtStatisticsRunner.loadUsedMacros(DesignUI.getInstance().getDataset().getBook());
                }
            } else {
                innerMacros = DefaultExtStatisticsRunner.loadUsedMacros(exeCtx.getBook());
            }
            MacroValue value = ExtRptMacroExecuteFacade.remoteExecute(innerMacros, inputCtrl.getDefDbsource().getName());
            String displayKey = inputCtrl.getDefDisplay().getName();
            String valueKey = inputCtrl.getDefValue().getName();
            int displayIndex = -1;
            int valueIndex = -1;
            ArrayList<DefObj> itemDatas = new ArrayList<DefObj>();
            for (int i = 0; i < value.getColums().length; ++i) {
                if (value.getColums()[i].equalsIgnoreCase(displayKey)) {
                    displayIndex = i;
                }
                if (value.getColums()[i].equalsIgnoreCase(valueKey)) {
                    valueIndex = i;
                }
                if (displayIndex != -1 && valueIndex != -1) break;
            }
            for (Variant[] row : value.getValues()) {
                DefObj o = new DefObj();
                o.setName(CtrlReportUtil.getObjectString(row[valueIndex]));
                o.setAlias(CtrlReportUtil.getObjectString(row[displayIndex]));
                itemDatas.add(o);
            }
            KDComboBoxCreator.buildComboBox(kDComboBox, itemDatas.iterator(), valueKey, displayKey);
        } else if (bind == 1) {
            Iterator itemDataIter = inputCtrl.getSelfList().iterator();
            KDComboBoxCreator.buildComboBox(kDComboBox, itemDataIter, null, null);
        }
        if (p.getDefaultValue() != null) {
            int size = kDComboBox.getItemCount();
            String defaultValue = p.getDefaultValue();
            if (!"#@$firstData$@#".equals(defaultValue)) {
                String[] stringArray;
                defaultValue = ArgInputComponentFactory.pertreateParameter(exeCtx == null ? null : DefaultExtStatisticsRunner.loadUsedMacros(exeCtx.getBook()), defaultValue, runtimeType);
                if (defaultValue == null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "";
                } else {
                    stringArray = defaultValue.split("0xx1xx");
                }
                String[] values = stringArray;
                for (int i = 0; i < size; ++i) {
                    DefObj defObj = (DefObj)kDComboBox.getItemAt(i);
                    if (!defObj.getName().equals(values[0]) || null == defObj.getAlias()) continue;
                    kDComboBox.setSelectedItem((Object)defObj);
                    break;
                }
            } else if (size > 1) {
                kDComboBox.setSelectedIndex(1);
            }
        }
        return kDComboBox;
    }

    private static final void getComboBoxCtrl_INTSYSTEM(KDComboBox kDComboBox, IInputCtrl inputCtrl, ExecutionContext exeCtx) {
        ArrayList<HashMap<String, String>> lst;
        String systemVarType = inputCtrl.getDefDbsource().getName();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String reportId = null;
        if (exeCtx != null) {
            reportId = exeCtx.getReportId();
        }
        if ((lst = OrgRangeManage.getOrgRangeList(null, userId, Integer.valueOf(systemVarType), reportId)) == null || lst.isEmpty()) {
            return;
        }
        String displayKey = inputCtrl.getDefDisplay().getName();
        String valueKey = inputCtrl.getDefValue().getName();
        Iterator<HashMap<String, String>> itemDataIter = lst.iterator();
        KDComboBoxCreator.buildComboBox(kDComboBox, itemDataIter, valueKey.toLowerCase(), displayKey.toLowerCase());
    }

    private static final void getComboBoxCtrl_INTDB(KDComboBox kDComboBox, IInputCtrl inputCtrl, String sourceReportOrgID, ExecutionContext exeCtx, DesignParameter[] relatedParams) throws Exception {
        String displayKey = "alias";
        String valueKey = "value";
        String dataSetType = inputCtrl.getDataSetType();
        boolean isKSQL = !"6".equals(dataSetType);
        DefObj def = inputCtrl.getDefDbsource();
        String fid = def.getName();
        String dbsourceName = def.getAlias();
        if (isKSQL) {
            displayKey = inputCtrl.getDefDisplay().getName();
            valueKey = inputCtrl.getDefValue().getName();
            String systemid = CtrlReportUtil.getObjectString(def.getProperty("systemID"));
            if (!systemid.equals("")) {
                fid = fid + "\\" + systemid + "\\" + dbsourceName;
            }
        }
        String orgID = ArgInputComponentFactory.getCurrentOrgId(sourceReportOrgID);
        String orgName = ArgInputComponentFactory.getCurrentOrgName();
        HashMap<String, String> models = null;
        if (null != exeCtx) {
            models = new HashMap<String, String>();
            String systemID = CtrlReportUtil.getObjectString(def.getProperty("systemID"));
            String embedMetaData = (String)exeCtx.getDataSetCacheObject((Object)SqlDSModelDrill.getKey(dbsourceName, systemID));
            models.put(SqlDSModelDrill.getKey(dbsourceName, systemID), embedMetaData);
        }
        Iterator itemDataIter = null;
        try {
            itemDataIter = RunReportParam.getBizDataList(null, isKSQL, fid, orgID, orgName, models, relatedParams).iterator();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        KDComboBoxCreator.buildComboBox(kDComboBox, itemDataIter, valueKey.toLowerCase(), displayKey.toLowerCase());
    }

    private static void buildComboBox(KDComboBox kDComboBox, Iterator itemDataIter, String valueKey, String displayKey) {
        String defName = "";
        String defAlias = "";
        if (itemDataIter.hasNext()) {
            kDComboBox.addItem((Object)KDComboBoxCreator.addItemToComboBox(kDComboBox, defName, defAlias));
        }
        while (itemDataIter.hasNext()) {
            DefObj item;
            Object dataItem = itemDataIter.next();
            DefObj defObj = item = dataItem instanceof DefObj ? (DefObj)dataItem : null;
            if (null == item && !StringUtils.isEmpty((String)valueKey)) {
                Map mapItem = (Map)dataItem;
                defName = CtrlReportUtil.getObjectString(mapItem.get(valueKey));
                defAlias = CtrlReportUtil.getObjectString(mapItem.get(displayKey));
                item = KDComboBoxCreator.addItemToComboBox(kDComboBox, defName, defAlias);
            }
            if (null == item) continue;
            kDComboBox.addItem((Object)item);
        }
    }

    private static DefObj addItemToComboBox(KDComboBox kDComboBox, String name, String alias) {
        DefObj item = new DefObj();
        item.setName(name);
        item.setAlias(alias);
        return item;
    }
}

