/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.mobileService;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.JSONLibDataFormatSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.mobileService.common.IResourceMethodHandler;
import com.kingdee.eas.rpts.mobileService.common.ResourceMethodFactory;
import com.kingdee.eas.rpts.mobileService.model.MobileResult;
import com.kingdee.eas.rpts.mobileService.runtime.Env;
import com.kingdee.eas.rpts.mobileService.util.ExtMobileJSONUtils;
import java.io.IOException;
import java.sql.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExtMobileRptService {
    private static Logger logger = CommonLogger.getLogger(ExtMobileRptService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String action(Context ctx, String json) throws IOException {
        Locale src = Locale.getDefault();
        Locale.setDefault(Locale.CHINA);
        Env.enter();
        String methodName = "";
        try {
            Map params = (Map)JSON.parse((String)json);
            ExtMobileRptService.setup(ctx, params);
            methodName = (String)params.get("remoteMethod");
            IResourceMethodHandler handler = ResourceMethodFactory.methodHandler(methodName);
            if (handler == null) {
                if (methodName.indexOf("Card") >= 0) {
                    String string = ExtMobileRptService.buildErrorResult(new MobileResult("no handler for method\uff1a" + methodName, 9999));
                    return string;
                }
                String string = ExtMobileRptService.buildJsonResult(new MobileResult("no handler for method\uff1a" + methodName, 9999));
                return string;
            }
            long start = System.currentTimeMillis();
            logger.error((Object)("-------------client request method[" + methodName + "]-------------"));
            MobileResult ret = handler.handle(ctx, handler.loadArgs(params));
            logger.error((Object)("-------------" + methodName + " service ok(" + (System.currentTimeMillis() - start) + ")-------------"));
            String string = ExtMobileRptService.buildJsonResult(ret);
            return string;
        }
        catch (ExtRptBizException e) {
            String string;
            logger.error((Object)"function error", (Throwable)e);
            if (methodName.indexOf("Card") >= 0) {
                string = ExtMobileRptService.buildErrorResult(new MobileResult(e.getErrorMessage(), e.getErrorCode()));
                return string;
            }
            string = ExtMobileRptService.buildJsonResult(new MobileResult(e.getErrorMessage(), e.getErrorCode()));
            return string;
        }
        finally {
            Locale.setDefault(src);
            Env.exit();
        }
    }

    private static void setup(Context easCtx, Map<String, String> params) throws ExtRptBizException {
        if (params == null) {
            return;
        }
        Env.set(Env.Key.easCtx, easCtx);
        Env.set(Env.Key.pubAcctId, params.get("pubacctid"));
        String rptId = params.get("reportId");
        String snapTag = params.get("snapshotTag");
        if (rptId != null) {
            boolean isHyperlink = false;
            if (ExtMobileJSONUtils.isJson(rptId)) {
                isHyperlink = true;
                rptId = ExtMobileJSONUtils.parseRptIdFromJson(easCtx, rptId);
            }
            Env.set(Env.Key.rptId, rptId);
            Env.set(Env.Key.webParamAdapter, new WebParamAdapter(easCtx, rptId, false));
            Env.set(Env.Key.isHyperlink, isHyperlink);
        }
        Env.set(Env.Key.snapshotTag, snapTag);
    }

    private static String buildErrorResult(MobileResult ret) {
        JSONObject json = new JSONObject();
        JSONObject errorJson = new JSONObject();
        Boolean s = ret.isSuccess();
        json.put("success", (Object)s);
        if (!s.booleanValue()) {
            errorJson.put("errorCode", (Object)ret.getErrorCode());
            errorJson.put("error", (Object)ret.getError());
        }
        json.put("data", (Object)errorJson);
        try {
            return ExtMobileRptService.toCompatibleJSONString(json);
        }
        catch (OutOfMemoryError oom) {
            oom.printStackTrace();
            json.put("success", (Object)false);
            errorJson.put("errorCode", (Object)9999);
            errorJson.put("error", (Object)"\u6570\u636e\u8f83\u591a\uff0c\u8bf7\u51cf\u5c11\u7ed3\u679c\u6570\u636e\u518d\u8bd5");
            json.put("data", (Object)errorJson);
            return json.toString();
        }
    }

    private static String buildJsonResult(MobileResult ret) {
        JSONObject json = new JSONObject();
        Boolean s = ret.isSuccess();
        json.put("success", (Object)s);
        if (!s.booleanValue()) {
            json.put("errorCode", (Object)ret.getErrorCode());
            json.put("errorMessage", (Object)ret.getError());
        }
        Object obj = ret.getData();
        json.put("data", obj);
        try {
            return ExtMobileRptService.toCompatibleJSONString(json);
        }
        catch (OutOfMemoryError oom) {
            oom.printStackTrace();
            json.put("data", null);
            json.put("success", (Object)false);
            json.put("errorCode", (Object)9999);
            json.put("errorMessage", (Object)"\u6570\u636e\u8f83\u591a\uff0c\u8bf7\u51cf\u5c11\u7ed3\u679c\u6570\u636e\u518d\u8bd5");
            return json.toString();
        }
    }

    private static String toCompatibleJSONString(Object object) {
        SerializeConfig config = new SerializeConfig();
        config.put(java.util.Date.class, (ObjectSerializer)new JSONLibDataFormatSerializer());
        config.put(Date.class, (ObjectSerializer)new JSONLibDataFormatSerializer());
        SerializerFeature[] features = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.BrowserCompatible};
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])features);
    }
}

