/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.mobileService.rpt;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAXException;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.CardContentBo;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.CardContentDAO;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.CardDAO;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputType;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.mobileService.common.IResourceMethodHandler;
import com.kingdee.eas.rpts.mobileService.license.ExtLightRptLisenceScavenger;
import com.kingdee.eas.rpts.mobileService.model.MobileResult;
import com.kingdee.eas.rpts.mobileService.rpt.ExtLightOrgsForReportHandler;
import com.kingdee.eas.rpts.mobileService.rpt.ExtLightReportContentHandler;
import com.kingdee.eas.rpts.mobileService.runtime.Env;
import com.kingdee.eas.rpts.mobileService.util.ExtLightCardContentExecuteUtil;
import com.kingdee.eas.rpts.mobileService.util.OrgSwitchHelper;
import com.kingdee.eas.rpts.web.man.MobileReportImpl;
import com.kingdee.eas.rpts.web.util.BeanFactory;
import com.kingdee.eas.rpts.web.vo.ReportInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ExtLightCardExecuteHandler
implements IResourceMethodHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MobileResult handle(Context easCtx, String ... args) throws ExtRptBizException {
        ExtLightRptLisenceScavenger.checkModuleLisence(easCtx);
        String currentOrgId = ((OrgUnitInfo)easCtx.get((Object)"CurOU")).getId().toString();
        try {
            Object info;
            String rptId = (String)Env.get(Env.Key.rptId);
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)easCtx);
            String userId = userInfo.getId().toString();
            String cardID = CardDAO.getCardID(easCtx, rptId, userId);
            CardContentBo bo = CardContentDAO.getContentByCardId(easCtx, cardID);
            String content = new String(bo.getCardContent());
            if (!StringUtil.isEmptyString((String)content) && (info = JSON.parse((String)content)) != null) {
                Date date = bo.getLastUpdateTime();
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("reportContent", info);
                data.put("lastUpdateTime", date == null ? new Date().toString() : date.toString());
                MobileResult mobileResult = new MobileResult(data);
                return mobileResult;
            }
            if (!StringUtil.isEmptyString((String)args[0])) {
                OrgSwitchHelper.switchOrg(easCtx, args[0]);
            } else {
                HashMap<String, Object> reportItem = new HashMap<String, Object>();
                ExtLightOrgsForReportHandler.listOrgs(easCtx, rptId, reportItem);
                OrgSwitchHelper.switchOrg(easCtx, (String)((Map)reportItem.get("currentOrg")).get("id"));
            }
            String filterJson = null;
            if (!StringUtil.isEmptyString((String)userId)) {
                byte[] cardFilter = CardDAO.getCardFilterByReportId(easCtx, rptId, userId);
                filterJson = cardFilter == null ? null : new String(cardFilter);
            }
            MobileResult mobileResult = ExtLightCardExecuteHandler.directlyExecute(easCtx, rptId, filterJson, cardID, null);
            return mobileResult;
        }
        finally {
            OrgSwitchHelper.switchOrg(easCtx, currentOrgId);
        }
    }

    @Override
    public String[] loadArgs(Map<String, String> params) {
        try {
            Integer height = Integer.parseInt(params.get("cardHeight"));
            Integer width = Integer.parseInt(params.get("cardWidth"));
            Env.set(Env.Key.cardHeight, height);
            Env.set(Env.Key.cardWidth, width);
        }
        catch (Exception e) {
            Env.set(Env.Key.cardHeight, Env.CARD_DEFAULT_HEIGHT);
            Env.set(Env.Key.cardWidth, Env.CARD_DEFAULT_WIDTH);
        }
        return new String[]{params.get("orgId")};
    }

    public static MobileResult directlyExecute(Context easCtx, String rptId, String filterJson, String cardID, Map macroParams) throws ExtRptBizException {
        try {
            WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
            HashMap<Object, Object> params = StringUtil.isEmptyString((String)filterJson) ? new HashMap() : ExtLightReportContentHandler.parseJSONParams(easCtx, rptId, filterJson);
            ArrayList sourceParams = adapter.mobileFetchParams();
            for (Object obj : sourceParams) {
                DesignParameter dp = (DesignParameter)((Object)obj);
                if (InputType.ALONE_CHECKBOX.equals(dp.getInputType())) {
                    DefObj def;
                    IInputCtrl ctrl = dp.getInputCtrl();
                    if ("1".equals(dp.getDefaultValue())) {
                        def = ctrl.getDefValue();
                        dp.setDefaultValue(def.getName());
                        dp.setDefaultAlias(def.getAlias());
                    } else {
                        def = ctrl.getDefDisplay();
                        dp.setDefaultValue(def.getName());
                        dp.setDefaultAlias(def.getAlias());
                    }
                }
                if (!params.containsKey(dp.getName())) {
                    dp.setCurentValue(dp.getDefaultValue());
                    dp.setCurentValueAlias(dp.getDefaultAlias());
                    params.put(dp.getName(), (Object)dp);
                }
                if (params.containsKey(dp.getName() + "_text")) continue;
                DesignParameter dp_text = new DesignParameter();
                dp_text.setDataType(DataType.STRING);
                dp_text.setDesignDataType(DesignDataType.TXT);
                dp_text.setName(dp.getName() + "_text");
                dp_text.setCurentValue(dp.getCurentValueAlias());
                dp_text.setIgnoreNull(dp.isIgnoreNull());
                params.put(dp_text.getName(), (Object)dp_text);
            }
            if (macroParams != null) {
                params.putAll((HashMap)macroParams);
            } else {
                RunReportParam.putServerDefalutListParamsMap(easCtx, params);
            }
            return ExtLightCardExecuteHandler.execute(easCtx, rptId, params, adapter, false, cardID);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw ExtRptBizException.newRptExecuteException(e);
        }
    }

    public static Object executeCard(Context easCtx, String rptId, HashMap<String, DesignParameter> params, Integer height, Integer width, WebParamAdapter adapter, String cardID) throws ExtRptBizException {
        try {
            MobileReportImpl template = MobileReportImpl.createTemplateImpl(easCtx, rptId);
            template.setContext(easCtx);
            Book book = ExtLightCardExecuteHandler.getExecutedCard(false, easCtx, rptId, params, adapter);
            template.setBook(book);
            String curSheetName = book.getActiveSheet().getSheetName();
            template.setCurrentSheetName(curSheetName);
            BeanFactory.makeupReportModelBhv().behaviour(template);
            ReportInfo data = BeanFactory.outputReportBhv().behaviour(template);
            if (data instanceof ReportInfo) {
                ExtLightCardContentExecuteUtil.reportInfoToCard(data, book, height, width);
                try {
                    String str = JSON.toJSONString((Object)data);
                    if (!StringUtil.isEmptyString((String)str)) {
                        CardContentBo bo = new CardContentBo();
                        bo.setCardId(cardID);
                        bo.setCardContent(str.getBytes());
                        CardContentDAO.updateContent(easCtx, bo);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return data;
        }
        catch (Exception e) {
            throw ExtRptBizException.newRptExecuteException(e);
        }
    }

    private static Book getExecutedCard(boolean isHyperlink, Context easCtx, String rptId, HashMap<String, DesignParameter> params, WebParamAdapter adapter) throws IOException, KDFException, KDFSAXException, Exception {
        easCtx.put((Object)"deployType", (Object)9);
        adapter.executeCard(params);
        return adapter.getBook();
    }

    private static MobileResult execute(Context easCtx, String rptId, HashMap<String, DesignParameter> params, WebParamAdapter adapter, boolean isHyperlink, String cardID) throws ExtRptBizException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Object info = ExtLightCardExecuteHandler.executeCard(easCtx, rptId, params, (Integer)Env.get(Env.Key.cardHeight), (Integer)Env.get(Env.Key.cardWidth), adapter, cardID);
        data.put("reportContent", info);
        return new MobileResult(data);
    }
}

