/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.mobileService.rpt;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.rpts.ctrlreport.mobile.exception.ExtRptBizException;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.mobileService.common.IResourceMethodHandler;
import com.kingdee.eas.rpts.mobileService.model.MobileResult;
import com.kingdee.eas.rpts.mobileService.rpt.ExtLightFilterDelayDataHandler;
import com.kingdee.eas.rpts.mobileService.runtime.Env;
import com.kingdee.eas.rpts.mobileService.util.OrgSwitchHelper;
import com.kingdee.eas.rpts.tobi.domain.WebReportDomain;
import com.kingdee.eas.rpts.web.filter.ReportParamDescription;
import com.kingdee.eas.rpts.web.filter.impl.ParamSuppliedValueDefineBySQL;
import com.kingdee.eas.rpts.web.vo.Entry;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ExtLightFilterHandler
implements IResourceMethodHandler {
    private static Logger logger = CommonLogger.getLogger(ExtLightFilterHandler.class);

    @Override
    public MobileResult handle(Context easCtx, String ... args) throws ExtRptBizException {
        String currentOrgId = ((OrgUnitInfo)easCtx.get((Object)"CurOU")).getId().toString();
        try {
            OrgSwitchHelper.switchOrg(easCtx, args[0]);
            String rptId = (String)Env.get(Env.Key.rptId);
            WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
            adapter.parseOutParam(args[1]);
            MobileResult mobileResult = new MobileResult(ExtLightFilterHandler.loadFilter(easCtx, rptId));
            return mobileResult;
        }
        catch (Exception e) {
            throw ExtRptBizException.newRptFilterVisitException(e);
        }
        finally {
            OrgSwitchHelper.switchOrg(easCtx, currentOrgId);
        }
    }

    public static TreeMap<String, Object> loadFilter(Context easCtx, String rptId) throws ExtRptBizException {
        try {
            WebParamAdapter adapter = (WebParamAdapter)Env.get(Env.Key.webParamAdapter);
            List<ReportParamDescription> pDefines = WebReportDomain.translateParams(easCtx, adapter.mobileFetchSortedParams(), adapter, rptId);
            return ExtLightFilterHandler.analysis(easCtx, pDefines, rptId);
        }
        catch (Exception e) {
            throw ExtRptBizException.newRptFilterVisitException(e);
        }
    }

    public static TreeMap<String, Object> analysis(Context easCtx, List<?> pDefines, String rptId) throws ExtRptBizException {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        ArrayList<String> orgRefParams = new ArrayList<String>();
        TreeMap<String, List<String>> paramRef = new TreeMap<String, List<String>>();
        map.put("associateWithOrg", orgRefParams);
        map.put("associate", paramRef);
        for (Object obj : pDefines) {
            List<String> relations;
            ReportParamDescription define = (ReportParamDescription)obj;
            String name = define.getName();
            if (define.isSuppliedValueOrgRelated()) {
                orgRefParams.add(name);
            }
            if ((relations = define.getRelations()) == null || relations.isEmpty()) continue;
            Iterator<String> iter = relations.iterator();
            while (iter.hasNext()) {
                if (!name.equals(iter.next())) continue;
                iter.remove();
            }
            if (relations.isEmpty()) continue;
            paramRef.put(name, relations);
        }
        map.put("params", pDefines);
        if (pDefines != null) {
            for (Object obj : pDefines) {
                ReportParamDescription param = (ReportParamDescription)obj;
                Object defaultValue = param.getDefaultValue();
                if (defaultValue instanceof Date) {
                    param.setDefaultValue(((Date)defaultValue).getTime());
                    continue;
                }
                ExtLightFilterHandler.defaultValueProcessor(easCtx, rptId, param);
            }
        }
        return map;
    }

    private static void defaultValueProcessor(Context easCtx, String rptId, ReportParamDescription<Object, ?> param) {
        int textIndex;
        HashMap jsonRowset;
        Object defaultValue = param.getDefaultValue();
        boolean defautValueIsList = defaultValue instanceof List;
        boolean defaultValueIsEntry = defaultValue instanceof Entry;
        if (!defautValueIsList && !defaultValueIsEntry) {
            return;
        }
        if (!(param.getSuppliedValueDescription() instanceof ParamSuppliedValueDefineBySQL)) {
            return;
        }
        ParamSuppliedValueDefineBySQL description = (ParamSuppliedValueDefineBySQL)param.getSuppliedValueDescription();
        try {
            jsonRowset = (HashMap)ExtLightFilterDelayDataHandler.gainSupplyValues(easCtx, description.getPersistenceModel(), rptId, null, param.getName()).getData();
        }
        catch (ExtRptBizException e) {
            jsonRowset = null;
            logger.error((Object)"------failed to parse supply values while check default values------", (Throwable)e);
        }
        if (jsonRowset == null) {
            return;
        }
        ArrayList rowsVO = (ArrayList)jsonRowset.get("rows");
        if (rowsVO == null || rowsVO.isEmpty()) {
            return;
        }
        HashMap metaVO = (HashMap)jsonRowset.get("meta");
        int valueIndex = ((ArrayList)metaVO.get("colNames")).indexOf(description.getValueFieldName().toUpperCase());
        if (valueIndex == -1) {
            valueIndex = ((ArrayList)metaVO.get("colNames")).indexOf(description.getValueFieldName());
        }
        if ((textIndex = ((ArrayList)metaVO.get("colNames")).indexOf(description.getTextFieldName().toUpperCase())) == -1) {
            textIndex = ((ArrayList)metaVO.get("colNames")).indexOf(description.getTextFieldName());
        }
        ArrayList<Entry<String, String>> list = null;
        ArrayList<Entry> remove = new ArrayList<Entry>();
        if (defautValueIsList) {
            list = (ArrayList<Entry<String, String>>)defaultValue;
            if (list.isEmpty()) {
                return;
            }
        } else if (defaultValueIsEntry) {
            if (((Entry)defaultValue).getValue() == null) {
                return;
            }
            list = new ArrayList<Entry<String, String>>();
            list.add((Entry)defaultValue);
        }
        ArrayList firstRow = null;
        block2: for (Entry entry : list) {
            for (int i = 0; i < rowsVO.size(); ++i) {
                ArrayList row = (ArrayList)rowsVO.get(i);
                if (firstRow == null) {
                    firstRow = row;
                }
                if (ExtLightFilterHandler.valueEq(entry.getValue(), row.get(valueIndex))) continue block2;
                if (i != rowsVO.size()) continue;
                remove.add(entry);
            }
        }
        if (!remove.isEmpty()) {
            list.removeAll(remove);
        }
        if (list.isEmpty()) {
            if (defaultValueIsEntry) {
                if (firstRow != null) {
                    param.setDefaultValue(new Entry(firstRow.get(valueIndex), firstRow.get(textIndex)));
                } else {
                    param.setDefaultValue(null);
                }
            } else if (defautValueIsList && list.isEmpty() && firstRow != null) {
                list.add(new Entry<String, String>(String.valueOf(firstRow.get(valueIndex)), String.valueOf(firstRow.get(textIndex))));
            }
        }
    }

    private static boolean valueEq(Object val1, Object val2) {
        if (val1 == null) {
            return val2 == null;
        }
        if (val2 == null) {
            return false;
        }
        return val1.equals(val2);
    }

    @Override
    public String[] loadArgs(Map<String, String> params) {
        return new String[]{params.get("orgId"), params.get("extOutParam")};
    }
}

