/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.mobileService.util;

import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.eas.rpts.web.model.AbstractEmbedObject;
import com.kingdee.eas.rpts.web.model.ColumnModel;
import com.kingdee.eas.rpts.web.model.RowModel;
import com.kingdee.eas.rpts.web.vo.ReportInfo;
import com.kingdee.eas.rpts.web.vo.SheetInfo;
import com.kingdee.eas.rpts.web.vo.TableInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ExtLightCardContentExecuteUtil {
    public static void reportInfoToCard(ReportInfo rptInfo, Book book, Integer height, Integer width) {
        String selectSheetName = null;
        String showType = null;
        String embedName = null;
        UserObject userObject = book.getUserObject("SELECT_SHEET_NAME");
        List<SheetInfo> sheetList = rptInfo.getSheetList();
        SheetInfo sheetInfo = null;
        TableInfo tableFragment = null;
        if (userObject != null) {
            selectSheetName = (String)userObject.getValue();
            showType = (String)book.getUserObject("SELECT_SHOW_TYPE").getValue();
            if (showType.equals("CHART")) {
                embedName = (String)book.getUserObject("SELECT_EMBED_NAME").getValue();
            }
            for (SheetInfo info : sheetList) {
                if (!selectSheetName.equals(info.getName())) continue;
                sheetInfo = info;
                break;
            }
            if (null != sheetInfo) {
                tableFragment = sheetInfo.getTableFragment();
            }
        } else {
            sheetInfo = sheetList.get(0);
            tableFragment = sheetInfo.getTableFragment();
            List<AbstractEmbedObject> embedChartList = tableFragment.getEmbedChartList();
            Collections.sort(embedChartList, new Comparator<AbstractEmbedObject>(){

                @Override
                public int compare(AbstractEmbedObject a, AbstractEmbedObject b) {
                    return a.getTop() - b.getTop();
                }
            });
            if (embedChartList != null && embedChartList.size() >= 1) {
                embedName = embedChartList.get(0).getName();
                showType = "CHART";
            } else {
                showType = "TABLE";
            }
        }
        sheetList.clear();
        sheetList.add(sheetInfo);
        ExtLightCardContentExecuteUtil.adjsutCard(tableFragment, showType, embedName, height, width);
    }

    private static void adjsutCard(TableInfo tableFragment, String showType, String embedName, int height, int width) {
        List<AbstractEmbedObject> embedChartList = tableFragment.getEmbedChartList();
        List<RowModel> rowList = tableFragment.getRowList();
        List<ColumnModel> colList = tableFragment.getColList();
        if ("TABLE".equals(showType)) {
            Object model;
            int i;
            embedChartList.clear();
            int rowHeight = 0;
            int colWidth = 0;
            int index = 0;
            ArrayList<RowModel> rowListTemp = new ArrayList<RowModel>();
            int len = rowList.size();
            for (i = 0; i < len; ++i) {
                model = rowList.get(i);
                if (((RowModel)model).getCellList() == null) continue;
                rowListTemp.add((RowModel)model);
                ++index;
                if ((rowHeight += ((RowModel)model).getHeight()) >= height) break;
            }
            tableFragment.setRowList(rowListTemp);
            index = 0;
            len = colList.size();
            for (i = 0; i < len; ++i) {
                model = colList.get(i);
                ++index;
                if ((colWidth += ((ColumnModel)model).getWidth()) >= width) break;
            }
            colList.subList(0, index);
        } else {
            rowList.clear();
            colList.clear();
            AbstractEmbedObject tempEmbed = null;
            for (AbstractEmbedObject embed : embedChartList) {
                if (!embed.getName().equals(embedName)) continue;
                tempEmbed = embed;
                break;
            }
            if (null != tempEmbed) {
                tempEmbed.setTop(2);
                tempEmbed.setLeft(2);
                tempEmbed.setWidth(width);
                tempEmbed.setHeight(height - 20);
            }
            embedChartList.clear();
            embedChartList.add(tempEmbed);
        }
    }
}

