/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.dispatch.server.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.rpts.snapshot.dispatch.codingrule.pojo.MaxSerialInfo;
import com.kingdee.eas.rpts.snapshot.dispatch.codingrule.server.impl.CodingRuleDAOImpl;
import com.kingdee.eas.rpts.snapshot.dispatch.codingrule.util.CodingRuleNumGenerator;
import com.kingdee.eas.rpts.snapshot.dispatch.server.app.AbstractSaveSnapShotAdapter;
import com.kingdee.eas.rpts.snapshot.dispatch.server.impl.SendEmailDAOImpl;
import com.kingdee.eas.rpts.snapshot.manage.consta.FolderType;
import com.kingdee.eas.rpts.snapshot.manage.exception.SnapshotException;
import com.kingdee.eas.rpts.snapshot.manage.pojo.PhantomSnapshot;
import com.kingdee.eas.rpts.snapshot.manage.pojo.SnapshotBaseInfo;
import com.kingdee.eas.rpts.snapshot.manage.service.SnapshotRelativeService;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaveToPublicFolder
extends AbstractSaveSnapShotAdapter {
    Logger logger = CommonLogger.getLogger(SaveToPublicFolder.class);

    public SaveToPublicFolder() {
        this(null, null, null);
    }

    public SaveToPublicFolder(Context ctx, List dispList, String locale) {
        super(ctx, dispList, locale);
        this._dispList = dispList;
        this._ctx = ctx;
        this._locale = locale;
        this.sendMail = new SendEmailDAOImpl();
        this.dao = new CodingRuleDAOImpl();
    }

    @Override
    protected boolean saveSnap(Context ctx, byte[] data, String curLocale, StringBuilder errorMsg, SnapshotBaseInfo snapInfo) throws BOSException, EASBizException, SQLException, IllegalArgumentException, SecurityException, ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SnapshotException {
        Map _dispatchMap = (Map)this._dispList.get(0);
        String reportId = (String)_dispatchMap.get("freportid");
        String userId = (String)_dispatchMap.get("dispatchupdateuserid");
        String systemId = (String)_dispatchMap.get("fsystemid");
        String orgId = (String)_dispatchMap.get("dispatchcurorgid");
        snapInfo.setLocationPath(systemId);
        snapInfo.setOrgID(orgId);
        CodingRuleNumGenerator numGenerate = new CodingRuleNumGenerator(ctx, curLocale, this._dispList, this.mapSystemParam);
        String snapName = numGenerate.generateNameBaseCodingRule();
        MaxSerialInfo maxSeialInfo = numGenerate.get_maxSeialInfo();
        errorMsg.append(numGenerate.get_errorMsg());
        if (errorMsg.length() > 0) {
            return false;
        }
        snapInfo.setName(snapName);
        snapInfo.setReportPeriod(-1);
        snapInfo.setCreatorID(userId);
        snapInfo.setLocationType(FolderType.COMMON_FOLDER);
        int saveType = ((Number)_dispatchMap.get("fsnapshotsavetype")).intValue();
        SnapshotRelativeService _srsv = new SnapshotRelativeService(ctx);
        PhantomSnapshot phantom = new PhantomSnapshot();
        phantom.setReportId(reportId);
        phantom.setName(snapName);
        phantom.setFake(false);
        ArrayList<PhantomSnapshot> phantomList = new ArrayList<PhantomSnapshot>(1);
        phantomList.add(phantom);
        List snapShotList = _srsv.findNameConflictByOrg(phantomList, systemId, orgId);
        if (snapShotList != null && snapShotList.size() > 0) {
            PhantomSnapshot rc = (PhantomSnapshot)snapShotList.get(0);
            snapInfo.setId(rc.getId());
        }
        snapInfo.setReportID(reportId);
        if (saveType == 1) {
            if (snapShotList != null && snapShotList.size() > 0) {
                this.updateMaxSerialNum(ctx, maxSeialInfo);
                errorMsg.append("\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728\u91cd\u540d\u7684\u5feb\u7167\uff0c\u8c03\u5ea6\u4e0d\u80fd\u8986\u76d6\u8be5\u5feb\u7167\u3002\r\n");
                return true;
            }
            _srsv.addSnapshot(snapInfo, data, FolderType.COMMON_FOLDER);
        } else if (saveType == 0) {
            if (snapShotList != null && snapShotList.size() > 0) {
                _srsv.deleteSnapshots(new String[]{snapInfo.getId()});
                _srsv.addSnapshot(snapInfo, data, FolderType.COMMON_FOLDER);
            } else {
                _srsv.addSnapshot(snapInfo, data, FolderType.COMMON_FOLDER);
            }
        }
        this.updateMaxSerialNum(ctx, maxSeialInfo);
        return true;
    }
}

