/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.manage.server.pf.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.rpts.snapshot.ds.model.SnapshotPartInfo;
import com.kingdee.eas.rpts.snapshot.ds.model.SnapshotQueryModel;
import com.kingdee.eas.rpts.snapshot.manage.consta.FolderType;
import com.kingdee.eas.rpts.snapshot.manage.consta.SnapshotSourceType;
import com.kingdee.eas.rpts.snapshot.manage.exception.IllegalParameterException;
import com.kingdee.eas.rpts.snapshot.manage.exception.SnapshotException;
import com.kingdee.eas.rpts.snapshot.manage.pojo.PhantomSnapshot;
import com.kingdee.eas.rpts.snapshot.manage.pojo.SnapshotBaseInfo;
import com.kingdee.eas.rpts.snapshot.manage.pojo.so.ReportGroupItem;
import com.kingdee.eas.rpts.snapshot.manage.server.pf.ISnapshotRelativeDAO;
import com.kingdee.eas.rpts.sumreport.data.SnapDataBean;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.rpts.sumreport.util.MixUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class SnapshotRelativeDAO
implements ISnapshotRelativeDAO {
    private Context _ctx;

    public SnapshotRelativeDAO() {
    }

    public SnapshotRelativeDAO(Context ctx) {
        this._ctx = ctx;
    }

    @Override
    public List queryCTReportList(String orgID, String branch, boolean includeSumUpload) throws SnapshotException {
        ArrayList<Serializable> arrayList;
        ArrayList<Serializable> lst;
        IRowSet rs;
        StringBuffer sqlBuf;
        block10: {
            Serializable item;
            String userID = EASUtil.getCurrentUserID(this.getContext());
            sqlBuf = new StringBuffer();
            sqlBuf.append("SELECT fid, fdeploypath, fname_l2 as name from t_bas_definereport ");
            sqlBuf.append("where fsystemid = ? AND fid ");
            sqlBuf.append(this.getPermissionFilter());
            if (!includeSumUpload) {
                sqlBuf.append("\tAnd ( FTempletType = ").append(-1);
                sqlBuf.append(" Or FTempletType is NULL)");
            }
            sqlBuf.append(" ORDER BY fcreatetime asc");
            rs = null;
            rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{branch, userID, orgID, userID, userID, orgID});
            lst = new ArrayList<Serializable>(rs.size());
            while (rs.next()) {
                item = new ReportGroupItem();
                ((ReportGroupItem)item).setId(rs.getString("fid"));
                ((ReportGroupItem)item).setName(rs.getString("name"));
                ((ReportGroupItem)item).setDeploy(!StringUtil.isEmptyString((String)rs.getString("fdeploypath")));
                lst.add(item);
            }
            if (lst.size() >= 1) break block10;
            item = lst;
            SQLUtils.cleanup((ResultSet)rs);
            return item;
        }
        try {
            sqlBuf = new StringBuffer();
            sqlBuf.append("SELECT DISTINCT Freportid from T_ext_sssnapshot ");
            sqlBuf.append("where Freportid in(");
            for (int i = 0; i < lst.size(); ++i) {
                sqlBuf.append("'").append(((ReportGroupItem)lst.get(i)).getId()).append("',");
            }
            sqlBuf.deleteCharAt(sqlBuf.length() - 1);
            sqlBuf.append(")");
            rs = null;
            rs = DbUtil.executeQuery(sqlBuf.toString(), null);
            block7: while (rs.next()) {
                String id = rs.getString("Freportid");
                for (int i = 0; i < lst.size(); ++i) {
                    ReportGroupItem item = (ReportGroupItem)lst.get(i);
                    if (!item.getId().equalsIgnoreCase(id)) continue;
                    item.setSnap(true);
                    continue block7;
                }
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    private String getPermissionFilter() {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append(" IN(");
        sqlBuf.append(" select p.FReportID from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r ");
        sqlBuf.append(" on p.FReportID = r.fid where p.FUserID = ? and p.FOrgID = ? ");
        sqlBuf.append(" union all select p.FReportID from T_EXT_Permission p");
        sqlBuf.append(" INNER JOIN T_BAS_DefineReport r on p.FReportID = r.fid where p.FUserID = ? ");
        sqlBuf.append(" and p.FOrgID is null ");
        sqlBuf.append(" union all select p.FReportID ");
        sqlBuf.append(" from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r ");
        sqlBuf.append(" on p.FReportID = r.fid INNER JOIN t_pm_userroleorg uro ON p.froleid = uro.froleid");
        sqlBuf.append(" where uro.FUserID = ? and uro.FOrgID = ? ) ");
        return sqlBuf.toString();
    }

    private String getPermissionFilter2() {
        Context ctx = this.getContext();
        String userID = EASUtil.getCurrentUserID(ctx);
        String orgID = EASUtil.getCurrentOrgID(ctx);
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append(" IN(");
        sqlBuf.append(" select p.FReportID from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r ");
        sqlBuf.append(" on p.FReportID = r.fid where p.FUserID = '").append(userID).append("' and p.FOrgID = '").append(orgID);
        sqlBuf.append("' union all select p.FReportID from T_EXT_Permission p");
        sqlBuf.append(" INNER JOIN T_BAS_DefineReport r on p.FReportID = r.fid where p.FUserID = '").append(userID);
        sqlBuf.append("' and p.FOrgID is null ");
        sqlBuf.append(" union all select p.FReportID ");
        sqlBuf.append(" from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r ");
        sqlBuf.append(" on p.FReportID = r.fid INNER JOIN t_pm_userroleorg uro ON p.froleid = uro.froleid");
        sqlBuf.append(" where uro.FUserID = '").append(userID).append("' and uro.FOrgID = '").append(orgID).append("' ) ");
        return sqlBuf.toString();
    }

    @Override
    public List queryPTReportList(String userID, String branch) throws SnapshotException {
        ArrayList<ReportGroupItem> arrayList;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append('(');
        sqlBuf.append("SELECT sc.freportid, max(sc.FcreateTime)as createtime , d.fname_l2 as name");
        sqlBuf.append(" FROM t_ext_ssshortcut sc LEFT OUTER JOIN t_bas_definereport d on sc.freportid = d.fid");
        sqlBuf.append(" WHERE sc.flocationType = 0 AND sc.fuserid = ? ");
        sqlBuf.append(" AND sc.flocationPath = ?  group by sc.freportid,d.fname_l2 ");
        sqlBuf.append("\tUNION ");
        sqlBuf.append("SELECT ss.freportid, max(ss.FcreateTime) as createtime, d.fname_l2 as name");
        sqlBuf.append("\tFROM t_ext_sssnapshot ss LEFT OUTER JOIN t_bas_definereport d on ss.freportid = d.fid");
        sqlBuf.append("\tWHERE ss.flocationType = 0  AND ss.fcreatorid = ? ");
        sqlBuf.append("\tAND ss.flocationPath = ?  group by ss.freportid,d.fname_l2 ");
        sqlBuf.append(")");
        sqlBuf.append("ORDER BY createtime desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{userID, branch, userID, branch});
            ArrayList<ReportGroupItem> lst = new ArrayList<ReportGroupItem>(rs.size());
            while (rs.next()) {
                ReportGroupItem item = new ReportGroupItem();
                item.setId(rs.getString("freportid"));
                item.setName(rs.getString("name"));
                lst.add(item);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    @Override
    public void addSnapshot(SnapshotBaseInfo baseInfo, SnapDataBean[] data, int locationType) throws SnapshotException {
        boolean forSum;
        StringBuffer insqlBuf = new StringBuffer("Insert Into T_EXT_SSSNAPSHOT(FID,FNAME,FlocationPath,FlocationType").append(",FORGID,FReportID,FCreatorID,FCreateTime,FReportPeriod");
        boolean bl = forSum = baseInfo.getReportPeriod() != -1;
        if (forSum) {
            insqlBuf.append(",FWeekBegin,FBeginDate,FendDate");
        }
        insqlBuf.append(") Values('");
        insqlBuf.append(baseInfo.getId()).append("','");
        insqlBuf.append(baseInfo.getName().replaceAll("'", "''")).append("','");
        insqlBuf.append(baseInfo.getLocationPath()).append("',");
        insqlBuf.append(baseInfo.getLocationType()).append(",'");
        insqlBuf.append(baseInfo.getOrgID()).append("','");
        insqlBuf.append(baseInfo.getReportID()).append("','");
        insqlBuf.append(baseInfo.getCreatorID()).append("',{ts'");
        insqlBuf.append(MixUtil.getDateFromTimestamp(baseInfo.getCreateTime())).append("'},");
        insqlBuf.append(baseInfo.getReportPeriod());
        if (forSum) {
            insqlBuf.append(",");
            insqlBuf.append(baseInfo.getWeekBegin()).append(",{ts'");
            insqlBuf.append(MixUtil.TIMESTAMP_FORMAT.format(baseInfo.getBeginDate())).append("'},{ts'");
            insqlBuf.append(MixUtil.TIMESTAMP_FORMAT.format(baseInfo.getEndDate())).append("'}");
        }
        insqlBuf.append(')');
        ArrayList<Object> params = new ArrayList<Object>(data.length * 4);
        String id = baseInfo.getId();
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            params.add(id);
            params.add(new Integer(i));
            params.add(data[i].getBlock());
            params.add(new Integer(data[i].getSize()));
        }
        String sql = "Insert Into T_EXT_SSDATA(Fid,FBlockIndex,FContent,FLength) values(?,?,?,?)";
        try {
            DbUtil.executeBatchUpdate(this._ctx, sql, params, 4, insqlBuf.toString());
        }
        catch (SQLException e) {
            throw SnapshotException.wrap(e);
        }
    }

    @Override
    public void deleteSnapshots(String[] shortcut) throws SnapshotException {
        if (shortcut == null || shortcut.length == 0) {
            return;
        }
        try {
            StringBuffer sqlBuf = new StringBuffer("Delete From T_EXT_SSSNAPSHOT Where FId in(");
            StringBuffer sqlBuf2 = new StringBuffer("Delete From T_EXT_SSDATA Where Fid in(");
            for (int i = 0; i < shortcut.length; ++i) {
                sqlBuf.append('\'').append(shortcut[i]).append("',");
                sqlBuf2.append('\'').append(shortcut[i]).append("',");
            }
            sqlBuf.setCharAt(sqlBuf.length() - 1, ')');
            sqlBuf2.setCharAt(sqlBuf2.length() - 1, ')');
            String[] sqls = new String[]{sqlBuf.toString(), sqlBuf2.toString()};
            DbUtil.executeBatchUpdate(this._ctx, sqls);
        }
        catch (SQLException e) {
            throw SnapshotException.wrap(e);
        }
    }

    @Override
    public void delShortcutsByLongNumber(String longNumber, String userID) throws SnapshotException {
        StringBuffer delBuf = new StringBuffer("Delete From T_EXT_SSshortcut where fuserid = ? and FlocationType=");
        delBuf.append(FolderType.PERSONAL_FOLDER).append(" And CharIndex('");
        delBuf.append(longNumber).append("',flocationPath) > 0");
        try {
            DbUtil.executeUpdate(delBuf.toString(), new Object[]{userID});
        }
        catch (SQLException e) {
            throw SnapshotException.wrap(e);
        }
    }

    @Override
    public void deleteShortcuts(String[] shortcuts) throws SnapshotException {
        if (shortcuts == null || shortcuts.length == 0) {
            throw new IllegalParameterException("Shortcuts\u53c2\u6570\u4e0d\u5e94\u8be5\u4e3aNULL,\u6216\u8005\u5143\u7d20\u4e2a\u6570\u4e3a0");
        }
        StringBuffer delBuf = new StringBuffer("Delete From T_EXT_SSSHORTCUT Where Fid IN (");
        for (int i = 0; i < shortcuts.length; ++i) {
            delBuf.append("?,");
        }
        delBuf.setCharAt(delBuf.length() - 1, ')');
        try {
            DbUtil.executeUpdate(delBuf.toString(), shortcuts);
        }
        catch (SQLException e) {
            throw SnapshotException.wrap(e);
        }
    }

    @Override
    public String[] querySnapshotsID(String longNumber, String userID) throws SnapshotException {
        String[] stringArray;
        block6: {
            StringBuffer queryBuf = new StringBuffer("Select Fid  From T_EXT_SSSNAPSHOT Where FCreatorID = ? And CharIndex('");
            queryBuf.append(longNumber).append("', FlocationPath) > 0");
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery(queryBuf.toString(), new Object[]{userID});
                String[] iDs = new String[rs.size()];
                int i = -1;
                while (rs.next()) {
                    iDs[++i] = rs.getString("Fid");
                }
                stringArray = iDs;
                if (rs == null) break block6;
            }
            catch (SQLException e) {
                try {
                    throw SnapshotException.wrap(e);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        SQLUtils.cleanup(rs);
                    }
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        return stringArray;
    }

    @Override
    public String[] queryCTAddupInfo(String orgID, boolean includeSumUpload) throws SnapshotException {
        String[] stringArray;
        String userID = EASUtil.getCurrentUserID(this.getContext());
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT distinct fsystemid From t_bas_definereport where fid  ");
        sqlBuf.append(this.getPermissionFilter());
        if (!includeSumUpload) {
            sqlBuf.append("\tAnd ( FTempletType = ").append(-1);
            sqlBuf.append(" Or FTempletType is NULL)");
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{userID, orgID, userID, userID, orgID});
            String[] paths = new String[rs.size()];
            int i = -1;
            while (rs.next()) {
                paths[++i] = rs.getString("fsystemid");
            }
            stringArray = paths;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return stringArray;
    }

    @Override
    public String[] queryPermDeploySysIds(String orgID, boolean includeSumUpload) throws SnapshotException {
        String[] stringArray;
        String userID = EASUtil.getCurrentUserID(this.getContext());
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT distinct fsystemid From t_bas_definereport where (fmenuid is not null or fbipath is not null or (fportletid is not null and fportletname is not null) or feaswebappcenterid is not null) and fid in ( ");
        sqlBuf.append(" select p.FReportID from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r ");
        sqlBuf.append(" on p.FReportID = r.fid where p.FUserID = ? and p.FOrgID = ? ");
        sqlBuf.append(" union all select p.FReportID from T_EXT_Permission p");
        sqlBuf.append(" INNER JOIN T_BAS_DefineReport r on p.FReportID = r.fid where p.FUserID = ? ");
        sqlBuf.append(" and p.FOrgID is null ");
        sqlBuf.append(" union all select p.FReportID ");
        sqlBuf.append(" from T_EXT_Permission p INNER JOIN T_BAS_DefineReport r ");
        sqlBuf.append(" on p.FReportID = r.fid INNER JOIN t_pm_userroleorg uro ON p.froleid = uro.froleid");
        sqlBuf.append(" where uro.FUserID = ? and uro.FOrgID = ? )");
        if (!includeSumUpload) {
            sqlBuf.append("\tAnd ( FTempletType = ").append(-1);
            sqlBuf.append(" Or FTempletType is NULL)");
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{userID, orgID, userID, userID, orgID});
            String[] paths = new String[rs.size()];
            int i = -1;
            while (rs.next()) {
                paths[++i] = rs.getString("fsystemid");
            }
            stringArray = paths;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return stringArray;
    }

    @Override
    public List getPhantomSnapshot(String userID, String reportID, String branch) throws SnapshotException {
        ArrayList<PhantomSnapshot> arrayList;
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT top ").append(6);
        buf.append("* FROM ((Select S.Fid,S.Fname,S.Fcreatorid,S.Fcreatetime,S.Freportperiod,S.Fweekbegin,S.Fbegindate,S.Fenddate,");
        buf.append("U.Fname_l2 As Name, -5 As Type,S.Freportid, '' As Fsnapshotid,S.forgid, O.fname_l2 as orgName, ");
        buf.append(" S.Fcreatetime as sendTime, O.fname_l2 as sender, S.FLASTUPDATETIME As updateTime ");
        buf.append("From T_ext_sssnapshot S Left Outer Join T_pm_user U On S.Fcreatorid = U.Fid Left Outer Join T_Org_BaseUnit O On S.ForgID = O.Fid");
        buf.append(" WHERE S.Fcreatorid = ? and S.FReportid = ? And S.FlocationType = 0 And s.FlocationPath = ?");
        buf.append(")Union All(");
        buf.append("Select Sc.Fid, Sc.Fname, Sc.Fcreatorid,Sc.Fcollectiontime As Fcreatetime,Sc.Freportperiod,Sc.Fweekbegin,Sc.Fbegindate,Sc.Fenddate,");
        buf.append("U.Fname_l2 As Name, sc.FsourceType As Type,Sc.Freportid,Sc.Fsnapshotid, Sc.forgid,O.fname_l2 as orgName,");
        buf.append(" Sc.Fsendtime as sendTime, U2.fname_l2 as sender, FSendTime as updateTime ");
        buf.append(" From T_ext_ssshortcut Sc Left Outer Join T_pm_user U On Sc.Fcreatorid = U.Fid ");
        buf.append(" Left Outer Join T_Org_BaseUnit O On Sc.ForgID = O.Fid ");
        buf.append(" Left Outer Join T_pm_user U2 On Sc.Fsenderid = U2.Fid ");
        buf.append(" WHERE Sc.fuserid = ? and Sc.FReportid = ? And Sc.FlocationType = 0 And Sc.FlocationPath = ?");
        buf.append(")) TT Order By TT.Fcreatetime Desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(buf.toString(), new Object[]{userID, reportID, branch, userID, reportID, branch});
            ArrayList<PhantomSnapshot> lst = new ArrayList<PhantomSnapshot>(rs.size());
            while (rs.next()) {
                PhantomSnapshot item = new PhantomSnapshot();
                item.setId(rs.getString("fid"));
                item.setName(rs.getString("fname"));
                item.setCreatorID(rs.getString("fcreatorid"));
                item.setCreateTime(rs.getTimestamp("fcreatetime"));
                item.setReportPeriod(rs.getInt("freportperiod"));
                item.setBeginDate(rs.getTimestamp("fbegindate"));
                item.setEndDate(rs.getTimestamp("fenddate"));
                item.setWeekBegin(rs.getInt("fweekbegin"));
                int type = rs.getInt("type");
                item.setFake(type != -5);
                type = type == -5 ? SnapshotSourceType.SNAPSHOT_CENTER_REAL : type;
                item.setSourceType(type);
                if (item.isFake()) {
                    item.setSnapshotId(rs.getString("fsnapshotid"));
                    item.setSender(rs.getString("sender"));
                    item.setSendTime(rs.getTimestamp("sendTime"));
                } else {
                    item.setSnapshotId(item.getId());
                    item.setUpdateTime(rs.getTimestamp("updateTime"));
                }
                item.setReportId(rs.getString("freportid"));
                item.setUserName(rs.getString("name"));
                item.setOrgID(rs.getString("forgid"));
                item.setOrgName(rs.getString("orgName"));
                lst.add(item);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    @Override
    public List getSnapshots(String orgID, String reportID, String branch) throws SnapshotException {
        ArrayList<PhantomSnapshot> arrayList;
        StringBuffer buf = new StringBuffer();
        buf.append("Select top ").append(6);
        buf.append(" S.Fid as cFid, S.Fname as shotname, S.Fcreatorid as creatorid, S.Fcreatetime as createtime, S.Freportperiod as reportperiod, S.Fweekbegin as weekbegin, S.Fbegindate as begindate, S.Fenddate enddate,");
        buf.append(" O.fname_l2 as orgname, U.Fname_l2 As Name,S.Freportid as reportid, S.flastupdateuserid As updatorId, U1.fname_l2 as updator, S.FLASTUPDATETIME As updateTime");
        buf.append(" From T_ext_sssnapshot S LEFT outer JOIN T_pm_user U On S.Fcreatorid = U.Fid  left outer join T_pm_user U1 on S.flastupdateuserid = U1.fid LEFT OUTER JOIN T_Org_BaseUnit O On S.ForgId = O.fid ");
        buf.append(" WHERE S.forgid = ? and S.FReportid = ? And S.FlocationType = 1 And s.FlocationPath = ? Order by createtime desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(buf.toString(), new Object[]{orgID, reportID, branch});
            ArrayList<PhantomSnapshot> lst = new ArrayList<PhantomSnapshot>(rs.size());
            while (rs.next()) {
                PhantomSnapshot item = new PhantomSnapshot();
                item.setId(rs.getString("cFid"));
                item.setName(rs.getString("shotname"));
                item.setCreatorID(rs.getString("creatorid"));
                item.setCreateTime(rs.getTimestamp("createtime"));
                item.setReportPeriod(rs.getInt("reportperiod"));
                item.setBeginDate(rs.getTimestamp("begindate"));
                item.setEndDate(rs.getTimestamp("enddate"));
                item.setWeekBegin(rs.getInt("weekbegin"));
                item.setSourceType(SnapshotSourceType.SNAPSHOT_CENTER_REAL);
                item.setSnapshotId(rs.getString("cFid"));
                item.setReportId(rs.getString("reportid"));
                item.setUserName(rs.getString("Name"));
                item.setOrgID(orgID);
                item.setOrgName(rs.getString("orgname"));
                item.setFake(false);
                item.setUpdator(rs.getString("updator"));
                item.setUpdateTime(rs.getTimestamp("updateTime"));
                lst.add(item);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    @Override
    public List getSumReportReports(String orgID) throws SnapshotException {
        ArrayList<ReportGroupItem> arrayList;
        StringBuffer sqlBuf = new StringBuffer("select rs.freportid, dr.fname_l2 as name from t_ext_reportsnap rs left outer join ");
        sqlBuf.append(" t_bas_definereport dr on rs.freportid = dr.fid where rs.forgid = ? order by rs.fcreatetime desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{orgID});
            ArrayList<ReportGroupItem> lst = new ArrayList<ReportGroupItem>(rs.size());
            HashSet<String> set = new HashSet<String>(rs.size());
            while (rs.next()) {
                ReportGroupItem item = new ReportGroupItem();
                item.setId(rs.getString("freportid"));
                if (set.contains(item.getId())) continue;
                item.setName(rs.getString("name"));
                set.add(item.getId());
                lst.add(item);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    @Override
    public List getSumReportSnapshots(String orgID, String reportID) throws SnapshotException {
        ArrayList<PhantomSnapshot> arrayList;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("Select top ").append(6);
        sqlBuf.append(" rs.fid , u.fname_l2 as username, rs.fcreatetime,td.freportperiod,td.Fweekbegin,rs.fcreatorid,");
        sqlBuf.append(" td.Fbegindate,td.Fenddate,td.fname_l2 as name from t_ext_reportsnap rs inner join t_ext_taskdistribute td on rs.ftaskdistributeid = td.fid left outer join t_pm_user u on u.fid = rs.fcreatorid where rs.forgid = ? and rs.freportid = ? order by rs.fcreatetime desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{orgID, reportID});
            ArrayList<PhantomSnapshot> lst = new ArrayList<PhantomSnapshot>(rs.size());
            String orgName = EASUtil.getCurrentOrgName(this.getContext());
            while (rs.next()) {
                PhantomSnapshot item = new PhantomSnapshot();
                item.setId(rs.getString("fid"));
                item.setName(rs.getString("name"));
                item.setCreateTime(rs.getTimestamp("fcreatetime"));
                item.setReportPeriod(rs.getInt("freportperiod"));
                item.setBeginDate(rs.getTimestamp("fbegindate"));
                item.setEndDate(rs.getTimestamp("fenddate"));
                item.setWeekBegin(rs.getInt("fweekbegin"));
                item.setUserName(rs.getString("username"));
                item.setSnapshotId(rs.getString("fid"));
                item.setSourceType(SnapshotSourceType.SUM_UPLOAD);
                item.setCreatorID(rs.getString("fcreatorid"));
                item.setOrgName(orgName);
                item.setFake(false);
                item.setReportId(reportID);
                lst.add(item);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    @Override
    public void updateSnapshot(String snapshotID, SnapDataBean[] entitys) throws SnapshotException {
        try {
            ArrayList<Object> params = new ArrayList<Object>(entitys.length * 4);
            int len = entitys.length;
            for (int i = 0; i < len; ++i) {
                params.add(snapshotID);
                params.add(new Integer(i));
                params.add(entitys[i].getBlock());
                params.add(new Integer(entitys[i].getSize()));
            }
            String sql = "insert into T_EXT_SSDATA(fid,FBlockIndex,FContent,FLength) values(?,?,?,?)";
            StringBuffer delSql = new StringBuffer("delete from T_EXT_SSDATA where fid ='");
            delSql.append(snapshotID).append('\'');
            DbUtil.executeBatchUpdate(sql, params, 4, delSql.toString());
        }
        catch (SQLException e) {
            throw SnapshotException.wrap("\u4fdd\u5b58\u5feb\u7167\u6570\u636e\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public void updateSnapshot(String userID, String snapshotID, SnapDataBean[] entitys) throws SnapshotException {
        try {
            ArrayList<Object> params = new ArrayList<Object>(entitys.length * 4);
            int len = entitys.length;
            for (int i = 0; i < len; ++i) {
                params.add(snapshotID);
                params.add(new Integer(i));
                params.add(entitys[i].getBlock());
                params.add(new Integer(entitys[i].getSize()));
            }
            String sql = "insert into T_EXT_SSDATA(fid,FBlockIndex,FContent,FLength) values(?,?,?,?)";
            StringBuffer delSql = new StringBuffer("delete from T_EXT_SSDATA where fid ='");
            delSql.append(snapshotID).append('\'');
            DbUtil.executeBatchUpdate(sql, params, 4, delSql.toString());
            String updateSql = "UPDATE T_ext_sssnapshot SET FLASTUPDATEUSERID = ?, FLASTUPDATETIME = ? WHERE FID = ? ";
            DbUtil.executeUpdate(updateSql, new Object[]{userID, new Timestamp(new Date().getTime()), snapshotID});
        }
        catch (SQLException e) {
            throw SnapshotException.wrap("\u4fdd\u5b58\u5feb\u7167\u6570\u636e\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public byte[] querySnapshotByID(String snapshotID) throws SnapshotException {
        StringBuffer sqlBuf = new StringBuffer("SELECT FID AS ID,FCONTENT AS DATA,FLENGTH AS LENGTH FROM");
        sqlBuf.append(" T_EXT_SSDATA WHERE FID =? ORDER BY FID,FBLOCKINDEX");
        try {
            IRowSet rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{snapshotID});
            SnapDataBean[] beans = new SnapDataBean[rs.size()];
            int index = 0;
            while (rs.next()) {
                int length = rs.getInt("LENGTH");
                byte[] block = new byte[length];
                try {
                    InputStream in = rs.getBlob("DATA").getBinaryStream();
                    try {
                        in.read(block);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (SQLException e) {
                    block = rs.getBytes("DATA");
                }
                beans[index++] = new SnapDataBean(block, length);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (int i = 0; i < beans.length; ++i) {
                out.write(beans[i].getBlock(), 0, beans[i].getSize());
                beans[i].GCBlock();
            }
            return out.toByteArray();
        }
        catch (SQLException e) {
            throw SnapshotException.wrap("\u67e5\u8be2\u5feb\u7167\u6570\u636e\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public byte[] querySumReportSnapshotData(String snapshotID) throws SnapshotException {
        StringBuffer sqlBuf = new StringBuffer("SELECT FID AS ID,FCONTENT AS DATA,FLENGTH AS LENGTH FROM");
        sqlBuf.append(" T_EXT_SNAPSHOTDATA WHERE FID =? ORDER BY FID,FBLOCKINDEX");
        try {
            IRowSet rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{snapshotID});
            SnapDataBean[] beans = new SnapDataBean[rs.size()];
            int index = 0;
            while (rs.next()) {
                int length = rs.getInt("LENGTH");
                byte[] block = new byte[length];
                try {
                    InputStream in = rs.getBlob("DATA").getBinaryStream();
                    try {
                        in.read(block);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (SQLException e) {
                    block = rs.getBytes("DATA");
                }
                beans[index++] = new SnapDataBean(block, length);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (int i = 0; i < beans.length; ++i) {
                out.write(beans[i].getBlock(), 0, beans[i].getSize());
                beans[i].GCBlock();
            }
            return out.toByteArray();
        }
        catch (SQLException e) {
            throw SnapshotException.wrap("\u67e5\u8be2\u5feb\u7167\u6570\u636e\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public String isExistSnapshotNameByOrg(String orgID, String locationPath, String reportID, String snapshotName) throws SnapshotException {
        String string;
        IRowSet rs;
        block5: {
            StringBuffer sqlBuf = new StringBuffer("Select fid from t_ext_sssnapshot where forgid = ? and flocationPath = ? and freportid = ? and flocationType = ?  and fname = ?");
            rs = null;
            rs = DbUtil.executeQuery(this._ctx, sqlBuf.toString(), new Object[]{orgID, locationPath, reportID, new Integer(FolderType.COMMON_FOLDER), snapshotName});
            if (!rs.next()) break block5;
            String string2 = rs.getString("fid");
            SQLUtils.cleanup((ResultSet)rs);
            return string2;
        }
        try {
            string = null;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return string;
    }

    @Override
    public String isExistSnapshotNameByUser(String userID, String locationPath, String reportID, String snapshotName) throws SnapshotException {
        String string;
        IRowSet rs;
        block5: {
            StringBuffer sqlBuf = new StringBuffer("select fid from t_ext_sssnapshot where fcreatorid = ? and freportid = ? and flocationType = ? and flocationPath = ? and fname = ?");
            rs = null;
            Object[] params = new Object[]{userID, reportID, new Integer(FolderType.PERSONAL_FOLDER), locationPath, snapshotName};
            rs = DbUtil.executeQuery(this._ctx, sqlBuf.toString(), params);
            if (!rs.next()) break block5;
            String string2 = rs.getString("fid");
            SQLUtils.cleanup((ResultSet)rs);
            return string2;
        }
        try {
            string = null;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return string;
    }

    @Override
    public void updatePhantomSnapshotName(String newName, String id) throws SnapshotException {
        StringBuffer sqlBuf = new StringBuffer("update T_EXT_SSSHORTCUT set fname = ? where fid = ?");
        try {
            DbUtil.executeUpdate(sqlBuf.toString(), new Object[]{newName, id});
        }
        catch (SQLException e) {
            throw SnapshotException.wrap(e);
        }
    }

    @Override
    public void updateSnapshotName(String newName, String id) throws SnapshotException {
        StringBuffer sqlBuf = new StringBuffer("update T_EXT_SSSNAPSHOT set fname = ? where fid = ?");
        try {
            DbUtil.executeUpdate(sqlBuf.toString(), new Object[]{newName, id});
        }
        catch (SQLException e) {
            throw SnapshotException.wrap(e);
        }
    }

    @Override
    public void updatePhantomProps(PhantomSnapshot snapshot) throws SnapshotException {
        StringBuffer sqlBuf = new StringBuffer("update T_EXT_SSSHORTCUT set fname = ?,freportperiod = ?, fweekbegin = ?");
        if (snapshot.getReportPeriod() != -1) {
            sqlBuf.append(", fbegindate= ? , fenddate = ? ");
        }
        sqlBuf.append(" where fid = ?");
        try {
            ArrayList<Object> paramsLst = new ArrayList<Object>(5);
            paramsLst.add(snapshot.getName());
            paramsLst.add(new Integer(snapshot.getReportPeriod()));
            paramsLst.add(new Integer(snapshot.getWeekBegin()));
            if (snapshot.getReportPeriod() != -1) {
                paramsLst.add(snapshot.getBeginDate());
                paramsLst.add(snapshot.getEndDate());
            }
            paramsLst.add(snapshot.getId());
            DbUtil.executeUpdate(sqlBuf.toString(), paramsLst.toArray());
        }
        catch (SQLException e) {
            throw SnapshotException.wrap(e);
        }
    }

    @Override
    public void updateSnapshotProps(PhantomSnapshot snapshot) throws SnapshotException {
        StringBuffer sqlBuf = new StringBuffer("update t_ext_sssnapshot set fname = ?,freportperiod = ?, fweekbegin = ?");
        if (snapshot.getReportPeriod() != -1) {
            sqlBuf.append(", fbegindate= ? , fenddate = ? ");
        }
        sqlBuf.append(" where fid = ?");
        try {
            ArrayList<Object> paramsLst = new ArrayList<Object>(5);
            paramsLst.add(snapshot.getName());
            paramsLst.add(new Integer(snapshot.getReportPeriod()));
            paramsLst.add(new Integer(snapshot.getWeekBegin()));
            if (snapshot.getReportPeriod() != -1) {
                paramsLst.add(snapshot.getBeginDate());
                paramsLst.add(snapshot.getEndDate());
            }
            paramsLst.add(snapshot.getId());
            DbUtil.executeUpdate(sqlBuf.toString(), paramsLst.toArray());
        }
        catch (SQLException e) {
            throw SnapshotException.wrap(e);
        }
    }

    private String getFavoriteSnapshotSQL(PhantomSnapshot shortcut) {
        StringBuffer sqlBuf = new StringBuffer("Insert Into T_EXT_SSSHORTCUT ( fid, flocationPath, flocationType, fcollectionTime,");
        sqlBuf.append("fcreatetime, fsourcetype, freportperiod,");
        if (shortcut.getReportPeriod() != -1) {
            sqlBuf.append("fweekbegin, fbegindate, fenddate,");
        }
        sqlBuf.append(" fuserid,fcreatorid,forgid,fsnapshotid,freportid, fname");
        String senderID = shortcut.getSender();
        if (!StringUtil.isEmptyString((String)senderID)) {
            sqlBuf.append(",fsenderid,fsendtime");
        }
        sqlBuf.append(")values(");
        sqlBuf.append('\'').append(shortcut.getId()).append("',");
        sqlBuf.append('\'').append(shortcut.getLocationPath()).append("',");
        sqlBuf.append(shortcut.getLocationType()).append(",");
        sqlBuf.append("{ts'").append(MixUtil.getDateFromTimestamp(shortcut.getCollectTime())).append("'},");
        sqlBuf.append("{ts'").append(MixUtil.getDateFromTimestamp(shortcut.getCreateTime())).append("'},");
        sqlBuf.append(shortcut.getSourceType()).append(",");
        sqlBuf.append(shortcut.getReportPeriod()).append(",");
        if (shortcut.getReportPeriod() != -1) {
            sqlBuf.append(shortcut.getWeekBegin()).append(",");
            sqlBuf.append("{ts'").append(MixUtil.getDateFromTimestamp(shortcut.getBeginDate())).append("'},");
            sqlBuf.append("{ts'").append(MixUtil.getDateFromTimestamp(shortcut.getEndDate())).append("'},");
        }
        sqlBuf.append('\'').append(shortcut.getUserId()).append("',");
        sqlBuf.append('\'').append(shortcut.getCreatorID()).append("',");
        sqlBuf.append('\'').append(shortcut.getOrgID()).append("',");
        sqlBuf.append('\'').append(shortcut.getSnapshotId()).append("',");
        sqlBuf.append('\'').append(shortcut.getReportId()).append("',");
        sqlBuf.append('\'').append(shortcut.getName().replaceAll("'", "''")).append("'");
        if (!StringUtil.isEmptyString((String)senderID)) {
            sqlBuf.append(",'").append(senderID).append("',{ts'");
            sqlBuf.append(MixUtil.getDateFromTimestamp(shortcut.getSendTime())).append("'}");
        }
        sqlBuf.append(")");
        return sqlBuf.toString();
    }

    @Override
    public void addShortcut(List phantomSnapshots) throws SnapshotException {
        try {
            String[] sqls = new String[phantomSnapshots.size()];
            int size = phantomSnapshots.size();
            for (int i = 0; i < size; ++i) {
                sqls[i] = this.getFavoriteSnapshotSQL((PhantomSnapshot)phantomSnapshots.get(i));
            }
            DbUtil.executeBatchUpdate(this._ctx, sqls);
        }
        catch (SQLException e) {
            throw SnapshotException.wrap(e);
        }
    }

    @Override
    public void movePhantoms(List snapshots) throws SnapshotException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("Update t_ext_ssshortcut set flocationPath = ?, flocationType = ?, fcreatetime = ?,fname = ? Where fid = ?");
        ArrayList<Object> paramLst = new ArrayList<Object>(snapshots.size() * 5);
        Integer personalType = new Integer(FolderType.PERSONAL_FOLDER);
        int size = snapshots.size();
        for (int i = 0; i < size; ++i) {
            PhantomSnapshot ps = (PhantomSnapshot)snapshots.get(i);
            paramLst.add(ps.getLocationPath());
            paramLst.add(personalType);
            paramLst.add(ps.getCreateTime());
            paramLst.add(ps.getName());
            paramLst.add(ps.getId());
        }
        try {
            DbUtil.executeBatchUpdate(sqlBuf.toString(), paramLst, 5, null);
        }
        catch (SQLException e) {
            throw SnapshotException.wrap(e);
        }
    }

    @Override
    public void moveSnapshots(List snapshots) throws SnapshotException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("Update T_EXT_SSSNAPSHOT set flocationPath = ?, flocationType = ?, fcreatetime = ?,fname = ? Where fid = ?");
        ArrayList<Object> paramLst = new ArrayList<Object>(snapshots.size() * 5);
        Integer personalType = new Integer(FolderType.PERSONAL_FOLDER);
        int size = snapshots.size();
        for (int i = 0; i < size; ++i) {
            PhantomSnapshot ps = (PhantomSnapshot)snapshots.get(i);
            paramLst.add(ps.getLocationPath());
            paramLst.add(personalType);
            paramLst.add(ps.getCreateTime());
            paramLst.add(ps.getName());
            paramLst.add(ps.getId());
        }
        try {
            DbUtil.executeBatchUpdate(sqlBuf.toString(), paramLst, 5, null);
        }
        catch (SQLException e) {
            throw SnapshotException.wrap(e);
        }
    }

    @Override
    public String isExistPhantomsByUser(String userID, String locationPath, String reportID, String snapshotName) throws SnapshotException {
        String string;
        IRowSet rs;
        block5: {
            StringBuffer sqlBuf = new StringBuffer("select fid from t_ext_ssshortcut where fuserid = ? and freportid = ? and flocationType = ? and flocationPath = ? and fname= ?");
            rs = null;
            Object[] params = new Object[]{userID, reportID, new Integer(FolderType.PERSONAL_FOLDER), locationPath, snapshotName};
            rs = DbUtil.executeQuery(this._ctx, sqlBuf.toString(), params);
            if (!rs.next()) break block5;
            String string2 = rs.getString("fid");
            SQLUtils.cleanup((ResultSet)rs);
            return string2;
        }
        try {
            string = null;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return string;
    }

    @Override
    public void deleteShortCutsByReportID(String[] reportIDs, String userID, String locationPath, int locationType) throws SnapshotException {
        if (reportIDs == null || reportIDs.length == 0) {
            return;
        }
        try {
            StringBuffer sqlBuf = new StringBuffer("Delete From T_EXT_SSShortcut Where FuserID ='");
            sqlBuf.append(userID).append("' AND FLocationType = ").append(locationType).append(" AND FLocationPath ='");
            sqlBuf.append(locationPath).append("' AND FreportID in(");
            for (int i = 0; i < reportIDs.length; ++i) {
                sqlBuf.append('\'').append(reportIDs[i]).append("',");
            }
            sqlBuf.setCharAt(sqlBuf.length() - 1, ')');
            DbUtil.executeUpdate(this._ctx, sqlBuf.toString(), null);
        }
        catch (SQLException e) {
            throw SnapshotException.wrap(e);
        }
    }

    @Override
    public void deleteSnapshotsByReportID(String[] reportIDs, String userOrOrgID, String locationPath, int locationType) throws SnapshotException {
        if (reportIDs == null || reportIDs.length == 0) {
            return;
        }
        try {
            StringBuffer identityPartSql = new StringBuffer();
            if (locationType == FolderType.PERSONAL_FOLDER) {
                identityPartSql.append("FCreatorID ='");
            } else {
                identityPartSql.append("FOrgID ='");
            }
            StringBuffer sqlBuf = new StringBuffer("Delete From T_EXT_SSSNAPSHOT Where ").append(identityPartSql.toString());
            sqlBuf.append(userOrOrgID).append("' AND FLocationType = ").append(locationType).append(" AND FLocationPath ='");
            sqlBuf.append(locationPath).append("' AND FreportID in(");
            StringBuffer sqlBuf2 = new StringBuffer("Delete From T_EXT_SSDATA where fid in ( select fid from t_ext_sssnapshot Where ");
            sqlBuf2.append(identityPartSql.toString());
            sqlBuf2.append(userOrOrgID).append("' AND FLocationType = ").append(locationType).append(" AND FLocationPath ='");
            sqlBuf2.append(locationPath).append("' AND FreportID in(");
            for (int i = 0; i < reportIDs.length; ++i) {
                sqlBuf.append('\'').append(reportIDs[i]).append("',");
                sqlBuf2.append('\'').append(reportIDs[i]).append("',");
            }
            sqlBuf.setCharAt(sqlBuf.length() - 1, ')');
            sqlBuf2.setCharAt(sqlBuf2.length() - 1, ')');
            sqlBuf2.append(')');
            String[] sqls = new String[]{sqlBuf2.toString(), sqlBuf.toString()};
            DbUtil.executeBatchUpdate(sqls);
        }
        catch (SQLException e) {
            throw SnapshotException.wrap(e);
        }
    }

    @Override
    public List getPhantomSnapshotNotLimited(String userID, String reportID, String branch) throws SnapshotException {
        ArrayList<PhantomSnapshot> arrayList;
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT ");
        buf.append("* FROM ((Select S.Fid,S.Fname,S.Fcreatorid,S.Fcreatetime,S.Freportperiod,S.Fweekbegin,S.Fbegindate,S.Fenddate,");
        buf.append("U.Fname_l2 As Name, -5 As Type,S.Freportid, '' As Fsnapshotid,S.forgid, O.fname_l2 as orgName, ");
        buf.append(" S.Fcreatetime as sendTime, O.fname_l2 as sender , S.FLASTUPDATETIME As updateTime ");
        buf.append("From T_ext_sssnapshot S Left Outer Join T_pm_user U On S.Fcreatorid = U.Fid Left Outer Join T_Org_BaseUnit O On S.ForgID = O.Fid");
        buf.append(" WHERE S.Fcreatorid = ? and S.FReportid = ? And S.FlocationType = 0 And s.FlocationPath = ?");
        buf.append(")Union All(");
        buf.append("Select Sc.Fid, Sc.Fname, Sc.Fcreatorid,Sc.Fcollectiontime As Fcreatetime,Sc.Freportperiod,Sc.Fweekbegin,Sc.Fbegindate,Sc.Fenddate,");
        buf.append("U.Fname_l2 As Name, sc.FsourceType As Type,Sc.Freportid,Sc.Fsnapshotid, Sc.forgid,O.fname_l2 as orgName,");
        buf.append(" Sc.Fsendtime as sendTime, U2.fname_l2 as sender, FSendTime as updateTime ");
        buf.append(" From T_ext_ssshortcut Sc Left Outer Join T_pm_user U On Sc.Fcreatorid = U.Fid ");
        buf.append(" Left Outer Join T_Org_BaseUnit O On Sc.ForgID = O.Fid ");
        buf.append(" Left Outer Join T_pm_user U2 On Sc.Fsenderid = U2.Fid ");
        buf.append(" WHERE Sc.fuserid = ? and Sc.FReportid = ? And Sc.FlocationType = 0 And Sc.FlocationPath = ?");
        buf.append(")) TT Order By TT.Fcreatetime Desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(buf.toString(), new Object[]{userID, reportID, branch, userID, reportID, branch});
            ArrayList<PhantomSnapshot> lst = new ArrayList<PhantomSnapshot>(rs.size());
            while (rs.next()) {
                PhantomSnapshot item = new PhantomSnapshot();
                item.setId(rs.getString("fid"));
                item.setName(rs.getString("fname"));
                item.setCreatorID(rs.getString("fcreatorid"));
                item.setCreateTime(rs.getTimestamp("fcreatetime"));
                item.setReportPeriod(rs.getInt("freportperiod"));
                item.setBeginDate(rs.getTimestamp("fbegindate"));
                item.setEndDate(rs.getTimestamp("fenddate"));
                item.setWeekBegin(rs.getInt("fweekbegin"));
                int type = rs.getInt("type");
                item.setFake(type != -5);
                type = type == -5 ? SnapshotSourceType.SNAPSHOT_CENTER_REAL : type;
                item.setSourceType(type);
                if (item.isFake()) {
                    item.setSnapshotId(rs.getString("fsnapshotid"));
                    item.setSender(rs.getString("sender"));
                    item.setSendTime(rs.getTimestamp("sendTime"));
                } else {
                    item.setSnapshotId(item.getId());
                    item.setUpdateTime(rs.getTimestamp("updateTime"));
                }
                item.setReportId(rs.getString("freportid"));
                item.setUserName(rs.getString("name"));
                item.setOrgID(rs.getString("forgid"));
                item.setOrgName(rs.getString("orgName"));
                lst.add(item);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    @Override
    public List getSnapshotsNotLimited(String orgID, String reportID, String branch) throws SnapshotException {
        ArrayList<PhantomSnapshot> arrayList;
        StringBuffer buf = new StringBuffer();
        buf.append("Select ");
        buf.append(" S.Fid as cFid, S.Fname as shotname, S.Fcreatorid as creatorid, S.Fcreatetime as createtime, S.Freportperiod as reportperiod, S.Fweekbegin as weekbegin, S.Fbegindate as begindate, S.Fenddate enddate,");
        buf.append(" O.fname_l2 as orgname, U.Fname_l2 As Name,S.Freportid as reportid, S.flastupdateuserid As updatorId, U1.fname_l2 as updator, S.FLASTUPDATETIME As updateTime");
        buf.append(" From T_ext_sssnapshot S LEFT outer JOIN T_pm_user U On S.Fcreatorid = U.Fid  left outer join T_pm_user U1 on S.flastupdateuserid = U1.fid LEFT OUTER JOIN T_Org_BaseUnit O On S.ForgId = O.fid ");
        buf.append(" WHERE S.forgid = ? and S.FReportid = ? And S.FlocationType = 1 And s.FlocationPath = ? Order by createtime desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(buf.toString(), new Object[]{orgID, reportID, branch});
            ArrayList<PhantomSnapshot> lst = new ArrayList<PhantomSnapshot>(rs.size());
            while (rs.next()) {
                PhantomSnapshot item = new PhantomSnapshot();
                item.setId(rs.getString("cFid"));
                item.setName(rs.getString("shotname"));
                item.setCreatorID(rs.getString("creatorid"));
                item.setCreateTime(rs.getTimestamp("createtime"));
                item.setReportPeriod(rs.getInt("reportperiod"));
                item.setBeginDate(rs.getTimestamp("begindate"));
                item.setEndDate(rs.getTimestamp("enddate"));
                item.setWeekBegin(rs.getInt("weekbegin"));
                item.setSourceType(SnapshotSourceType.SNAPSHOT_CENTER_REAL);
                item.setSnapshotId(rs.getString("cFid"));
                item.setReportId(rs.getString("reportid"));
                item.setUserName(rs.getString("Name"));
                item.setOrgID(orgID);
                item.setOrgName(rs.getString("orgname"));
                item.setFake(false);
                item.setUpdator(rs.getString("updator"));
                item.setUpdateTime(rs.getTimestamp("updateTime"));
                lst.add(item);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    @Override
    public List getSumReportSnapshotsNotLimited(String orgID, String reportID) throws SnapshotException {
        ArrayList<PhantomSnapshot> arrayList;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("Select ");
        sqlBuf.append(" rs.fid , u.fname_l2 as username, rs.fcreatetime,td.freportperiod,td.Fweekbegin,rs.fcreatorid,");
        sqlBuf.append(" td.Fbegindate,td.Fenddate,td.fname_l2 as name from t_ext_reportsnap rs inner join t_ext_taskdistribute td on rs.ftaskdistributeid = td.fid left outer join t_pm_user u on u.fid = rs.fcreatorid where rs.forgid = ? and rs.freportid = ? order by rs.fcreatetime desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{orgID, reportID});
            ArrayList<PhantomSnapshot> lst = new ArrayList<PhantomSnapshot>(rs.size());
            String orgName = EASUtil.getCurrentOrgName(this.getContext());
            while (rs.next()) {
                PhantomSnapshot item = new PhantomSnapshot();
                item.setId(rs.getString("fid"));
                item.setName(rs.getString("name"));
                item.setCreateTime(rs.getTimestamp("fcreatetime"));
                item.setReportPeriod(rs.getInt("freportperiod"));
                item.setBeginDate(rs.getTimestamp("fbegindate"));
                item.setEndDate(rs.getTimestamp("fenddate"));
                item.setWeekBegin(rs.getInt("fweekbegin"));
                item.setUserName(rs.getString("username"));
                item.setSnapshotId(rs.getString("fid"));
                item.setSourceType(SnapshotSourceType.SUM_UPLOAD);
                item.setCreatorID(rs.getString("fcreatorid"));
                item.setOrgName(orgName);
                item.setFake(false);
                item.setReportId(reportID);
                lst.add(item);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map getUserMailsIDAndName(String wSQL, String otherDataCenter) throws SnapshotException {
        HashMap<String, String> hashMap;
        StringBuffer sqlBuf = new StringBuffer("select fsnapshotid as id, fname as name from t_ext_ssshortcutsbox Where");
        sqlBuf.append(wSQL);
        IRowSet rs = null;
        try {
            rs = ExtDBUtil.executeQuery(this.getContext(), sqlBuf.toString(), otherDataCenter);
            HashMap<String, String> id2Name = new HashMap<String, String>(rs.size());
            while (rs.next()) {
                id2Name.put(rs.getString("ID"), rs.getString("NAME"));
            }
            hashMap = id2Name;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
                catch (BOSException _) {
                    throw SnapshotException.wrap((Exception)((Object)_));
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return hashMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map getUserPhantomIDAndName(String wSQL, String otherDataCenter) throws SnapshotException {
        HashMap<String, String> hashMap;
        StringBuffer sqlBuf = new StringBuffer("select Fsnapshotid as id, fname as name from T_EXT_SSSHORTCUT Where ");
        sqlBuf.append(wSQL);
        IRowSet rs = null;
        try {
            rs = ExtDBUtil.executeQuery(this.getContext(), sqlBuf.toString(), otherDataCenter);
            HashMap<String, String> id2Name = new HashMap<String, String>(rs.size());
            while (rs.next()) {
                id2Name.put(rs.getString("ID"), rs.getString("NAME"));
            }
            hashMap = id2Name;
        }
        catch (BOSException e) {
            try {
                throw SnapshotException.wrap((Exception)((Object)e));
                catch (SQLException _) {
                    throw SnapshotException.wrap(_);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return hashMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map getUserSnapshotIDAndName(String wSQL, String otherDataCenter) throws SnapshotException {
        HashMap<String, String> hashMap;
        StringBuffer sqlBuf = new StringBuffer("select fid as id, fname as name from T_EXT_SSSNAPSHOT Where ");
        sqlBuf.append(wSQL);
        sqlBuf.append(" AND FREPORTID ");
        sqlBuf.append(this.getPermissionFilter2());
        IRowSet rs = null;
        try {
            rs = ExtDBUtil.executeQuery(this.getContext(), sqlBuf.toString(), otherDataCenter);
            HashMap<String, String> id2Name = new HashMap<String, String>(rs.size());
            while (rs.next()) {
                id2Name.put(rs.getString("ID"), rs.getString("NAME"));
            }
            hashMap = id2Name;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
                catch (BOSException _) {
                    throw SnapshotException.wrap((Exception)((Object)_));
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return hashMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map getUserPhantomsIDAndData(String[] ids, String otherDataCenter) throws SnapshotException {
        HashMap<String, byte[]> hashMap;
        if (ids == null || ids.length == 0) {
            return new HashMap(1);
        }
        StringBuffer sqlBuf = new StringBuffer("SELECT FID AS ID, FBLOCKINDEX AS BINDEX,FCONTENT AS DATA,FLENGTH AS LENGTH FROM ");
        sqlBuf.append(" T_EXT_SSDATA WHERE FID IN(");
        for (int i = 0; i < ids.length; ++i) {
            sqlBuf.append('\'').append(ids[i]).append("',");
        }
        sqlBuf.setCharAt(sqlBuf.length() - 1, ')');
        sqlBuf.append(" ORDER BY FID ASC, FBLOCKINDEX DESC");
        IRowSet rs = null;
        try {
            rs = ExtDBUtil.executeQuery(this.getContext(), sqlBuf.toString(), otherDataCenter);
            HashMap<String, byte[]> rsMap = new HashMap<String, byte[]>(rs.size());
            if (rs.next()) {
                boolean breakAll = false;
                do {
                    String id = rs.getString("ID");
                    int size = rs.getInt("BINDEX") + 1;
                    SnapDataBean[] beans = new SnapDataBean[size];
                    int index = 0;
                    for (int i = size - 1; i >= 0; --i) {
                        int length = rs.getInt("LENGTH");
                        byte[] block = new byte[length];
                        try {
                            InputStream in = rs.getBlob("DATA").getBinaryStream();
                            try {
                                in.read(block);
                            }
                            catch (IOException e) {
                                throw SnapshotException.wrap(e);
                            }
                        }
                        catch (SQLException e) {
                            block = rs.getBytes("DATA");
                        }
                        beans[index++] = new SnapDataBean(block, length);
                        if (rs.next()) continue;
                        breakAll = true;
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    for (int i = beans.length - 1; i >= 0; --i) {
                        out.write(beans[i].getBlock(), 0, beans[i].getSize());
                        beans[i].GCBlock();
                    }
                    rsMap.put(id, out.toByteArray());
                } while (!breakAll);
            }
            hashMap = rsMap;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
                catch (BOSException _) {
                    throw SnapshotException.wrap((Exception)((Object)_));
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return hashMap;
    }

    @Override
    public String[] getCommonTreeFilterSetBySnapshot(String orgID) throws SnapshotException {
        String[] stringArray;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("SELECT distinct flocationPath from t_ext_sssnapshot where flocationType = ? and forgid = ? and freportid  ");
        sqlBuf.append(this.getPermissionFilter2());
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{new Integer(FolderType.COMMON_FOLDER), orgID});
            String[] paths = new String[rs.size()];
            int i = -1;
            while (rs.next()) {
                paths[++i] = rs.getString("flocationPath");
            }
            stringArray = paths;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return stringArray;
    }

    @Override
    public List getPhantomSnapshotNotLimited(String userID, String branch, SnapshotQueryModel model) throws SnapshotException {
        ArrayList<SnapshotPartInfo> arrayList;
        StringBuffer buf = new StringBuffer();
        boolean allDir = StringUtil.isEmptyString((String)branch);
        buf.append("SELECT ");
        buf.append("* FROM ((Select S.Fid as sid,S.Fname,D.Fname_l2 as ReportName, 0 as fake, S.FReportId ");
        buf.append(" From T_ext_sssnapshot S Left Outer Join T_BAS_DefineReport D On S.FReportId = D.Fid");
        buf.append(" WHERE S.Fcreatorid = ? ");
        buf.append(" And S.FlocationType = 0 ");
        if (!allDir) {
            buf.append("And s.FlocationPath = '").append(branch).append("' ");
        }
        if (model != null) {
            if (!StringUtil.isEmptyString((String)model.getSnapName())) {
                buf.append(" AND S.Fname like '%").append(model.getSnapName()).append("%' ");
            }
            if (!StringUtil.isEmptyString((String)model.getReportName())) {
                buf.append(" AND D.Fname_l2 like '%").append(model.getReportName()).append("%' ");
            }
        }
        buf.append(")Union All(");
        buf.append("Select Sc.FSnapshotid as sid, Sc.Fname,D.Fname_l2 as ReportName, 1 as fake,Sc.FReportId");
        buf.append(" From T_ext_ssshortcut Sc Left Outer Join T_Bas_DefineReport D On Sc.FReportId = D.Fid WHERE Sc.fuserid = ? ");
        buf.append(" And Sc.FlocationType = 0 ");
        if (!allDir) {
            buf.append(" And Sc.FlocationPath = '").append(branch).append("' ");
        }
        if (model != null) {
            if (!StringUtil.isEmptyString((String)model.getSnapName())) {
                buf.append(" AND Sc.Fname like '%").append(model.getSnapName()).append("%' ");
            }
            if (!StringUtil.isEmptyString((String)model.getReportName())) {
                buf.append(" AND D.Fname_l2 like '%").append(model.getReportName()).append("%' ");
            }
        }
        buf.append(")) TT Order By TT.FReportId Desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(buf.toString(), new Object[]{userID, userID});
            ArrayList<SnapshotPartInfo> lst = new ArrayList<SnapshotPartInfo>(rs.size());
            while (rs.next()) {
                SnapshotPartInfo item = new SnapshotPartInfo();
                item.setSnapshotID(rs.getString("sid"));
                item.setSnapshotName(rs.getString("fname"));
                item.setReportName(rs.getString("reportName"));
                int type = rs.getInt("fake");
                item.setFake(type == 1);
                lst.add(item);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    @Override
    public List getSnapshotsNotLimited(String orgID, String branch, SnapshotQueryModel model) throws SnapshotException {
        ArrayList<SnapshotPartInfo> arrayList;
        StringBuffer buf = new StringBuffer();
        String userID = EASUtil.getCurrentUserID(this.getContext());
        boolean allDir = StringUtil.isEmptyString((String)branch);
        buf.append("Select ");
        buf.append(" S.Fid,S.Fname,D.fname_l2 as reportName");
        buf.append(" From T_ext_sssnapshot S");
        buf.append(" LEFT OUTER JOIN T_BAS_definereport D on D.fid = S.FReportID WHERE S.forgid = ? ");
        buf.append(" And S.FlocationType = 1 ");
        if (!allDir) {
            buf.append("And s.FlocationPath = '").append(branch).append("' ");
        }
        if (model != null) {
            if (!StringUtil.isEmptyString((String)model.getSnapName())) {
                buf.append(" AND S.Fname like '%").append(model.getSnapName()).append("%' ");
            }
            if (!StringUtil.isEmptyString((String)model.getReportName())) {
                buf.append(" AND D.Fname_l2 like '%").append(model.getReportName()).append("%' ");
            }
        }
        buf.append(" and S.FReportid ");
        buf.append(this.getPermissionFilter());
        buf.append("  Order by S.FReportID asc,S.fcreatetime desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(buf.toString(), new Object[]{orgID, userID, orgID, userID, userID, orgID});
            ArrayList<SnapshotPartInfo> lst = new ArrayList<SnapshotPartInfo>(rs.size());
            while (rs.next()) {
                SnapshotPartInfo item = new SnapshotPartInfo();
                item.setSnapshotID(rs.getString("fid"));
                item.setSnapshotName(rs.getString("fname"));
                item.setReportName(rs.getString("reportName"));
                item.setFake(false);
                lst.add(item);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw SnapshotException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    private Context getContext() {
        if (this._ctx != null) {
            return this._ctx;
        }
        return ServerUtil.getContext();
    }
}

