/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.manage.server.ug.impl;

import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.rpts.snapshot.manage.exception.UserGroupException;
import com.kingdee.eas.rpts.snapshot.manage.pojo.ug.SSUserInfo;
import com.kingdee.eas.rpts.snapshot.manage.pojo.ug.UserGroupInfo;
import com.kingdee.eas.rpts.snapshot.manage.server.ug.IUserGroupDAO;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.rpts.sumreport.util.MixUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UserGroupDAO
implements IUserGroupDAO {
    private String _userID = EASUtil.getCurrentUserID(ServerUtil.getContext());

    @Override
    public void delUserGroup(UserGroupInfo entity) throws UserGroupException {
        StringBuffer delGroup = new StringBuffer("Delete T_ext_SSuserGroup where fid = '");
        delGroup.append(entity.getId()).append('\'');
        StringBuffer delItems = new StringBuffer("Delete T_EXT_SSUGEntry where fgroupid = '");
        delItems.append(entity.getId()).append('\'');
        try {
            DbUtil.executeBatchUpdate(new String[]{delGroup.toString(), delItems.toString()});
        }
        catch (SQLException e) {
            throw UserGroupException.wrap(e);
        }
    }

    @Override
    public void insertUserGroup(UserGroupInfo entity) throws UserGroupException {
        StringBuffer sqlBuf = new StringBuffer("insert into t_ext_ssusergroup(fid,fname,fcreateTime,Fcreatorid)values(");
        sqlBuf.append('\'').append(entity.getId()).append("',");
        sqlBuf.append('\'').append(entity.getName()).append("',");
        sqlBuf.append("{ts'").append(MixUtil.getDateFromTimestamp(entity.getCreateTime())).append("'},");
        sqlBuf.append('\'').append(entity.getCreatorID()).append('\'');
        sqlBuf.append(')');
        StringBuffer itemBuf = new StringBuffer("insert into T_EXT_SSUGEntry(fid,fgroupid,fuserid)values(?,?,?)");
        List groupItems = entity.getItems();
        ArrayList<String> paramLst = new ArrayList<String>(groupItems.size() * 3);
        int size = groupItems.size();
        for (int i = 0; i < size; ++i) {
            SSUserInfo item = (SSUserInfo)groupItems.get(i);
            paramLst.add(item.getId());
            paramLst.add(item.getGroupID());
            paramLst.add(item.getUserID());
        }
        try {
            DbUtil.executeBatchUpdate(itemBuf.toString(), paramLst, 3, sqlBuf.toString());
        }
        catch (SQLException e) {
            throw UserGroupException.wrap(e);
        }
    }

    @Override
    public void delUserGroupItems(String groupID, String[] itemIDs) throws UserGroupException {
        if (itemIDs == null || itemIDs.length == 0) {
            return;
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append(" delete T_EXT_SSUGEntry where fgroupid = ? and fid in (");
        for (int i = 0; i < itemIDs.length; ++i) {
            sqlBuf.append("?,");
        }
        sqlBuf.setCharAt(sqlBuf.length() - 1, ')');
        List params = Arrays.asList((Object[])itemIDs);
        params.add(0, groupID);
        try {
            DbUtil.executeUpdate(sqlBuf.toString(), params.toArray());
        }
        catch (SQLException e) {
            throw UserGroupException.wrap(e);
        }
    }

    @Override
    public List queryAllUserGroups() throws UserGroupException {
        ArrayList<UserGroupInfo> arrayList;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("Select fid, fname From T_EXT_SSUSERGROUP where fcreatorid = ? order by fcreatetime desc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sqlBuf.toString(), new Object[]{this._userID});
            ArrayList<UserGroupInfo> lst = new ArrayList<UserGroupInfo>();
            while (rs.next()) {
                UserGroupInfo group = new UserGroupInfo();
                group.setId(rs.getString("fid"));
                group.setName(rs.getString("fname"));
                lst.add(group);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw UserGroupException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    @Override
    public List queryAllUsers() throws UserGroupException {
        ArrayList<SSUserInfo> arrayList;
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append(" Select fid, fnumber, fname_l2 as name from t_pm_user where ftype not in ( 10,60,70) and fisDelete = 0 and fAgentUser = 0");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sqlBuf.toString(), null);
            ArrayList<SSUserInfo> lst = new ArrayList<SSUserInfo>();
            while (rs.next()) {
                String userID = rs.getString("fid");
                if (userID.equals(this._userID)) continue;
                SSUserInfo user = new SSUserInfo();
                user.setUserID(userID);
                user.assemblyName(rs.getString("fnumber"), rs.getString("name"));
                lst.add(user);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw UserGroupException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    @Override
    public List queryUsersByGroupID(String[] groupIDs) throws UserGroupException {
        ArrayList<SSUserInfo> arrayList;
        if (groupIDs == null || groupIDs.length == 0) {
            return null;
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("Select ss.fid, ss.fuserid, u.fname_l2 as name, u.fnumber, ss.fgroupid from T_EXT_SSUGEntry ss left outer join t_pm_user u ");
        sqlBuf.append(" on ss.fuserid = u.fid where ss.fgroupid in (");
        for (int i = 0; i < groupIDs.length; ++i) {
            sqlBuf.append("?,");
        }
        sqlBuf.setCharAt(sqlBuf.length() - 1, ')');
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery(sqlBuf.toString(), groupIDs);
            ArrayList<SSUserInfo> lst = new ArrayList<SSUserInfo>(rs.size());
            while (rs.next()) {
                SSUserInfo userInfo = new SSUserInfo();
                userInfo.setId(rs.getString("fid"));
                userInfo.setUserID(rs.getString("fuserid"));
                userInfo.setGroupID(rs.getString("fgroupid"));
                userInfo.assemblyName(rs.getString("fnumber"), rs.getString("name"));
                lst.add(userInfo);
            }
            arrayList = lst;
        }
        catch (SQLException e) {
            try {
                throw UserGroupException.wrap(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return arrayList;
    }

    @Override
    public void updateUserGroup(UserGroupInfo entity) throws UserGroupException {
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("Update T_EXT_SSUSERGROUP Set FName = ? , Flastupdatetime = ?,Flastupdateperson = ?  Where fid = ?");
        try {
            DbUtil.executeUpdate(sqlBuf.toString(), new Object[]{entity.getName(), entity.getLastUpdateTime(), entity.getLastUpdatePerson(), entity.getId()});
        }
        catch (SQLException e) {
            throw UserGroupException.wrap(e);
        }
    }

    @Override
    public void updateUserGroupItems(UserGroupInfo entity) throws UserGroupException {
        StringBuffer sqlBuf = new StringBuffer("delete T_EXT_SSUGEntry where fgroupid = ");
        sqlBuf.append('\'').append(entity.getId()).append('\'');
        StringBuffer itemBuf = new StringBuffer("insert into T_EXT_SSUGEntry(fid,fgroupid,fuserid)values(?,?,?)");
        List groupItems = entity.getItems();
        ArrayList<String> paramLst = new ArrayList<String>(groupItems.size() * 3);
        int size = groupItems.size();
        for (int i = 0; i < size; ++i) {
            SSUserInfo item = (SSUserInfo)groupItems.get(i);
            paramLst.add(item.getId());
            paramLst.add(item.getGroupID());
            paramLst.add(item.getUserID());
        }
        try {
            DbUtil.executeBatchUpdate(itemBuf.toString(), paramLst, 3, sqlBuf.toString());
        }
        catch (SQLException e) {
            throw UserGroupException.wrap(e);
        }
    }
}

