/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.manage.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.ctrl.semantic.common.Util;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.snapshot.manage.exception.PersonalFolderException;
import com.kingdee.eas.rpts.snapshot.manage.pojo.PersonalFolder;
import com.kingdee.eas.rpts.snapshot.manage.server.pf.IPersonalFolderDAO;
import com.kingdee.eas.rpts.snapshot.manage.server.pf.impl.PersonalFolderDAO;
import com.kingdee.eas.rpts.snapshot.manage.server.pf.impl.SnapshotRelativeDAO;
import com.kingdee.eas.rpts.snapshot.manage.service.IPersonalFolderService;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.List;

public class PersonalFolderService
extends ORMObject
implements IPersonalFolderService {
    private static final String ENTITY_KEY = "ENTITY_KEY";
    private IPersonalFolderDAO _dao;

    public PersonalFolderService() {
        this.registerInterface(IPersonalFolderService.class, this);
        this._dao = new PersonalFolderDAO();
    }

    public static IPersonalFolderService getInst() throws PersonalFolderException {
        String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
        try {
            return (IPersonalFolderService)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)PersonalFolderService.class.getName(), IPersonalFolderService.class);
        }
        catch (BOSException e) {
            throw PersonalFolderException.wrap("Initial Personal Folder Service error.", (Exception)((Object)e));
        }
    }

    @Override
    public PersonalFolder loadMyFolder() throws PersonalFolderException {
        List folderList = this._dao.buildTree(ContextUtil.getCurrentUserInfo((Context)ServerUtil.getContext()).getId().toString());
        PersonalFolder rootFolder = (PersonalFolder)PersonalFolder.ROOT.clone();
        if (null != folderList && folderList.size() >= 1) {
            HashMap<String, PersonalFolder> cache = new HashMap<String, PersonalFolder>();
            cache.put(rootFolder.getId(), rootFolder);
            int size = folderList.size();
            for (int i = 0; i < size; ++i) {
                PersonalFolder folder = (PersonalFolder)folderList.get(i);
                if (cache.containsKey(folder.getParentId())) {
                    PersonalFolder pFolder = (PersonalFolder)cache.get(folder.getParentId());
                    pFolder.addChild(folder);
                }
                cache.put(folder.getId(), folder);
            }
            Object var3_3 = null;
        }
        return rootFolder;
    }

    @Override
    public boolean isNameExist(String name, String parentID) throws PersonalFolderException {
        return this._dao.isNameExist(name, parentID);
    }

    @Override
    public void newFolder(PersonalFolder folder) throws PersonalFolderException {
        int count = this._dao.getCount(ContextUtil.getCurrentUserInfo((Context)ServerUtil.getContext()).getId().toString());
        folder.setOrder(count);
        this._dao.insertFolder(folder);
    }

    @Override
    public void delFolder(PersonalFolder folder) throws PersonalFolderException {
        RptParams params = new RptParams();
        params.setString("FullName", this.getClass().getName());
        params.setString("MethodName", "_delFolder");
        params.setObject(ENTITY_KEY, (Object)folder);
        try {
            FacadeFactory.commonExecuteRequired(ServerUtil.getContext(), params);
        }
        catch (BOSException e) {
            throw PersonalFolderException.wrap((Exception)((Object)e));
        }
    }

    public RptParams _delFolder(Context ctx, RptParams pr) {
        PersonalFolder folder = (PersonalFolder)pr.getObject(ENTITY_KEY);
        RptParams rs = new RptParams();
        try {
            if (folder.isLeaf()) {
                this._dao.deleteLeafFolder(folder);
            } else {
                this._dao.deleteBranchFolder(folder);
            }
            SnapshotRelativeDAO ssDao = new SnapshotRelativeDAO();
            ssDao.delShortcutsByLongNumber(folder.getLongNumber(), folder.getUserId());
            String[] ids = ssDao.querySnapshotsID(folder.getLongNumber(), folder.getUserId());
            ssDao.deleteSnapshots(ids);
        }
        catch (Exception e) {
            rs.setObject("exception", (Object)PersonalFolderException.wrap(e));
        }
        return rs;
    }

    @Override
    public void renameFolder(PersonalFolder folder) throws PersonalFolderException {
        this._dao.updateFolder(folder);
    }

    @Override
    public String getNameByLongNumber(String longNumber) throws PersonalFolderException {
        if (longNumber == null) {
            return "";
        }
        if (longNumber.equals(PersonalFolder.ROOT.getLongNumber())) {
            return PersonalFolder.ROOT.getName();
        }
        String[] ids = longNumber.split(Util.PATH_SPLIT);
        return this._dao.getNamebyID(ids[ids.length - 1]);
    }
}

