/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.manage.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.eas.base.permission.Permission;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.snapshot.ds.model.SnapshotQueryModel;
import com.kingdee.eas.rpts.snapshot.ds.model.SumPropsModel;
import com.kingdee.eas.rpts.snapshot.manage.consta.FolderType;
import com.kingdee.eas.rpts.snapshot.manage.exception.SnapshotException;
import com.kingdee.eas.rpts.snapshot.manage.pojo.PhantomSnapshot;
import com.kingdee.eas.rpts.snapshot.manage.pojo.SnapshotBaseInfo;
import com.kingdee.eas.rpts.snapshot.manage.pojo.so.ReportGroupItem;
import com.kingdee.eas.rpts.snapshot.manage.server.pf.ISnapshotRelativeDAO;
import com.kingdee.eas.rpts.snapshot.manage.server.pf.impl.SnapshotRelativeDAO;
import com.kingdee.eas.rpts.snapshot.manage.service.ISnapshotRelativeService;
import com.kingdee.eas.rpts.sumreport.data.SnapDataBean;
import com.kingdee.eas.rpts.sumreport.util.EASUtil;
import com.kingdee.eas.rpts.sumreport.util.MixUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SnapshotRelativeService
extends ORMObject
implements ISnapshotRelativeService {
    private ISnapshotRelativeDAO _dao;
    private static final String BASE_PATH = "com.kingdee.eas";
    public static final int BLOCK_SIZE = 65536;
    private static final String ENTITY_KEY = "ENTITY_KEY";
    private static final String EXCEPTION_KEY = "EXCEPTION_KEY";
    private static final String REPORT_KEY = "REPORT_KEY";
    private Context _ctx;

    public SnapshotRelativeService() {
        this.registerInterface(ISnapshotRelativeService.class, this);
        this._dao = new SnapshotRelativeDAO();
    }

    public SnapshotRelativeService(Context ctx) {
        this.registerInterface(ISnapshotRelativeService.class, this);
        this._ctx = ctx;
        this._dao = new SnapshotRelativeDAO(ctx);
    }

    public static ISnapshotRelativeService getInst() throws SnapshotException {
        String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
        try {
            return (ISnapshotRelativeService)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)SnapshotRelativeService.class.getName(), ISnapshotRelativeService.class);
        }
        catch (BOSException e) {
            throw SnapshotException.wrap("Initial SnapshotRelativeService error.", (Exception)((Object)e));
        }
    }

    @Override
    public Set getCommonTreeFilterSet(String orgID) throws SnapshotException {
        String[] paths = this._dao.queryCTAddupInfo(orgID, false);
        HashSet<String> set = new HashSet<String>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            if (StringUtil.isEmptyString((String)paths[i]) || paths[i].equals("root")) continue;
            set.add(paths[i]);
        }
        set.add("com.kingdee.eas.eas");
        return set;
    }

    @Override
    public List getPhantomSnapshot(String userID, String reportID, String branch) throws SnapshotException {
        return this._dao.getPhantomSnapshot(userID, reportID, branch);
    }

    @Override
    public List queryPTReportList(String userID, String branch) throws SnapshotException {
        return this._dao.queryPTReportList(userID, branch);
    }

    @Override
    public List getSnapshots(String orgID, String reportID, String branch) throws SnapshotException {
        return this._dao.getSnapshots(orgID, reportID, branch);
    }

    @Override
    public List queryCTReportList(String orgID, String branch) throws SnapshotException {
        return this._dao.queryCTReportList(orgID, branch, false);
    }

    @Override
    public void addSnapshot(SnapshotBaseInfo baseInfo, byte[] data, int locationType) throws SnapshotException {
        baseInfo.setId(UID.create((int)44));
        baseInfo.setCreateTime(new Timestamp(new Date().getTime()));
        this._dao.addSnapshot(baseInfo, this.cutApart(data), locationType);
    }

    private SnapDataBean[] cutApart(byte[] source) {
        int leaveBytes = source.length;
        int index = 0;
        int srcPos = 0;
        int size = leaveBytes / 65536 + (leaveBytes % 65536 > 0 ? 1 : 0);
        SnapDataBean[] blocks = new SnapDataBean[size];
        while (leaveBytes > 0) {
            int bytes = 65536;
            if (65536 > leaveBytes) {
                bytes = leaveBytes;
            }
            byte[] buffer = new byte[bytes];
            System.arraycopy(source, srcPos, buffer, 0, bytes);
            leaveBytes -= 65536;
            SnapDataBean block = new SnapDataBean(buffer, index);
            srcPos += 65536;
            blocks[index] = block;
            ++index;
        }
        return blocks;
    }

    @Override
    public List getSumReportReports(String orgID) throws SnapshotException {
        return this._dao.getSumReportReports(orgID);
    }

    @Override
    public int checkUploadAndSumPermission(String orgID, String userID) throws EASBizException, BOSException {
        Permission permission = new Permission();
        ObjectUuidPK orgPk = new ObjectUuidPK(orgID);
        ObjectUuidPK userPk = new ObjectUuidPK(userID);
        boolean result = false;
        int retn = -1;
        result = permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Sum_Make");
        if (!result) {
            boolean bl = result = result || permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Sum_Approve");
        }
        if (!result) {
            boolean bl = result = result || permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Sum_Upload");
        }
        if (result) {
            retn = 1;
        }
        if (!(result = permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Upload_Make"))) {
            boolean bl = result = result || permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Upload_Approve");
        }
        if (!result) {
            boolean bl = result = result || permission.hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "ext_Upload_Upload");
        }
        if (result && retn == 1) {
            retn = -1;
        } else if (result) {
            retn = 0;
        } else if (!result && retn == -1) {
            retn = -2;
        }
        return retn;
    }

    @Override
    public List getSumReportSnapshots(String orgID, String reportID) throws SnapshotException {
        return this._dao.getSumReportSnapshots(orgID, reportID);
    }

    @Override
    public byte[] getSnapshotData(String snapshotID) throws SnapshotException {
        return this._dao.querySnapshotByID(snapshotID);
    }

    @Override
    public DefineReportInfo queryReportTemplateInfo(String reportID) throws SnapshotException {
        try {
            return DefineReportBO.getReportInfo(this.getContext(), reportID);
        }
        catch (BOSException e) {
            throw SnapshotException.wrap("\u83b7\u53d6\u6a21\u677f\u6570\u636e\u5931\u8d25", (Exception)((Object)e));
        }
    }

    @Override
    public void updateSnapshot(String snapshotID, byte[] data) throws SnapshotException {
        SnapDataBean[] blocks = this.cutApart(data);
        this._dao.updateSnapshot(snapshotID, blocks);
    }

    @Override
    public void updateSnapshot(String userID, String snapshotID, byte[] data) throws SnapshotException {
        SnapDataBean[] blocks = this.cutApart(data);
        this._dao.updateSnapshot(userID, snapshotID, blocks);
    }

    @Override
    public byte[] getSumUploadSnapshotData(String snapshotID) throws SnapshotException {
        return this._dao.querySumReportSnapshotData(snapshotID);
    }

    @Override
    public List findNameConflictByOrg(List phantoms, String locationPath, String orgID) throws SnapshotException {
        ArrayList<PhantomSnapshot> conflictLst = new ArrayList<PhantomSnapshot>();
        int size = phantoms.size();
        for (int i = 0; i < size; ++i) {
            PhantomSnapshot snapshot = (PhantomSnapshot)phantoms.get(i);
            String fid = this._dao.isExistSnapshotNameByOrg(orgID, locationPath, snapshot.getReportId(), snapshot.getName());
            if (fid == null) continue;
            if (StringUtil.isEmptyString((String)snapshot.getId())) {
                snapshot.setId(fid);
            }
            conflictLst.add(snapshot);
        }
        return conflictLst;
    }

    @Override
    public List findNameConflictByUser(List phantoms, String locationPath, String userID) throws SnapshotException {
        ArrayList<PhantomSnapshot> conflictLst = new ArrayList<PhantomSnapshot>();
        int size = phantoms.size();
        for (int i = 0; i < size; ++i) {
            PhantomSnapshot snapshot = (PhantomSnapshot)phantoms.get(i);
            String fid = null;
            fid = snapshot.isFake() ? this._dao.isExistPhantomsByUser(userID, locationPath, snapshot.getReportId(), snapshot.getName()) : this._dao.isExistSnapshotNameByUser(userID, locationPath, snapshot.getReportId(), snapshot.getName());
            if (fid == null) continue;
            if (StringUtil.isEmptyString((String)snapshot.getId())) {
                snapshot.setId(fid);
            }
            conflictLst.add(snapshot);
        }
        return conflictLst;
    }

    @Override
    public void copyPhantomSnapshots(List phantoms, String locationPath) throws SnapshotException {
        RptParams params = new RptParams();
        params.setString("FullName", this.getClass().getName());
        params.setString("MethodName", "_copyPhantomSnapshots");
        params.setObject(ENTITY_KEY, (Object)phantoms);
        params.setString("LocationPath", locationPath);
        try {
            RptParams rp = FacadeFactory.commonExecuteRequired(this.getContext(), params);
            SnapshotException ex = (SnapshotException)rp.getObject(EXCEPTION_KEY);
            if (ex != null) {
                throw ex;
            }
        }
        catch (BOSException e) {
            throw SnapshotException.wrap((Exception)((Object)e));
        }
    }

    public RptParams _copyPhantomSnapshots(Context ctx, RptParams pr) {
        List phantoms = (List)pr.getObject(ENTITY_KEY);
        String locationPath = pr.getString("LocationPath");
        ArrayList<PhantomSnapshot> real = new ArrayList<PhantomSnapshot>();
        ArrayList<PhantomSnapshot> fake = new ArrayList<PhantomSnapshot>();
        Timestamp now = new Timestamp(new Date().getTime());
        String userID = EASUtil.getCurrentUserID(ctx);
        String orgID = EASUtil.getCurrentOrgID(ctx);
        int size = phantoms.size();
        for (int i = 0; i < size; ++i) {
            PhantomSnapshot ps = (PhantomSnapshot)phantoms.get(i);
            if (ps.isFake()) {
                fake.add(ps);
                continue;
            }
            real.add(ps);
        }
        RptParams rs = new RptParams();
        try {
            PhantomSnapshot ps;
            int i;
            int size2 = real.size();
            for (i = 0; i < size2; ++i) {
                ps = (PhantomSnapshot)real.get(i);
                SnapshotBaseInfo snapshot = this.pack(ps, now, userID, locationPath);
                snapshot.setOrgID(orgID);
                byte[] data = this._dao.querySnapshotByID(ps.getId());
                this.addSnapshot(snapshot, data, FolderType.PERSONAL_FOLDER);
            }
            size2 = fake.size();
            for (i = 0; i < size2; ++i) {
                ps = (PhantomSnapshot)fake.get(i);
                ps.setId(UID.create((int)44));
                ps.setUserId(userID);
                ps.setOrgID(orgID);
                ps.setCollectTime(now);
                ps.setLocationPath(locationPath);
            }
            if (fake.size() > 0) {
                this.addPhantomSnapshot(fake);
            }
        }
        catch (SnapshotException e) {
            rs.setObject(EXCEPTION_KEY, (Object)e);
        }
        return rs;
    }

    private SnapshotBaseInfo pack(PhantomSnapshot ps, Timestamp now, String userID, String locationPath) {
        SnapshotBaseInfo snapshot = new SnapshotBaseInfo();
        snapshot.setId(UID.create((int)44));
        snapshot.setCreateTime(now);
        snapshot.setName(ps.getName());
        snapshot.setReportID(ps.getReportId());
        snapshot.setCreatorID(userID);
        snapshot.setLocationPath(locationPath);
        snapshot.setLocationType(FolderType.PERSONAL_FOLDER);
        snapshot.setWeekBegin(ps.getWeekBegin());
        snapshot.setBeginDate(ps.getBeginDate());
        snapshot.setEndDate(ps.getEndDate());
        snapshot.setReportPeriod(ps.getReportPeriod());
        return snapshot;
    }

    @Override
    public void favoriteSnapshots(List phantoms, String locationPath) throws SnapshotException {
        Timestamp now = new Timestamp(new Date().getTime());
        Context ctx = this.getContext();
        String userID = EASUtil.getCurrentUserID(ctx);
        int size = phantoms.size();
        for (int i = 0; i < size; ++i) {
            PhantomSnapshot ps = (PhantomSnapshot)phantoms.get(i);
            ps.setId(UID.create((int)44));
            ps.setCollectTime(now);
            ps.setUserId(userID);
            ps.setLocationType(FolderType.PERSONAL_FOLDER);
            ps.setLocationPath(locationPath);
        }
        this._dao.addShortcut(phantoms);
    }

    @Override
    public void movePhantomSnapshots(List phantoms, String locationPath, boolean deleteOrignal) throws SnapshotException {
        RptParams params = new RptParams();
        params.setString("FullName", this.getClass().getName());
        params.setString("MethodName", "_movePhantomSnapshots");
        params.setObject(ENTITY_KEY, (Object)phantoms);
        params.setString("LocationPath", locationPath);
        try {
            RptParams rp = FacadeFactory.commonExecuteRequired(this.getContext(), params);
            SnapshotException ex = (SnapshotException)rp.getObject(EXCEPTION_KEY);
            if (ex != null) {
                throw ex;
            }
        }
        catch (BOSException e) {
            throw SnapshotException.wrap((Exception)((Object)e));
        }
    }

    public RptParams _movePhantomSnapshots(Context ctx, RptParams pr) {
        List phantoms = (List)pr.getObject(ENTITY_KEY);
        String locationPath = pr.getString("LocationPath");
        ArrayList<PhantomSnapshot> real = new ArrayList<PhantomSnapshot>();
        ArrayList<PhantomSnapshot> fake = new ArrayList<PhantomSnapshot>();
        int size = phantoms.size();
        for (int i = 0; i < size; ++i) {
            PhantomSnapshot ps = (PhantomSnapshot)phantoms.get(i);
            ps.setLocationPath(locationPath);
            ps.setLocationType(FolderType.PERSONAL_FOLDER);
            if (ps.isFake()) {
                fake.add(ps);
                continue;
            }
            real.add(ps);
        }
        RptParams rs = new RptParams();
        try {
            if (!fake.isEmpty()) {
                this._dao.movePhantoms(fake);
            }
            if (!real.isEmpty()) {
                this._dao.moveSnapshots(real);
            }
        }
        catch (SnapshotException e) {
            rs.setObject(EXCEPTION_KEY, (Object)e);
        }
        return rs;
    }

    @Override
    public void addPhantomSnapshot(List snapshots) throws SnapshotException {
        this._dao.addShortcut(snapshots);
    }

    @Override
    public void deleteSnapshots(String[] snapshotIDs) throws SnapshotException {
        this._dao.deleteSnapshots(snapshotIDs);
    }

    @Override
    public void updatePhantomName(PhantomSnapshot ps) throws SnapshotException {
        if (ps.isFake()) {
            this._dao.updatePhantomSnapshotName(ps.getName(), ps.getId());
        } else {
            this._dao.updateSnapshotName(ps.getName(), ps.getId());
        }
    }

    @Override
    public void updatePhantomProps(PhantomSnapshot phantomSnapshot) throws SnapshotException {
        if (phantomSnapshot.isFake()) {
            this._dao.updatePhantomProps(phantomSnapshot);
        } else {
            this._dao.updateSnapshotProps(phantomSnapshot);
        }
    }

    public RptParams _delPhantomSnapshot(Context ctx, RptParams pr) {
        RptParams rp = new RptParams();
        List phantoms = (List)pr.getObject(ENTITY_KEY);
        List reports = (List)pr.getObject(REPORT_KEY);
        String locationPath = pr.getString("LOCATION_PATH");
        int locationType = pr.getInt("LOCATION_TYPE");
        ArrayList<PhantomSnapshot> real = new ArrayList<PhantomSnapshot>();
        ArrayList<PhantomSnapshot> fake = new ArrayList<PhantomSnapshot>();
        int size = phantoms.size();
        for (int i = 0; i < size; ++i) {
            PhantomSnapshot ps = (PhantomSnapshot)phantoms.get(i);
            if (ps.isFake()) {
                fake.add(ps);
                continue;
            }
            real.add(ps);
        }
        try {
            PhantomSnapshot ps;
            if (reports.size() > 0) {
                String userID = EASUtil.getCurrentUserID(ctx);
                String orgID = EASUtil.getCurrentOrgID(ctx);
                String[] reportIDs = new String[reports.size()];
                int size2 = reports.size();
                for (int i = 0; i < size2; ++i) {
                    ReportGroupItem rg = (ReportGroupItem)reports.get(i);
                    reportIDs[i] = rg.getId();
                }
                String identityID = locationType == FolderType.PERSONAL_FOLDER ? userID : orgID;
                this._dao.deleteShortCutsByReportID(reportIDs, userID, locationPath, locationType);
                this._dao.deleteSnapshotsByReportID(reportIDs, identityID, locationPath, locationType);
            }
            if (fake.size() > 0) {
                String[] shortCutIDs = new String[fake.size()];
                int size3 = fake.size();
                for (int i = 0; i < size3; ++i) {
                    ps = (PhantomSnapshot)fake.get(i);
                    shortCutIDs[i] = ps.getId();
                }
                this._dao.deleteShortcuts(shortCutIDs);
            }
            if (real.size() > 0) {
                String[] snapshotIDs = new String[real.size()];
                int size4 = real.size();
                for (int i = 0; i < size4; ++i) {
                    ps = (PhantomSnapshot)real.get(i);
                    snapshotIDs[i] = ps.getId();
                }
                this._dao.deleteSnapshots(snapshotIDs);
            }
        }
        catch (SnapshotException e) {
            rp.setObject(EXCEPTION_KEY, (Object)e);
        }
        return rp;
    }

    @Override
    public void delPhantomSnapshot(List snapshots, List reportIDs, String locationPath, int locationType) throws SnapshotException {
        RptParams params = new RptParams();
        params.setString("FullName", this.getClass().getName());
        params.setString("MethodName", "_delPhantomSnapshot");
        params.setObject(ENTITY_KEY, (Object)snapshots);
        params.setObject(REPORT_KEY, (Object)reportIDs);
        params.setString("LOCATION_PATH", locationPath);
        params.setInt("LOCATION_TYPE", locationType);
        try {
            RptParams rp = FacadeFactory.commonExecuteRequired(this.getContext(), params);
            SnapshotException ex = (SnapshotException)rp.getObject(EXCEPTION_KEY);
            if (ex != null) {
                throw ex;
            }
        }
        catch (BOSException e) {
            throw SnapshotException.wrap((Exception)((Object)e));
        }
    }

    @Override
    public List getPhantomSnapshotNotLimited(String userID, String reportID, String branch) throws SnapshotException {
        return this._dao.getPhantomSnapshotNotLimited(userID, reportID, branch);
    }

    @Override
    public List getSnapshotsNotLimited(String orgID, String reportID, String branch) throws SnapshotException {
        return this._dao.getSnapshotsNotLimited(orgID, reportID, branch);
    }

    @Override
    public List getSumReportSnapshotsNotLimited(String orgID, String reportID) throws SnapshotException {
        return this._dao.getSumReportSnapshotsNotLimited(orgID, reportID);
    }

    @Override
    public Map getUserPhantomsIDAndNames(SumPropsModel model, String reportID, String snapName, String creatorID, String orgID, String otherDataCenter) throws SnapshotException {
        return null;
    }

    @Override
    public Map getUserPhantomsIdAndNames(SumPropsModel model, String reportID, String snapName, String otherDataCenter) throws SnapshotException {
        StringBuffer filterBuf = new StringBuffer();
        filterBuf.append(" freportid = '").append(reportID);
        if (!StringUtil.isEmptyString((String)snapName)) {
            filterBuf.append("' And Fname like '%").append(snapName).append("%");
        }
        filterBuf.append("' AND FreportPeriod = ").append(model.getReportPeriod());
        if (model.getReportPeriod() != -1) {
            filterBuf.append(" AND ");
            filterBuf.append(" FbeginDate = {ts'").append(MixUtil.getDateFromTimestamp(model.getBeginDate())).append("'} AND ");
            filterBuf.append(" FendDate = {ts'").append(MixUtil.getDateFromTimestamp(model.getEndDate())).append("'} ");
            if (model.getReportPeriod() == 7) {
                filterBuf.append(" AND FweekBegin =").append(model.getWeekBegin());
            }
        }
        HashMap id2Names = new HashMap();
        String userID = EASUtil.getCurrentUserID(this.getContext());
        Map map = this._dao.getUserSnapshotIDAndName(filterBuf.toString(), otherDataCenter);
        id2Names.putAll(map);
        StringBuffer wSQL = new StringBuffer();
        wSQL.append(" Faddressee = '").append(userID).append("' AND ");
        wSQL.append(filterBuf.toString());
        Map map2 = this._dao.getUserMailsIDAndName(wSQL.toString(), otherDataCenter);
        id2Names.putAll(map2);
        wSQL = new StringBuffer();
        wSQL.append(" FUserID = '").append(userID).append("' AND ");
        wSQL.append(filterBuf.toString());
        map2 = this._dao.getUserPhantomIDAndName(wSQL.toString(), otherDataCenter);
        id2Names.putAll(map2);
        return id2Names;
    }

    @Override
    public Map getUserPhantomsID2Data(String[] ids, String otherDataCenter) throws SnapshotException {
        return this._dao.getUserPhantomsIDAndData(ids, otherDataCenter);
    }

    @Override
    public Set getCommonTreeFilterSetBySnapshot(String orgID) throws SnapshotException {
        String[] paths = this._dao.getCommonTreeFilterSetBySnapshot(orgID);
        HashSet<String> set = new HashSet<String>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            if (StringUtil.isEmptyString((String)paths[i]) || paths[i].equals("root")) continue;
            set.add(paths[i]);
        }
        set.add("com.kingdee.eas.eas");
        return set;
    }

    @Override
    public List getPhantomSnapshotNotLimited(String userID, String branch) throws SnapshotException {
        return this._dao.getPhantomSnapshotNotLimited(userID, branch, (SnapshotQueryModel)null);
    }

    @Override
    public List getSnapshotsNotLimited(String orgID, String branch) throws SnapshotException {
        return this._dao.getSnapshotsNotLimited(orgID, branch, (SnapshotQueryModel)null);
    }

    @Override
    public List queryPhantomSnapshots(SnapshotQueryModel queryModel, String branch, int folderType) throws SnapshotException {
        List snaps;
        String userID = EASUtil.getCurrentUserID(this.getContext());
        String orgID = EASUtil.getCurrentOrgID(this.getContext());
        if (queryModel.getDirRange() == 0) {
            if (folderType == FolderType.PERSONAL_FOLDER) {
                return this._dao.getPhantomSnapshotNotLimited(userID, branch, queryModel);
            }
            if (folderType == FolderType.COMMON_FOLDER) {
                return this._dao.getSnapshotsNotLimited(orgID, branch, queryModel);
            }
            return null;
        }
        ArrayList lst = new ArrayList();
        List phantoms = this._dao.getPhantomSnapshotNotLimited(userID, null, queryModel);
        if (phantoms != null) {
            lst.addAll(phantoms);
        }
        if ((snaps = this._dao.getSnapshotsNotLimited(orgID, null, queryModel)) != null) {
            lst.addAll(snaps);
        }
        return lst;
    }

    @Override
    public Set queryPermDeploySysIds(String orgID) throws SnapshotException {
        String[] paths = this._dao.queryPermDeploySysIds(orgID, false);
        HashSet<String> set = new HashSet<String>(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            if (StringUtil.isEmptyString((String)paths[i]) || paths[i].equals("root")) continue;
            set.add(paths[i]);
        }
        set.add("com.kingdee.eas.eas");
        return set;
    }

    private Context getContext() {
        if (this._ctx != null) {
            return this._ctx;
        }
        return ServerUtil.getContext();
    }
}

