/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.snapshot.manage.util;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.rpts.ctrlreport.data.ReportSnapType;
import com.kingdee.eas.rpts.sumreport.util.MixUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class SumPeriodUtil {
    private static SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd");

    public static String revertToString(Date from, Date to, int weekBegin, ReportSnapType type) {
        if (type == ReportSnapType.EMPTY) {
            return "";
        }
        StringBuffer dateString = new StringBuffer();
        Calendar calFrom = Calendar.getInstance();
        calFrom.setTime(from);
        Calendar calTo = Calendar.getInstance();
        calTo.setTime(to);
        dateString.append(SumPeriodUtil.revert(calFrom, type, calTo));
        String beautiful = dateString.toString();
        if (StringUtil.isEmptyString((String)beautiful)) {
            StringBuffer buf = new StringBuffer();
            buf.append(DF.format(from));
            buf.append('~');
            buf.append(DF.format(to));
            beautiful = buf.toString();
        }
        return beautiful;
    }

    public static String revert(Calendar calFrom, ReportSnapType type, Calendar calTo) {
        StringBuffer dateString = new StringBuffer();
        int year = calFrom.get(1);
        int month = calFrom.get(2) + 1;
        int day = calFrom.get(5);
        if (type == ReportSnapType.UNKNOW) {
            return "";
        }
        if (type == ReportSnapType.YEAR) {
            dateString.append(year).append("\u5e74");
        } else if (type == ReportSnapType.MONTH) {
            dateString.append(year).append("\u5e74").append(month).append("\u6708");
        } else if (type == ReportSnapType.QUARTER) {
            dateString.append(year).append("\u5e74");
            SumPeriodUtil.revertQuarter(dateString, calFrom);
        } else if (type == ReportSnapType.MONTHHALF) {
            boolean halfMonth;
            String start = MixUtil.formatDate(calFrom.getTime());
            String yearStr = start.substring(0, 4);
            dateString.append(yearStr).append("\u5e74");
            month = Integer.parseInt(start.substring(5, 7));
            dateString.append(month).append("\u6708");
            boolean bl = halfMonth = !"01".equals(start.substring(8));
            if (!halfMonth) {
                dateString.append("\u4e0a\u534a\u6708");
            } else if (halfMonth) {
                dateString.append("\u4e0b\u534a\u6708");
            }
        } else if (type == ReportSnapType.WEEK) {
            dateString.append(year).append("\u5e74");
            calFrom.set(7, 1);
            int weekth = calFrom.get(4);
            if (weekth < 5) {
                String start = MixUtil.formatDate(calFrom.getTime());
                month = Integer.parseInt(start.substring(5, 7));
                dateString.append(month).append("\u6708");
                dateString.append("\u7b2c").append(weekth).append("\u4e2a\u661f\u671f");
            } else {
                String end = DF.format(calTo.getTime());
                int newMonth = Integer.parseInt(end.substring(5, 7));
                dateString.append(newMonth).append("\u6708");
                dateString.append("\u7b2c").append(weekth - 4).append("\u4e2a\u661f\u671f");
            }
        } else if (type == ReportSnapType.DAY) {
            dateString.append(year).append("\u5e74");
            dateString.append(month).append("\u6708");
            dateString.append(day).append("\u65e5");
        } else if (type == ReportSnapType.YEARHALF) {
            boolean halfYear;
            dateString.append(year).append("\u5e74");
            String start = MixUtil.formatDate(calFrom.getTime());
            boolean bl = halfYear = !"01".equals(start.substring(5, 7));
            if (!halfYear) {
                dateString.append("\u4e0a\u534a\u5e74");
            } else if (halfYear) {
                dateString.append("\u4e0b\u534a\u5e74");
            }
        }
        return dateString.toString();
    }

    private static void revertQuarter(StringBuffer dateString, Calendar cal) {
        String start = MixUtil.formatDate(cal.getTime());
        int idx = (Integer.parseInt(start.substring(5, 7)) - 1) / 3;
        dateString.append(idx + 1).append("\u5b63\u5ea6");
    }
}

