/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.statistics;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.bo.ExtReportOutDBBO;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.statistics.dynamic.IExtStatisticsRunner;
import com.kingdee.eas.rpts.statistics.exception.SalmonBizException;
import com.kingdee.eas.rpts.statistics.info.EnterpriseInfo;
import com.kingdee.eas.rpts.statistics.info.StatisticsInfoPacket;
import com.kingdee.eas.rpts.statistics.util.ServiceUtil;
import com.kingdee.eas.rpts.statistics.util.XMLUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jdom2.Content;
import org.jdom2.Element;

class ZipFileCreator {
    private Context easCtx;
    private IExtStatisticsRunner statisticsRunner;
    private EnterpriseInfo info;

    ZipFileCreator(Context easCtx, IExtStatisticsRunner statisticsRunner, EnterpriseInfo info) {
        this.easCtx = easCtx;
        this.statisticsRunner = statisticsRunner;
        this.info = info;
    }

    /*
     * Loose catch block
     */
    void createFile() throws SalmonBizException {
        int length;
        FileOutputStream out;
        FileInputStream in;
        String filePath;
        block19: {
            boolean fileExists;
            String tcpUrl;
            String status;
            IRowSet rowset;
            try {
                rowset = DbUtil.executeQuery((Context)this.easCtx, (String)"SELECT FFILEPATH,FSTATUS,FCLUSTERNODENAME FROM T_EXT_UPLOADCLIENT");
            }
            catch (BOSException e) {
                throw new SalmonBizException("[BOSException]failed to query uploadclient status.", e);
            }
            try {
                if (!rowset.next()) {
                    throw new SalmonBizException("no client has been choosen.", null);
                }
                filePath = rowset.getString("FFILEPATH");
                status = rowset.getString("FSTATUS");
                tcpUrl = rowset.getString("FCLUSTERNODENAME");
            }
            catch (SQLException e) {
                throw new SalmonBizException("[SQLException]failed to query uploadclient status.", e);
            }
            boolean lastFinished = StringUtil.equals((String)status, (String)"FINISHED");
            boolean bl = fileExists = filePath != null;
            if (fileExists) {
                fileExists = ServiceUtil.ClusterUtil.isClusterFileExists(this.easCtx, tcpUrl, filePath);
            }
            if (!lastFinished && fileExists) {
                return;
            }
            try {
                DbUtil.execute((Context)this.easCtx, (String)"UPDATE T_EXT_UPLOADCLIENT SET FSTATUS='CREATING'");
            }
            catch (BOSException e) {
                throw new SalmonBizException("[BOSException]failed to lock uploadclient status.", e);
            }
            in = null;
            out = null;
            File tmpPackageFile = File.createTempFile("ext-salmon-data", ".data");
            out = new FileOutputStream(tmpPackageFile);
            this.fillOutputStream(this.easCtx, out);
            in = new FileInputStream(tmpPackageFile);
            filePath = tmpPackageFile.getAbsolutePath();
            length = in.available();
            try {
                DbUtil.execute((Context)this.easCtx, (String)"UPDATE T_EXT_UPLOADCLIENT SET FSTATUS='ERROR'");
                break block19;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            break block19;
            catch (IOException e) {
                try {
                    throw new SalmonBizException("[IOException]failed to access server filesystem.", e);
                }
                catch (Throwable throwable) {
                    try {
                        DbUtil.execute((Context)this.easCtx, (String)"UPDATE T_EXT_UPLOADCLIENT SET FSTATUS='ERROR'");
                    }
                    catch (BOSException e2) {
                        e2.printStackTrace();
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{out, in});
                    throw throwable;
                }
            }
        }
        CloseUtil.close((Closeable[])new Closeable[]{out, in});
        try {
            DbUtil.execute((Context)this.easCtx, (String)"UPDATE T_EXT_UPLOADCLIENT SET FCLUSTERNODENAME=?,FFILEPATH=?,FFILELENGTH=?,FLASTUPLOAD=?,FSTATUS=?", (Object[])new Object[]{ServiceUtil.ClusterUtil.getCurrentTcpUrl(), filePath, length, 0, null});
        }
        catch (BOSException e) {
            throw new SalmonBizException("[BOSException]failed to update uploadclient status.", e);
        }
    }

    private void fillOutputStream(Context easCtx, OutputStream out) throws SalmonBizException {
        ZipOutputStream zipOut = new ZipOutputStream(out);
        this.addEnterpriseInfo(zipOut);
        int i = 0;
        ArrayList<Object> rptUuids = new ArrayList<Object>();
        while (this.statisticsRunner.nextRptPackage(easCtx)) {
            StatisticsInfoPacket packet = this.statisticsRunner.get();
            rptUuids.add(packet.getRptUuid());
            packet.wrap(i++, zipOut);
        }
        this.addRptStatsInfo(rptUuids, easCtx, i, zipOut);
        try {
            zipOut.close();
        }
        catch (IOException e) {
            throw new SalmonBizException("[IOException]failed to close zipFile output stream.", e);
        }
    }

    private void addEnterpriseInfo(ZipOutputStream zipOut) throws SalmonBizException {
        Element enterpriseDes = this.enterpriseInfoDocument();
        try {
            zipOut.putNextEntry(new ZipEntry("info" + new Date().getTime() + ".xml"));
            XMLUtil.output(enterpriseDes, zipOut);
        }
        catch (IOException e) {
            throw new SalmonBizException("[IOException]failed to add enterprise description to zipFile output stream.", e);
        }
    }

    private void addRptStatsInfo(ArrayList<Object> rptUuids, Context easCtx, int i, ZipOutputStream zipOut) throws SalmonBizException {
        IRowSet rs;
        StringBuilder sb = new StringBuilder("SELECT FID FROM T_EXT_EXPORTEDRPT ");
        if (!rptUuids.isEmpty()) {
            sb.append("WHERE FID NOT IN(?");
            Iterator<Object> iter = rptUuids.iterator();
            iter.next();
            while (iter.hasNext()) {
                sb.append(",?");
                iter.next();
            }
            sb.append(")");
        }
        try {
            rs = DbUtil.executeQuery((Context)easCtx, (String)sb.toString(), (Object[])rptUuids.toArray(new Object[0]));
        }
        catch (BOSException e) {
            throw new SalmonBizException("[BOSException]failed to query rpt statsinfo.", e);
        }
        try {
            while (rs.next()) {
                Element stats;
                String rptUuid = rs.getString("FID");
                DefineReportInfo info = DefineReportBO.getReportInfo(easCtx, rptUuid);
                if (info == null || (stats = this.statisticsRunner.nextRptUsageStatus(easCtx, rptUuid)) == null) continue;
                StatisticsInfoPacket statPackage = new StatisticsInfoPacket();
                statPackage.setRptName(info.getName());
                statPackage.setRptUuid(info.getId().toString());
                statPackage.setSystemId(info.getSystemID());
                statPackage.setTemplateType(String.valueOf(info.getTempletType()));
                statPackage.setTemplateVersion(String.valueOf(new Date().getTime()));
                statPackage.setRptUsageStatus(stats);
                statPackage.wrap(i++, zipOut);
            }
        }
        catch (BOSException e) {
            throw new SalmonBizException("[BOSException]failed to query rpt datainfo.", e);
        }
        catch (SQLException e) {
            throw new SalmonBizException("[SQLException]failed to query rpt statsinfo.", e);
        }
    }

    private Element enterpriseInfoDocument() {
        Element ele = this.buildCommonEnterpriseInfo();
        ele.addContent((Content)this.buildOutDbElement(this.easCtx));
        return ele;
    }

    private Element buildCommonEnterpriseInfo() {
        Element ele = new Element("enterprise");
        ele.addContent((Content)this.buildCommonElement("name", this.info.getName()));
        ele.addContent((Content)this.buildCommonElement("uuid", this.info.getUuid()));
        ele.addContent((Content)this.buildCommonElement("dbCode", this.info.getDbCode()));
        ele.addContent((Content)this.buildCommonElement("dbType", this.info.getDbType()));
        ele.addContent((Content)this.buildCommonElement("version", this.info.getVersion()));
        return ele;
    }

    private Element buildCommonElement(String name, String text) {
        Element element = new Element(name);
        element.setText(text);
        return element;
    }

    private Element buildOutDbElement(Context easCtx) {
        Element outDbs = new Element("outDbList");
        try {
            for (HashMap map : ExtReportOutDBBO.getDBList(easCtx)) {
                Element outDb = new Element("outDb");
                outDb.setAttribute("name", CtrlReportUtil.getObjectString(map.get("fdbcentername")));
                outDb.setAttribute("type", CtrlReportUtil.getObjectString(map.get("fdbtype")));
                outDbs.addContent((Content)outDb);
            }
        }
        catch (BOSException e) {
            Element fail = new Element("failMessage");
            fail.setText(e.getMessage());
            outDbs.addContent((Content)fail);
        }
        return outDbs;
    }
}

