/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.tobi;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReport;
import com.kingdee.bos.ctrl.analysis.web.pagesetup.PageSetup;
import com.kingdee.bos.ctrl.analysis.web.pagesetup.PageSetupUtil;
import com.kingdee.bos.ctrl.analysis.web.print.model.SetupModel;
import com.kingdee.bos.ctrl.analysis.web.print.model.ZoomScaleModel;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterImpl;
import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.fulfil.ExportUtil;
import com.kingdee.bos.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.bos.ctrl.ext.immit.ShowcaseConfig;
import com.kingdee.bos.ctrl.ext.util.ShowcaseUtil;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.io.htm.HtmlExporter;
import com.kingdee.bos.ctrl.kds.io.htm.KdsToHtmlExporter;
import com.kingdee.bos.ctrl.kds.io.htm.explorer.AbstractHyperLinkHelper;
import com.kingdee.bos.ctrl.kds.io.htm.explorer.PageContext;
import com.kingdee.bos.ctrl.kds.io.htm.explorer.event.WebMouseEvent;
import com.kingdee.bos.ctrl.kds.io.kds.BookToKDSBook;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.Chart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartModel;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.bos.ctrl.kds.nio.BookDataWrapper;
import com.kingdee.bos.ctrl.kds.print.MultiPrintJobProvider;
import com.kingdee.bos.ctrl.kds.print.PrintManager;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.config.PrintJobConfig;
import com.kingdee.bos.ctrl.print.config.attribute.FreeMediaSize;
import com.kingdee.bos.ctrl.print.config.attribute.MediaSizeNameExtend;
import com.kingdee.bos.ctrl.print.config.attribute.PageIntervalInfo;
import com.kingdee.bos.ctrl.print.config.attribute.ZoomScaleInfo;
import com.kingdee.bos.ctrl.print.control.PaperInfo;
import com.kingdee.bos.ctrl.print.io.PdfExport;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import com.kingdee.eas.rpts.cloud.service.CloudRptCenterControllerFacade;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.audittool.ReportAuditUtil;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.rpts.ctrlreport.data.PermissionKind;
import com.kingdee.eas.rpts.ctrlreport.model.CheckJavaDataSet;
import com.kingdee.eas.rpts.ctrlreport.model.CheckJavaDataSetException;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.tobi.FilterXmlTrans;
import com.kingdee.eas.rpts.tobi.HyperLinkHelper;
import com.kingdee.eas.rpts.tobi.domain.WebReportDomain;
import com.kingdee.eas.rpts.web.man.ReportImpl;
import com.kingdee.eas.rpts.web.param.CreateReport;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ExtReportImpl
implements ExtReport {
    private static Logger logger = CommonLogger.getLogger(ExtReportImpl.class);
    private static float DPI_MM = KDToolkit.getCurrentDpi() * 10 / 72;
    private String reportPath;
    private String repositoryPath;
    private Document filterDocument;
    private PagingContext pagingContext;
    private PageContext pageContext;
    private Sheet _sheet;
    private HtmlExporter treeHtmlExporter;
    private KdsToHtmlExporter htmlExporter;
    private String FilePath = "?servletType=GetChart&filename=";
    private String webContextPath = "/easportal/BIReport";
    private String reportId = null;
    private String reportName;
    private String systemId;
    private String domain;
    private WebParamAdapter _adapter;
    private int _pageCount = 50;
    private int _screenCount = 15;
    private boolean _hasScreenCount = false;
    private boolean _isTree = false;
    private Map _parameterMap;
    private WebReportDomain webReportDomain;
    private ReportImpl report;
    private boolean isHyperlink;
    BIReportFilter filter = null;
    private final Object xslLock = new Object();
    private final Object pdfLock = new Object();
    private final Object xlsxLock = new Object();

    public ExtReportImpl(String reportPath, String repositoryPath) {
        this.reportPath = reportPath;
        this.repositoryPath = repositoryPath;
        this.pageContext = new PageContext();
        this.pagingContext = new PagingContext();
        this.report = new ReportImpl(this.reportPath);
        this.webReportDomain = new WebReportDomain();
    }

    public ExtReportImpl(String reportPath, String repositoryPath, String reportName, String systemId, String domain) {
        this.reportPath = reportPath;
        this.repositoryPath = repositoryPath;
        this.reportName = reportName;
        this.systemId = systemId;
        this.domain = domain;
        this.pageContext = new PageContext();
        this.pagingContext = new PagingContext();
        this.report = new ReportImpl(this.reportPath);
        this.webReportDomain = new WebReportDomain();
    }

    public ExtReportImpl(String reportPath, String repositoryPath, String reportName, String systemId) {
        this(reportPath, repositoryPath, reportName, systemId, null);
    }

    public WebParamAdapter getAdapter(com.kingdee.bos.Context ctx, String reportID) {
        if (this._adapter == null) {
            this._adapter = new WebParamAdapter(ctx, reportID);
        }
        return this._adapter;
    }

    public WebParamAdapter getAdapter(com.kingdee.bos.Context ctx, String reportID, boolean isCheckLisence) {
        if (this._adapter == null) {
            this._adapter = new WebParamAdapter(ctx, reportID, isCheckLisence);
        }
        return this._adapter;
    }

    public WebParamAdapter getAdapter(com.kingdee.bos.Context ctx, String reportName, String systemID, String orgID) {
        if (this._adapter == null) {
            this._adapter = new WebParamAdapter(ctx, reportName, systemID, orgID);
        }
        return this._adapter;
    }

    public WebParamAdapter getAdapter(com.kingdee.bos.Context ctx, String reportName, String systemID, String orgID, String reportId) {
        if (this._adapter == null) {
            this._adapter = new WebParamAdapter(ctx, reportName, systemID, orgID, reportId);
        }
        return this._adapter;
    }

    public String execute(Object[] filterValue, Object[] filterCaption, HttpServletRequest request) throws BIReportException {
        String returnStr;
        long start = System.currentTimeMillis();
        HashMap<String, String> mapValue = new HashMap<String, String>();
        HashMap<String, String> mapAlias = new HashMap<String, String>();
        this.webContextPath = request.getRequestURL().toString();
        if (this._parameterMap == null && null != filterValue && filterValue.length > 0) {
            Element root = this.filterDocument.getDocumentElement();
            NodeList children = root.getChildNodes();
            for (int i = 0; i < filterValue.length; ++i) {
                Element element = (Element)children.item(i);
                Object obj = filterValue[i];
                if (null == obj) continue;
                List lstValue = (List)filterValue[i];
                List lstAlias = (List)filterCaption[i];
                if (lstValue.isEmpty()) continue;
                String defaultValue = element.getAttribute("defaultValue");
                String defaultAlias = element.getAttribute("defaultCaption");
                int size = lstValue.size();
                String value = "";
                String alias = "";
                for (int n = 0; n < size; ++n) {
                    String valueTmp = CtrlReportUtil.getObjectString(lstValue.get(n));
                    String aliasTmp = defaultAlias;
                    aliasTmp = valueTmp.equals(defaultValue) ? defaultAlias : CtrlReportUtil.getObjectString(lstAlias == null ? null : lstAlias.get(n));
                    value = value + valueTmp + "0xx1xx";
                    alias = alias + aliasTmp + "0xx1xx";
                }
                if (!value.equals("")) {
                    value = value.substring(0, value.length() - "0xx1xx".length());
                    alias = alias.substring(0, alias.length() - "0xx1xx".length());
                }
                String paramName = element.getAttribute("name");
                mapValue.put(paramName, value);
                mapAlias.put(paramName, alias);
            }
        }
        com.kingdee.bos.Context ctx = BISystem.getContext((HttpServletRequest)request);
        ctx.put((Object)"com.kingdee.bos.ctrl.analysis.web.ajax.ExtWebReportHandler.IS_BI_REQUEST", (Object)true);
        WebParamAdapter adapter = null;
        if (this.repositoryPath != null || this._parameterMap != null) {
            this.reportId = this.reportPath;
            adapter = this.reportName != null && this.systemId != null ? this.getAdapter(ctx, this.reportName, this.systemId, this.domain, this.reportPath) : this.getAdapter(ctx, this.reportPath);
        } else if (this.reportId != null) {
            adapter = this.getAdapter(ctx, this.reportId);
        } else {
            String[] list = this.reportPath.split("\u0001");
            adapter = this.getAdapter(ctx, list[0], list[1], request.getParameter("ExtRptsOrgID"));
        }
        adapter.setHyperlink(this.isHyperlink);
        adapter.setTree(this._isTree);
        try {
            if (!CheckJavaDataSet.checkUIType(ctx, this.reportId, this.reportName, this.systemId, this.domain)) {
                throw new CheckJavaDataSetException("\u62a5\u8868\u4e2d\u7684JAVA\u6570\u636e\u96c6\u4f7f\u7528\u4e86\u4ee3\u7801\u7f16\u5199\u7684\u53c2\u6570\u754c\u9762\uff0c\u4e0d\u80fd\u6267\u884c\u3002");
            }
        }
        catch (CheckJavaDataSetException e) {
            logger.error((Object)"\u6267\u884c\u6269\u5c55\u62a5\u8868\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            throw new BIReportException("\u6267\u884c\u6269\u5c55\u62a5\u8868\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        try {
            if (this._parameterMap == null) {
                adapter.execute(mapValue, mapAlias);
            } else {
                adapter.execute(this._parameterMap);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"\u6267\u884c\u6269\u5c55\u62a5\u8868\u67e5\u8be2\u5931\u8d25", (Throwable)ex);
            throw new BIReportException("\u6267\u884c\u6269\u5c55\u62a5\u8868\u67e5\u8be2\u5931\u8d25:" + ex.getMessage(), (Throwable)ex);
        }
        this._isTree = adapter.isTree();
        Book book = adapter.getBook();
        if (book.getSheetCount() > 1) {
            logger.error((Object)"BI\u6682\u4e0d\u652f\u6301\u591a\u9875\u7b7e\u62a5\u8868\uff01");
            throw new BIReportException("BI\u6682\u4e0d\u652f\u6301\u591a\u9875\u7b7e\u62a5\u8868\uff01", null);
        }
        for (int sh = book.getSheetCount() - 1; sh >= 0; --sh) {
            EmbedhLayer layer = book.getSheet(sh).getEmbedments(false);
            if (null == layer) continue;
            int size = layer.size();
            for (int i = 0; i < size; ++i) {
                EmbedObject eo = layer.getEmbed(i);
                if (!(eo instanceof Chart)) continue;
                ChartModel model = ((Chart)eo).getModel();
                ChartDataNode node = model.getDataNode();
                node.setDirty(true);
                node.getData();
                node.setNeedRecalc(false);
                node.setDirty(false);
                model.refreshChartData(model.getChartType());
            }
        }
        this._sheet = adapter.getPartSheet(0, 0);
        if (this._isTree) {
            Sheet curSheet = this._sheet;
            String pageId = request.getParameter("pageId");
            HyperLinkHelper hyperHelper = new HyperLinkHelper(ctx);
            this.treeHtmlExporter = new HtmlExporter(curSheet, this.pageContext, this._pageCount, pageId, (AbstractHyperLinkHelper)hyperHelper);
            this.pageContext = this.treeHtmlExporter.getPagingContext();
            this.treeHtmlExporter.setFileSavePath(System.getProperty("java.io.tmpdir"));
            this.treeHtmlExporter.setFilePrefixPath(this.getFilePath(""));
            returnStr = this.treeHtmlExporter.exportDiv();
            this._adapter = adapter;
        } else {
            this.pagingContext.initPageContext(this._sheet, adapter);
            this.report.setBook(book);
            this.report.setCurrentSheetName(this._sheet.getSheetName());
            CreateReport json = new CreateReport();
            returnStr = "";
        }
        long execTime = System.currentTimeMillis() - start;
        DefineReportInfo info = null;
        try {
            info = DefineReportBO.getReportInfo(ctx, this.reportId);
            if (ReportAuditUtil.isDeployReport(info)) {
                int pathType = 0;
                pathType = this._parameterMap != null ? 8 : (this.repositoryPath != null ? 2 : 3);
                ReportAuditUtil.updateAuditTable(ctx, info, execTime, pathType);
            }
        }
        catch (BOSException e) {
            logger.info((Object)("\u66f4\u65b0\u62a5\u8868(" + info != null ? info.getName() : this.reportId + ")\u7edf\u8ba1\u7ed3\u679c\u5931\u8d25\uff01"), (Throwable)e);
        }
        return returnStr;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public BIReportFilter getFilter(HttpServletRequest request) throws BIReportException {
        if (this._parameterMap != null) {
            return null;
        }
        if (null != this.filter) {
            return this.filter;
        }
        com.kingdee.bos.Context ctx = BISystem.getContext((HttpServletRequest)request);
        ctx.put((Object)"com.kingdee.bos.ctrl.analysis.web.ajax.ExtWebReportHandler.IS_BI_REQUEST", (Object)true);
        WebParamAdapter adapter = null;
        if (request.getParameter("ExtRptsSystemID") == null) {
            adapter = this.systemId != null ? this.getAdapter(ctx, this.reportName, this.systemId, this.domain, this.reportPath) : this.getAdapter(ctx, this.reportPath);
        } else {
            String[] list = this.reportPath.split("\u0001");
            adapter = this.getAdapter(ctx, list[0], list[1], request.getParameter("ExtRptsOrgID"));
        }
        adapter.setHyperlink(this.isHyperlink);
        String selectType = request.getParameter("selectType");
        String isDshExtReort = request.getParameter("isDshExtReport");
        String orgFullName = request.getParameter("orgFullName");
        if (!StringUtil.isEmptyString((String)isDshExtReort)) {
            try {
                adapter.setDshExtReport(Boolean.parseBoolean(isDshExtReort));
                adapter.setOrgFullName(orgFullName);
            }
            catch (Exception e) {
                adapter.setDshExtReport(false);
            }
        }
        if (!StringUtil.isEmptyString((String)selectType)) {
            adapter.setDshExtReportSelectType(selectType);
        }
        Element rootXML = null;
        String outParam = request.getParameter("extOutParam");
        Map mapOutParam = adapter.parseOutParam(outParam);
        try {
            Map parameters;
            String filter_xml = FilterXmlTrans.translate(adapter.getReportParamXmlString(true, mapOutParam));
            this.reportId = adapter.getReportID();
            ArrayList allUnionParam = adapter.getAllUnionParam();
            this.report.setAllUnionParam(allUnionParam);
            UserObject uo = adapter.getBook().getUserObject("ROW_COUNT_OF_WEB_REPORT");
            if (uo != null) {
                this._pageCount = Integer.parseInt((String)uo.getValue());
                if (!this._isTree) {
                    this.pagingContext.pageRowCount = this._pageCount;
                } else {
                    this.pageContext.setRowSum(this._pageCount);
                }
            }
            if ((uo = this._adapter.getBook().getUserObject("ROW_COUNT_OF_PAGE_REPORT")) != null) {
                this._screenCount = Integer.parseInt((String)uo.getValue());
                if (!this._isTree) {
                    this.pagingContext.screenCount = this._screenCount;
                } else {
                    this.pageContext.setScreenRowCount(this._screenCount);
                }
            }
            if ((uo = this._adapter.getBook().getUserObject("HAS_ROW_COUNT_OF_PAGE")) != null) {
                this._hasScreenCount = "true".equals((String)uo.getValue());
                if (!this._isTree) {
                    this.pagingContext.hasScreenCount = this._hasScreenCount;
                } else {
                    this.pageContext.setScreenCountEnable(this._hasScreenCount);
                }
            }
            if (filter_xml == null) {
                return null;
            }
            String newXml = filter_xml.replaceAll("\n", "").replaceAll("\r", "").replaceAll("\t", "");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document doc = builder.parse(new InputSource(new StringReader(newXml)));
            if (request.getParameter("ExtRptsSystemID") != null && (parameters = request.getParameterMap()) != null) {
                NodeList nodelist = doc.getElementsByTagName("FilterItem");
                int size = nodelist.getLength();
                for (int i = 0; i < size; ++i) {
                    Node item = nodelist.item(i);
                    Node name = item.getAttributes().getNamedItem("name");
                    String nodeName = name.getNodeValue();
                    if (!parameters.containsKey(nodeName)) continue;
                    item.getAttributes().getNamedItem("defaultValue").setNodeValue(request.getParameter(nodeName));
                }
            }
            rootXML = doc.getDocumentElement();
            this.filterDocument = doc;
        }
        catch (Exception e) {
            logger.error((Object)("\u8fd4\u56de\u5171\u4eab\u7684WEB\u8fc7\u6ee4\u754c\u9762XML\u5b57\u7b26\u4e32\u5931\u8d25Exception:" + e.getMessage()), (Throwable)e);
            throw new BIReportException(e.getMessage(), (Throwable)e);
        }
        this.filter = new BIReportFilterImpl((Node)rootXML);
        return this.filter;
    }

    public boolean hasFilter(HttpServletRequest request) throws BIReportException {
        String paramCacheId = request.getParameter("paramCacheId");
        if (this._parameterMap != null) {
            return false;
        }
        try {
            this.filter = this.getFilter(request);
            return this.filter.getItemCount() > 0;
        }
        catch (Exception e) {
            logger.error((Object)("\u8fd4\u56de\u5171\u4eab\u7684WEB\u8fc7\u6ee4\u754c\u9762XML\u5b57\u7b26\u4e32\u5931\u8d25:" + e.getMessage()), (Throwable)e);
            throw new BIReportException(e.getMessage(), (Throwable)e);
        }
    }

    public String getFilterF7(int itemIndex, Map mapParams, HttpServletRequest request) throws BIReportException {
        String f7FilterData = null;
        Element element = null;
        if (this.filterDocument != null) {
            element = (Element)this.filterDocument.getDocumentElement().getChildNodes().item(itemIndex);
        }
        if (element != null && element.getAttribute("type").equalsIgnoreCase("sql")) {
            String errMsg = element.getAttribute("errMsg");
            if (errMsg != null && !"null".equals(errMsg) && errMsg.length() > 0) {
                throw new BIReportException(errMsg);
            }
            String fullName = element.getAttribute("fullname");
            String displayColumn = element.getAttribute("displayColumn");
            String valueColumn = element.getAttribute("valueColumn");
            try {
                f7FilterData = this._adapter.getF7Data(fullName, displayColumn, valueColumn);
            }
            catch (Exception e) {
                logger.error((Object)"get f7 data error", (Throwable)e);
                String emsg = CtrlReportUtil.getObjectString(e.getMessage());
                emsg = emsg.replaceAll("\n", "<br>");
                throw new BIReportException("\u83b7\u53d6F7\u6570\u636e\u5931\u8d25 :" + emsg, (Throwable)e);
            }
        }
        Document tmpDoc = null;
        try {
            if (null != f7FilterData) {
                String newXml = f7FilterData.replaceAll("\n", "").replaceAll("\r", "").replaceAll("\t", "");
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                tmpDoc = builder.parse(new InputSource(new StringReader(newXml)));
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u89e3\u6790F7\u6570\u636eXML\u5931\u8d25", (Throwable)e);
            throw new BIReportException("\u89e3\u6790F7\u6570\u636eXML\u5931\u8d25", (Throwable)e);
        }
        StringBuffer result = new StringBuffer("");
        if (tmpDoc != null) {
            Element root = tmpDoc.getDocumentElement();
            NodeList children = root.getChildNodes();
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                Element e = (Element)children.item(i);
                result.append(e.getAttribute("caption"));
                result.append("\u0001");
                result.append(e.getAttribute("value"));
                result.append("\u0001");
            }
            if (children.getLength() > 0) {
                return result.substring(0, result.length() - 1);
            }
        }
        return result.toString();
    }

    public String getF7ValueCaption(int itemIndex, String value, HttpServletRequest request) throws BIReportException {
        String defaultCaption = this.filter.getItem(itemIndex).getDefaultCaption();
        if (StringUtil.isEmptyString((String)defaultCaption)) {
            return value;
        }
        return defaultCaption;
    }

    public void filterVerify(Object[] filterValue, HttpServletRequest request) throws BIReportException {
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getExportFile(Object lock, String suffix) {
        long randomId;
        Object object = lock;
        synchronized (object) {
            randomId = new Random().nextLong() & Integer.MAX_VALUE;
        }
        String reportName = this._adapter.getReportName();
        if (StringUtil.isEmptyString((String)reportName)) {
            reportName = "EXTREPORT";
        }
        return new File(new File(System.getProperty("java.io.tmpdir")), reportName + randomId + suffix);
    }

    public String exportToXsl(boolean isMergeExport) {
        long start = System.currentTimeMillis();
        Book book = this._adapter.getBook();
        if (this.treeHtmlExporter != null) {
            book = this.treeHtmlExporter.getPrintBook(book);
        }
        int sheetCount = book.getSheetCount();
        String[] sheetNames = new String[sheetCount];
        for (int sh = sheetCount - 1; sh >= 0; --sh) {
            sheetNames[sh] = book.getSheet(sh).getSheetName();
            Sheet sheet = book.getSheet(sh);
            boolean isSecurity = ExtGuiExecutor.isSecurityHidedRowsOrCols((Book)book);
            if (!isSecurity) continue;
            int[] hiddenRows = sheet.getSecHidedRows();
            int[] hiddenCols = sheet.getSecHidedCols();
            AlgorithmUtil.delHideRowsAndCols((int[])hiddenRows, (int[])hiddenCols, (Sheet)sheet);
        }
        KDSBook kdsbook = BookToKDSBook.traslate((Book)book, (String[])sheetNames);
        ExportUtil.removeHideSheet((Book)book, (KDSBook)kdsbook);
        ExportManager em = new ExportManager();
        String config = (String)book.getUserObjectValue("ShowcaseConfigTemplet");
        ShowcaseConfig caseConfig = ShowcaseUtil.toShowcaseConfig((String)config, (ShowcaseConfig)new ShowcaseConfig());
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"TRUE");
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"FALSE");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)String.valueOf(caseConfig.isShowFormula()));
        em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_MERGE_BLOCKS, (Object)String.valueOf(isMergeExport));
        File xslFile = this.getExportFile(this.xslLock, ".xls");
        em.exportToExcel(kdsbook, xslFile.getAbsolutePath());
        this.insertAuditExportDetail(start);
        return xslFile.getName();
    }

    private String exportToXlsx(boolean isMergeExport) throws BIReportException {
        long start = System.currentTimeMillis();
        Book book = this._adapter.getBook();
        if (this.treeHtmlExporter != null) {
            book = this.treeHtmlExporter.getPrintBook(book);
        }
        Book tempBook = book;
        boolean hasFlashChart = ExportUtil.hasFlashChart((Book)book);
        try {
            if (hasFlashChart) {
                tempBook = BookIOUtil.unpack((byte[])BookIOUtil.pack((Book)book));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        tempBook.setCalculate(false);
        try {
            if (hasFlashChart) {
                ExportUtil.setEmbedModel((Book)tempBook, (Book)book);
            }
            String config = (String)book.getUserObjectValue("ShowcaseConfigTemplet");
            ShowcaseConfig caseConfig = ShowcaseUtil.toShowcaseConfig((String)config, (ShowcaseConfig)new ShowcaseConfig());
            BookDataWrapper wrapper = new BookDataWrapper(tempBook);
            wrapper.setExportFormula(caseConfig.isShowFormula());
            wrapper.setExportHideCols(caseConfig.isHideEditable());
            wrapper.setExportHideRows(caseConfig.isHideEditable());
            wrapper.setExportMergeBlocks(isMergeExport);
            File xlsxFile = this.getExportFile(this.xlsxLock, ".xlsx");
            SXSSFExportWrapper exporter = new SXSSFExportWrapper((AbstractDataWrapper)wrapper);
            exporter.write(xlsxFile.getAbsolutePath());
            this.insertAuditExportDetail(start);
            return xlsxFile.getName();
        }
        catch (Exception ex) {
            logger.error((Object)"\u5bfc\u51faxlsx\u683c\u5f0f\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)ex);
            throw new BIReportException("\u5bfc\u51faxlsx\u683c\u5f0f\u6587\u4ef6\u5931\u8d25\uff01");
        }
    }

    private void insertAuditExportDetail(long start) {
        long execTime = System.currentTimeMillis() - start;
        DefineReportInfo info = null;
        try {
            info = DefineReportBO.getReportInfo(null, this.reportId);
            if (ReportAuditUtil.isDeployReport(info)) {
                int pathType = 0;
                pathType = this._parameterMap != null ? 8 : (this.repositoryPath != null ? 2 : 3);
                ReportAuditUtil.insertAuditExport(null, info, execTime, pathType);
            }
        }
        catch (BOSException e) {
            String temp = info != null ? info.getName() : this.reportId;
            logger.info((Object)("\u66f4\u65b0\u62a5\u8868(" + temp + ")\u7edf\u8ba1\u7ed3\u679c\u5931\u8d25\uff01"), (Throwable)e);
        }
    }

    public String getFilePath(String fileName) {
        return this.webContextPath + this.FilePath + fileName;
    }

    public String printToPDF(SetupModel setupModel) {
        Book book = this._adapter.getBook();
        File pdfFile = this.getExportFile(this.pdfLock, ".pdf");
        PdfExport pdf = new PdfExport();
        KDPrinter printer = null;
        PrintManager printManager = new PrintManager(new MultiPrintJobProvider(book));
        printer = printManager.printImageOnly() ? printManager.getImagePrinter().getPrinter() : printManager.getPrinter();
        PaperInfo paperInfo = new PaperInfo();
        printer.getPrintJob().setPaperInfo(paperInfo);
        printManager.reloadPrintJob();
        this.addAttributes(printer, setupModel);
        printer.getPrintJob().preparePagination();
        this.addPaperInfo(paperInfo, setupModel);
        List footerRow = setupModel.getListFooterRow();
        List headerRow = setupModel.getListHeaderRow();
        pdf.setPrintSetup(headerRow, footerRow);
        pdf.export(pdfFile.getAbsolutePath(), printer);
        return pdfFile.getName();
    }

    private void addAttributes(KDPrinter printer, SetupModel setupModel) {
        PrintJobConfig[] configs = printer.getPrintJob().getJobsConfigs();
        for (int m = 0; m < configs.length; ++m) {
            PrintJobConfig printJobConfig = configs[m];
            PrintRequestAttributeSet set = printJobConfig.getPrintRequestAttributeSet();
            Media me = (Media)set.get(Media.class);
            String paperSize = setupModel.getPaperSize();
            float paperWidth = setupModel.getPaperWidth();
            float paperHeight = setupModel.getPaperHeight();
            if (me != null && !me.toString().equalsIgnoreCase(paperSize)) {
                if (paperSize.equalsIgnoreCase("custom")) {
                    MediaSizeNameExtend media = MediaSizeNameExtend.CUSTOM;
                    MediaSize ms = MediaSize.getMediaSizeForName((MediaSizeName)media);
                    if (ms == null) {
                        new FreeMediaSize(paperWidth, paperHeight, 1000, (MediaSizeName)media);
                    } else if (ms instanceof FreeMediaSize) {
                        ((FreeMediaSize)ms).setXY(paperWidth, paperHeight, 1000);
                    }
                    printJobConfig.addAttribute((Attribute)media);
                } else {
                    MediaSizeName msn = KDPrinterUtils.getMediaSizeName((String)paperSize);
                    printJobConfig.addAttribute((Attribute)msn);
                }
            }
            if (setupModel.isLandscape()) {
                set.add(OrientationRequested.LANDSCAPE);
            }
            set.add((Attribute)new PageIntervalInfo(setupModel.getMarginTop(), setupModel.getMarginLeft(), setupModel.getMarginBottom(), setupModel.getMarginRight(), 1000));
            ZoomScaleModel scale = setupModel.getScaleModel();
            if (!scale.isAutoFit()) {
                float f = scale.getScale();
                if (f <= 0.0f) {
                    f = 100.0f;
                }
                set.add((Attribute)new ZoomScaleInfo((double)(f / 100.0f)));
                continue;
            }
            int w = scale.getAutoFitWidth();
            int h = scale.getAutoFitHeight();
            set.add((Attribute)new ZoomScaleInfo(w, h));
        }
    }

    private void addPaperInfo(PaperInfo paperInfo, SetupModel setupModel) {
        int paperWidth = (int)setupModel.getPaperWidth();
        int paperHeight = (int)setupModel.getPaperHeight();
        int x = (int)setupModel.getMarginLeft();
        int y = (int)setupModel.getMarginTop();
        int pageWidth = paperWidth - x - (int)setupModel.getMarginRight();
        int pageHeight = paperHeight - y - (int)setupModel.getMarginBottom();
        paperInfo.setPaperSize((int)StyleUtil.lomToPt((double)((float)paperWidth * DPI_MM)), (int)StyleUtil.lomToPt((double)((float)paperHeight * DPI_MM)));
        paperInfo.setPageBounds((int)StyleUtil.lomToPt((double)((float)x * DPI_MM)), (int)StyleUtil.lomToPt((double)((float)y * DPI_MM)), (int)StyleUtil.lomToPt((double)((float)pageWidth * DPI_MM)), (int)StyleUtil.lomToPt((double)((float)pageHeight * DPI_MM)));
    }

    public String exportToPdf(PageSetup pageSetup) {
        long start = System.currentTimeMillis();
        Book book = this._adapter.getBook();
        File pdfFile = this.getExportFile(this.pdfLock, ".pdf");
        PdfExport pdf = new PdfExport();
        KDPrinter printer = null;
        PrintManager printManager = new PrintManager(new MultiPrintJobProvider(book));
        printer = printManager.printImageOnly() ? printManager.getImagePrinter().getPrinter() : printManager.getPrinter();
        PaperInfo paperInfo = new PaperInfo();
        printer.getPrintJob().setPaperInfo(paperInfo);
        printManager.reloadPrintJob();
        this.setAttributes(printer, pageSetup);
        printer.getPrintJob().preparePagination();
        this.setPaperInfo(paperInfo, pageSetup);
        pdf.export(pdfFile.getAbsolutePath(), printer);
        this.insertAuditExportDetail(start);
        return pdfFile.getName();
    }

    private void setPaperInfo(PaperInfo paperInfo, PageSetup pageSetup) {
        int paperWidth = pageSetup.getPaperSizeWidth();
        int paperHeight = pageSetup.getPaperSizeHeight();
        int x = pageSetup.getPaperMaginLeft();
        int y = pageSetup.getPaperMaginTop();
        int pageWidth = paperWidth - x - pageSetup.getPaperMaginRight();
        int pageHeight = paperHeight - y - pageSetup.getPaperMaginBottom();
        paperInfo.setPaperSize((int)StyleUtil.lomToPt((double)((float)paperWidth * DPI_MM)), (int)StyleUtil.lomToPt((double)((float)paperHeight * DPI_MM)));
        paperInfo.setPageBounds((int)StyleUtil.lomToPt((double)((float)x * DPI_MM)), (int)StyleUtil.lomToPt((double)((float)y * DPI_MM)), (int)StyleUtil.lomToPt((double)((float)pageWidth * DPI_MM)), (int)StyleUtil.lomToPt((double)((float)pageHeight * DPI_MM)));
    }

    private void setAttributes(KDPrinter printer, PageSetup pageSetup) {
        PrintJobConfig[] configs = printer.getPrintJob().getJobsConfigs();
        PrintRequestAttributeSet set = configs[0].getPrintRequestAttributeSet();
        String[] names = PageSetupUtil.getAllPaperName();
        int l = names.length;
        for (int i = 0; i < l; ++i) {
            if (!names[i].equals(pageSetup.getPaperSize())) continue;
            set.add((Attribute)((Object)PageSetupUtil.getEnumValueTable()[i]));
            break;
        }
        if (pageSetup.getPaperOrientation()) {
            set.add(OrientationRequested.LANDSCAPE);
        }
        set.add((Attribute)new PageIntervalInfo((float)pageSetup.getPaperMaginTop(), (float)pageSetup.getPaperMaginLeft(), (float)pageSetup.getPaperMaginBottom(), (float)pageSetup.getPaperMaginRight(), 1000));
    }

    public int getCurPageNumber() throws BIReportException {
        if (this._isTree) {
            return this.pageContext.getPageIndex();
        }
        return this.pagingContext.getCurrentPage();
    }

    public int getPageTotal() throws BIReportException {
        if (this._isTree) {
            return this.pageContext.getPageCount();
        }
        return this.pagingContext.getPageCount();
    }

    public int getPerPageRows() throws BIReportException {
        if (this._isTree) {
            return this.pageContext.getRowSumPerPage();
        }
        return this.pagingContext.getPageRowCount();
    }

    public float getScreenHeight() throws BIReportException {
        if (this._isTree) {
            return this.pageContext.getScreenHeight();
        }
        return this.pagingContext.getScreenHeight();
    }

    public int getPerScreenRows() throws BIReportException {
        if (this._isTree) {
            return this.pageContext.getScreenCount();
        }
        return this.pagingContext.getPerScreenRows();
    }

    public boolean hasScreenCount() {
        if (this._isTree) {
            return this.pageContext.isScreenCountEnable();
        }
        return this.pagingContext.hasScreenCount();
    }

    public void setPerScreenRows(int perScreenRows) throws BIReportException {
        this._screenCount = perScreenRows;
        if (this._isTree) {
            this.pageContext.setScreenRowCount(perScreenRows);
        } else {
            this.pagingContext.setScreenRowCount(perScreenRows);
        }
    }

    private String refreshCurPage(Sheet _sheet) throws IOException {
        if (this._isTree) {
            if (this.treeHtmlExporter == null) {
                return null;
            }
            String result = this.treeHtmlExporter.exportDiv();
            return result;
        }
        if (this.htmlExporter == null) {
            return null;
        }
        if (_sheet != null) {
            this.htmlExporter.setSheet(_sheet);
        }
        this.htmlExporter.setRow1(this.pagingContext.currentRowStart);
        this.htmlExporter.setRow2(this.pagingContext.currentRowEnd);
        this.htmlExporter.setScreenHeight(this.pagingContext.getScreenHeight());
        this.htmlExporter.setScreenRow(this.pagingContext.hasScreenCount);
        if (this.pagingContext.pageCount == 1 && this.pagingContext.currentPage + 1 == this.pagingContext.pageCount) {
            this.htmlExporter.setEnforceShowGraph(true);
        }
        return this.htmlExporter.exportDiv();
    }

    public void setCurPageNumber(int pageNumber) throws BIReportException {
        if (this._isTree) {
            this.pageContext.setPageIndex(pageNumber);
        } else {
            this.pagingContext.goToPage(pageNumber);
        }
    }

    public int setPerPageRows(int perPageRows) throws BIReportException {
        if (this._isTree) {
            this.pageContext.setRowSum(perPageRows);
        } else {
            this.pagingContext.setPageRowCount(perPageRows);
            this.pagingContext.initPageContext(this._sheet, null);
        }
        return this.getCurPageNumber();
    }

    public int getTotalRows() throws BIReportException {
        return 0;
    }

    public String service(HttpServletRequest request, String action, Map params) throws BIReportException {
        if ("".equals(action != null ? action.trim() : "")) {
            return "";
        }
        String curAction = action.trim();
        if ("refresh".equals(curAction)) {
            try {
                String result = this.refreshCurPage(this.pagingContext.get_curSheet());
                return result;
            }
            catch (IOException e) {
                throw new BIReportException((Throwable)e);
            }
        }
        boolean originExportPermission = Boolean.parseBoolean(request.getParameter("OriginPermission"));
        if (!(this.authorizedExport(this.reportId, request) || this._adapter.isHyperlink() && originExportPermission || "printToPDF".equalsIgnoreCase(curAction))) {
            throw new BIReportException("\u6ca1\u6709\u5bfc\u51fa\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u5bfc\u51fa\u64cd\u4f5c\uff01");
        }
        if ("exportToExcel".equals(curAction)) {
            Object megerExport = params.get("isMegerExport");
            boolean isMergeExport = megerExport != null ? (Boolean)megerExport : true;
            return this.exportToXsl(isMergeExport);
        }
        if ("exportToExcel2007".equals(curAction)) {
            Object megerExport = params.get("isMegerExport");
            boolean isMergeExport = megerExport != null ? (Boolean)megerExport : true;
            return this.exportToXlsx(isMergeExport);
        }
        if ("exportToPDF".equals(curAction)) {
            PageSetup pageSetup = (PageSetup)params.get("pageSetup");
            String path = this.exportToPdf(pageSetup);
            return path;
        }
        if ("responseClick".equals(curAction) && this._isTree) {
            String location = request.getParameter("location");
            String[] param = location.split(",");
            if (param.length != 2) {
                return "error";
            }
            int row = Integer.parseInt(param[0]);
            int col = Integer.parseInt(param[1]);
            WebMouseEvent event = new WebMouseEvent(row, col, 1);
            String result = this.treeHtmlExporter.doMouseEvent(event);
            return result;
        }
        if ("printToPDF".equalsIgnoreCase(curAction)) {
            boolean originPrintPermission = Boolean.parseBoolean(request.getParameter("OriginPrintPermission"));
            if (!(this.authorizedPrint(this.reportId, request) || this._adapter.isHyperlink() && originPrintPermission)) {
                throw new BIReportException("\u6ca1\u6709\u6253\u5370\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u6253\u5370\u64cd\u4f5c\uff01");
            }
            SetupModel setupModel = (SetupModel)params.get("printSetup");
            String path = this.printToPDF(setupModel);
            return path;
        }
        return "";
    }

    private boolean authorizedExport(String reportID, HttpServletRequest request) throws BIReportException {
        com.kingdee.bos.Context ctx = BISystem.getContext((HttpServletRequest)request);
        ctx.put((Object)"com.kingdee.bos.ctrl.analysis.web.ajax.ExtWebReportHandler.IS_BI_REQUEST", (Object)true);
        return PermissionBO.hasDataPermissionByReportId(ctx, BISystem.getCurrentUser((HttpServletRequest)request), BISystem.getCurrentOrgUnitID((HttpServletRequest)request), reportID, PermissionKind.EXPORT);
    }

    private boolean authorizedPrint(String reportID, HttpServletRequest request) throws BIReportException {
        com.kingdee.bos.Context ctx = BISystem.getContext((HttpServletRequest)request);
        ctx.put((Object)"com.kingdee.bos.ctrl.analysis.web.ajax.ExtWebReportHandler.IS_BI_REQUEST", (Object)true);
        return PermissionBO.hasDataPermissionByReportId(ctx, BISystem.getCurrentUser((HttpServletRequest)request), BISystem.getCurrentOrgUnitID((HttpServletRequest)request), reportID, PermissionKind.PRINT);
    }

    public void setParameterJson(String json) {
        if (StringUtil.isEmptyString((String)json) || json.equals("null")) {
            return;
        }
        this._parameterMap = new TreeMap();
        Context ctx = Context.enter();
        Scriptable scope = ctx.initStandardObjects(null);
        Scriptable p = null;
        try {
            p = (Scriptable)ctx.evaluateString(scope, "json = (" + json + ")", "JSON", 1, null);
            p.has(0, scope);
        }
        catch (Exception e) {
            logger.error((Object)e.getCause());
        }
        Scriptable s = (Scriptable)p.get(0, scope);
        Object[] ids = s.getIds();
        for (int i = 0; i < ids.length; ++i) {
            Object avv;
            Object o = s.get(ids[i].toString(), scope);
            if (o == null || Context.getUndefinedValue().equals(o) || Scriptable.NOT_FOUND.equals(o)) continue;
            HashMap<String, Object> pMap = new HashMap<String, Object>();
            Scriptable pOne = (Scriptable)o;
            Object obj = pOne.get("DT", scope);
            if (obj != null && !Context.getUndefinedValue().equals(obj) && !Scriptable.NOT_FOUND.equals(obj)) {
                pMap.put("DT", obj);
            }
            if ((obj = pOne.get("NM", scope)) != null && !Context.getUndefinedValue().equals(obj) && !Scriptable.NOT_FOUND.equals(obj)) {
                pMap.put("NM", obj);
            }
            if ((obj = pOne.get("AA", scope)) != null && !Context.getUndefinedValue().equals(obj) && !Scriptable.NOT_FOUND.equals(obj)) {
                pMap.put("AA", obj);
            }
            if ((obj = pOne.get("VA", scope)) != null && !Context.getUndefinedValue().equals(obj) && !Scriptable.NOT_FOUND.equals(obj)) {
                pMap.put("VA", obj);
            }
            if ((avv = pOne.get("AVV", scope)) instanceof Scriptable) {
                ArrayList<Object> list = new ArrayList<Object>();
                if ("Array".equals(((Scriptable)avv).getClassName())) {
                    Scriptable avvS = (Scriptable)avv;
                    int j = 0;
                    while (avvS.has(j, scope)) {
                        list.add(avvS.get(j, scope));
                        ++j;
                    }
                }
                pMap.put("AVV", list.toArray(new Object[1]));
            } else if (avv != null && !Context.getUndefinedValue().equals(avv) && !Scriptable.NOT_FOUND.equals(avv)) {
                pMap.put("AVV", avv);
            }
            ParameterImpl parameter = new ParameterImpl();
            parameter.fromJsonMap(pMap);
            this._parameterMap.put(parameter.getName(), parameter);
        }
    }

    public ReportImpl getReport() {
        return this.report;
    }

    public void setReport(ReportImpl report) {
        this.report = report;
    }

    public boolean isParamsNeedFill() {
        int size;
        List allUnionParam;
        if (this.report != null && (allUnionParam = this.report.getAllUnionParam()) != null && (size = allUnionParam.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                DesignParameter dp = (DesignParameter)((Object)allUnionParam.get(i));
                if (dp.isAllowNull() || !StringUtils.isEmpty((String)dp.getDefaultValue())) continue;
                return true;
            }
        }
        return false;
    }

    public void setHyperlink(boolean isHyperlink) {
        this.isHyperlink = isHyperlink;
    }

    public String getCloudRptId(com.kingdee.bos.Context easCtx) {
        try {
            return DefineReportBO.getRptCloudUuid(easCtx, this.reportId);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean isAccredited(com.kingdee.bos.Context easCtx) {
        try {
            return PermissionBO.hasDataPermissionByReportId(easCtx, ContextUtil.getCurrentUserInfo((com.kingdee.bos.Context)easCtx).getId().toString(), ContextUtil.getCurrentOrgUnit((com.kingdee.bos.Context)easCtx).getId().toString(), this.reportId, PermissionKind.VIEW);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isModifiedTemplate(com.kingdee.bos.Context easCtx) {
        try {
            Book book = BookIOUtil.unpack((byte[])DefineReportBO.getReportInfo(easCtx, this.reportId).getContent());
            String cloudRptUuid = book.getCloudRptUuid();
            if (!StringUtil.isEmptyString((String)cloudRptUuid) && book.getUserObjectValue("CLOUD_REPORT_DEMO_BOOK_DATA") == null) {
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    public String getRptName(com.kingdee.bos.Context easCtx) {
        try {
            return DefineReportBO.getReportInfo(easCtx, this.reportId).getName(easCtx.getLocale());
        }
        catch (BOSException e) {
            e.printStackTrace();
            return "";
        }
    }

    public boolean isCloudRptCenterEnable(com.kingdee.bos.Context easCtx) {
        return CloudRptCenterControllerFacade.getLocalInst(easCtx).isCloudRptCenterEnable();
    }

    private void initAdapter(com.kingdee.bos.Context easCtx) {
        if (this._adapter == null) {
            if (this.systemId != null) {
                this.getAdapter(easCtx, this.reportName, this.systemId, this.domain, this.reportPath);
            } else {
                this.getAdapter(easCtx, this.reportPath);
            }
        }
    }

    public boolean isHideMenubarInReport(com.kingdee.bos.Context easCtx) {
        this.initAdapter(easCtx);
        try {
            return this._adapter.isHideMenubarInReport();
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u6269\u5c55\u62a5\u8868\u5728\u95e8\u6237\u4e0a\u662f\u5426\u9690\u85cf\u83dc\u5355\u680f\u7684\u914d\u7f6e\u5931\u8d25!reportPath=" + this.reportPath), (Throwable)e);
            return false;
        }
    }

    public boolean isFullScreen(com.kingdee.bos.Context easCtx) {
        this.initAdapter(easCtx);
        try {
            return this._adapter.isFullScreen();
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u6269\u5c55\u62a5\u8868\u5728\u95e8\u6237\u4e0a\u662f\u5426\u5168\u5c4f\u6253\u5f00\u7684\u914d\u7f6e\u5931\u8d25!reportPath=" + this.reportPath), (Throwable)e);
            return false;
        }
    }

    public boolean isPopFilter(com.kingdee.bos.Context easCtx) {
        this.initAdapter(easCtx);
        try {
            return this._adapter.isPopFilter();
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u6269\u5c55\u62a5\u8868\u5728\u95e8\u6237\u4e0a\u662f\u5426\u5f39\u51fa\u8fc7\u6ee4\u5668\u7684\u914d\u7f6e\u5931\u8d25!reportPath=" + this.reportPath), (Throwable)e);
            return false;
        }
    }

    public boolean hasDataSet(com.kingdee.bos.Context easCtx) {
        Book book = this._adapter.getBook();
        ExtDataSetManager dataSetManager = book.getDataSetManager();
        if (null != dataSetManager) {
            return dataSetManager.size() != 0;
        }
        return true;
    }

    class PagingContext {
        private boolean pagingOn = true;
        private int pageRowCount;
        private boolean hasScreenCount;
        private int screenCount;
        private int screenHeight = -1;
        private int currentRowStart = 0;
        private int currentRowEnd = 0;
        private int pageCount = 1;
        private int currentPage = 0;
        private int sheetRowCount = 0;
        private WebParamAdapter adapter;
        private Sheet _curSheet;

        public PagingContext() {
            this.pageRowCount = ExtReportImpl.this._pageCount;
            this.hasScreenCount = ExtReportImpl.this._hasScreenCount;
            this.screenCount = ExtReportImpl.this._screenCount;
        }

        public WebParamAdapter getAdapter() {
            return this.adapter;
        }

        public Sheet get_curSheet() {
            return this._curSheet;
        }

        public int getCurrentPage() {
            return this.currentPage;
        }

        public void setCurrentPage(int currentPage) {
            this.currentPage = currentPage;
        }

        public void initPageContext(Sheet _sSheet, WebParamAdapter _adapter) {
            if (this.pagingOn) {
                int maxRow = _sSheet.getMaxRowIndex() + 1;
                int remainder = maxRow % this.pageRowCount;
                int multiples = maxRow / this.pageRowCount;
                this.pageCount = remainder > 0 ? multiples + 1 : multiples;
                this.currentRowStart = 0;
                this.currentRowEnd = Math.min(maxRow, this.currentRowStart + this.pageRowCount - 1);
                this.currentPage = 0;
                this.sheetRowCount = maxRow - 1;
                this._curSheet = _sSheet;
                if (_adapter != null) {
                    this.adapter = _adapter;
                }
            }
        }

        public boolean isPagingOn() {
            return this.pagingOn;
        }

        public void setPagingOn(boolean pagingOn) {
            this.pagingOn = pagingOn;
        }

        public int getPageRowCount() {
            return this.pageRowCount;
        }

        public boolean hasScreenCount() {
            return this.hasScreenCount;
        }

        public int getScreenHeight() {
            if (!this.hasScreenCount) {
                return 0;
            }
            if (this.screenHeight > 0) {
                return this.screenHeight;
            }
            int min = Math.min(this.screenCount, Math.min(this.pageRowCount, this.sheetRowCount));
            this.screenHeight = this.getHeightBefore(min);
            return this.screenHeight;
        }

        public int getPerScreenRows() {
            return this.screenCount;
        }

        public void setScreenRowCount(int rowCount) {
            this.screenCount = rowCount;
            this.screenHeight = -1;
        }

        private int getHeightBefore(int rowCount) {
            int height = 0;
            Sheet sheet = this.adapter.getBook().getActiveSheet();
            int index = 0;
            int row = ExtReportImpl.this._sheet.getSheetOption().getViewSplitInfo().getRowSplit();
            int i = 0;
            while (i < rowCount) {
                int h = SheetBaseMath.getRowHeight((Sheet)sheet, (int)index, (boolean)false);
                if (h > 0) {
                    height += h;
                    if (index >= row) {
                        ++i;
                    }
                }
                ++index;
            }
            return height += 20;
        }

        public void setPageRowCount(int pageRowCount) {
            this.pageRowCount = pageRowCount;
            this.screenHeight = -1;
        }

        public int getCurrentRowStart() {
            return this.currentRowStart;
        }

        public void setCurrentRowStart(int currentRowStart) {
            this.currentRowStart = currentRowStart;
        }

        public int getCurrentRowEnd() {
            return this.currentRowEnd;
        }

        public void setCurrentRowEnd(int currentRowEnd) {
            this.currentRowEnd = currentRowEnd;
        }

        public int getPageCount() {
            return this.pageCount;
        }

        public void setPageCount(int pageCount) {
            this.pageCount = pageCount;
        }

        private void reCalculatePageContext(int curPage) {
            if (this.pagingOn && curPage >= 0 && curPage < this.pageCount) {
                this.currentRowStart = Math.max(curPage * this.pageRowCount, 0);
                this.currentRowEnd = Math.min(this.currentRowStart + this.pageRowCount - 1, this.sheetRowCount);
                this.currentPage = curPage;
            }
        }

        public Sheet nextPage() {
            this.reCalculatePageContext(this.currentPage + 1);
            Sheet _sheet = this.adapter.getPartSheet(this.currentRowStart, this.currentRowEnd);
            return _sheet;
        }

        public Sheet prePage() {
            this.reCalculatePageContext(this.currentPage + 1);
            Sheet _sheet = this.adapter.getPartSheet(this.currentRowStart, this.currentRowEnd);
            return _sheet;
        }

        public Sheet goToPage(int goToPageIdx) {
            this.reCalculatePageContext(goToPageIdx);
            Sheet _sheet = this.adapter.getPartSheet(this.currentRowStart, this.currentRowEnd);
            return _sheet;
        }

        public Sheet firstPage() {
            Sheet _sheet = this.adapter.getPartSheet(this.currentRowStart, this.currentRowEnd);
            return _sheet;
        }
    }
}

