/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.tobi.domain;

import chrriis.dj.nativeswing.common.Utils;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.util.HMACUtil;
import com.kingdee.bos.ctrl.analysis.web.ajax.PageManager;
import com.kingdee.bos.ctrl.analysis.web.ajax.ReportPage;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtFilterHandler;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReportPage;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterScheme;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.ShareStrategy;
import com.kingdee.bos.ctrl.common.util.SecretKeyUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.ChartLinkRequestHandler;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.model.ChartDataItemInfo;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.rpts.ctrlreport.innerlink.CellInnerLinkWebExec;
import com.kingdee.eas.rpts.ctrlreport.innerlink.ChartInnerLinkWebExec;
import com.kingdee.eas.rpts.ctrlreport.innerlink.InnerLinkException;
import com.kingdee.eas.rpts.ctrlreport.innerlink.LinkParamVo;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.eas.rpts.ctrlsqldesign.data.IInputCtrl;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputState;
import com.kingdee.eas.rpts.ctrlsqldesign.data.InputType;
import com.kingdee.eas.rpts.ctrlsqldesign.data.TreeStructType;
import com.kingdee.eas.rpts.ctrlsqldesign.model.WebParamAdapter;
import com.kingdee.eas.rpts.tobi.ExtReportImpl;
import com.kingdee.eas.rpts.tobi.util.AnalysisReportUtil;
import com.kingdee.eas.rpts.tobi.util.ExtFilterParamUtil;
import com.kingdee.eas.rpts.web.filter.CtrlType;
import com.kingdee.eas.rpts.web.filter.F7ParamDescription;
import com.kingdee.eas.rpts.web.filter.FilterSchemeInfo;
import com.kingdee.eas.rpts.web.filter.ReportParamDescription;
import com.kingdee.eas.rpts.web.man.ReportImpl;
import com.kingdee.eas.rpts.web.model.LinkModel;
import com.kingdee.eas.rpts.web.param.CreateSheet;
import com.kingdee.eas.rpts.web.util.BeanFactory;
import com.kingdee.eas.rpts.web.util.ReportBookHelper;
import com.kingdee.eas.rpts.web.vo.Entry;
import com.kingdee.eas.rpts.web.vo.FilterSchemeVO;
import com.kingdee.eas.rpts.web.vo.KsqlRowset;
import com.kingdee.eas.rpts.web.vo.ReportInfo;
import com.kingdee.eas.rpts.web.vo.SheetInfo;
import com.kingdee.eas.rpts.web.vo.TableInfo;
import com.kingdee.eas.rpts.web.vo.TreeNodeEntry;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class WebReportDomain {
    public String loadReport(JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        Map<String, String> aliasMap;
        Map<String, String> paramMap;
        String pageId = oJson.getString("pageId");
        String paramCacheId = oJson.getString("paramCacheId");
        ReportPage page = (ReportPage)PageManager.getPage((String)pageId);
        if (page == null) {
            throw new BIReportException("\u62a5\u8868\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\uff01");
        }
        ExtReportImpl extReportImpl = (ExtReportImpl)((ExtReportPage)page).getExtReport();
        ReportImpl reportImpl = extReportImpl.getReport();
        Context ctx = BISystem.getContext((HttpServletRequest)request);
        WebParamAdapter paramAdapter = extReportImpl.getAdapter(ctx, reportImpl.getReportId());
        List allUnionParam = reportImpl.getAllUnionParam();
        List<ReportParamDescription> paramList = reportImpl.getParamList();
        if (paramCacheId != null && !"".equals(paramCacheId)) {
            JSONObject paramJson = PageManager.getCacheParam((String)paramCacheId);
            paramMap = WebReportDomain.getParamMap(allUnionParam, paramJson, "value", false);
            aliasMap = WebReportDomain.getParamMap(allUnionParam, paramJson, "text", false);
            PageManager.removeCacheParam((String)paramCacheId);
        } else {
            paramMap = new HashMap();
            aliasMap = new HashMap();
            int size = -1;
            if (allUnionParam != null && (size = allUnionParam.size()) > 0) {
                int j = 0;
                for (int i = 0; i < size; ++i) {
                    InputType inputType;
                    DesignParameter dp = (DesignParameter)((Object)allUnionParam.get(i));
                    String paramName = dp.getName();
                    String value = dp.getDefaultValue();
                    String alias = dp.getDefaultAlias();
                    if (!StringUtil.isEmptyString((String)value)) {
                        paramMap.put(paramName, value);
                        aliasMap.put(paramName, alias);
                    }
                    if ((inputType = dp.getInputType()) == InputType.EMPTY || inputType == InputType.Separator) {
                        paramMap.put(paramName, value);
                        aliasMap.put(paramName, alias);
                        continue;
                    }
                    if (inputType == InputType.ALONE_CHECKBOX) {
                        ReportParamDescription paramDescription = paramList.get(j);
                        this.setDefaultParam(paramDescription, paramMap, aliasMap, dp);
                    }
                    ++j;
                }
            }
        }
        this.putLoadPathType(paramMap, oJson);
        try {
            paramAdapter.execute(paramMap, aliasMap);
        }
        catch (Exception e) {
            throw new BIReportException((Throwable)e);
        }
        Book book = paramAdapter.getBook();
        reportImpl.setBook(book);
        String curSheetName = book.getActiveSheet().getSheetName();
        reportImpl.setCurrentSheetName(curSheetName);
        reportImpl.setPageId(pageId);
        BeanFactory.makeupReportModelBhv().behaviour(reportImpl);
        reportImpl.setContext(ctx);
        ReportInfo reportInfo = BeanFactory.outputReportBhv().behaviour(reportImpl);
        return new JSONObject((Object)reportInfo).toString();
    }

    public void cacheAnalysisReportParam(JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        Context ctx = BISystem.getContext((HttpServletRequest)request);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        HashMap parameterMap = PageManager.getParameterMap((HttpServletRequest)request);
        String reportId = (String)parameterMap.get("rptId");
        if (reportId == null || reportId.length() == 0) {
            reportId = (String)parameterMap.get("ExtReportId");
        }
        parameterMap.put("oJson_param", oJson.toString());
        AnalysisReportUtil.cacheReportFilterValue(userId, reportId, parameterMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeReport(JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        String pageId = oJson.getString("pageId");
        try {
            Context ctx;
            ExtReportImpl extReportImpl;
            Book book;
            ReportPage page = (ReportPage)PageManager.getPage((String)pageId);
            if (null != page && (book = (extReportImpl = (ExtReportImpl)((ExtReportPage)page).getExtReport()).getAdapter(ctx = BISystem.getContext((HttpServletRequest)request), extReportImpl.getReport().getReportId()).getBook()) != null) {
                book.getDeps().setUserInterrupted(true);
            }
        }
        finally {
            PageManager.close((String)pageId);
        }
    }

    public String applyFilter(JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        String pageId = oJson.getString("pageId");
        String schemeName = oJson.getString("schemeName");
        Boolean isDefaultChange = oJson.getBoolean("isDefaultChange");
        ReportPage page = (ReportPage)PageManager.getPage((String)pageId);
        if (null == page) {
            page = (ReportPage)PageManager.createPage((String)"extReport", (HttpServletRequest)request, null, (String)pageId);
            page.getReport().getFilter(request);
        }
        ExtReportImpl extReportImpl = (ExtReportImpl)((ExtReportPage)page).getExtReport();
        ReportImpl reportImpl = extReportImpl.getReport();
        Context ctx = BISystem.getContext((HttpServletRequest)request);
        if (null != ctx) {
            WebContextUtil.initRpcConfig((Context)ctx);
        }
        WebParamAdapter paramAdapter = extReportImpl.getAdapter(ctx, reportImpl.getReportId());
        List allUnionParam = reportImpl.getAllUnionParam();
        Map paramMap = WebReportDomain.getParamMap(allUnionParam, oJson, "value", false);
        Map aliasMap = WebReportDomain.getParamMap(allUnionParam, oJson, "text", false);
        if (isDefaultChange.booleanValue()) {
            ExtFilterHandler.changeSchemeDefaultStatus((ReportPage)page, (HttpServletRequest)request, (String)schemeName);
        }
        this.putLoadPathType(paramMap, oJson);
        try {
            paramAdapter.execute(paramMap, aliasMap);
        }
        catch (Exception e) {
            throw new BIReportException((Throwable)e);
        }
        Book book = paramAdapter.getBook();
        reportImpl.setBook(book);
        if (reportImpl.getCurrentSheetName() == null) {
            String curSheetName = book.getActiveSheet().getSheetName();
            reportImpl.setCurrentSheetName(curSheetName);
        }
        BeanFactory.makeupReportModelBhv().behaviour(reportImpl);
        reportImpl.setContext(ctx);
        reportImpl.setPageId(pageId);
        ReportInfo reportInfo = BeanFactory.outputReportBhv().behaviour(reportImpl);
        return new JSONObject((Object)reportInfo).toString();
    }

    private void putLoadPathType(Map paramMap, JSONObject oJson) throws JSONException {
        if (oJson.has("portlet")) {
            String loadFrom = oJson.getString("portlet");
            int loadPathType = StringUtil.isEmptyString((String)loadFrom) ? 2 : 3;
            paramMap.put("loadPathType", loadPathType);
        }
    }

    public String cacheParam(JSONObject oJson) throws BIReportException, JSONException {
        return PageManager.addCacheParam((JSONObject)oJson);
    }

    public String switchSheet(JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        String pageId = oJson.getString("pageId");
        ReportPage page = (ReportPage)PageManager.getPage((String)pageId);
        if (page == null) {
            throw new BIReportException("\u62a5\u8868\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\uff01");
        }
        ExtReportImpl extReportImpl = (ExtReportImpl)((ExtReportPage)page).getExtReport();
        ReportImpl reportImpl = extReportImpl.getReport();
        String sheetName = oJson.getString("sheetName");
        CreateSheet sheetJson = CreateSheet.instance();
        sheetJson.setSheetName(sheetName);
        reportImpl.setContext(BISystem.getContext((HttpServletRequest)request));
        if (oJson.has("switchOnly") && "true".equalsIgnoreCase(oJson.getString("switchOnly"))) {
            reportImpl.setCurrentSheetName(sheetName);
            return "true";
        }
        SheetInfo sheetInfo = BeanFactory.outputSheetBhv().behaviour(reportImpl, sheetJson);
        return new JSONObject((Object)sheetInfo).toString();
    }

    public String getFilterSchemes(JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        String flag = oJson.getString("flag");
        String pageId = oJson.getString("pageId");
        ReportPage page = (ReportPage)PageManager.getPage((String)pageId);
        if (page == null) {
            throw new BIReportException("\u62a5\u8868\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\uff01");
        }
        BIReportFilter filter = page.getReport().getFilter(request);
        ExtReportImpl extReportImpl = (ExtReportImpl)((ExtReportPage)page).getExtReport();
        ReportImpl reportImpl = extReportImpl.getReport();
        FilterScheme defaultScheme = this.getDefaultFilterScheme(filter, reportImpl);
        FilterSchemeInfo defaultSchemeInfo = new FilterSchemeInfo();
        defaultSchemeInfo.setCaption(defaultScheme.getCaption());
        defaultSchemeInfo.setValue(defaultScheme + "");
        FilterScheme[] fs = "0".equals(flag) ? ExtFilterHandler.getFilterSchemes((HttpServletRequest)request, (String)"0", (ExtReportPage)((ExtReportPage)page), (BIReportFilter)filter) : ("1".equals(flag) ? ExtFilterHandler.getFilterSchemes((HttpServletRequest)request, (String)"1", (ExtReportPage)((ExtReportPage)page), (BIReportFilter)filter) : ExtFilterHandler.getFilterSchemes((HttpServletRequest)request, (String)"2", (ExtReportPage)((ExtReportPage)page), (BIReportFilter)filter));
        ArrayList<FilterSchemeInfo> schemeList = new ArrayList<FilterSchemeInfo>();
        schemeList.add(defaultSchemeInfo);
        for (int i = 0; i < fs.length; ++i) {
            FilterSchemeInfo info = new FilterSchemeInfo();
            info.setCaption(fs[i].getCaption());
            info.setValue(fs[i] + "");
            if (defaultSchemeInfo.getCaption().equals(fs[i].getCaption())) continue;
            schemeList.add(info);
        }
        FilterSchemeVO schemeVO = new FilterSchemeVO();
        schemeVO.setSchemeList(schemeList);
        return new JSONObject((Object)schemeVO).toString();
    }

    private FilterScheme getDefaultFilterScheme(BIReportFilter filter, ReportImpl reportImpl) throws BIReportException {
        int paramSize = filter.getItemCount();
        Object[] defaultValueParams = new Object[paramSize];
        Object[] defaultCaptionParams = new Object[paramSize];
        Object[] nameParams = new Object[paramSize];
        List allUnionParam = reportImpl.getAllUnionParam();
        int size = -1;
        int j = 0;
        if (allUnionParam != null && (size = allUnionParam.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                DesignParameter dp = (DesignParameter)((Object)allUnionParam.get(i));
                if (dp.getInputType() == InputType.EMPTY || dp.getInputType() == InputType.Separator) continue;
                nameParams[j] = dp.getName();
                String value = dp.getDefaultValue();
                String alias = dp.getDefaultAlias() != null ? dp.getDefaultAlias() : value;
                defaultValueParams[j] = Arrays.asList(value);
                defaultCaptionParams[j] = Arrays.asList(alias);
                ++j;
            }
        }
        FilterScheme defaultScheme = FilterScheme.createFilterScheme((String)"\u9ed8\u8ba4\u65b9\u6848", (Object[])defaultValueParams, (Object[])defaultCaptionParams, null, null, (Object[])nameParams);
        return defaultScheme;
    }

    public String delFilterScheme(JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        String pageId = oJson.getString("pageId");
        ReportPage page = (ReportPage)PageManager.getPage((String)pageId);
        if (page == null) {
            throw new BIReportException("\u62a5\u8868\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\uff01");
        }
        String caption = oJson.getString("filterName");
        String shareType = oJson.getString("flag");
        try {
            ExtFilterHandler.delScheme((String)caption, (HttpServletRequest)request, (ExtReportPage)((ExtReportPage)page), (String)shareType);
        }
        catch (BIReportException e) {
            return e.getMessage();
        }
        return "true";
    }

    public String lazyLoadFragment(JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        String pageId = oJson.getString("pageId");
        ReportPage page = (ReportPage)PageManager.getPage((String)pageId);
        if (page == null) {
            throw new BIReportException("\u62a5\u8868\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\uff01");
        }
        ExtReportImpl extReportImpl = (ExtReportImpl)((ExtReportPage)page).getExtReport();
        ReportImpl reportImpl = extReportImpl.getReport();
        reportImpl.setContext(BISystem.getContext((HttpServletRequest)request));
        TableInfo table = BeanFactory.outputTableBhv().behaviour(reportImpl);
        return new JSONObject((Object)table).toString();
    }

    public String lazyLoadTree(JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        String pageId = oJson.getString("pageId");
        int rowIdx = oJson.getInt("rowIdx");
        int level = oJson.getInt("treeLevel");
        ReportPage page = (ReportPage)PageManager.getPage((String)pageId);
        if (page == null) {
            throw new BIReportException("\u62a5\u8868\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\uff01");
        }
        ExtReportImpl extReportImpl = (ExtReportImpl)((ExtReportPage)page).getExtReport();
        ReportImpl reportImpl = extReportImpl.getReport();
        reportImpl.setContext(BISystem.getContext((HttpServletRequest)request));
        TableInfo table = BeanFactory.outputTableTreeBhv().behaviour(reportImpl, rowIdx, level);
        return new JSONObject((Object)table).toString();
    }

    public String saveFilterScheme(JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        String pageId = oJson.getString("pageId");
        String shareType = oJson.getString("flag");
        String schemeName = oJson.getString("schemeName");
        FilterSchemeInfo info = new FilterSchemeInfo();
        if (schemeName.contains("script") || schemeName.contains("iframe") || schemeName.contains("<") || schemeName.contains(">")) {
            info.setInvalid(true);
        } else {
            Boolean isDefaultChange = oJson.getBoolean("isDefaultChange");
            ReportPage page = (ReportPage)PageManager.getPage((String)pageId);
            if (page == null) {
                throw new BIReportException("\u62a5\u8868\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\uff01");
            }
            BIReportFilter filter = page.getReport().getFilter(request);
            String repPath = page.getReport().getRepositoryPath();
            int count = filter.getItemCount();
            Object[] valueParams = new Object[count];
            Object[] captionParams = new Object[count];
            Object[] nameParams = new Object[count];
            for (int i = 0; i < count; ++i) {
                valueParams[i] = Arrays.asList(this.analysisParamJson(oJson, "valParams", i));
                captionParams[i] = Arrays.asList(this.analysisParamJson(oJson, "capParams", i));
                nameParams[i] = this.analysisParamJson(oJson, "nameParams", i)[0];
            }
            ShareStrategy ss = new ShareStrategy(request, shareType);
            FilterScheme scheme = null;
            try {
                scheme = FilterScheme.createFilterScheme((String)schemeName, (Object[])valueParams, (Object[])captionParams, (ShareStrategy)ss, (String)repPath, (Object[])nameParams);
            }
            catch (BIReportException e) {
                return e.getMessage();
            }
            ExtFilterHandler.saveScheme((String)BISystem.getCurrentUser((HttpServletRequest)request), (boolean)false, (ReportPage)page, (HttpServletRequest)request, (FilterScheme)scheme, (boolean)false);
            if (isDefaultChange.booleanValue()) {
                ExtFilterHandler.changeSchemeDefaultStatus((ReportPage)page, (HttpServletRequest)request, (String)schemeName);
            }
            info.setCaption(scheme.getCaption());
            info.setValue(scheme + "");
        }
        return new JSONObject((Object)info).toString();
    }

    private String[] analysisParamJson(JSONObject oJson, String type, int index) throws JSONException {
        JSONArray arrJson = (JSONArray)((JSONArray)oJson.get(type)).get(index);
        int count = arrJson.length();
        String[] ret = new String[count];
        for (int i = 0; i < count; ++i) {
            String str;
            ret[i] = str = (String)arrJson.get(i);
        }
        return ret;
    }

    private void setDefaultParam(ReportParamDescription paramDescription, Map paramMap, Map aliasMap, DesignParameter dp) {
        String paramName = dp.getName();
        String ctrlType = paramDescription.getCtrlType();
        if (CtrlType.F7.name().equals(ctrlType)) {
            paramMap.put(paramName, "");
            aliasMap.put(paramName, "");
        } else if (CtrlType.TextField.name().equals(ctrlType)) {
            paramMap.put(paramName, "");
            aliasMap.put(paramName, "");
        } else if (CtrlType.CheckBoxGroup.name().equals(ctrlType)) {
            paramMap.put(paramName, "");
            aliasMap.put(paramName, "");
        } else if (CtrlType.ComboBox.name().equals(ctrlType)) {
            paramMap.put(paramName, "");
            aliasMap.put(paramName, "");
        } else if (CtrlType.DateTime.name().equals(ctrlType)) {
            paramMap.put(paramName, "");
            aliasMap.put(paramName, "");
        } else if (CtrlType.CheckBox.name().equals(ctrlType)) {
            Entry entry = (Entry)paramDescription.getDefaultValue();
            paramMap.put(paramName, entry.getValue());
            aliasMap.put(paramName, entry.getText());
        } else if (CtrlType.NumberStepper.name().equals(ctrlType)) {
            paramMap.put(paramName, "");
            aliasMap.put(paramName, "");
        } else {
            paramMap.put(paramName, "");
            aliasMap.put(paramName, "");
        }
    }

    public static Map getParamMap(List paramlist, String strParams, String type, boolean isApplyFilter) throws JSONException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        JSONArray attParam = new JSONArray(strParams);
        if (attParam.length() == 0) {
            return paramMap;
        }
        int size = -1;
        if (paramlist != null && (size = paramlist.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                DesignParameter dp = (DesignParameter)((Object)paramlist.get(i));
                String paramName = dp.getName();
                if (dp.getInputState() == InputState.HIDDEN && isApplyFilter) {
                    if ("value".equals(type)) {
                        paramMap.put(paramName, dp.getDefaultValue());
                        continue;
                    }
                    paramMap.put(paramName, dp.getDefaultAlias());
                    continue;
                }
                JSONObject oParam = null;
                JSONObject tempParam = null;
                for (int j = 0; j < attParam.length(); ++j) {
                    tempParam = (JSONObject)attParam.get(j);
                    if (!paramName.toUpperCase(Locale.ENGLISH).equals(tempParam.getString("paramName").toUpperCase(Locale.ENGLISH))) continue;
                    oParam = tempParam;
                    break;
                }
                String strVars = oParam == null ? "[]" : oParam.getString("paramVars");
                JSONArray arrVar = new JSONArray(strVars);
                StringBuilder sbValue = new StringBuilder();
                for (int j = 0; j < arrVar.length(); ++j) {
                    JSONObject var = (JSONObject)arrVar.get(j);
                    String value = var.getString(type);
                    InputType inputType = dp.getInputType();
                    if (inputType != null && inputType.equals(InputType.INPUT)) {
                        if (!value.equals("") && value.indexOf(";") != -1) {
                            value = ExtStringUtil.replace(value, ";", "0xx1xx");
                        }
                        sbValue.append(value);
                        if (j + 1 >= arrVar.length()) continue;
                        sbValue.append("0xx1xx");
                        continue;
                    }
                    if (value.equals("")) continue;
                    sbValue.append(value);
                    if (j + 1 >= arrVar.length()) continue;
                    sbValue.append("0xx1xx");
                }
                paramMap.put(paramName, sbValue.toString());
            }
        }
        return paramMap;
    }

    public static Map getParamMap(List paramlist, JSONObject oJson, String type, boolean isApplyFilter) throws JSONException {
        String strParams = oJson.getString("paramValues");
        return WebReportDomain.getParamMap(paramlist, strParams, type, isApplyFilter);
    }

    public static Map getAliasMap(List paramlist, JSONObject oJson) throws JSONException {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        String strParams = oJson.getString("paramValues");
        JSONArray attParam = new JSONArray(strParams);
        int size = -1;
        if (paramlist != null && (size = paramlist.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                DesignParameter dp = (DesignParameter)((Object)paramlist.get(i));
                String paramName = dp.getName();
                if (dp.getInputState() == InputState.HIDDEN) {
                    aliasMap.put(paramName, dp.getDefaultAlias());
                    continue;
                }
                JSONObject oParam = null;
                for (int j = 0; j < attParam.length() && !paramName.equals((oParam = (JSONObject)attParam.get(j)).getString("paramName")); ++j) {
                }
                String strVars = null;
                if (null != oParam) {
                    strVars = oParam.getString("paramVars");
                }
                JSONArray arrVar = new JSONArray(strVars);
                StringBuilder sbValue = new StringBuilder();
                for (int j = 0; j < arrVar.length(); ++j) {
                    JSONObject var = (JSONObject)arrVar.get(j);
                    String value = var.getString("text");
                    sbValue.append(value);
                    if (j + 1 >= arrVar.length()) continue;
                    sbValue.append("0xx1xx");
                }
                aliasMap.put(paramName, sbValue.toString());
            }
        }
        return aliasMap;
    }

    public String applyRefresh() throws BIReportException {
        return null;
    }

    public List<ReportParamDescription> getReportParams(String pageId, HttpServletRequest request) throws BIReportException {
        ReportPage page = (ReportPage)PageManager.getPage((String)pageId);
        if (page == null) {
            throw new BIReportException("\u62a5\u8868\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\uff01");
        }
        ExtReportImpl extReportImpl = (ExtReportImpl)((ExtReportPage)page).getExtReport();
        return this.getReportParams(BISystem.getContext((HttpServletRequest)request), extReportImpl);
    }

    public List<ReportParamDescription> getReportParams(Context easCtx, ExtReportImpl extReportImpl) throws BIReportException {
        ReportImpl reportImpl = extReportImpl.getReport();
        List allUnionParam = reportImpl.getAllUnionParam();
        WebParamAdapter paramAdapter = extReportImpl.getAdapter(easCtx, reportImpl.getReportId());
        List<ReportParamDescription> ret = WebReportDomain.translateParams(easCtx, allUnionParam, paramAdapter, reportImpl.getReportId());
        reportImpl.setParamList(ret);
        return ret;
    }

    public Map<String, Object> getReportScheme(JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        String pageId = oJson.getString("pageId");
        ReportPage page = (ReportPage)PageManager.getPage((String)pageId);
        if (page == null) {
            throw new BIReportException("\u62a5\u8868\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\uff01");
        }
        ExtReportImpl extReportImpl = (ExtReportImpl)((ExtReportPage)page).getExtReport();
        ReportImpl reportImpl = extReportImpl.getReport();
        BIReportFilter filter = page.getReport().getFilter(request);
        Repository rep = BISystem.getRepository((HttpServletRequest)request);
        String repPath = page.getReport().getRepositoryPath();
        boolean hasDefaultSchemeInDatabase = false;
        FilterScheme defaultScheme = this.getDefaultFilterScheme(filter, reportImpl);
        ShareStrategy shareStrategy = new ShareStrategy(request, "0");
        defaultScheme.setShareStrategy(shareStrategy);
        FilterSchemeInfo defaultSchemeInfo = new FilterSchemeInfo();
        defaultSchemeInfo.setCaption(defaultScheme.getCaption());
        defaultSchemeInfo.setValue(defaultScheme + "");
        FilterScheme[] fs = null;
        try {
            fs = FilterScheme.getFilterSchemesSharedByUserAndOrgUnit((String)repPath, (BIReportFilter)filter, (Repository)rep);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fs != null) {
            for (int i = 0; i < fs.length; ++i) {
                try {
                    ExtFilterHandler.saveScheme((String)BISystem.getCurrentUser((HttpServletRequest)request), (boolean)false, (ReportPage)page, (HttpServletRequest)request, (FilterScheme)fs[i], (boolean)false);
                    continue;
                }
                catch (Exception exp) {
                    break;
                }
            }
        }
        fs = ExtFilterHandler.getFilterSchemes((HttpServletRequest)request, (String)"0", (ExtReportPage)((ExtReportPage)page), (BIReportFilter)filter);
        ArrayList<FilterSchemeInfo> schemeList = new ArrayList<FilterSchemeInfo>();
        schemeList.add(defaultSchemeInfo);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hasDeFaultEnter", false);
        map.put("defaultEnter", "");
        for (int i = 0; i < fs.length; ++i) {
            FilterSchemeInfo info = new FilterSchemeInfo();
            info.setCaption(fs[i].getCaption().replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
            info.setValue(fs[i] + "");
            if (fs[i].isDefault()) {
                map.put("hasDeFaultEnter", true);
                map.put("defaultEnter", fs[i].getCaption());
            }
            if (!defaultSchemeInfo.getCaption().equals(fs[i].getCaption())) {
                schemeList.add(info);
                continue;
            }
            hasDefaultSchemeInDatabase = true;
        }
        map.put("schemeList", schemeList);
        if (!hasDefaultSchemeInDatabase) {
            ExtFilterHandler.saveScheme((String)BISystem.getCurrentUser((HttpServletRequest)request), (boolean)false, (ReportPage)page, (HttpServletRequest)request, (FilterScheme)defaultScheme, (boolean)true);
        }
        return map;
    }

    public String getDelaySuppliedValue(JSONObject oJson, HttpServletRequest request) throws BIReportException, JSONException {
        Entry<String, String> entry;
        ArrayList lst;
        String hmac;
        String pageId = oJson.getString("pageId");
        Context ctx = BISystem.getContext((HttpServletRequest)request);
        String paramName = oJson.getString("paramName");
        String textName = oJson.getString("textName");
        String valueName = oJson.getString("valueName");
        int dataSourceType = oJson.getInt("dataSourceType");
        String reportId = oJson.getString("reportId");
        String xmlContent = oJson.getString("datasetXml");
        String string = hmac = oJson.has("hmac") ? oJson.getString("hmac") : null;
        if (!StringUtil.isEmptyString((String)hmac)) {
            try {
                if (!HMACUtil.genHMAC((byte[])xmlContent.getBytes("UTF-8"), (byte[])SecretKeyUtil.getInstance().getSecretKey().getBytes("UTF-8")).equals(hmac)) {
                    throw new BIReportException("hmac \u6821\u9a8c\u4e0d\u901a\u8fc7\u3002");
                }
                xmlContent = new String(Base64.decode((String)xmlContent), "UTF-8");
            }
            catch (Exception e) {
                throw new BIReportException((Throwable)e);
            }
        }
        JSONArray paramValues = oJson.getJSONArray("paramValues");
        HashMap<String, Object> params = new HashMap<String, Object>();
        int length = paramValues.length();
        for (int index = 0; index < length; ++index) {
            JSONObject o = paramValues.getJSONObject(index);
            JSONArray values = o.getJSONArray("paramValues");
            if (values.length() == 1) {
                params.put(o.getString("paramName"), values.getString(0));
                continue;
            }
            if (values.length() <= 1) continue;
            Object value = values.getString(0);
            int length2 = values.length();
            for (int index2 = 1; index2 < length2; ++index2) {
                value = (String)value + "0xx1xx" + values.getString(index2);
            }
            params.put(o.getString("paramName"), value);
        }
        ReportPage page = (ReportPage)PageManager.getPage((String)pageId);
        if (page == null) {
            throw new BIReportException("\u62a5\u8868\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\uff01");
        }
        ExtReportImpl extReportImpl = (ExtReportImpl)((ExtReportPage)page).getExtReport();
        List allUnionParam = extReportImpl.getReport().getAllUnionParam();
        TreeStructType treeStructType = null;
        for (DesignParameter dp : allUnionParam) {
            IInputCtrl inputCtrl;
            DesignParameter[][] suppliers;
            if (!dp.getName().equals(paramName)) continue;
            for (DesignParameter[] supplier : suppliers = dp.getSupplierParams(ctx)) {
                if (supplier[0] == null || supplier[1] == null) continue;
                String disKey = supplier[0].getName();
                String sourceKey = supplier[1].getName();
                if (!params.containsKey(sourceKey)) continue;
                Object value = params.get(sourceKey);
                params.put(disKey, value);
            }
            if (dp.getInputType() != InputType.F7LIST || (inputCtrl = dp.getInputCtrl()) == null) break;
            treeStructType = inputCtrl.getTreeType();
            break;
        }
        if ((lst = ExtFilterParamUtil.getF7SuppliedValue(ctx, reportId, xmlContent, textName, valueName, dataSourceType, params)) == null || lst.isEmpty()) {
            return null;
        }
        if (treeStructType == null) {
            ArrayList entryList = new ArrayList();
            Iterator it = lst.iterator();
            while (it.hasNext()) {
                entry = new Entry<String, String>();
                HashMap mapitem = (HashMap)it.next();
                entry.setText(CtrlReportUtil.getObjectString(mapitem.get(textName.toLowerCase())));
                entry.setValue(CtrlReportUtil.getObjectString(mapitem.get(valueName.toLowerCase())));
                entryList.add(entry);
            }
            KsqlRowset rowSet = new KsqlRowset();
            rowSet.setEntryList(entryList);
            return new JSONObject((Object)rowSet).toString();
        }
        ArrayList entryList = new ArrayList();
        for (int i = 0; i < lst.size(); ++i) {
            entry = new TreeNodeEntry();
            HashMap mapitem = (HashMap)lst.get(i);
            ((TreeNodeEntry)entry).setText(CtrlReportUtil.getObjectString(mapitem.get(textName.toLowerCase())));
            ((TreeNodeEntry)entry).setValue(CtrlReportUtil.getObjectString(mapitem.get(valueName.toLowerCase())));
            entryList.add(entry);
        }
        String currentNodeIdName = valueName.toLowerCase();
        String parentNodeIdName = "parentnodeid";
        int treeType = treeStructType.getTreeType();
        switch (treeType) {
            case -1: {
                break;
            }
            case 0: {
                if (dataSourceType == 6) {
                    currentNodeIdName = "id";
                    parentNodeIdName = "parentId";
                    break;
                }
                currentNodeIdName = treeStructType.getNodeCurrent().getName().toLowerCase();
                parentNodeIdName = treeStructType.getNodeParent().getName().toLowerCase();
                break;
            }
            case 1: {
                String longNumberName = treeStructType.getNodeLongNum().getName();
                String nodeSeparator = treeStructType.getNodeSeparator();
                lst = (ArrayList)ExtFilterParamUtil.translateLongNumberTreeType(lst, longNumberName, nodeSeparator, currentNodeIdName, parentNodeIdName);
                break;
            }
        }
        String textNameLowCase = textName.toLowerCase();
        String valueNameLowCase = valueName.toLowerCase();
        for (int i = 0; i < entryList.size(); ++i) {
            TreeNodeEntry entry2 = (TreeNodeEntry)entryList.get(i);
            HashMap mapitem = (HashMap)lst.get(i);
            entry2.setId(CtrlReportUtil.getObjectString(mapitem.get(currentNodeIdName)));
            entry2.setParentId(CtrlReportUtil.getObjectString(mapitem.get(parentNodeIdName)));
        }
        KsqlRowset rowSet = new KsqlRowset();
        rowSet.setEntryList(entryList);
        return new JSONObject((Object)rowSet).toString();
    }

    public static List<ReportParamDescription> translateParams(Context easCtx, List allUnionParam, WebParamAdapter paramAdapter, String reportId) throws BIReportException {
        Locale easLocale = null;
        if (easCtx != null) {
            easLocale = easCtx.getLocale();
        }
        ArrayList<ReportParamDescription> paramList = new ArrayList<ReportParamDescription>();
        int size = -1;
        if (allUnionParam != null && (size = allUnionParam.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                ReportParamDescription param;
                DesignParameter dp = (DesignParameter)((Object)allUnionParam.get(i));
                InputType inputType = dp.getInputType();
                if (inputType == InputType.EMPTY || inputType == InputType.Separator) continue;
                if (inputType == InputType.F7LIST) {
                    param = new F7ParamDescription();
                    IInputCtrl unit = dp.getInputCtrl();
                    if (unit != null) {
                        TreeStructType treeStructType;
                        DefObj def = unit.getDefDbsource();
                        if (def != null) {
                            ((F7ParamDescription)param).setBindSourceName(def.getAlias());
                            String maxRestrictNumber = unit.getRowLimit();
                            if (unit.isAllowMultipleSelected() && maxRestrictNumber != null) {
                                ((F7ParamDescription)param).setMaxRestrictNumber(Integer.parseInt(maxRestrictNumber));
                            } else {
                                ((F7ParamDescription)param).setMaxRestrictNumber(1);
                            }
                        }
                        if ((treeStructType = unit.getTreeType()) != null) {
                            boolean isTree = false;
                            switch (treeStructType.getTreeType()) {
                                case 0: 
                                case 1: {
                                    isTree = true;
                                    break;
                                }
                                case -1: {
                                    isTree = false;
                                    break;
                                }
                                default: {
                                    isTree = false;
                                }
                            }
                            ((F7ParamDescription)param).setIsTree(isTree);
                            ((F7ParamDescription)param).setTreeExpandLevel(treeStructType.getTreeExpandLevel());
                        }
                        param.setEditable(unit.isAllowEdit());
                    }
                } else {
                    param = new ReportParamDescription();
                }
                DesignParameter[] rela = dp.getRelatedParams();
                if (rela != null && rela.length != 0) {
                    ArrayList<String> relation = new ArrayList<String>();
                    for (int k = 0; k < rela.length; ++k) {
                        relation.add(rela[k].getName());
                    }
                    param.setRelations(relation);
                }
                param.setDataType(ExtFilterParamUtil.translateDataType(dp.getDesignDataType()));
                param.setRequired(!dp.isAllowNull());
                param.setName(dp.getName());
                param.setState(ExtFilterParamUtil.translateState(dp.getInputState()));
                param.setText(easLocale == null ? dp.getAliasName() : dp.getAliasName(easLocale));
                ExtFilterParamUtil.translateCtrlType(easCtx, dp, param, reportId, true, paramAdapter);
                paramList.add(param);
            }
        }
        return paramList;
    }

    public LinkModel chartInnerLink(Context ctx, LinkParamVo linkParam, String pageId, String currentSheetName) throws InnerLinkException {
        ReportPage page = (ReportPage)PageManager.getPage((String)pageId);
        if (page == null) {
            throw new InnerLinkException("\u62a5\u8868\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\uff01");
        }
        ExtReportImpl extReportImpl = (ExtReportImpl)((ExtReportPage)page).getExtReport();
        ReportImpl reportImpl = extReportImpl.getReport();
        Book book = reportImpl.getBook();
        return WebReportDomain.chartInnerLink(linkParam, currentSheetName, book, pageId, ctx);
    }

    public static LinkModel chartInnerLink(LinkParamVo linkParam, String currentSheetName, Book book, String pageId, Context ctx) throws InnerLinkException {
        String linkSrc = linkParam.getLinkSrc();
        linkSrc = Utils.decodeBase64((String)linkSrc);
        Sheet sheet = book.getSheet(currentSheetName);
        EmbedhLayer layer = sheet.getEmbedments(false);
        if (layer != null && layer.size() != 0) {
            ChartLinkRequestHandler.decodeChartParams((ChartDataItemInfo)linkParam);
            ChartRectEmbedment fChart = null;
            EmbedhLayer.EmbedIterator iter = layer.getIterator(true);
            while (iter.hasNext()) {
                EmbedObject embed = iter.next();
                if (!(embed instanceof ChartRectEmbedment) || !embed.getName().equals(linkSrc)) continue;
                fChart = (ChartRectEmbedment)embed;
                break;
            }
            if (fChart != null) {
                ChartInnerLinkWebExec linkExec = new ChartInnerLinkWebExec(book, pageId, fChart.getModel(), ctx);
                linkExec.setDataItemInfo(linkParam);
                return linkExec.execute();
            }
            throw new InnerLinkException("\u672a\u627e\u5230\u5f53\u524d\u56fe\u8868[" + linkSrc + "]!");
        }
        throw new InnerLinkException("\u672a\u627e\u5230\u5f53\u524d\u56fe\u8868[" + linkSrc + "]!");
    }

    public LinkModel cellInnerLink(Context ctx, String pageId, String currentSheetName, String linkSrc) throws InnerLinkException {
        ReportPage page = (ReportPage)PageManager.getPage((String)pageId);
        if (page == null) {
            throw new InnerLinkException("\u62a5\u8868\u4f1a\u8bdd\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u62a5\u8868\uff01");
        }
        ExtReportImpl extReportImpl = (ExtReportImpl)((ExtReportPage)page).getExtReport();
        ReportImpl reportImpl = extReportImpl.getReport();
        Book book = reportImpl.getBook();
        LinkParamVo linkParam = new LinkParamVo();
        linkParam.setLinkSrc(linkSrc);
        return WebReportDomain.cellInnerLink(linkParam, currentSheetName, book, pageId, ctx);
    }

    public static LinkModel cellInnerLink(LinkParamVo linkParam, String currentSheetName, Book book, String pageId, Context ctx) throws InnerLinkException {
        String linkSrc = linkParam.getLinkSrc();
        String[] arrName = linkSrc.split("!");
        if (arrName == null || arrName.length != 2) {
            throw new InnerLinkException("\u672a\u80fd\u6b63\u786e\u89e3\u6790\u5f53\u524d\u5355\u5143\u683c[" + linkSrc + "]!");
        }
        String cellName = arrName[1];
        Sheet sheet = book.getSheet(currentSheetName);
        Cell cell = ((CellBlockNode)sheet.getRange(cellName).getBlock(0)).getFirstCell(false);
        if (cell == null) {
            throw new InnerLinkException("\u672a\u80fd\u6b63\u786e\u89e3\u6790\u5f53\u524d\u5355\u5143\u683c[" + cellName + "]!");
        }
        HyperlinkCalculableProps hyperLinkCalProps = ReportBookHelper.getHyperLink(cell);
        if (hyperLinkCalProps != null) {
            HashMap tars = hyperLinkCalProps.getTargets();
            InnerLinkTargets innerTars = (InnerLinkTargets)tars.get("EXT_INNER");
            CellInnerLinkWebExec executor = new CellInnerLinkWebExec(book, pageId, ctx);
            executor.setCell(cell);
            executor.setInnerLinkTargets(innerTars);
            return executor.execute();
        }
        throw new InnerLinkException("\u672a\u627e\u5230\u5f53\u524d\u5355\u5143\u683c\u9700\u8981\u8054\u52a8\u7684\u76ee\u6807\uff01");
    }

    public String getSecretKey() throws BIReportException, JSONException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("secretKey", SecretKeyUtil.getInstance().getSecretKey());
        return new JSONObject(result).toString();
    }
}

