/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.web.bhv;

import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.ViewSplitInfo;
import com.kingdee.eas.rpts.web.bhv.OutputTableBhv;
import com.kingdee.eas.rpts.web.man.ReportImpl;
import com.kingdee.eas.rpts.web.man.SheetImpl;
import com.kingdee.eas.rpts.web.model.MergeBlock;
import com.kingdee.eas.rpts.web.param.IJsonMap;
import com.kingdee.eas.rpts.web.util.BeanFactory;
import com.kingdee.eas.rpts.web.util.StyleToCss;
import com.kingdee.eas.rpts.web.vo.SheetInfo;
import com.kingdee.eas.rpts.web.vo.TableInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class OutputSheetBhv {
    public SheetInfo behaviour(ReportImpl report, IJsonMap json) {
        Object resized;
        String sheetName = (String)json.get("sheetName");
        SheetImpl sheetModel = report.getSheet(sheetName);
        if (report.isbMobile()) {
            sheetModel.setStartRow(0);
            sheetModel.setEndRow(0);
        }
        Book book = report.getBook();
        report.setCurrentSheetName(sheetName);
        Sheet bookSheet = book.getSheet(sheetName);
        SheetInfo sheetInfo = new SheetInfo();
        List<MergeBlock> mergeBlocks = this.outputMergeBlocks(bookSheet);
        this.setPageContext(mergeBlocks, sheetModel, bookSheet);
        OutputTableBhv outputTableBhv = BeanFactory.outputTableBhv();
        TableInfo table = outputTableBhv.behaviour(report);
        sheetInfo.setTableFragment(table);
        sheetInfo.setName(sheetName);
        sheetInfo.setTableStyle(StyleToCss.getCssStyle(bookSheet.getStyle()));
        sheetInfo.setTableBorder(StyleToCss.getCssBorder(bookSheet.getStyle()));
        ViewSplitInfo splitInfo = bookSheet.getSheetOption().getViewSplitInfo();
        boolean hasHeader = splitInfo.isFreezed();
        if (hasHeader) {
            sheetInfo.setHeader(splitInfo.getRowSplit(), splitInfo.getColSplit());
        }
        if ((resized = bookSheet.getUserObjectValue("resizedInRuntime")) != null && new Boolean((String)resized).booleanValue()) {
            sheetInfo.setResized(true);
        }
        SortedAttributeSpanArray rowSpans = bookSheet.getRowSpans();
        HashSet<Integer> hideRow = new HashSet<Integer>();
        int length = sheetModel.getRowCount();
        block0: for (int i = 0; i < length; ++i) {
            for (int j = 0; j < rowSpans.size(); ++j) {
                SortedAttributeSpanArray.AttributeSpan span = rowSpans.getAttributeSpan(j);
                if (!span.contains(i) || span.isVisible()) continue;
                hideRow.add(i);
                continue block0;
            }
        }
        sheetInfo.setTableHiddenRowCount(hideRow.size());
        sheetInfo.setTableRowCount(sheetModel.getRowCount());
        sheetInfo.setMergeBlocks(mergeBlocks);
        sheetInfo.setTree(sheetModel.isTree());
        return sheetInfo;
    }

    private List<MergeBlock> outputMergeBlocks(Sheet bookSheet) {
        ArrayList<MergeBlock> mergeBlockList = new ArrayList<MergeBlock>();
        MergeBlocks mergeBlocks = bookSheet.getMerger(false);
        if (mergeBlocks != null) {
            for (int i = 0; i < mergeBlocks.size(); ++i) {
                CellBlock cellBlock = mergeBlocks.getBlock(i);
                MergeBlock mergeBlock = new MergeBlock();
                mergeBlock.setRowFrom(cellBlock.getRow());
                mergeBlock.setRowTo(cellBlock.getRow2());
                mergeBlock.setColFrom(cellBlock.getCol());
                mergeBlock.setColTo(cellBlock.getCol2());
                mergeBlockList.add(mergeBlock);
            }
        }
        return mergeBlockList;
    }

    private void setPageContext(List<MergeBlock> mergeBlocks, SheetImpl sheetModel, Sheet sheet) {
        int[] array = sheet.getMaxColAndRowIndex(false);
        int colMax = array[1];
        int rowMax = array[0];
        sheetModel.setRowCount(rowMax + 1);
        sheetModel.setColCount(colMax + 1);
    }
}

