/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.web.bhv;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Row;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.eas.rpts.web.man.ReportImpl;
import com.kingdee.eas.rpts.web.man.SheetImpl;
import com.kingdee.eas.rpts.web.model.CellModel;
import com.kingdee.eas.rpts.web.model.RowModel;
import com.kingdee.eas.rpts.web.util.BeanFactory;
import com.kingdee.eas.rpts.web.util.ReportBookHelper;
import com.kingdee.eas.rpts.web.util.StyleToCss;
import com.kingdee.eas.rpts.web.vo.TableInfo;
import java.util.ArrayList;
import java.util.List;

public class OutputTableTreeBhv {
    public TableInfo behaviour(ReportImpl report, int rowIdx, int level) {
        Book book = report.getBook();
        SheetImpl sheetModel = report.getCurrentSheet();
        Sheet bookSheet = book.getSheet(sheetModel.getSheetName());
        Context ctx = report.getContext();
        TableInfo fragment = this.outputTableTree(sheetModel, bookSheet, ctx, rowIdx, level);
        fragment.setBorderStyleMap(BeanFactory.getStyleMap().getBorderStyleMap());
        fragment.setStyleMap(BeanFactory.getStyleMap().getStyleMap());
        BeanFactory.clearStyles();
        return fragment;
    }

    private TableInfo outputTableTree(SheetImpl sheetModel, Sheet sheet, Context ctx, int rowIdx, int level) {
        int rowCount = sheetModel.getRowCount();
        int colCount = sheetModel.getColCount();
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        TableInfo tableFragment = new TableInfo();
        ArrayList<RowModel> rowList = new ArrayList<RowModel>();
        for (int i = rowIdx; i < rowCount; ++i) {
            int[] type = sheetModel.displayType(i);
            if (type[1] > level) continue;
            if (type[1] < level) break;
            RowModel row = new RowModel();
            Row bookRow = sheet.getRow(i, false);
            if (bookRow != null) {
                int spanIdx = rowSpans.searchSpan(i);
                if (spanIdx >= 0) {
                    SortedAttributeSpanArray.AttributeSpan span = (SortedAttributeSpanArray.AttributeSpan)rowSpans.getSpan(spanIdx);
                    row.setHeight(span.getLength() + 1);
                    row.setStyle(StyleToCss.getCssStyle(span.getStyle()));
                    row.setBorder(StyleToCss.getCssBorder(span.getStyle()));
                } else {
                    row.setHeight(sheet.getDefRowHeight() + 1);
                }
                List<CellModel> cellList = ReportBookHelper.buildCell(bookRow, colCount, sheetModel, tableFragment, ctx, sheet);
                row.setCellList(cellList);
            } else {
                row.setHeight(sheet.getDefRowHeight() + 1);
            }
            row.setIndex(i);
            rowList.add(row);
        }
        tableFragment.setRowList(rowList);
        return tableFragment;
    }
}

