/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.wrapper;

import com.kingdee.bos.BOSClassNotFoundException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.MissingMetaDataException;
import com.kingdee.bos.ReflectException;
import com.kingdee.bos.framework.BOProxy;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.AccessLevel;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.TransactionAttribute;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.FunctionObjectCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceExecutionException;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.rpc.ObjectFactory;
import com.kingdee.exception.FriendlyBOSException;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class FacadeInvoke {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.service.job.wrapper.FacadeInvoke");

    private FacadeInvoke() {
    }

    public static Object localInvoke(Context ctx, IMetaDataPK pk, String methodName, Object[] args) throws BOSException {
        return FacadeInvoke.localInvoke(ctx, pk, methodName, args, false);
    }

    public static Object localInvoke(Context ctx, IMetaDataPK pk, String methodName, Object[] args, boolean isHandleEvent) throws BOSException {
        return FacadeInvoke.innerLocalInvoke(ctx, pk, methodName, args, isHandleEvent, true);
    }

    public static Object localInvokeNoProxy(Context ctx, IMetaDataPK pk, String methodName, Object[] args) throws BOSException {
        return FacadeInvoke.innerLocalInvoke(ctx, pk, methodName, args, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object innerLocalInvoke(Context ctx, IMetaDataPK pk, String methodName, Object[] args, boolean isHandleEvent, boolean useProxy) throws BOSException {
        if (ctx == null) throw new IllegalArgumentException("Parameters error!");
        if (pk == null) throw new IllegalArgumentException("Parameters error!");
        if (args == null) {
            throw new IllegalArgumentException("Parameters error!");
        }
        boolean controllerBeanInvoke = false;
        Class[] parameterTypes = null;
        try {
            FacadeInfo facade = FacadeInvoke.getFacade(ctx, pk);
            BOSObjectType bosType = facade.getType();
            HashMap<String, Object> hashMap = FacadeInvoke.getFacadeMap(ctx, bosType, facade, methodName, args);
            MethodInfo method = (MethodInfo)hashMap.get("method");
            Class[] argsClasses = parameterTypes = (Class[])hashMap.get("parameterTypes");
            Object[] argsValues = args;
            if (controllerBeanInvoke) {
                argsClasses = new Class[parameterTypes.length + 1];
                argsValues = new Object[args.length + 1];
                argsClasses[0] = Context.class;
                if (parameterTypes.length > 0) {
                    System.arraycopy(parameterTypes, 0, argsClasses, 1, parameterTypes.length);
                }
                if (ctx != null) {
                    ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                }
                argsValues[0] = ctx;
                if (args.length > 0) {
                    System.arraycopy(args, 0, argsValues, 1, args.length);
                }
            }
            if (argsClasses != null && argsValues != null && argsClasses.length != argsValues.length) {
                FriendlyBOSException exception = new FriendlyBOSException("BOSFramework_invokeFunction_paramSizeNotMatched", null, null);
                exception.addArg(facade.getAlias());
                exception.addArg(facade.getFullName());
                exception.addArg(methodName);
                throw exception;
            }
            if (!isHandleEvent) {
                WfEventListenerStateManager.getInstance().disableEventListener();
            }
            IBOSObject obj = null;
            Method runMethod = null;
            try {
                obj = BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
                runMethod = FacadeInvoke.getMethod(obj, methodName, argsClasses);
            }
            catch (Exception e) {
                BOProxy bop = BOProxy.getProxy((Context)ctx, (BOSObjectType)bosType);
                try {
                    Object object = bop.callCmethod(method, args);
                    return object;
                }
                catch (Throwable e1) {
                    throw new BOSException(e1);
                }
                finally {
                    WfEventListenerStateManager.getInstance().enableEventListener();
                }
            }
            Object returnObj = null;
            try {
                returnObj = TransactionAttribute.REQUIRED.equals((Object)method.getTransactionAttribute()) || TransactionAttribute.REQUIRESNEW.equals((Object)method.getTransactionAttribute()) ? ObjectFactory.invokeRequired((Object)obj, (Method)runMethod, (Object[])argsValues) : runMethod.invoke((Object)obj, argsValues);
            }
            finally {
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
            if (returnObj == null) return null;
            return returnObj;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectException((Throwable)illegalAccessException);
        }
        catch (ClassNotFoundException e) {
            throw new BOSClassNotFoundException((Throwable)e);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable e = invocationTargetException.getTargetException();
            if (!(e instanceof BOSException)) throw new BOSException(e);
            throw (BOSException)e;
        }
    }

    private static HashMap<String, Object> getFacadeMap(Context ctx, BOSObjectType bosType, FacadeInfo facade, String methodName, Object[] args) throws BOSException, ClassNotFoundException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (facade == null) {
            throw new IllegalArgumentException(facade + " is null!");
        }
        MethodCollection methodCol = facade.getMethods();
        MethodInfo oper = null;
        if (methodCol != null) {
            int length = methodCol.size();
            for (int i = 0; i < length; ++i) {
                MethodInfo methodInfo;
                Class[] parameterTypes;
                if (!StringUtils.equalsIgnoreCase((String)methodCol.get(i).getName(), (String)methodName) || args.length != (parameterTypes = FacadeInvoke.getParameterTypes(ctx, bosType, methodInfo = methodCol.get(i), methodName)).length) continue;
                boolean b = true;
                for (int j = 0; j < args.length; ++j) {
                    if (!args[j].getClass().getName().equals(parameterTypes.getClass().getName())) continue;
                    b = false;
                    break;
                }
                if (!b) continue;
                oper = methodInfo;
                hashMap.put("method", methodInfo);
                hashMap.put("parameterTypes", parameterTypes);
                break;
            }
            if (oper == null) {
                FriendlyBOSException exception = new FriendlyBOSException("BOSFramework_invokeFunction_operationNotFound", null, null);
                exception.addArg(facade.getAlias());
                exception.addArg(facade.getFullName());
                exception.addArg(methodName);
                throw exception;
            }
        } else if (oper == null) {
            FriendlyBOSException exception = new FriendlyBOSException("BOSFramework_invokeFunction_operationNotFound", null, null);
            exception.addArg(facade.getAlias());
            exception.addArg(facade.getFullName());
            exception.addArg(methodName);
            throw exception;
        }
        return hashMap;
    }

    private static String getEntityOjbectByParam(Context ctx, ParameterInfo param) throws BOSException {
        String metaRef = param.getMetaDataRef();
        String metaPack = metaRef.substring(0, metaRef.lastIndexOf(46));
        String metaName = metaRef.substring(metaRef.lastIndexOf(46) + 1);
        MetaDataPK metaPK = new MetaDataPK(metaPack, metaName);
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)metaPK);
        String objValueClassName = entity.getBusinessImplName() + "Info";
        return objValueClassName;
    }

    private static Class getObjectCollectionClazzByParam(Context ctx, ParameterInfo param) throws ClassNotFoundException {
        String metaRef = param.getMetaDataRef();
        String metaPack = metaRef.substring(0, metaRef.lastIndexOf(46));
        String metaName = metaRef.substring(metaRef.lastIndexOf(46) + 1);
        MetaDataPK metaPK = MetaDataPK.create((String)metaPack, (String)metaName);
        EntityObjectInfo entity = MetaDataLoader.getEntity((Context)ctx, (IMetaDataPK)metaPK);
        return entity.getObjectCollectionClazzRuntime();
    }

    public static Map getOperation(Context ctx, IMetaDataPK uiPK) throws BOSException {
        return FacadeInvoke.getOperation(ctx, uiPK, null);
    }

    public static Map getOperation(Context ctx, IMetaDataPK uiPK, String actionName) throws BOSException {
        if (uiPK == null) {
            throw new IllegalArgumentException("Parameter error!");
        }
        FunctionObjectCollection funcCol = FacadeInvoke.getRemoteFunctionRef(ctx, uiPK, MetaDataTypeList.UIOBJECT);
        if (funcCol == null) {
            throw new MissingMetaDataException("Get FunctionObject Collection error!");
        }
        Hashtable<String, OperationInfo> map = new Hashtable<String, OperationInfo>();
        int lengthFunc = funcCol.size();
        for (int i = 0; i < lengthFunc; ++i) {
            FunctionObjectInfo function = funcCol.get(i);
            OperationCollection operCol = function.getOperation();
            int lengthOper = operCol.size();
            for (int j = 0; j < lengthOper; ++j) {
                OperationInfo oper = operCol.get(j);
                if (actionName == null) {
                    map.put(function.toString() + "-" + j, oper);
                    continue;
                }
                if (oper.getUiActionRef() == null || !StringUtils.equalsIgnoreCase((String)oper.getUiActionRef().getActionRefName(), (String)actionName)) continue;
                map.put(function.toString() + "-" + oper.getUiActionRef().getUIStatus(), oper);
            }
        }
        return map;
    }

    public static FunctionObjectCollection getRemoteFunctionRef(Context ctx, IMetaDataPK refPK, BOSObjectType bosType) throws BOSException {
        if (refPK == null) {
            throw new IllegalArgumentException("Parameter error! refPK is null.");
        }
        FunctionObjectInfo function = null;
        FunctionObjectCollection reFuncCol = new FunctionObjectCollection();
        FunctionObjectCollection funcCol = FacadeInvoke.getFunctions(ctx);
        int length = funcCol.size();
        for (int i = 0; i < length; ++i) {
            function = funcCol.get(i);
            OperationCollection opers = function.getOperation();
            for (int j = 0; j < opers.size(); ++j) {
                OperationInfo oper = opers.get(j);
                if (oper == null) {
                    logger.error((Object)("ERROR:operation is null. function :" + function.getName()));
                    continue;
                }
                if (bosType == MetaDataTypeList.ENTITY && oper.getEntityObjectRef() != null) {
                    if (!StringUtils.equalsIgnoreCase((String)(oper.getEntityObjectRef().getPackage() + "." + oper.getEntityObjectRef().getName()), (String)(refPK.getPackage() + "." + refPK.getName()))) continue;
                    reFuncCol.add(function);
                    continue;
                }
                if (bosType == MetaDataTypeList.FACADE && oper.getFacadeObjectRef() != null) {
                    if (!StringUtils.equalsIgnoreCase((String)(oper.getFacadeObjectRef().getPackage() + "." + oper.getFacadeObjectRef().getName()), (String)(refPK.getPackage() + "." + refPK.getName()))) continue;
                    reFuncCol.add(function);
                    continue;
                }
                if (bosType != MetaDataTypeList.UIOBJECT || oper.getUiActionRef() == null) continue;
                UIObjectInfo uiObjectInfo = oper.getUiActionRef().getUIObjectRef();
                if (uiObjectInfo == null) {
                    logger.error((Object)("UIObject not found! Please check Function[" + function.getFullName() + "] 's UIAction [" + oper.getUiActionRef().getActionRefName() + "]."));
                    continue;
                }
                if (!StringUtils.equalsIgnoreCase((String)(uiObjectInfo.getPackage() + "." + uiObjectInfo.getName()), (String)(refPK.getPackage() + "." + refPK.getName()))) continue;
                reFuncCol.add(function);
            }
        }
        if (reFuncCol.size() == 0) {
            throw new MissingMetaDataException("Error! Don't Found MetaData Object: " + refPK.getPackage() + "." + refPK.getName());
        }
        return reFuncCol;
    }

    private static OperationInfo getOperation(FunctionObjectInfo function, String operationName) throws BOSException {
        if (function == null) {
            throw new IllegalArgumentException(function + " is null!");
        }
        OperationCollection operCol = function.getOperation();
        OperationInfo oper = null;
        if (operCol != null) {
            int length = operCol.size();
            for (int i = 0; i < length; ++i) {
                if (!StringUtils.equalsIgnoreCase((String)operCol.get(i).getName(), (String)operationName)) continue;
                oper = operCol.get(i);
                break;
            }
            if (oper == null) {
                FriendlyBOSException exception = new FriendlyBOSException("BOSFramework_invokeFunction_operationNotFound", null, null);
                exception.addArg(function.getAlias());
                exception.addArg(function.getFullName());
                exception.addArg(operationName);
                throw exception;
            }
        } else if (oper == null) {
            FriendlyBOSException exception = new FriendlyBOSException("BOSFramework_invokeFunction_operationNotFound", null, null);
            exception.addArg(function.getAlias());
            exception.addArg(function.getFullName());
            exception.addArg(operationName);
            throw exception;
        }
        return oper;
    }

    private static MethodInfo getFacadeMehod(FacadeInfo facade, String methodName) throws BOSException {
        if (facade == null) {
            throw new IllegalArgumentException(facade + " is null!");
        }
        MethodCollection methodCol = facade.getMethods();
        MethodInfo oper = null;
        if (methodCol != null) {
            int length = methodCol.size();
            for (int i = 0; i < length; ++i) {
                if (!StringUtils.equalsIgnoreCase((String)methodCol.get(i).getName(), (String)methodName)) continue;
                oper = methodCol.get(i);
                break;
            }
            if (oper == null) {
                FriendlyBOSException exception = new FriendlyBOSException("BOSFramework_invokeFunction_operationNotFound", null, null);
                exception.addArg(facade.getAlias());
                exception.addArg(facade.getFullName());
                exception.addArg(methodName);
                throw exception;
            }
        } else if (oper == null) {
            FriendlyBOSException exception = new FriendlyBOSException("BOSFramework_invokeFunction_operationNotFound", null, null);
            exception.addArg(facade.getAlias());
            exception.addArg(facade.getFullName());
            exception.addArg(methodName);
            throw exception;
        }
        return oper;
    }

    private static Class[] getParameterTypes(Context ctx, BOSObjectType bosType, MethodInfo method, String methodName) throws BOSException, ClassNotFoundException {
        String methodInnerId;
        Class[] parameterTypes = null;
        BusinessObjectInfo boInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getBusinessObject(bosType);
        method = boInfo.getInheritedMethodByID(methodInnerId = method.getInnerID());
        if (method.getAccessLevel() == AccessLevel.PUBLIC) {
            methodName = method.getName();
            ParameterCollection paramCol = method.getParameters();
            parameterTypes = new Class[paramCol.size()];
            int length = paramCol.size();
            for (int i = 0; i < length; ++i) {
                Class paramClass;
                ParameterInfo param = paramCol.get(i);
                String temp = param.getDataType();
                if (temp.trim().equalsIgnoreCase(DataType.OBJECTVALUE.toString())) {
                    Class<?> c;
                    String objValueClassName = FacadeInvoke.getEntityOjbectByParam(ctx, param);
                    parameterTypes[i] = c = Class.forName(objValueClassName);
                    continue;
                }
                if (temp.trim().equalsIgnoreCase(DataType.OBJECTCOLLECTION.toString())) {
                    try {
                        parameterTypes[i] = FacadeInvoke.getObjectCollectionClazzByParam(ctx, param);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new BOSClassNotFoundException("Get param data type error.", (Throwable)e);
                    }
                }
                if (temp.trim().equalsIgnoreCase(DataType.ENUM.toString())) {
                    if (!StringUtils.isEmpty((String)param.getMetaDataRef())) {
                        try {
                            parameterTypes[i] = Class.forName(param.getMetaDataRef());
                            continue;
                        }
                        catch (ClassNotFoundException e) {
                            throw new BOSClassNotFoundException("Get param data type error.", (Throwable)e);
                        }
                    }
                    parameterTypes[i] = ObjectUtils.getArgumentTypeClass((String)temp);
                    continue;
                }
                parameterTypes[i] = paramClass = ObjectUtils.getArgumentTypeClass((String)temp);
            }
        }
        return parameterTypes;
    }

    private static Method getMethod(Object obj, String methodName, Class[] parameterTypes) throws BOSException {
        if (obj == null || parameterTypes == null) {
            throw new IllegalArgumentException("Parameters error!");
        }
        try {
            return obj.getClass().getMethod(methodName, parameterTypes);
        }
        catch (SecurityException securityException) {
            throw new ReflectException((Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectException((Throwable)noSuchMethodException);
        }
    }

    private static BusinessObjectInfo getBO(Context ctx, IMetaDataPK pk, String operationName) throws BOSException {
        if (ctx == null || pk == null) {
            throw new IllegalArgumentException();
        }
        Object bo = null;
        FunctionObjectInfo function = FacadeInvoke.getFunction(ctx, pk);
        if (function == null) {
            FriendlyBOSException exception = new FriendlyBOSException("BOSFramework_invokeFunction_functionNotFound", null, null);
            exception.addArg(function.getAlias());
            exception.addArg(pk.getFullName());
            throw exception;
        }
        OperationInfo operation = FacadeInvoke.getOperation(function, operationName);
        if (operation != null) {
            bo = operation.getFacadeObjectRef() != null ? operation.getFacadeObjectRef() : operation.getEntityObjectRef();
        } else {
            FriendlyBOSException exception = new FriendlyBOSException("BOSFramework_invokeFunction_operationNotFound", null, null);
            exception.addArg(function.getAlias());
            exception.addArg(pk.getFullName());
            exception.addArg(operationName);
            throw exception;
        }
        if (bo == null) {
            FriendlyBOSException exception = new FriendlyBOSException("BOSFramework_invokeFunction_boNotFound", null, null);
            exception.addArg(function.getAlias());
            exception.addArg(pk.getFullName());
            exception.addArg(operation.getAlias());
            exception.addArg(operationName);
            throw exception;
        }
        return bo;
    }

    public static FunctionObjectInfo getFunction(Context ctx, IMetaDataPK pk) throws BOSException {
        return MetaDataLoader.getFunction((Context)ctx, (IMetaDataPK)pk);
    }

    public static FacadeInfo getFacade(Context ctx, IMetaDataPK pk) throws BOSException {
        return MetaDataLoader.getFacade((Context)ctx, (IMetaDataPK)pk);
    }

    private static FunctionObjectCollection getFunctions(Context ctx) throws BOSException {
        return MetaDataLoader.getFunctions((Context)ctx);
    }

    protected static ServiceContext createServiceContext(BusinessObjectInfo boInfo, IMetaDataPK methodPK, Object[] params) {
        return new ServiceContext(boInfo.getType(), boInfo.getBOSType(), methodPK, params);
    }

    protected static void invokeServiceBefore(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(0);
        ServiceStateManager.ServiceState state = new ServiceStateManager.ServiceState();
        state.enableSpecialService("PERMISSION_SERVICE");
        ServiceStateManager.getInstance().setServiceState(state);
        ServiceManagerFactory.getServiceManager().execute((IServiceContext)svcCtx);
    }

    protected static void invokeServiceAfter(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(1);
        ServiceManagerFactory.getServiceManager().execute((IServiceContext)svcCtx);
    }
}

