/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.util.Heap;
import com.kingdee.bos.service.job.util.IHeapElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class WaitingJobs {
    private static Heap jobs = new Heap();

    public static boolean in(Job job) {
        if (job.setState(JobState.Waiting)) {
            return WaitingJobs.innerIn(job);
        }
        return false;
    }

    private static synchronized boolean innerIn(Job job) {
        boolean b = jobs.push(new Item(job));
        WaitingJobs.class.notifyAll();
        return b;
    }

    static synchronized Job out() {
        Item item;
        while (true) {
            if (jobs.size() == 0) {
                try {
                    WaitingJobs.class.wait(5000L);
                }
                catch (Throwable throwable) {}
                continue;
            }
            item = (Item)jobs.top();
            long diff = item.job.getScheduledTime().getTime() - System.currentTimeMillis();
            if (diff <= 0L) break;
            try {
                if (diff > 5000L) {
                    diff = 5000L;
                }
                WaitingJobs.class.wait(diff);
            }
            catch (Throwable throwable) {}
        }
        item = (Item)jobs.pop();
        return item.job;
    }

    static synchronized Job get(String key) {
        Item item = (Item)jobs.get(key);
        return item != null ? item.job : null;
    }

    static synchronized Job remove(String key) {
        Item item = (Item)jobs.remove(key);
        return item != null ? item.job : null;
    }

    static synchronized String dump() {
        ArrayList list = jobs.toArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            Item item = (Item)list.get(i);
            Job job = item.job;
            sb.append(i + 1).append(".  ");
            String title = job.getTitle();
            if (title == null) {
                title = job.getHandler().getClass().getName();
                int j = title.lastIndexOf(46);
                title = title.substring(j + 1);
            }
            sb.append(title);
            sb.append("; ");
            if (job.getContext() != null) {
                sb.append("{").append(job.getContext().getAIS()).append("} ");
            }
            sb.append(job.getScheduledTime());
            sb.append(",");
            sb.append(job.getState());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static synchronized int size() {
        return jobs.size();
    }

    public static synchronized List getAllJobs() {
        ArrayList list = jobs.toArray();
        ArrayList ret = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Item item = (Item)list.get(i);
            Job job = item.job;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", job.getId());
            String title = job.getTitle();
            if (title == null) {
                title = job.getHandler().getClass().getName();
                int j = title.lastIndexOf(46);
                title = title.substring(j + 1);
            }
            map.put("title", title);
            map.put("handler", job.getHandler() == null ? null : job.getHandler().toString());
            map.put("createdTime", job.getCreatedTime());
            map.put("finishTime", job.getFinishTime());
            map.put("scheduledTime", job.getScheduledTime());
            map.put("state", job.getState().toString());
            map.put("priotity", job.getPriority());
            ret.add(map);
        }
        return ret;
    }

    public static synchronized Collection<String> getJobIds() {
        ArrayList<String> list = new ArrayList<String>(WaitingJobs.size());
        for (Object o : jobs.toArray()) {
            Job job = ((Item)o).job;
            list.add(job.getId());
        }
        return list;
    }

    private static class Item
    implements IHeapElement {
        Job job;

        Item(Job job) {
            this.job = job;
        }

        @Override
        public String getKey() {
            return this.job.getKey();
        }

        @Override
        public long getPriority() {
            return this.job.getScheduledTime().getTime();
        }

        public String toString() {
            return this.job.toString();
        }
    }
}

