/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.core;

import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.service.job.util.Heap;
import com.kingdee.bos.service.job.util.IHeapElement;
import java.util.ArrayList;

class WaitingJobsBak {
    private static Heap jobs = new Heap();

    WaitingJobsBak() {
    }

    static boolean in(Job job) {
        if (job.setState(JobState.Waiting)) {
            return WaitingJobsBak.innerIn(job);
        }
        return false;
    }

    private static synchronized boolean innerIn(Job job) {
        boolean b = jobs.push(new Item(job));
        WaitingJobsBak.class.notifyAll();
        return b;
    }

    static synchronized Job out() {
        Item item;
        while (jobs.size() == 0) {
            try {
                WaitingJobsBak.class.wait(1000L);
            }
            catch (Throwable throwable) {}
        }
        while (true) {
            item = (Item)jobs.top();
            long diff = item.job.getScheduledTime().getTime() - System.currentTimeMillis();
            if (diff <= 0L) break;
            try {
                WaitingJobsBak.class.wait(diff);
            }
            catch (Throwable throwable) {}
        }
        item = (Item)jobs.pop();
        return item.job;
    }

    static synchronized Job get(String key) {
        Item item = (Item)jobs.get(key);
        return item != null ? item.job : null;
    }

    static synchronized Job remove(String key) {
        Item item = (Item)jobs.remove(key);
        return item != null ? item.job : null;
    }

    static synchronized String dump() {
        ArrayList list = jobs.toArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            Item item = (Item)list.get(i);
            Job job = item.job;
            sb.append(i + 1).append(".  ");
            String title = job.getTitle();
            if (title == null) {
                title = job.getHandler().getClass().getName();
                int j = title.lastIndexOf(46);
                title = title.substring(j + 1);
            }
            sb.append(title);
            sb.append("; ");
            if (job.getContext() != null) {
                sb.append("{").append(job.getContext().getAIS()).append("} ");
            }
            sb.append(job.getScheduledTime());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    static synchronized int size() {
        return jobs.size();
    }

    private static class Item
    implements IHeapElement {
        Job job;

        Item(Job job) {
            this.job = job;
        }

        @Override
        public String getKey() {
            return this.job.getKey();
        }

        @Override
        public long getPriority() {
            return this.job.getScheduledTime().getTime();
        }

        public String toString() {
            return this.job.toString();
        }
    }
}

