/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.job.ext;

import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.IServiceInstanceIdGenerator;
import com.kingdee.bos.service.job.util.Config;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.util.IPUtils;
import com.kingdee.util.StringUtils;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.Properties;
import java.util.zip.CRC32;
import org.apache.log4j.Logger;

public class DefaultInstanceIdGenerator
implements IServiceInstanceIdGenerator {
    public static final Logger logger = Logger.getLogger(DefaultInstanceIdGenerator.class);
    private String instanceId = null;
    private String hostName = null;
    private String addresses = null;
    private String serverId = null;
    private String newServerId = null;
    private String eas = null;

    @Override
    public String getInstanceId() {
        if (this.instanceId == null) {
            String eas = this.getEasInstanceName();
            this.instanceId = eas + "@" + this.getServerId() + ":" + ORMRPConfig.getTcpConnectionPort();
        }
        return this.instanceId;
    }

    @Override
    public String getOldInstanceId() {
        if (this.instanceId == null) {
            String eas = this.getEasInstanceName();
            this.instanceId = eas + "@" + this.getOldServerId() + ":" + ORMRPConfig.getTcpConnectionPort();
        }
        return this.instanceId;
    }

    @Override
    public String getRPCInstanceId() {
        if (this.instanceId == null) {
            String eas = this.getEasInstanceName();
            this.instanceId = eas + "@" + this.getOldServerId() + ":" + ORMRPConfig.getTcpConnectionPort();
        }
        return this.instanceId;
    }

    @Override
    public String getLocalHostName() {
        if (this.hostName == null) {
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                this.hostName = this.getServerId();
            }
        }
        return this.hostName;
    }

    @Override
    public String getLocalIpAddresses() {
        if (this.addresses == null) {
            String[] addresses = Config.getLocalAddresses();
            if (addresses.length == 0) {
                this.addresses = "local";
            } else {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < addresses.length; ++i) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(addresses[i]);
                }
                this.addresses = sb.toString();
            }
        }
        return this.addresses;
    }

    @Override
    public String getOldNewServerId() {
        if (this.newServerId == null) {
            String serverId = this.getOldServerId();
            String propertydir = System.getProperty("eas.properties.dir");
            CRC32 crc = new CRC32();
            crc.update(propertydir.getBytes());
            String hexStr = Long.toHexString(crc.getValue());
            this.newServerId = serverId + "|" + hexStr;
        }
        return this.newServerId;
    }

    @Override
    public String getNewServerId() {
        if (this.newServerId == null) {
            String serverId = this.getServerId();
            String propertydir = System.getProperty("eas.properties.dir");
            CRC32 crc = new CRC32();
            crc.update(propertydir.getBytes());
            String hexStr = Long.toHexString(crc.getValue());
            this.newServerId = serverId + "|" + hexStr;
        }
        return this.newServerId;
    }

    @Override
    public String getRPCNewServerId() {
        if (this.newServerId == null) {
            String serverId = this.getServerId();
            String propertydir = System.getProperty("eas.properties.dir");
            CRC32 crc = new CRC32();
            crc.update(propertydir.getBytes());
            String hexStr = Long.toHexString(crc.getValue());
            this.newServerId = serverId + "|" + hexStr;
        }
        return this.newServerId;
    }

    @Override
    public String getOldServerId() {
        if (this.serverId == null) {
            this.serverId = Configuration.getLocalIP();
            if (this.serverId != null) {
                return this.serverId;
            }
            try {
                String[] addresses = Config.getLocalAddresses();
                this.serverId = addresses.length == 0 ? "local" : addresses[0];
            }
            catch (Throwable t) {
                this.serverId = "local-e";
            }
        }
        return this.serverId;
    }

    @Override
    public String getServerId() {
        if (this.serverId == null) {
            this.serverId = Configuration.getLocalIP();
            if (this.serverId != null) {
                return this.serverId;
            }
            try {
                this.serverId = LicenseSrvFactory.getInstance().getLicenseIP();
            }
            catch (Throwable e1) {
                logger.error((Object)"cannot get LicenseIP", e1);
            }
            try {
                if (StringUtils.isEmpty((String)this.serverId)) {
                    this.serverId = IPUtils.getLocleAddress().getHostAddress();
                }
            }
            catch (Throwable e2) {
                this.serverId = "local-e";
                logger.error((Object)"cannot serverId from LocleAddress", e2);
            }
        }
        return this.serverId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRPCServerId() {
        if (this.serverId == null) {
            this.serverId = Configuration.getLocalIP();
            if (this.serverId != null) {
                return this.serverId;
            }
            String config = System.getProperty("EAS_HOME") + "/server/cluster/ormrpc_loadbalance.properties";
            FileInputStream fs = null;
            try {
                fs = new FileInputStream(config);
                Properties props = new Properties();
                props.load(fs);
                String temp = props.getProperty("loadbalance", "false");
                if (ORMRPConfig.isTrue((String)temp)) {
                    this.serverId = props.getProperty("loadbalanceIP", IPUtils.getLocleAddress().getHostAddress());
                }
            }
            catch (Throwable e1) {
                logger.error((Object)("cannot load config file from [" + config + "]"), e1);
            }
            finally {
                try {
                    if (fs != null) {
                        fs.close();
                    }
                }
                catch (Exception props) {}
            }
            try {
                if (StringUtils.isEmpty((String)this.serverId)) {
                    this.serverId = IPUtils.getLocleAddress().getHostAddress();
                }
            }
            catch (Throwable e2) {
                this.serverId = "local-e";
                logger.error((Object)"cannot serverId from LocleAddress", e2);
            }
        }
        return this.serverId;
    }

    @Override
    public String getEasInstanceName() {
        if (this.eas == null) {
            try {
                this.eas = System.getProperty("EAS_INSTANCE_NAME");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.eas == null) {
                this.eas = "eas";
            }
        }
        return this.eas;
    }

    @Override
    public boolean isSameIp() {
        String licenseIp = this.getServerId();
        String netIp = this.getOldServerId();
        if (StringUtils.isEmpty((String)licenseIp) || StringUtils.isEmpty((String)netIp)) {
            return true;
        }
        return licenseIp.equals(netIp);
    }

    @Override
    public boolean isSameIpForRPC() {
        String licenseIp = this.getServerId();
        String RPCIp = this.getRPCServerId();
        if (StringUtils.isEmpty((String)licenseIp) || StringUtils.isEmpty((String)RPCIp)) {
            return true;
        }
        return licenseIp.equals(RPCIp);
    }
}

