/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.scheduler.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.Cache;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.scheduler.util.IWorkCalendar;
import com.kingdee.bos.service.scheduler.util.TimeSpan;
import com.kingdee.bos.service.scheduler.util.WorkCalendarSchema;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DefaultWorkCalendar
implements IWorkCalendar {
    public static final int DEFAULT_VALUE = 0;
    public static final int WORKDAY_VALUE = 1;
    public static final int HOLIDAY_VALUE = 2;
    public static final int RESTDAY_VALUE = 3;
    public static final int HALFWORKDAY_VALUE = 4;
    private static HashMap<String, Cache> caches = new HashMap();

    @Override
    public TimeSpan[] getWorkingTimes(Context ctx, String orgId, Date date) throws Exception {
        WorkCalendarSchema schema = DefaultWorkCalendar.getSchema(ctx, orgId);
        if (schema.getId() == null) {
            return this.getTimeSpanWithoutSchema(schema, date);
        }
        int dateType = this.getDateType(ctx, date, schema.getId());
        switch (dateType) {
            case 0: {
                return this.getTimeSpanWithoutSchema(schema, date);
            }
            case 4: {
                return this.getTimeSpan4HafWorkDay(schema, date);
            }
            case 2: 
            case 3: {
                return new TimeSpan[0];
            }
            case 1: {
                return this.generateTimeSpan4WorkDay(schema, date);
            }
        }
        throw new UnsupportedOperationException("{" + dateType + "} is illegal date type!");
    }

    @Override
    public WorkCalendarSchema getWorkCalendarSchema(Context ctx, String orgId) throws Exception {
        return DefaultWorkCalendar.getSchema(ctx, orgId);
    }

    private TimeSpan[] getTimeSpan4HafWorkDay(WorkCalendarSchema schema, Date datetime) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = df.format(datetime).substring(0, 10);
        Date am_start = df.parse(date + " " + schema.getAmStart());
        Date am_end = df.parse(date + " " + schema.getAmEnd());
        TimeSpan am = new TimeSpan(am_start, am_end);
        return new TimeSpan[]{am};
    }

    private int getDateType(Context ctx, Date date, String workCalendarId) throws Exception {
        Calendar c = this.setFirstMomentOfDay(date);
        Timestamp begin = new Timestamp(c.getTime().getTime());
        this.setLastMomentOfDay(c);
        Timestamp end = new Timestamp(c.getTime().getTime());
        String sql = "select fdatetype from T_WorkCalendarDayEntry where FWorkCanlendarID='" + workCalendarId + "' and FWorkDate >= ? and FWorkDate <= ?";
        ArrayList list = SQL.executeQuery(ctx, sql, new int[]{93, 93}, new Object[]{begin, end});
        if (list.size() == 0) {
            return 0;
        }
        String fdatetype = ((Map)list.get(0)).get("fdatetype").toString();
        return Integer.parseInt(fdatetype);
    }

    private void setLastMomentOfDay(Calendar c) {
        c.set(10, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 990);
    }

    private Calendar setFirstMomentOfDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c;
    }

    private TimeSpan[] getTimeSpanWithoutSchema(WorkCalendarSchema schema, Date datetime) throws Exception {
        if (schema.isWeekend(datetime)) {
            return new TimeSpan[0];
        }
        return this.generateTimeSpan4WorkDay(schema, datetime);
    }

    private TimeSpan[] generateTimeSpan4WorkDay(WorkCalendarSchema schema, Date datetime) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = df.format(datetime).substring(0, 10);
        Date am_start = df.parse(date + " " + schema.getAmStart());
        Date am_end = df.parse(date + " " + schema.getAmEnd());
        TimeSpan am = new TimeSpan(am_start, am_end);
        Date pm_start = df.parse(date + " " + schema.getPmStart());
        Date pm_end = df.parse(date + " " + schema.getPmEnd());
        TimeSpan pm = new TimeSpan(pm_start, pm_end);
        return new TimeSpan[]{am, pm};
    }

    private static WorkCalendarSchema getSchema(Context ctx, String orgId) throws Exception {
        Cache cache = DefaultWorkCalendar.getCache(ctx);
        WorkCalendarSchema schema = (WorkCalendarSchema)cache.getCachedObject(orgId);
        if (schema == null) {
            schema = DefaultWorkCalendar.loadSchema(ctx, orgId);
            cache.pushCachedObject(orgId, schema);
        }
        return schema;
    }

    private static WorkCalendarSchema loadSchema(Context ctx, String orgId) throws Exception {
        String longNumber = DefaultWorkCalendar.getOrgLongNumber(ctx, orgId);
        String sql = DefaultWorkCalendar.generateSql4WorkCalendar(longNumber);
        ArrayList result = SQL.executeQuery(ctx, sql);
        if (result.size() == 0) {
            throw new BOSException("\u7ec4\u7ec7\u7f16\u7801 \uff1a " + orgId + " \u4e0b\u6ca1\u6709\u5de5\u4f5c\u65e5\u5386 ");
        }
        return new WorkCalendarSchema((Map)result.get(0));
    }

    private static String generateSql4WorkCalendar(String longNumber) {
        StringBuffer org_numbers = new StringBuffer();
        for (String number : longNumber.split("!")) {
            if (org_numbers.length() > 0) {
                org_numbers.append(",");
            }
            org_numbers.append("'").append(number).append("'");
        }
        String sql = "select top 1 a.fid as fid, fdefaultweekend,a.fbegintimeam,a.fendtimeam,fbegintimepm,fendtimepm from T_WorkCalendar a, T_Org_Admin b where a.FOrgUnitID = b.fid and b.fnumber in (" + org_numbers + ") order by b.FLongNumber desc";
        return sql;
    }

    private static String getOrgLongNumber(Context ctx, String orgId) throws BOSException {
        String longNumber = (String)SQL.getValue(ctx.getAIS(), "select FLongNumber from T_Org_Admin where fid = '" + orgId + "'");
        if (longNumber == null) {
            throw new IllegalArgumentException("\u7ec4\u7ec7(" + orgId + ")\u5728\u6570\u636e\u4e2d\u5fc3(" + ctx.getAIS() + ")\u4e0d\u5b58\u5728\uff01");
        }
        return longNumber;
    }

    private static synchronized Cache getCache(Context ctx) {
        String key = ctx.getAIS();
        Cache cache = caches.get(key);
        if (cache == null) {
            cache = new Cache(1000);
            caches.put(key, cache);
        }
        return cache;
    }
}

