/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.scheduler.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public final class WorkCalendarSchema {
    private String id;
    private String amStart;
    private String amEnd;
    private String pmStart;
    private String pmEnd;
    private boolean[] weekend;
    private long worktime;

    public WorkCalendarSchema(Map<String, Object> data) {
        this.id = data.get("fid").toString();
        this.amStart = this.readTime(data, "fbegintimeam", "9-0");
        this.amEnd = this.readTime(data, "fendtimeam", "12-0");
        this.pmStart = this.readTime(data, "fbegintimepm", "14-0");
        this.pmEnd = this.readTime(data, "fendtimepm", "17-0");
        this.setWeekend(data);
        this.calcWorkTime();
    }

    private void calcWorkTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date start = df.parse("2000-1-1 " + this.amStart);
            Date end = df.parse("2000-1-1 " + this.amEnd);
            this.worktime += end.getTime() - start.getTime();
            start = df.parse("2000-1-1 " + this.pmStart);
            end = df.parse("2000-1-1 " + this.pmEnd);
            this.worktime += end.getTime() - start.getTime();
        }
        catch (ParseException e) {
            this.worktime = 28800000L;
        }
    }

    private void setWeekend(Map<String, Object> data) {
        String s = (String)data.get("fdefaultweekend");
        if (s == null || s.length() == 0) {
            s = "!1!7";
        }
        this.weekend = new boolean[8];
        for (String i : s.split("!")) {
            if (i.length() <= 0) continue;
            this.weekend[Integer.parseInt((String)i)] = true;
        }
    }

    private String readTime(Map<String, Object> data, String field, String defaultValue) {
        String minute;
        String[] array;
        String hour;
        String s = (String)data.get(field);
        if (s == null) {
            s = defaultValue;
        }
        if ((hour = (array = s.split("\\-"))[0]).length() == 1) {
            hour = "0" + hour;
        }
        if ((minute = array[1]).length() == 1) {
            minute = "0" + minute;
        }
        return hour + ":" + minute + ":00";
    }

    public String getAmEnd() {
        return this.amEnd;
    }

    public String getAmStart() {
        return this.amStart;
    }

    public long getWorkTime() {
        return this.worktime;
    }

    public String getId() {
        return this.id;
    }

    public String getPmEnd() {
        return this.pmEnd;
    }

    public String getPmStart() {
        return this.pmStart;
    }

    public boolean isWeekend(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int weekday = c.get(7);
        return this.weekend[weekday];
    }
}

