/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.support.quartz.impl;

import com.kingdee.bos.support.quartz.impl.BatchUpdater;
import com.kingdee.bos.support.quartz.impl.JobWrapper;
import com.kingdee.bos.support.quartz.impl.PersistenceJobStoreBase;
import com.kingdee.bos.support.quartz.impl.TriggerWrapper;
import com.kingdee.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.naming.NameNotFoundException;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerException;
import org.quartz.StatefulJob;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.triggers.AbstractTrigger;
import org.quartz.spi.JobStore;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.TriggerFiredBundle;

public abstract class PersistenceJobStoreSupport
extends PersistenceJobStoreBase
implements JobStore {
    @Override
    protected abstract void initialize() throws Exception;

    public synchronized void storeJobAndTrigger(JobDetail newJob, Trigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.checkClosed();
        try {
            if (this.store.existsJob(newJob)) {
                throw new ObjectAlreadyExistsException(newJob);
            }
            if (this.store.existsTrigger(newTrigger)) {
                throw new ObjectAlreadyExistsException(newTrigger);
            }
            this.addJob(newJob, false);
            this.addTrigger(newTrigger, false);
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            if (e instanceof ObjectAlreadyExistsException) {
                throw (ObjectAlreadyExistsException)e;
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void storeJob(JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.checkClosed();
        try {
            this.addJob(newJob, replaceExisting);
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            if (e instanceof ObjectAlreadyExistsException) {
                throw (ObjectAlreadyExistsException)e;
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public synchronized boolean removeJob(String jobName, String groupName) throws JobPersistenceException {
        this.checkClosed();
        try {
            boolean b = this.removeJob(groupName, jobName);
            this.helper.commit();
            return b;
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized JobDetail retrieveJob(String jobName, String groupName) throws JobPersistenceException {
        this.checkClosed();
        JobWrapper jw = (JobWrapper)this.store.allJobs.get(JobWrapper.getJobNameKey(groupName, jobName));
        if (jw == null) {
            return null;
        }
        return jw.jobDetail;
    }

    public synchronized void storeTrigger(Trigger newTrigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.checkClosed();
        try {
            this.addTrigger(newTrigger, replaceExisting);
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            if (e instanceof ObjectAlreadyExistsException) {
                throw (ObjectAlreadyExistsException)e;
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public synchronized boolean removeTrigger(String triggerName, String groupName) throws JobPersistenceException {
        this.checkClosed();
        try {
            boolean b = this.removeTrigger(groupName, triggerName);
            this.helper.commit();
            return b;
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public synchronized boolean replaceTrigger(String triggerName, String groupName, Trigger newTrigger) throws JobPersistenceException {
        this.checkClosed();
        try {
            boolean b = this.replaceTrigger(groupName, triggerName, newTrigger);
            this.helper.commit();
            return b;
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized Trigger retrieveTrigger(String triggerName, String groupName) throws JobPersistenceException {
        this.checkClosed();
        TriggerWrapper tw = (TriggerWrapper)this.store.allTriggers.get(TriggerWrapper.getTriggerNameKey(groupName, triggerName));
        if (tw == null) {
            return null;
        }
        return tw.trigger;
    }

    public void storeCalendar(String name, Calendar calendar, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.storeCalendar(name, calendar, replaceExisting, false);
    }

    public synchronized void storeCalendar(String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        this.checkClosed();
        try {
            this.addCalendar(name, calendar, replaceExisting, updateTriggers);
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            if (e instanceof ObjectAlreadyExistsException) {
                throw (ObjectAlreadyExistsException)e;
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public synchronized boolean removeCalendar(String calName) throws JobPersistenceException {
        this.checkClosed();
        try {
            boolean b = this.removeCalendar(calName);
            this.helper.commit();
            return b;
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized Calendar retrieveCalendar(String calName) throws JobPersistenceException {
        return (Calendar)this.store.calendars.get(calName);
    }

    public synchronized int getNumberOfJobs() throws JobPersistenceException {
        return this.store.allJobs.size();
    }

    public synchronized int getNumberOfTriggers() throws JobPersistenceException {
        return this.store.allTriggers.size();
    }

    public synchronized int getNumberOfCalendars() throws JobPersistenceException {
        return this.store.calendars.size();
    }

    public synchronized String[] getJobNames(String groupName) throws JobPersistenceException {
        HashMap jobs = this.store.getJobGroup(groupName, false);
        if (jobs == null) {
            return new String[0];
        }
        String[] names = new String[jobs.size()];
        jobs.keySet().toArray(names);
        return names;
    }

    public synchronized String[] getTriggerNames(String groupName) throws JobPersistenceException {
        HashMap triggers = this.store.getTriggerGroup(groupName, false);
        if (triggers == null) {
            return new String[0];
        }
        String[] names = new String[triggers.size()];
        triggers.keySet().toArray(names);
        return names;
    }

    public synchronized List<String> getJobGroupNames() throws JobPersistenceException {
        return new ArrayList<String>(this.store.groupJobs.keySet());
    }

    public synchronized List<String> getTriggerGroupNames() throws JobPersistenceException {
        return new ArrayList<String>(this.store.groupTriggers.keySet());
    }

    public synchronized List<String> getCalendarNames() throws JobPersistenceException {
        return new ArrayList<String>(this.store.calendars.keySet());
    }

    public synchronized Trigger[] getTriggersForJob(String jobName, String groupName) throws JobPersistenceException {
        List triggers = this.store.getTriggersForJob(JobWrapper.getJobNameKey(groupName, jobName), true);
        return triggers.toArray(new Trigger[triggers.size()]);
    }

    public synchronized int getTriggerState(String triggerName, String triggerGroup) throws JobPersistenceException {
        TriggerWrapper tw = (TriggerWrapper)this.store.allTriggers.get(TriggerWrapper.getTriggerNameKey(triggerGroup, triggerName));
        if (tw == null) {
            return Trigger.TriggerState.NONE.ordinal();
        }
        if (tw.state == 3) {
            return Trigger.TriggerState.COMPLETE.ordinal();
        }
        if (tw.state == 4) {
            return Trigger.TriggerState.PAUSED.ordinal();
        }
        return Trigger.TriggerState.NORMAL.ordinal();
    }

    private void pauseTrigger(TriggerWrapper tw) throws Exception {
        if (tw == null || tw.trigger == null) {
            return;
        }
        if (tw.state == 3) {
            return;
        }
        this.setTriggerState(tw, 4);
        this.store.timeTriggers.remove(tw);
    }

    public synchronized void pauseTrigger(String triggerName, String groupName) throws JobPersistenceException {
        this.checkClosed();
        try {
            TriggerWrapper tw = this.store.getTrigger(groupName, triggerName);
            this.pauseTrigger(tw);
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void pauseTriggerGroup(String groupName) throws JobPersistenceException {
        this.checkClosed();
        if (this.pausedTriggerGroups.contains(groupName)) {
            return;
        }
        this.pausedTriggerGroups.add(groupName);
        try {
            Iterator it = this.store.getTriggerGroup(groupName, false).values().iterator();
            while (it.hasNext()) {
                this.pauseTrigger((TriggerWrapper)it.next());
            }
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void pauseJob(String jobName, String groupName) throws JobPersistenceException {
        this.checkClosed();
        try {
            Iterator it = this.store.getTriggersForJob(JobWrapper.getJobNameKey(groupName, jobName), false).iterator();
            while (it.hasNext()) {
                this.pauseTrigger((TriggerWrapper)it.next());
            }
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void pauseJobGroup(String groupName) throws JobPersistenceException {
        this.checkClosed();
        try {
            for (TriggerWrapper tw : this.store.allTriggers.values()) {
                if (!tw.trigger.getJobKey().getGroup().equals(groupName)) continue;
                this.pauseTrigger(tw);
            }
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    private synchronized void resumeTrigger(TriggerWrapper tw) throws Exception {
        if (tw == null || tw.trigger == null) {
            return;
        }
        Trigger trig = tw.getTrigger();
        if (tw.state != 4) {
            return;
        }
        if (this.blockedJobs.contains(JobWrapper.getJobNameKey(trig.getJobKey().getGroup(), trig.getJobKey().getName()))) {
            this.setTriggerState(tw, 5);
        } else {
            this.setTriggerState(tw, 0);
        }
        this.applyMisfire(tw);
        if (tw.state == 0) {
            this.store.timeTriggers.add(tw);
        }
    }

    public synchronized void resumeTrigger(String triggerName, String groupName) throws JobPersistenceException {
        this.checkClosed();
        try {
            this.resumeTrigger(this.store.getTrigger(groupName, triggerName));
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void resumeTriggerGroup(String groupName) throws JobPersistenceException {
        this.checkClosed();
        if (!this.pausedTriggerGroups.contains(groupName)) {
            return;
        }
        this.pausedTriggerGroups.remove(groupName);
        try {
            Iterator it = this.store.getTriggerGroup(groupName, false).values().iterator();
            while (it.hasNext()) {
                this.resumeTrigger((TriggerWrapper)it.next());
            }
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized Set getPausedTriggerGroups() throws JobPersistenceException {
        HashSet set = new HashSet();
        set.addAll(this.pausedTriggerGroups);
        return set;
    }

    public synchronized void resumeJob(String jobName, String groupName) throws JobPersistenceException {
        this.checkClosed();
        if (!this.pausedTriggerGroups.contains(groupName)) {
            return;
        }
        this.pausedTriggerGroups.remove(groupName);
        try {
            Iterator it = this.store.getTriggersForJob(JobWrapper.getJobNameKey(groupName, jobName), false).iterator();
            while (it.hasNext()) {
                this.resumeTrigger((TriggerWrapper)it.next());
            }
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void resumeJobGroup(String groupName) throws JobPersistenceException {
        this.checkClosed();
        try {
            for (TriggerWrapper tw : this.store.allTriggers.values()) {
                if (!tw.trigger.getJobKey().getGroup().equals(groupName)) continue;
                this.resumeTrigger(tw);
            }
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void pauseAll() throws JobPersistenceException {
        this.checkClosed();
        try {
            for (TriggerWrapper tw : this.store.allTriggers.values()) {
                this.pauseTrigger(tw);
            }
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void resumeAll() throws JobPersistenceException {
        this.checkClosed();
        try {
            for (TriggerWrapper tw : this.store.allTriggers.values()) {
                this.resumeTrigger(tw);
            }
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    private synchronized Trigger handleTrigger(TriggerWrapper tw) throws JobPersistenceException {
        try {
            if (tw.trigger.getNextFireTime() == null) {
                this.store.timeTriggers.remove(tw);
                tw = null;
                return null;
            }
            this.store.timeTriggers.remove(tw);
            if (this.applyMisfire(tw)) {
                if (tw.trigger.getNextFireTime() != null) {
                    this.store.timeTriggers.add(tw);
                }
                tw = null;
                return null;
            }
            this.setTriggerState(tw, 1);
            ((AbstractTrigger)tw.trigger).setFireInstanceId(PersistenceJobStoreSupport.getFiredTriggerRecordId());
            Trigger result = null;
            try {
                result = (Trigger)ObjectUtils.createCopy((Object)tw.trigger);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            this.helper.commit();
            return result;
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            if (e instanceof NameNotFoundException) {
                throw new JobPersistenceException(e.getMessage(), (Throwable)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger acquireNextTrigger() throws JobPersistenceException {
        Trigger result;
        block10: {
            this.checkClosed();
            result = null;
            TriggerWrapper tw = null;
            if (tw == null) {
                PersistenceJobStoreSupport persistenceJobStoreSupport = this;
                synchronized (persistenceJobStoreSupport) {
                    try {
                        tw = (TriggerWrapper)this.store.timeTriggers.first();
                    }
                    catch (NoSuchElementException nsee) {
                        break block10;
                    }
                    if (tw == null) {
                        break block10;
                    }
                }
                if (this.helper instanceof BatchUpdater) {
                    BatchUpdater update = (BatchUpdater)this.helper;
                    try {
                        update.finalCheckTrigger(tw.getTrigger().getKey().getGroup(), tw.getTrigger().getKey().getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                result = this.handleTrigger(tw);
            }
        }
        return result;
    }

    public synchronized void releaseAcquiredTrigger(Trigger trigger) throws JobPersistenceException {
        this.checkClosed();
        try {
            TriggerWrapper tw = this.store.getTrigger(TriggerWrapper.getTriggerNameKey(trigger));
            if (tw != null && tw.state != 3 && tw.state != 4) {
                this.setTriggerState(tw, 0);
                this.store.timeTriggers.add(tw);
            }
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized TriggerFiredBundle triggerFired(Trigger trigger) throws JobPersistenceException {
        this.checkClosed();
        try {
            TriggerWrapper tw = this.store.getTrigger(TriggerWrapper.getTriggerNameKey(trigger));
            if (tw == null || tw.trigger == null) {
                return null;
            }
            if (tw.state == 3) {
                return null;
            }
            if (tw.state == 4) {
                return null;
            }
            if (tw.state == 5) {
                return null;
            }
            Calendar cal = null;
            if (tw.trigger.getCalendarName() != null) {
                cal = this.retrieveCalendar(tw.trigger.getCalendarName());
            }
            Date prevFireTime = trigger.getPreviousFireTime();
            ((AbstractTrigger)tw.trigger).triggered(cal);
            ((AbstractTrigger)trigger).triggered(cal);
            this.setTriggerState(tw, 0);
            this.updateTrigger(tw);
            TriggerFiredBundle bndle = new TriggerFiredBundle(this.retrieveJob(trigger.getJobKey().getName(), trigger.getJobKey().getGroup()), (OperableTrigger)trigger, cal, false, new Date(), trigger.getPreviousFireTime(), prevFireTime, trigger.getNextFireTime());
            JobDetail job = bndle.getJobDetail();
            if (job.getJobClass() != null && StatefulJob.class.isAssignableFrom(job.getJobClass())) {
                List trigs = this.store.getTriggersForJob(JobWrapper.getJobNameKey(job), false);
                for (TriggerWrapper ttw : trigs) {
                    if (ttw.state == 0) {
                        this.setTriggerState(ttw, 5);
                    }
                    this.store.timeTriggers.remove(ttw);
                }
                this.blockedJobs.add(JobWrapper.getJobNameKey(job));
            } else if (tw.trigger.getNextFireTime() != null) {
                this.store.timeTriggers.add(tw);
            }
            this.helper.commit();
            return bndle;
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void triggeredJobComplete(Trigger trigger, JobDetail jobDetail, int triggerInstCode) throws JobPersistenceException {
        this.checkClosed();
        try {
            String jobKey = JobWrapper.getJobNameKey(jobDetail);
            JobWrapper jw = (JobWrapper)this.store.allJobs.get(jobKey);
            TriggerWrapper tw2 = this.store.getTrigger(TriggerWrapper.getTriggerNameKey(trigger));
            if (jw != null) {
                JobDetail jd = jw.jobDetail;
                if (jd.getJobClass() != null && StatefulJob.class.isAssignableFrom(jd.getJobClass())) {
                    JobDataMap newData = jobDetail.getJobDataMap();
                    if (newData != null) {
                        newData.clearDirtyFlag();
                    }
                    ((JobDetailImpl)jd).setJobDataMap(newData);
                    this.blockedJobs.remove(JobWrapper.getJobNameKey(jd));
                    List trigs = this.store.getTriggersForJob(JobWrapper.getJobNameKey(jd), false);
                    for (TriggerWrapper ttw : trigs) {
                        if (ttw.state != 5) continue;
                        if (this.pausedTriggerGroups.contains(ttw.trigger.getKey().getGroup())) {
                            this.setTriggerState(ttw, 4);
                            continue;
                        }
                        this.setTriggerState(ttw, 0);
                        this.store.timeTriggers.add(ttw);
                    }
                    this.updateJob(jw);
                }
            } else {
                this.blockedJobs.remove(JobWrapper.getJobNameKey(jobDetail));
            }
            if (tw2 != null) {
                if (triggerInstCode == Trigger.CompletedExecutionInstruction.DELETE_TRIGGER.ordinal()) {
                    if (trigger.getNextFireTime() == null) {
                        if (tw2.getTrigger().getNextFireTime() == null) {
                            this.removeTrigger(tw2);
                        }
                    } else {
                        this.removeTrigger(tw2);
                    }
                } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_TRIGGER_COMPLETE.ordinal()) {
                    this.setTriggerState(tw2, 3);
                    this.store.timeTriggers.remove(tw2);
                } else if (triggerInstCode == Trigger.CompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE.ordinal()) {
                    List tws = this.store.getTriggersForJob(JobWrapper.getJobNameKey(trigger.getJobKey().getGroup(), trigger.getJobKey().getName()), false);
                    for (TriggerWrapper tw2 : tws) {
                        this.setTriggerState(tw2, 3);
                        this.store.timeTriggers.remove(tw2);
                    }
                }
            }
            this.helper.commit();
        }
        catch (Exception e) {
            this.helper.rollback();
            if (e instanceof JobPersistenceException) {
                throw (JobPersistenceException)((Object)e);
            }
            throw new JobPersistenceException(e.getMessage(), (Throwable)e);
        }
    }

    public Trigger acquireNextTrigger(long noLaterThan) throws JobPersistenceException {
        return this.acquireNextTrigger();
    }

    public void schedulerStarted() throws SchedulerException {
    }
}

