/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.console;

import com.kingdee.bos.tool.console.IUserStream;
import com.kingdee.bos.tool.console.IUserStreamListener;
import com.kingdee.bos.tool.console.UserStreamImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class UserStreamManager {
    public static final Color NORMAL_COLOR = UserStreamManager.createColor(0, 0, 0);
    public static final Color ERROR_COLOR = UserStreamManager.createColor(255, 0, 0);
    public static final Color LINK_COLOR = UserStreamManager.createColor(0, 0, 255);
    private Vector fListenerList = new Vector(10);
    private HashMap fUserStreams = new HashMap();
    private static UserStreamManager userStreamManager;

    public static UserStreamManager getUserStreamManager() {
        if (null == userStreamManager) {
            userStreamManager = new UserStreamManager();
        }
        return userStreamManager;
    }

    private UserStreamManager() {
    }

    private static Color createColor(int r, int g, int b) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return new Color((Device)display, r, g, b);
    }

    public void addStreamListener(IUserStreamListener listener) {
        this.fListenerList.add(listener);
    }

    public void removeStreamListener(IUserStreamListener listener) {
        this.fListenerList.remove(listener);
    }

    public IUserStream createUserStream(String streamId) {
        UserStreamImpl newStream = new UserStreamImpl(streamId);
        this.fUserStreams.put(streamId, newStream);
        this.addListenersToStream(newStream);
        this.fireStreamAdded(streamId);
        return newStream;
    }

    private void addListenersToStream(IUserStream newStream) {
        for (IUserStreamListener listener : this.fListenerList) {
            newStream.addStreamListener(listener);
        }
    }

    private void fireStreamAdded(String streamId) {
        for (IUserStreamListener listener : this.fListenerList) {
            listener.streamCreated(streamId);
        }
    }

    public IUserStream getUserStream(String streamId) {
        return (IUserStream)this.fUserStreams.get(streamId);
    }

    public void removeUserStream(String streamId) {
        this.fUserStreams.remove(streamId);
        this.fireStreamRemoved(streamId);
    }

    private void fireStreamRemoved(String streamId) {
        for (IUserStreamListener listener : this.fListenerList) {
            listener.streamRemoved(streamId);
        }
    }

    public Collection getUserStreams() {
        return this.fUserStreams.values();
    }

    public void removeAllClosedStreams() {
        HashMap<String, IUserStream> runningStreams = new HashMap<String, IUserStream>();
        for (IUserStream stream : this.getUserStreams()) {
            if (!stream.isClosed()) {
                runningStreams.put(stream.getStreamId(), stream);
                continue;
            }
            this.fireStreamRemoved(stream.getStreamId());
        }
        this.fUserStreams = runningStreams;
    }
}

