/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dialogs;

import com.kingdee.bos.tool.dialogs.Messages;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Locale;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FontDialog
extends Dialog {
    private Font font;
    private Text txtFamily;
    private List lstFamily;
    private Button btnBold;
    private Button btnItalic;
    private Text txtSize;
    private List lstSize;
    private static String[] fontFamily = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private Button btnClear;
    private boolean updateing;
    private boolean clear;

    public FontDialog(Shell parentShell, Font font) {
        super(parentShell);
        this.font = font;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.FontDialog_SheZhiZiTiDuiHuaKuang);
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout gl = (GridLayout)container.getLayout();
        gl.numColumns = 2;
        Composite leftArea = new Composite(container, 0);
        GridData data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 180;
        leftArea.setLayoutData((Object)data);
        gl = new GridLayout();
        gl.numColumns = 1;
        leftArea.setLayout((Layout)gl);
        Composite rightArea = new Composite(container, 0);
        data = new GridData(1808);
        data.heightHint = 200;
        data.widthHint = 100;
        rightArea.setLayoutData((Object)data);
        gl = new GridLayout();
        gl.numColumns = 1;
        rightArea.setLayout((Layout)gl);
        Label labFamily = new Label(leftArea, 0);
        labFamily.setText(Messages.FontDialog_ZiTi);
        data = new GridData();
        data.widthHint = 100;
        labFamily.setLayoutData((Object)data);
        this.txtFamily = new Text(leftArea, 2048);
        data = new GridData(1808);
        this.txtFamily.setLayoutData((Object)data);
        this.lstFamily = new List(leftArea, 2820);
        data = new GridData(1808);
        data.heightHint = 120;
        this.lstFamily.setLayoutData((Object)data);
        Label labStyle = new Label(rightArea, 0);
        labStyle.setText(Messages.FontDialog_ZiXing);
        data = new GridData();
        data.widthHint = 60;
        labStyle.setLayoutData((Object)data);
        this.btnBold = new Button(rightArea, 32);
        this.btnBold.setText("\u7c97\u4f53");
        this.btnItalic = new Button(rightArea, 32);
        this.btnItalic.setText("\u659c\u4f53");
        new Label(rightArea, 0);
        Label labSize = new Label(rightArea, 0);
        labSize.setText(Messages.FontDialog_DaXiao);
        this.txtSize = new Text(rightArea, 2048);
        data = new GridData();
        data.widthHint = 30;
        this.txtSize.setLayoutData((Object)data);
        new Label(rightArea, 0);
        new Label(rightArea, 0);
        this.btnClear = new Button(rightArea, 32);
        this.btnClear.setText(Messages.FontDialog_QuXiaoZiTiSheZhi);
        this.init();
        this.txtFamily.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FontDialog.this.txtFamilyModify(e);
            }
        });
        this.lstFamily.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog.this.updateing = true;
                FontDialog.this.txtFamily.setText(FontDialog.this.lstFamily.getSelection()[0]);
                FontDialog.this.updateing = false;
            }
        });
        this.btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FontDialog.this.btnClear.getSelection()) {
                    FontDialog.this.txtFamily.setEnabled(false);
                    FontDialog.this.txtSize.setEnabled(false);
                    FontDialog.this.lstFamily.setEnabled(false);
                    FontDialog.this.btnBold.setEnabled(false);
                    FontDialog.this.btnItalic.setEnabled(false);
                } else {
                    FontDialog.this.txtFamily.setEnabled(true);
                    FontDialog.this.txtSize.setEnabled(true);
                    FontDialog.this.lstFamily.setEnabled(true);
                    FontDialog.this.btnBold.setEnabled(true);
                    FontDialog.this.btnItalic.setEnabled(true);
                }
            }
        });
        return container;
    }

    private void txtFamilyModify(ModifyEvent e) {
        if (this.updateing) {
            return;
        }
        String text = this.txtFamily.getText();
        int index = 0;
        for (int i = 0; i < fontFamily.length; ++i) {
            if (!fontFamily[i].toLowerCase(Locale.ENGLISH).startsWith(text.toLowerCase(Locale.ENGLISH))) continue;
            index = i;
            break;
        }
        this.lstFamily.setSelection(index);
    }

    private void init() {
        this.lstFamily.setItems(fontFamily);
        if (this.font != null) {
            this.txtFamily.setText(this.font.getFamily());
            this.txtSize.setText("" + this.font.getSize());
            if ((this.font.getStyle() & 1) != 0) {
                this.btnBold.setSelection(true);
            }
            if ((this.font.getStyle() & 2) != 0) {
                this.btnItalic.setSelection(true);
            }
        }
    }

    protected void okPressed() {
        this.clear = this.btnClear.getSelection();
        if (!this.clear) {
            String familyText = this.txtFamily.getText();
            if (familyText.trim().length() == 0) {
                MessageDialog dlg = new MessageDialog(this.getShell(), "", null, Messages.FontDialog_BiXuXuanZeYiGeZiTi, 2, new String[]{"OK"}, 0);
                dlg.create();
                dlg.open();
                return;
            }
            String family = this.lstFamily.getSelection().length == 0 ? this.txtFamily.getText() : this.lstFamily.getSelection()[0];
            int style = 0;
            if (this.btnBold.getSelection()) {
                style = 1;
            }
            if (this.btnItalic.getSelection()) {
                style |= 2;
            }
            int size = 12;
            try {
                size = Integer.parseInt(this.txtSize.getText().trim());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (size <= 0 || size >= 72) {
                size = 12;
            }
            this.font = new Font(family, style, size);
        }
        super.okPressed();
    }

    public Font getFont() {
        return this.font;
    }

    public boolean isClear() {
        return this.clear;
    }
}

