/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.cloud;

import com.kingdee.bos.Context;
import com.kingdee.bos.cloud.CloudServerInfo;
import com.kingdee.bos.cloud.LoginInfo;
import com.kingdee.bos.cloud.ServerExceptionHelper;
import com.kingdee.bos.cloud.UTF8GetMethod;
import com.kingdee.bos.cloud.UTF8PostMethod;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.md.cache.AliasUtil;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.md.mdfs.RemoteFSInfo;
import com.kingdee.bos.md.mdfs.RemoteFSInfoCollection;
import com.kingdee.bos.md.tools.BizMetadataUtil;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.PFileUtils;
import com.kingdee.bos.tool.utils.MD5;
import com.kingdee.bos.tool.utils.StringZipper;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CloudAppServerInfo {
    public static final String BASE_METAS_LIST_FILE = "metadata.lst";
    private String projectName = "";
    private IMDProject fProject;
    private final LoginInfo loginInfo;
    private Context context = null;
    private String serverUrl = "http://192.168.61.8:6888/easWebClient/BOS_CLOUD_APP";
    private String ormrpcUrl = "tcp://192.168.61.8:11034";
    private String testUrl = "http://192.168.61.8:6888/easWeb/";
    private static Hashtable instances = new Hashtable();
    private HttpClient httpClient;
    private MultiThreadedHttpConnectionManager connectionManager;
    private DefaultHttpMethodRetryHandler retryHandler;
    private long loginTime = -1L;
    private int status = 200;
    private byte[] content = null;
    private String appPath = null;

    public static synchronized CloudAppServerInfo getInstance(IMDProject project) {
        String projectName = project.getName();
        CloudAppServerInfo info = (CloudAppServerInfo)instances.get(projectName);
        if (info == null) {
            info = new CloudAppServerInfo(projectName);
            info.fProject = project;
        }
        return info;
    }

    public CloudAppServerInfo(String projectName) {
        this.projectName = projectName;
        this.loginInfo = new LoginInfo(projectName);
        instances.put(projectName, this);
    }

    public void resetLogin() {
        this.loginTime = -1L;
    }

    private void ensureLogin() throws Exception {
        if (this.loginTime == -1L) {
            this.login();
        }
    }

    private IMDProject getMDProject() {
        if (this.fProject == null) {
            this.fProject = MDResourceUtil.getMDProject(this.projectName);
        }
        return this.fProject;
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessageBody() {
        if (this.content == null) {
            return "";
        }
        return new String(this.content);
    }

    public void login() throws Exception {
        this.loginTime = -1L;
        CloudServerInfo.getInstance().fillProjectInfo(this);
        this.init();
        StringBuffer sb = new StringBuffer();
        sb.append("login");
        sb.append("&username=" + this.loginInfo.getServerUser());
        sb.append("&projectname=" + this.projectName);
        if (!StringUtils.isEmpty((String)this.loginInfo.getServerP())) {
            sb.append("&password=" + this.loginInfo.getServerP());
        }
        this.executeGet(sb.toString(), "\u767b\u5f55");
        this.loginTime = System.currentTimeMillis();
        this.executeGet("retrieve_app_info", "\u83b7\u53d6\u5e94\u7528\u4fe1\u606f");
        this.initServerInfo();
        this.updateBaseMetas(null);
        this.updateMDTree(true);
        if (this.getMDProject() != null) {
            this.getMDProject().reset();
        }
    }

    public boolean isLogined() {
        return this.loginTime != -1L;
    }

    private void init() throws URIException, NullPointerException {
        if (this.httpClient == null) {
            this.retryHandler = new DefaultHttpMethodRetryHandler(2, false);
            this.connectionManager = new MultiThreadedHttpConnectionManager();
            this.connectionManager.getParams().setConnectionTimeout(30000);
            this.connectionManager.getParams().setSoTimeout(30000);
            this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
            URI uri = new URI(this.serverUrl, false);
            this.httpClient.getHostConfiguration().setHost(uri.getHost(), uri.getPort());
            this.appPath = uri.getPath();
        }
    }

    private void initServerInfo() throws IOException {
        Properties prop = new Properties();
        prop.load(new ByteArrayInputStream(this.content));
        this.ormrpcUrl = prop.getProperty("ormrpcUrl");
        this.testUrl = prop.getProperty("testUrl");
        this.context = new Context();
        this.context.setAIS(prop.getProperty("ais"));
        this.context.setSolution(prop.getProperty("solution"));
        this.context.setLocale(new Locale(prop.getProperty("locale")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadSolution(IProgressMonitor monitor) throws Exception {
        block8: {
            block7: {
                IMDProject project;
                File root;
                boolean downloadBase;
                this.ensureLogin();
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                boolean bl = downloadBase = !(root = (project = this.getMDProject()).getBaseMetadataDir()).exists();
                if (!downloadBase) {
                    String[] cs = root.list();
                    boolean bl2 = downloadBase = cs == null || cs.length == 0;
                }
                if (!downloadBase) break block7;
                this.executeGet("list_base_metadata", "\u4e0b\u8f7d\u89e3\u51b3 \u65b9\u6848");
                String str = this.getMessageBody();
                String[] strs = str.split("\n");
                root.mkdirs();
                monitor.beginTask("\u4e0b\u8f7d\u6587\u4ef6..", strs.length + 1);
                int n = strs.length;
                for (int i = 0; i < n; ++i) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException("\u7528\u6237\u4e2d\u6b62\u4e86\u4e0b\u8f7d\u64cd\u4f5c");
                    }
                    String name = strs[i];
                    int index = name.indexOf(61);
                    if (index != -1) {
                        name = name.substring(0, index);
                    }
                    monitor.setTaskName("\u4e0b\u8f7d:(" + (i + 1) + "/" + n + ")" + name);
                    this.downloadBaseMD(root, name);
                    monitor.worked(1);
                }
                Properties prop = new Properties();
                prop.load(new ByteArrayInputStream(str.getBytes()));
                File file = new File(root, BASE_METAS_LIST_FILE);
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                    prop.store(fileOutputStream, "mic");
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileOutputStream);
                    throw throwable;
                }
                FileUtils.close(fileOutputStream);
                break block8;
            }
            this.updateBaseMetas(monitor);
        }
        monitor.setTaskName("\u4e0b\u8f7d\u52a8\u6001\u5143\u6570\u636e\u5217\u8868...");
        this.updateMDTree(true);
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateBaseMetas(IProgressMonitor monitor) throws Exception {
        this.ensureLogin();
        this.executeGet("list_base_metadata", "\u4e0b\u8f7d\u57fa\u7840\u5143\u6570\u636e");
        Properties sevProp = new Properties();
        sevProp.load(new ByteArrayInputStream(this.content));
        File root = this.getMDProject().getBaseMetadataDir();
        File file = new File(root, BASE_METAS_LIST_FILE);
        Properties lclProp = new Properties();
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                lclProp.load(fileInputStream);
            }
            catch (Exception ex) {
                try {
                    LogTool.logInfo("\u65e0\u6cd5\u52a0\u8f7d\u7279\u5f81\u5217\u8868", ex);
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileInputStream);
                    throw throwable;
                }
                FileUtils.close(fileInputStream);
            }
            FileUtils.close(fileInputStream);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String string : sevProp.keySet()) {
            if (!new File(root, string).exists()) {
                list.add(string);
                continue;
            }
            String sevTS = sevProp.getProperty(string);
            String lclTS = lclProp.getProperty(string);
            if (StringUtils.isEmpty((String)lclTS)) {
                lclTS = MD5.asHex(MD5.getHash(new File(root, string)));
            }
            if (sevTS.equals(lclTS)) continue;
            list.add(string);
        }
        if (list.isEmpty()) {
            return 0;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("\u4e0b\u8f7d\u6587\u4ef6..", list.size());
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (monitor.isCanceled()) {
                throw new InterruptedException("\u7528\u6237\u4e2d\u6b62\u4e86\u4e0b\u8f7d\u64cd\u4f5c");
            }
            String name = (String)list.get(i);
            name = StringUtils.replace((String)name, (String)"\\", (String)"/");
            monitor.setTaskName("\u4e0b\u8f7d:(" + (i + 1) + "/" + n + ")" + name);
            this.downloadBaseMD(root, name);
            monitor.worked(1);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            sevProp.store(fileOutputStream, "mic");
        }
        catch (Throwable throwable) {
            FileUtils.close(fileOutputStream);
            throw throwable;
        }
        FileUtils.close(fileOutputStream);
        return list.size();
    }

    private Exception wrapException(String oper, Throwable t) {
        this.loginTime = -1L;
        return ServerExceptionHelper.getInstance().wrapException(this, oper, t);
    }

    public int updateMDTree(boolean fireUpdate) throws Exception {
        this.ensureLogin();
        this.executeGet("list_dy_metadata", "\u66f4\u65b0");
        int count = 0;
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this.content));
        Map map = (Map)in.readObject();
        IMDProject project = this.getMDProject();
        RemoteFSInfoCollection coll = RemoteFSInfoCollection.get(project);
        ArrayList<RemoteFSInfo> list = new ArrayList<RemoteFSInfo>();
        for (String path : map.keySet()) {
            Properties prop = (Properties)map.get(path);
            if (prop == null) continue;
            RemoteFSInfo serverInfo = new RemoteFSInfo(path, prop);
            list.add(serverInfo);
            if (coll.getRemoteFSInfo(path) != null && coll.getRemoteFSInfo(path).equals(serverInfo)) continue;
            ++count;
        }
        coll.clear();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            RemoteFSInfo serverInfo = (RemoteFSInfo)list.get(i);
            coll.replace(serverInfo);
        }
        String prefix = project.getPrefix();
        if (!StringUtils.isEmpty((String)prefix) && !(prefix = StringUtils.replace((String)prefix, (String)".", (String)"/")).endsWith("/")) {
            prefix = prefix + "/";
        }
        coll.addFile(prefix + project.getName() + "/" + project.getName() + ".package");
        coll.store2File();
        if (fireUpdate) {
            MDResourceUtil.fireWorkspaceUpdate();
        }
        return count;
    }

    private void downloadBaseMD(File root, String path) throws Exception {
        this.ensureLogin();
        path = path.trim();
        this.executePost("retrieve_base_metadata", "\u4e0b\u8f7d\u57fa\u7840\u5143\u6570\u636e", new String[]{"path"}, new String[]{path}, new File(root, path));
    }

    private void downloadClientFile(File root, String path) throws Exception {
        this.ensureLogin();
        path = path.trim();
        this.executePost("retrieve_client_file", "\u4e0b\u8f7d\u5ba2\u6237\u7aef\u6587\u4ef6", new String[]{"path"}, new String[]{path}, new File(root, path));
    }

    public boolean checkExists(IMDFile file) throws Exception {
        this.updateMDTree(false);
        RemoteFSInfoCollection coll = RemoteFSInfoCollection.get(file.getMDProject());
        return coll.getRemoteFSInfo(file.getPath()) != null;
    }

    public void storeFile(IMDFile bizFile, boolean checkIn) throws Exception {
        if ("FnMenuTree.xml".equals(bizFile.getPath())) {
            String content = PFileUtils.getFileContent(bizFile.toFile());
            byte[] contentbytes = StringZipper.zipStringToBytes(content);
            content = Base64.encodeBytes((byte[])contentbytes);
            this.executePost("store_metadata", "\u4fdd\u5b58\u5143\u6570\u636e", new String[]{"metadatapk", "md5", "alias", "zipped", "content"}, new String[]{bizFile.getPath(), "", "FnMenuTree.xml", "1", content});
            if (checkIn) {
                this.checkIn(bizFile);
            }
        } else {
            Object[] files = BizMetadataUtil.getRelateMetas(new IMDObject[]{bizFile}, 4);
            if (files.length == 0) {
                files = new IMDFile[]{bizFile};
            }
            RemoteFSInfoCollection coll = RemoteFSInfoCollection.get(this.getMDProject());
            String serverUser = this.loginInfo.getServerUser();
            for (int i = 0; i < files.length; ++i) {
                String md5;
                RemoteFSInfo info;
                IMDFile file = files[i];
                if (!file.toFile().exists() || !StringUtils.isEmpty((String)(info = coll.addFile(file.getPath())).getCheckOutUser()) && !serverUser.equals(info.getCheckOutUser()) || (md5 = PFileUtils.getMD5(file.toFile())).equals(info.getMd5())) continue;
                String content = PFileUtils.getFileContent(file.toFile());
                byte[] contentbytes = StringZipper.zipStringToBytes(content);
                content = Base64.encodeBytes((byte[])contentbytes);
                this.executePost("store_metadata", "\u4fdd\u5b58\u5143\u6570\u636e", new String[]{"metadatapk", "md5", "alias", "zipped", "content"}, new String[]{file.getPath(), md5, AliasUtil.getAlias(file), "1", content});
            }
            if (checkIn) {
                ArrayList<IMDFile> list = new ArrayList<IMDFile>();
                list.addAll(Arrays.asList((Object[])files));
                if (!list.contains(bizFile)) {
                    list.add(bizFile);
                }
                this.checkIn(list.toArray(new IMDFile[list.size()]));
            }
        }
    }

    private String getPKs(IMDFile[] files, boolean onlyModified) {
        String pks = "";
        for (int i = 0; i < files.length; ++i) {
            if (pks.length() > 0) {
                pks = pks + ";";
            }
            if (onlyModified && !files[i].isModified()) continue;
            pks = pks + files[i].getPath();
        }
        return pks;
    }

    public boolean checkIn(IMDFile[] files) throws Exception {
        this.ensureLogin();
        String pks = this.getPKs(files, true);
        if (StringUtils.isEmpty((String)pks)) {
            return true;
        }
        this.executePost("checkin_metadatas", "\u89e3\u9501\u5143\u6570\u636e", new String[]{"metadatapks"}, new String[]{pks});
        if (this.content != null) {
            String body = this.getMessageBody();
            LogTool.logError("check in metadata error!: " + body, new Exception("check error"));
        } else {
            RemoteFSInfoCollection coll = RemoteFSInfoCollection.get(this.getMDProject());
            for (int i = 0; i < files.length; ++i) {
                coll.addFile(files[i].getPath()).setCheckOutUser(null);
            }
        }
        this.fireUpdated(files);
        return 200 != this.status;
    }

    private void fireUpdated(IMDFile[] files) {
        ArrayList<IMDFile> list = new ArrayList<IMDFile>();
        for (int i = 0; i < files.length; ++i) {
            for (IMDResource object = files[i]; object != null && !object.isRoot() && !list.contains(object); object = object.getParent()) {
                list.add((IMDFile)object);
            }
        }
        MDResourceUtil.fireResourceUpdated(list.toArray(new IMDObject[list.size()]));
    }

    public boolean checkIn(IMDFile file) throws Exception {
        return this.checkIn(new IMDFile[]{file});
    }

    public boolean isCheckOut(IMDFile file) throws Exception {
        if (this.isCheckOutLocal(file)) {
            return true;
        }
        this.updateMDTree(false);
        return this.isCheckOutLocal(file);
    }

    public boolean isCheckOutLocal(IMDFile file) {
        RemoteFSInfoCollection coll = RemoteFSInfoCollection.get(file.getMDProject());
        RemoteFSInfo info = coll.addFile(file.getPath());
        return this.loginInfo.getServerUser().equals(info.getCheckOutUser());
    }

    public String getCheckOutUser(IMDFile file) {
        RemoteFSInfoCollection coll = RemoteFSInfoCollection.get(file.getMDProject());
        RemoteFSInfo info = coll.addFile(file.getPath());
        return info.getCheckOutUser();
    }

    public void checkOut(IMDFile file) throws Exception {
        ArrayList<String> list;
        if (this.isCheckOut(file)) {
            return;
        }
        IMDFile[] files = BizMetadataUtil.getRelateMetas(new IMDObject[]{file}, 3);
        String pks = this.getPKs(files, false);
        this.executePost("checkout_metadatas", "\u9501\u5b9a\u5143\u6570\u636e", new String[]{"metadatapks"}, new String[]{pks});
        if (this.content == null) {
            RemoteFSInfoCollection coll = RemoteFSInfoCollection.get(this.getMDProject());
            String serverUser = this.loginInfo.getServerUser();
            for (int i = 0; i < files.length; ++i) {
                coll.addFile(files[i].getPath()).setCheckOutUser(serverUser);
            }
            this.fireUpdated(files);
            return;
        }
        String msg = this.getMessageBody();
        String[] items = StringUtils.split((String)msg, (String)";");
        HashMap map = new HashMap();
        int len = this.getMDProject().getPrefix().length() + this.projectName.length() + 1;
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            String[] p = StringUtils.split((String)item, (String)":");
            if (p.length != 2) continue;
            list = (ArrayList<String>)map.get(p[1]);
            if (list == null) {
                list = new ArrayList<String>();
                map.put(p[1], list);
            }
            if (p[0].length() > len) {
                p[0] = p[0].substring(len);
            }
            list.add(p[0]);
        }
        StringBuffer sb = new StringBuffer();
        for (String user : map.keySet()) {
            list = (List)map.get(user);
            sb.append("\u7528\u6237[" + user + "]\u9501\u5b9a\u4e86\u4ee5\u4e0b\u5143\u6570\u636e\uff1a\r\n");
            for (int i = 0; i < list.size(); ++i) {
                sb.append("- " + list.get(i) + "\r\n");
            }
            sb.append("\r\n");
        }
        LogTool.logError(sb.toString(), null);
        throw new Exception("\u5143\u6570\u636e\u53ca\u76f8\u5173\u5143\u6570\u636e\u6b63\u5728\u88ab\u5176\u5b83\u7528\u6237\u4fee\u6539\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u65e5\u5fd7\u89c6\u56fe");
    }

    public Map getFileInfo(IMDFile[] files) throws Exception {
        this.ensureLogin();
        String pks = this.getPKs(files, false);
        this.executePost("query_metadata_status", "\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f", "metadatapks", pks);
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this.content));
        Map map = null;
        try {
            map = (Map)in.readObject();
            in.close();
        }
        catch (Exception ex) {
            LogTool.logError("\u5904\u7406\u8bf7\u6c42\u9519\u8bef", ex);
            return null;
        }
        HashMap<String, RemoteFSInfo> result = new HashMap<String, RemoteFSInfo>();
        for (String path : map.keySet()) {
            Properties prop = (Properties)map.get(path);
            if (prop == null) continue;
            RemoteFSInfo serverInfo = new RemoteFSInfo(path, prop);
            result.put(path, serverInfo);
        }
        return result;
    }

    public void downloadMetadata(String path) throws Exception {
        this.executeGet("retrieve_dy_metadata&metadatapk=" + URIUtil.encodeAll((String)path), "\u4e0b\u8f7d\u5143\u6570\u636e");
        File root = this.getMDProject().getSrcMetadataDir();
        File nf = new File(root, path);
        PFileUtils.write2File(this.content, nf);
        try {
            IMDProject project = this.getMDProject();
            if (project != null && project.isContextInited()) {
                IMDFile mdFile = project.getRoot().getChildFile(path);
                IDevMetadataLoader loader = project.getMetadataLoader();
                loader.refresh(mdFile.toFile().getParentFile());
                loader.clear(mdFile.getBOSType(), (IMetaDataPK)mdFile.getMetaDataPK());
            }
        }
        catch (Throwable t) {
            LogTool.debug("\u6e05\u9664\u7f13\u5b58\u65f6\u51fa\u9519", t);
        }
    }

    public void resetMd5() throws Exception {
        this.ensureLogin();
        this.executeGet("reset_md5", "\u91cd\u7f6eMD5");
    }

    public boolean isUpdated(IMDFile file, long compareTS) throws Exception {
        if (!file.toFile().exists()) {
            return true;
        }
        Map map = this.getFileInfo(new IMDFile[]{file});
        RemoteFSInfo info = (RemoteFSInfo)map.get(file.getPath());
        long serverTime = info.getLastModifyTime();
        if (serverTime < 1L) {
            return true;
        }
        return serverTime != compareTS;
    }

    public int updateMetdata(IMDFile file, boolean force) throws Exception {
        this.ensureLogin();
        if (file.getExtension().equals("permission") || file.getExtension().equals("log") || "FnMenuTree.xml".equals(file.getPath())) {
            try {
                this.downloadMetadata(file.getPath());
                return 1;
            }
            catch (Exception ex) {
                if (this.status != -10007) {
                    throw ex;
                }
                return 0;
            }
        }
        this.executeGet("query_updated_metadatas&metadatapks=" + URIUtil.encodeAll((String)file.getPath()), "\u67e5\u8be2\u66f4\u65b0");
        String body = this.getMessageBody();
        if (StringUtils.isEmpty((String)body)) {
            return 0;
        }
        String[] pks = StringUtils.split((String)body, (String)"\n");
        IMDProject project = file.getMDProject();
        IMDFolder mdRoot = project.getRoot();
        int count = 0;
        for (int i = 0; i < pks.length; ++i) {
            String localMd5;
            String pk = pks[i];
            int index = pk.indexOf(58);
            String path = pk.substring(0, index);
            String md5 = pk.substring(index + 1);
            IMDFile mdfile = mdRoot.getChildFile(path);
            if (!mdfile.toFile().exists()) {
                this.downloadMetadata(path);
                ++count;
                continue;
            }
            if (this.isCheckOutLocal(mdfile) && !force || (localMd5 = PFileUtils.getMD5(mdfile.toFile())).equals(md5)) continue;
            this.downloadMetadata(path);
            if (LogTool.isDebug() && !(localMd5 = PFileUtils.getMD5(mdfile.toFile())).equals(md5)) {
                LogTool.logWarn("\u66f4\u65b0\u540eMD5\u4e0d\u76f8\u540c:" + mdfile.toFile(), new Exception());
            }
            ++count;
        }
        return count;
    }

    public void deploy(IMDObject[] resources) throws Exception {
        for (int i = 0; i < resources.length; ++i) {
            IMDFile file;
            if (!(resources[i] instanceof IMDFile) || !this.isCheckOut(file = (IMDFile)resources[i])) continue;
            this.storeFile(file, false);
        }
        this.ensureLogin();
        IMDFile[] files = MDResourceUtil.listChildFiles(resources);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            sb.append(files[i].getPath() + ";");
        }
        this.executePost("deploy_metadata", "\u53d1\u5e03\u5143\u6570\u636e", "metadatapks", sb.toString());
    }

    private void executePost(String command, String alias, String[] parameterNames, String[] parameterValues) throws Exception {
        this.executePost(command, alias, parameterNames, parameterValues, null);
    }

    private void executePost(String command, String alias, String parameterNames, String parameterValues) throws Exception {
        this.executePost(command, alias, new String[]{parameterNames}, new String[]{parameterValues});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executePost(String command, String alias, String[] parameterNames, String[] parameterValues, File toFile) throws Exception {
        block11: {
            this.content = null;
            this.status = -5000;
            UTF8PostMethod post = new UTF8PostMethod(this.appPath);
            this.connectionManager.getParams().setConnectionTimeout(50000);
            this.connectionManager.getParams().setSoTimeout(50000);
            try {
                post.setParameter("command", command);
                if (parameterNames != null) {
                    for (int i = 0; i < parameterNames.length; ++i) {
                        post.setParameter(parameterNames[i], parameterValues[i]);
                    }
                }
                this.status = this.httpClient.executeMethod((HttpMethod)post);
                if (toFile != null && this.status == 200) {
                    InputStream responseBodyAsStream = null;
                    try {
                        responseBodyAsStream = post.getResponseBodyAsStream();
                        PFileUtils.write2File(responseBodyAsStream, toFile);
                        break block11;
                    }
                    finally {
                        FileUtils.close(responseBodyAsStream);
                    }
                }
                this.getContent((HttpMethodBase)post);
            }
            catch (Exception ex) {
                throw this.wrapException(alias, ex);
            }
            finally {
                post.releaseConnection();
            }
        }
        this.doWithStatus(alias);
    }

    private void executeGet(String command, String alias) throws Exception {
        this.executeGet(command, alias, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeGet(String command, String alias, File toFile) throws Exception {
        block9: {
            this.content = null;
            this.status = -5000;
            UTF8GetMethod get = new UTF8GetMethod(this.appPath + "?command=" + command);
            get.getParams().setParameter("http.method.retry-handler", (Object)this.retryHandler);
            get.getParams().setParameter("http.socket.timeout", (Object)new Integer(50000));
            this.connectionManager.getParams().setConnectionTimeout(50000);
            this.connectionManager.getParams().setSoTimeout(50000);
            try {
                this.status = this.httpClient.executeMethod((HttpMethod)get);
                if (toFile != null && this.status == 200) {
                    InputStream responseBodyAsStream = null;
                    try {
                        responseBodyAsStream = get.getResponseBodyAsStream();
                        PFileUtils.write2File(responseBodyAsStream, toFile);
                        break block9;
                    }
                    finally {
                        FileUtils.close(responseBodyAsStream);
                    }
                }
                this.getContent((HttpMethodBase)get);
            }
            catch (Exception ex) {
                throw this.wrapException(alias, ex);
            }
            finally {
                get.releaseConnection();
            }
        }
        this.doWithStatus(alias);
    }

    private void doWithStatus(String alias) throws Exception {
        if (this.status != 200) {
            throw this.wrapException(alias, null);
        }
    }

    private void getContent(HttpMethodBase method) throws IOException {
        InputStream responseBodyAsStream = null;
        try {
            responseBodyAsStream = method.getResponseBodyAsStream();
            this.content = PFileUtils.getContents(responseBodyAsStream);
        }
        finally {
            FileUtils.close(responseBodyAsStream);
        }
        if (this.content != null && this.content.length == 0) {
            this.content = null;
        }
        if (this.content == null) {
            return;
        }
        if (method.getResponseHeader("zipped") == null) {
            return;
        }
        if (!"1".equalsIgnoreCase(method.getResponseHeader("zipped").getValue())) {
            return;
        }
        this.content = StringZipper.ungzipFromBytes(this.content);
    }

    public boolean delete(IMDFile[] files) throws Exception {
        this.ensureLogin();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            sb.append(files[i].getPath() + ";");
            LogTool.logInfo("\u5f85\u5220\u9664\u5143\u6570\u636e:" + files[i].getPath(), null);
        }
        this.executePost("delete_metadata", "\u5220\u9664\u5143\u6570\u636e", "metadatapks", sb.toString());
        return 200 == this.status && this.content == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadClientEnv(File root, IProgressMonitor monitor) throws Exception {
        this.ensureLogin();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName("\u6b63\u5728\u68c0\u67e5\u66f4\u65b0..");
        this.executeGet("list_client_files", "\u83b7\u53d6\u5ba2\u6237\u7aef\u5217\u8868");
        Properties props = new Properties();
        File propFile = new File(root, "time.properties");
        if (propFile.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(propFile);
                props.load(fileInputStream);
            }
            catch (Throwable t) {
                try {
                    LogTool.logError("\u52a0\u8f7d\u66f4\u65b0\u65f6\u95f4\u65f6\u51fa\u9519", t);
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileInputStream);
                    throw throwable;
                }
                FileUtils.close(fileInputStream);
            }
            FileUtils.close(fileInputStream);
        }
        String body = this.getMessageBody();
        String[] paths = StringUtils.split((String)body, (String)"\n");
        monitor.beginTask("\u4e0b\u8f7d\u5143\u6570\u636e", paths.length);
        int n = paths.length;
        for (int i = 0; i < n; ++i) {
            String oldTime;
            if (monitor.isCanceled()) {
                throw new InterruptedException("\u7528\u6237\u53d6\u6d88");
            }
            String path = paths[i];
            String newTime = null;
            int index = path.indexOf(61);
            if (index != -1) {
                path = paths[i].substring(0, index);
                newTime = paths[i].substring(index + 1);
            }
            if (!StringUtils.isEmpty((String)(oldTime = props.getProperty(path))) && oldTime.equals(newTime)) continue;
            if (!StringUtils.isEmpty(newTime)) {
                props.put(path, newTime);
            }
            monitor.setTaskName("\u4e0b\u8f7d(" + i + "/" + n + "):" + path);
            this.downloadClientFile(root, path);
            monitor.worked(1);
        }
        if (!propFile.exists() && propFile.getParentFile() != null) {
            propFile.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(propFile);
            props.store(fileOutputStream, "mic");
        }
        catch (Throwable t) {
            try {
                LogTool.logError("\u4fdd\u5b58\u66f4\u65b0\u65f6\u95f4\u65f6\u51fa\u9519", t);
            }
            catch (Throwable throwable) {
                FileUtils.close(fileOutputStream);
                throw throwable;
            }
            FileUtils.close(fileOutputStream);
        }
        FileUtils.close(fileOutputStream);
        monitor.done();
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getOrmrpcUrl() {
        if (StringUtils.isEmpty((String)this.ormrpcUrl)) {
            try {
                URI uri = new URI(this.serverUrl, false);
                this.ormrpcUrl = "tcp://" + uri.getHost() + ":11034";
            }
            catch (Exception ex) {
                LogTool.logError("error", ex);
            }
        }
        return this.ormrpcUrl;
    }

    public Context getContext() {
        return this.context;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getTestUrl(String path) throws Exception {
        this.ensureLogin();
        String cmd = "query_test_url";
        if (!StringUtils.isEmpty((String)path)) {
            cmd = cmd + "&path=" + URIUtil.encodeAll((String)path);
        }
        this.executeGet(cmd, "\u83b7\u53d6\u6d4b\u8bd5\u5730\u5740");
        return this.getMessageBody();
    }

    public String getTestUrl() {
        return this.testUrl;
    }

    public LoginInfo getLoginInfo() {
        return this.loginInfo;
    }
}

