/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.actions.base;

import com.kingdee.bos.md.actions.base.BaseAction;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDObject;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDObjectAdapter;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.tool.LogTool;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;

public abstract class BaseMDResourceAction
extends BaseAction {
    private static Set ALL_ACTIONS = new HashSet();
    protected static final int ACCEPT_PROJECT = 1;
    protected static final int ACCEPT_FOLDER = 2;
    protected static final int ACCEPT_FILE = 4;
    protected static final int ACCEPT_MULTI = 8;
    protected static final int ACCEPT_EMPTY = 16;
    protected static final int ACCEPT_LIB = 32;
    protected static final int ACCEPT_REMOTE = 64;
    protected static final int TOOL_ACTION = 128;
    protected static final int LIMIT_PACKAGE = 256;
    protected static final int CHECK_REMOTE_SERVER = 512;
    protected static final int NO_EMPTY = 47;
    protected static final int NO_PROJECT = 14;
    protected static final int ALL = 63;
    protected static final int NO_LIB = 15;
    private boolean acceptProject = false;
    private boolean acceptFolder = false;
    private boolean acceptFile = false;
    private boolean acceptMulti = false;
    private boolean acceptEmtpy = false;
    private boolean acceptLib = false;
    private boolean acceptRemote = false;
    private boolean isToolAction = false;
    private boolean limitPackage = false;
    private boolean checkRemoteServer = false;
    private IMDObject[] resources;
    protected IStructuredSelection selection;
    private IMDProject project;

    public static void setSelectedFile(IMDFile file) {
    }

    public BaseMDResourceAction(int style) {
        this.acceptProject = (style & 1) != 0;
        this.acceptFolder = (style & 2) != 0;
        this.acceptFile = (style & 4) != 0;
        this.acceptMulti = (style & 8) != 0;
        this.acceptEmtpy = (style & 0x10) != 0;
        this.acceptLib = (style & 0x20) != 0;
        this.acceptRemote = (style & 0x40) != 0;
        this.isToolAction = (style & 0x80) != 0;
        this.limitPackage = (style & 0x100) != 0;
        this.checkRemoteServer = (style & 0x200) != 0;
        ALL_ACTIONS.add(this);
        this.setEnabled(this.acceptEmtpy);
    }

    protected boolean checkToolEnable() {
        return true;
    }

    private void setSelection(IStructuredSelection sel) {
        if (this.isToolAction) {
            this.project = null;
            for (Object adapter : sel) {
                IMDObject obj = null;
                if (adapter instanceof IMDObject) {
                    obj = (IMDObject)adapter;
                } else if (adapter instanceof MDObjectAdapter) {
                    obj = ((MDObjectAdapter)adapter).getModel();
                } else if (adapter instanceof IAdaptable) {
                    IResource resource = (IResource)((IAdaptable)adapter).getAdapter(IResource.class);
                    obj = MDResourceUtil.toMDResource(resource);
                }
                if (obj == null) continue;
                this.project = obj.getMDProject();
                break;
            }
            if (!this.checkBiz(new IMDObject[]{this.project})) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
            return;
        }
        this.resources = null;
        this.selection = null;
        this.project = null;
        this.setEnabled(false);
        if (sel.isEmpty()) {
            if (!this.acceptEmtpy) {
                return;
            }
            this.setEnabled(true);
            return;
        }
        if (!this.acceptMulti && sel.size() > 1) {
            return;
        }
        ArrayList<IMDObject> res = new ArrayList<IMDObject>();
        for (Object adapter : sel) {
            IMDObject obj = null;
            if (adapter instanceof IMDObject) {
                obj = (IMDObject)adapter;
            } else if (adapter instanceof MDObjectAdapter) {
                obj = ((MDObjectAdapter)adapter).getModel();
            } else if (adapter instanceof IAdaptable) {
                IResource resource = (IResource)((IAdaptable)adapter).getAdapter(IResource.class);
                obj = MDResourceUtil.toMDResource(resource);
            }
            if (obj == null) {
                return;
            }
            if (!this.acceptLib && !obj.isModified()) {
                return;
            }
            if (obj instanceof IMDProject && !this.acceptProject) {
                return;
            }
            if (obj instanceof IMDFolder && !this.acceptFolder ? !this.acceptFolder : obj instanceof IMDFile && !this.acceptFile) {
                return;
            }
            res.add(obj);
        }
        if (res.isEmpty() && !this.acceptEmtpy) {
            return;
        }
        IMDObject[] ress = null;
        ress = this.acceptProject && !this.acceptFolder && !this.acceptFile ? res.toArray(new IMDProject[res.size()]) : (!this.acceptProject && this.acceptFolder && !this.acceptFile ? res.toArray(new IMDFolder[res.size()]) : (!this.acceptProject && !this.acceptFolder && this.acceptFile ? res.toArray(new IMDFile[res.size()]) : res.toArray(new IMDObject[res.size()])));
        this.project = ress[0].getMDProject();
        if (!this.checkBiz(ress)) {
            return;
        }
        this.resources = ress;
        this.selection = sel;
        if (!this.checkToolEnable()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        if (!(event.getSelection() instanceof IStructuredSelection)) {
            return;
        }
        this.setSelection((IStructuredSelection)event.getSelection());
    }

    protected boolean checkBiz(IMDObject[] resources) {
        return true;
    }

    public final void run() {
        try {
            this.run(this.resources);
        }
        catch (InvocationTargetException ex) {
            LogTool.logError(ex.getTargetException().getMessage(), ex.getTargetException());
            MessageDialog.openError((Shell)this.getShell(), (String)"\u9519\u8bef", (String)ex.getTargetException().getMessage());
            return;
        }
        catch (Exception e) {
            LogTool.logError("\u6267\u884cAction\u65f6\u51fa\u9519:" + e.getMessage(), e);
            MessageDialog.openError((Shell)this.getShell(), (String)"\u9519\u8bef", (String)("\u6267\u884c\u64cd\u4f5c\u65f6\u53d1\u751f\u9519\u8bef\uff1a" + e.getLocalizedMessage() + ", \u8be6\u7ec6\u65e5\u5fd7\u8bf7\u67e5\u770b\u9519\u8bef\u65e5\u5fd7\u89c6\u56fe"));
        }
    }

    protected abstract void run(IMDObject[] var1) throws Exception;

    protected final IMDProject getMDProject() {
        return this.project;
    }
}

