/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.cache;

import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MDSimpleObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map extendProperties = new HashMap();
    private Map resources = new HashMap();
    private Properties properties = new Properties();
    private Map pks = new HashMap();
    private String path = null;

    public MDSimpleObject(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setProperty(String key, String value) {
        if (key != null && value != null) {
            this.properties.setProperty(key.toLowerCase(), value);
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key.toLowerCase());
    }

    public String getPK(String key) {
        return this.getProperty(key);
    }

    public String[] getPKS(String key) {
        String[] tpk = (String[])this.pks.get(key);
        if (tpk == null) {
            return new String[0];
        }
        return tpk;
    }

    public void addPKS(String key, List list) {
        String[] old = this.getPKS(key);
        if (old != null) {
            for (int i = 0; i < old.length; ++i) {
                if (list.contains(old[i]) || StringUtils.isEmpty((String)old[i])) continue;
                list.add(old[i]);
            }
        }
        this.pks.put(key, list.toArray(new String[list.size()]));
    }

    public String getPackageName() {
        return this.properties.getProperty("package");
    }

    public String getName() {
        return this.properties.getProperty("name");
    }

    public boolean isUserDefined() {
        return Boolean.valueOf(this.properties.getProperty("userdefined"));
    }

    public String getAlias(String lang) {
        String key = this.properties.getProperty("alias");
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        String alias = this.getResource(key, lang = this.fixLang(lang));
        if ("null".equalsIgnoreCase(alias)) {
            return null;
        }
        return alias;
    }

    public String getDescription(String lang) {
        lang = this.fixLang(lang);
        return this.getResource(this.properties.getProperty("description"), lang);
    }

    public void setExtendProperty(String key, String value, String lang) {
        Properties prop = (Properties)this.extendProperties.get(lang = this.fixLang(lang));
        if (prop == null) {
            prop = new Properties();
            this.extendProperties.put(lang, prop);
        }
        prop.put(key.toLowerCase(), value);
    }

    public String getExtendProperty(String key, String lang) {
        Properties prop = (Properties)this.extendProperties.get(lang = this.fixLang(lang));
        if (prop == null) {
            return null;
        }
        return prop.getProperty(key.toLowerCase());
    }

    public String getExtendProperty(String key) {
        return this.getExtendProperty(key, null);
    }

    public String getResource(String key, String lang) {
        Properties prop = (Properties)this.resources.get(lang = this.fixLang(lang));
        if (prop == null) {
            return null;
        }
        return prop.getProperty(key.toLowerCase());
    }

    public String getResource(String key) {
        return this.getExtendProperty(key, null);
    }

    public void setResource(String key, String value, String lang) {
        Properties prop = (Properties)this.resources.get(lang = this.fixLang(lang));
        if (prop == null) {
            prop = new Properties();
            this.resources.put(lang, prop);
        }
        prop.put(key.toLowerCase(), value);
    }

    private String fixLang(String lang) {
        if (lang == null) {
            lang = "zh_CN";
        }
        return lang;
    }
}

