/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.mdfs;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.engine.impl.Loader2;
import com.kingdee.bos.md.cache.SimpleMDUtil;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.bos.md.mdfs.MDFile;
import com.kingdee.bos.md.mdfs.MDFolder;
import com.kingdee.bos.md.mdfs.MDObject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.SuffixCollection;
import com.kingdee.bos.metadata.management.SuffixInfo;
import com.kingdee.bos.metadata.util.ContextManager;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.PFileUtils;
import com.kingdee.bos.tool.context.IToolContext;
import com.kingdee.bos.tool.context.SolutionDescription;
import com.kingdee.bos.tool.context.ToolContext;
import com.kingdee.bos.tool.function.Func2V;
import com.kingdee.bos.tool.function.Maps;
import com.kingdee.bos.tool.solution.SolutionDelegate;
import com.kingdee.bos.tool.solution.SolutionHelper;
import com.kingdee.bos.tool.utils.LocaleUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class MDProject
extends MDObject
implements IMDProject {
    protected File projectRoot = null;
    protected String name = null;
    private IProject eclipse_prj;
    private IFolder metadata_dir;
    private IFolder basemetas_dir;
    private boolean isDisposed = false;
    private File srcMetadataDir = null;
    private File baseMetadataDir = null;
    protected SolutionInfo solutionInfo = null;
    protected HashMap suffixes;
    protected Locale locale;
    protected String prefix = null;
    protected ToolContext context = null;
    protected IDevMetadataLoader loader = null;
    protected Hashtable<String, File[]> zipEntryMap = null;
    private File[] baseMetadataJars = null;
    private boolean isExtSolution = false;
    private Map<String, IMDResource> libResources = new HashMap<String, IMDResource>();
    private static final String[] excludeFileName = new String[]{"CVS", ".SVN"};

    public MDProject(File projectRoot, String name) {
        this.name = name;
        this.projectRoot = projectRoot;
        this.eclipse_prj = this.toIProject();
        if (!SolutionHelper.validSolutionProject(this.eclipse_prj)) {
            LogTool.logWarn("\u65e0\u6548\u7684BIM\u5de5\u7a0b:" + this.eclipse_prj.getLocationURI(), null);
            this.resetMetaDir();
            MDResourceUtil.addMDProject(this);
        } else {
            this.init();
        }
    }

    protected IProject toIProject() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!new File(projects[i].getLocationURI()).equals(this.projectRoot)) continue;
            return projects[i];
        }
        return null;
    }

    private void init() {
        this.resetMetaDir();
        this.clearCache();
        this.loadCache();
        MDResourceUtil.addMDProject(this);
    }

    public void resetMetaDir() {
        this.metadata_dir = this.eclipse_prj.getFolder("metadata");
        this.basemetas_dir = this.eclipse_prj.getFolder("basemetas");
        ProjectDescription desp = ((Project)this.eclipse_prj).internalGetDescription();
        if (desp.getLinkLocationURI(this.metadata_dir.getProjectRelativePath()) == null) {
            this.srcMetadataDir = new File(this.projectRoot, "metadata");
            if (this.metadata_dir.isLinked()) {
                try {
                    this.metadata_dir.delete(false, null);
                }
                catch (CoreException e) {
                    LogTool.logError("\u5220\u9664\u94fe\u63a5\u6587\u4ef6\u5931\u8d25:" + this.metadata_dir.getLocationURI(), e);
                }
            }
        } else {
            this.srcMetadataDir = new File(desp.getLinkLocationURI(this.metadata_dir.getProjectRelativePath()));
        }
        if (desp.getLinkLocationURI(this.basemetas_dir.getProjectRelativePath()) == null) {
            this.baseMetadataDir = new File(this.projectRoot, "basemetas");
            if (this.basemetas_dir.isLinked()) {
                try {
                    this.basemetas_dir.delete(false, null);
                }
                catch (CoreException e) {
                    LogTool.logError("\u5220\u9664\u94fe\u63a5\u6587\u4ef6\u5931\u8d25:" + this.basemetas_dir.getLocationURI(), e);
                }
            }
        } else {
            this.baseMetadataDir = new File(desp.getLinkLocationURI(this.basemetas_dir.getProjectRelativePath()));
        }
        if (!this.srcMetadataDir.exists()) {
            this.srcMetadataDir.mkdirs();
        }
    }

    public MDProject(File projectRoot, String name, File baseMetadaDir, File srcMetadataDir) {
        this.projectRoot = projectRoot;
        this.name = name;
        this.srcMetadataDir = srcMetadataDir;
        this.baseMetadataDir = baseMetadaDir;
        this.init();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Context getORMContext() {
        return this.getToolContext().getORMContext();
    }

    @Override
    public File getSrcMetadataDir() {
        return this.srcMetadataDir;
    }

    @Override
    public File getBaseMetadataDir() {
        return this.baseMetadataDir;
    }

    @Override
    public void clearCache() {
        if (this.baseMetadataJars != null) {
            File[] temp = this.baseMetadataJars;
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = null;
            }
            this.baseMetadataJars = null;
        }
        this.solutionInfo = null;
        if (this.suffixes != null) {
            this.suffixes.clear();
        }
        this.suffixes = null;
        this.locale = null;
        this.prefix = null;
        this.context = null;
        if (this.loader != null) {
            this.loader.close();
        }
        this.loader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SolutionInfo getSolutionInfo() {
        if (this.solutionInfo == null) {
            MDProject mDProject = this;
            synchronized (mDProject) {
                if (this.context == null) {
                    this.initToolContext();
                }
            }
        }
        return this.solutionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getSuffixes() {
        MDProject mDProject = this;
        synchronized (mDProject) {
            if (this.suffixes == null) {
                this.initToolContext();
            }
        }
        this.suffixes.put(MetaDataTypeList.WEBUIOBJECT.toString(), "web");
        return this.suffixes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Locale getLocale() {
        MDProject mDProject = this;
        synchronized (mDProject) {
            if (this.locale == null) {
                this.initToolContext();
            }
        }
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPrefix() {
        MDProject mDProject = this;
        synchronized (mDProject) {
            if (this.prefix == null) {
                this.initToolContext();
            }
        }
        return this.prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IToolContext getToolContext() {
        MDProject mDProject = this;
        synchronized (mDProject) {
            if (this.context == null) {
                this.initToolContext();
            }
        }
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDevMetadataLoader getMetadataLoader() {
        MDProject mDProject = this;
        synchronized (mDProject) {
            if (this.loader == null) {
                this.initToolContext();
            }
        }
        return this.loader;
    }

    private Context createContext(String slnName) {
        Context context = null;
        Method[] methods = Context.class.getMethods();
        int length = methods.length;
        for (int i = 0; i < length; ++i) {
            if (!"getOriginLocale".equals(methods[i].getName())) continue;
            final Method md = methods[i];
            context = new Context(slnName){

                public Locale getLocale() {
                    try {
                        return (Locale)md.invoke((Object)this, new Object[0]);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            };
            break;
        }
        if (context == null) {
            context = new Context(slnName);
        }
        return context;
    }

    private Context getOrCreateContext() {
        if (this.isContextInited()) {
            Context ctx = this.context.getORMContext();
            ctx.setLocale(null);
            return ctx;
        }
        return this.createContext("STUDIO");
    }

    protected synchronized void initToolContext() {
        if (this.isDisposed) {
            throw new RuntimeException("\u5143\u6570\u636e\u6587\u4ef6\u5f15\u7528\u7684\u5de5\u7a0b\u5df2\u7ecf\u5e9f\u5f03,\u8bf7\u4ece\u89c6\u56fe\u4e2d\u91cd\u65b0\u6253\u5f00");
        }
        LogTool.watch(null);
        SolutionDescription desc = null;
        try {
            desc = SolutionDescription.getSolutionDescriptor(this);
        }
        catch (Exception ex) {
            LogTool.logError("", ex);
        }
        if (desc == null && this.isValidateProject()) {
            SolutionDelegate delegate = new SolutionDelegate();
            delegate.setExtSolution(false);
            delegate.setName(this.name);
            delegate.setSource("metadata");
            delegate.setResource("resources");
            SolutionHelper.newSolutionXML(this.toFile().getAbsolutePath(), delegate);
            desc = SolutionDescription.getSolutionDescriptor(this);
        }
        ToolContext tcontext = new ToolContext();
        tcontext.setProjectName(this.name);
        if (desc != null) {
            tcontext.setSolutionName(desc.getSolutionName());
            tcontext.setResName(desc.getResName());
            tcontext.setExtSolution(desc.isExtSolution());
            tcontext.setExtDirs(desc.getExtDirs());
            if (desc.isExtSolution() && !desc.isNewSolution()) {
                File srcMetas = this.getSrcMetadataDir();
                if (srcMetas.exists()) {
                    srcMetas.renameTo(new File(this.toFile(), "metadata_bak"));
                    srcMetas.mkdir();
                }
                Vector v = desc.getExtDirs();
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    File f = new File(this.toFile(), (String)iter.next());
                    if (f.exists()) {
                        try {
                            FileUtils.getFileUtils().copyFileByPath(f, srcMetas);
                        }
                        catch (IOException e) {
                            LogTool.logError("\u62f7\u8d1d\u6269\u5c55\u5143\u6570\u636e\u76ee\u5f55\u65f6\u51fa\u9519", e);
                        }
                        continue;
                    }
                    LogTool.logError("\u6307\u5b9a\u7684\u6269\u5c55\u5143\u6570\u636e\u76ee\u5f55\u4e0d\u5b58\u5728," + f.getAbsolutePath(), new Exception());
                }
            }
        } else {
            tcontext.setSolutionName(this.name);
            tcontext.setResName("resources");
            tcontext.setExtSolution(false);
        }
        tcontext.setSrcName("metadata");
        Vector<String> stdDirs = new Vector<String>();
        stdDirs.add(this.getBaseMetadataDir().getAbsolutePath());
        tcontext.setStdDirs(stdDirs);
        Context ctx = this.getOrCreateContext();
        ctx.put((Object)"current_mode", (Object)"STUDIO");
        String path = this.getSrcMetadataDir().getAbsolutePath();
        File[] libFiles = this.getBaseMetadataJars();
        int n = libFiles.length;
        for (int i = 0; i < n; ++i) {
            path = path + ";" + libFiles[i].getAbsolutePath();
        }
        ctx.put((Object)"METADATAPATH", (Object)path);
        ContextManager.setContext((Context)ctx);
        tcontext.setORMContext(ctx);
        File expdir = new File(this.toFile(), "exporttemp");
        File basedir = new File(this.toFile(), "basetemp");
        if (tcontext.isExtSolution()) {
            if (!expdir.exists()) {
                expdir.mkdirs();
            }
            ctx.put((Object)"exporttemp", (Object)expdir);
            if (!basedir.exists()) {
                basedir.mkdirs();
            }
        }
        this.isExtSolution = tcontext.isExtSolution();
        if (this.loader != null) {
            this.loader.close();
        }
        this.loader = new Loader2(this.getSrcMetadataDir(), libFiles, expdir, basedir, tcontext.isExtSolution());
        ctx.put((Object)"DEVMETADATALOADER", (Object)this.loader);
        try {
            BOSLocaleUtil.reset((SolutionInfo)this.loader.getSolution());
        }
        catch (Throwable e) {
            LogTool.logError("\u91cd\u8f7d\u65b9\u8a00\u65f6\u51fa\u9519", e);
        }
        try {
            this.solutionInfo = this.loader.getSolution();
            tcontext.setSuffixes(this.solutionInfo.getSuffixes());
            tcontext.setPerfix(this.solutionInfo.getPerfix() == null ? "" : this.solutionInfo.getPerfix());
            SuffixCollection suffixCol = tcontext.getSuffixes();
            this.suffixes = new HashMap(suffixCol.size());
            int n2 = suffixCol.size();
            for (int i = 0; i < n2; ++i) {
                SuffixInfo info = suffixCol.get(i);
                this.suffixes.put(info.getMetaDataType(), info.getSuffix());
            }
            this.prefix = tcontext.getPerfix();
            this.prefix = StringUtils.replace((String)this.prefix, (String)"/", (String)".");
            this.locale = this.getDefaultLocale();
            if (this.locale != null) {
                ctx.setLocale(this.locale);
                ContextUtils.setLocaleToEnv((Locale)this.locale);
            }
        }
        catch (Throwable e) {
            LogTool.logError("\u52a0\u8f7d\u89e3\u51b3\u65b9\u6848\u4fe1\u606f(SOLUTION)\u65f6\u51fa\u9519", e);
        }
        this.store2Cache();
        this.context = tcontext;
        LogTool.watch("initialize project context [" + this.name + "]");
    }

    private Locale getDefaultLocale() {
        String nl = "zh_CN";
        if (nl == null) {
            nl = Locale.getDefault().getLanguage() + "_" + Locale.getDefault().getCountry();
        }
        Locale locale = null;
        LanguageCollection languages = this.solutionInfo.getLanguages();
        for (int i = 0; i < languages.size(); ++i) {
            LanguageInfo lang = languages.get(i);
            if (!lang.getLocaleString().equalsIgnoreCase(nl)) continue;
            locale = LocaleUtils.getLocale(lang);
            break;
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCache() {
        File file = new File(this.toFile(), "cache/project.cache");
        if (!file.exists()) {
            return;
        }
        ObjectInputStream input = null;
        FileInputStream finput = null;
        try {
            finput = new FileInputStream(file);
            input = new ObjectInputStream(finput);
            this.locale = (Locale)input.readObject();
            this.suffixes = (HashMap)input.readObject();
            this.solutionInfo = (SolutionInfo)input.readObject();
            this.prefix = (String)input.readObject();
            this.isExtSolution = (Boolean)input.readObject();
            finput.close();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (finput != null) {
                    finput.close();
                }
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (this.prefix != null) {
            this.prefix = StringUtils.replace((String)this.prefix, (String)"/", (String)".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void store2Cache() {
        block7: {
            if (!this.isValidateProject()) {
                return;
            }
            File file = new File(this.toFile(), "cache/project.cache");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            ObjectOutputStream out = null;
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(file);
                out = new ObjectOutputStream(new FileOutputStream(file));
                out.writeObject(this.locale);
                out.writeObject(this.suffixes);
                out.writeObject(this.solutionInfo);
                out.writeObject(this.prefix);
                out.writeObject(new Boolean(this.isExtSolution));
                out.flush();
                out.close();
                fout.close();
                FileUtils.close(out);
            }
            catch (Exception e) {
                LogTool.logError("\u4fdd\u5b58\u7f13\u5b58\u4fe1\u606f\u65f6\u51fa\u9519", e);
                break block7;
            }
            finally {
                FileUtils.close(out);
                FileUtils.close(fout);
            }
            FileUtils.close(fout);
        }
    }

    @Override
    public File toFile() {
        return this.projectRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] getLibFiles(String path) {
        path = MDResourceUtil.getMDPath((IMDProject)this, path);
        MDProject mDProject = this;
        synchronized (mDProject) {
            if (this.zipEntryMap == null) {
                this.initLibs();
            }
        }
        return this.zipEntryMap.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] getBaseMetadataJars() {
        MDProject mDProject = this;
        synchronized (mDProject) {
            if (this.baseMetadataJars == null || this.baseMetadataJars.length == 0) {
                this.initLibs();
            }
        }
        return this.baseMetadataJars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void initLibs() {
        long t0 = System.currentTimeMillis();
        this.libResources.clear();
        this.baseMetadataJars = MDResourceUtil.listMetadataLib(this);
        HashMap<String, ArrayList<File>> map = new HashMap<String, ArrayList<File>>();
        ZipFile zipFile = null;
        for (int i = 0; i < this.baseMetadataJars.length; ++i) {
            try {
                zipFile = new ZipFile(this.baseMetadataJars[i]);
                Enumeration<? extends ZipEntry> enu = zipFile.entries();
                while (enu.hasMoreElements()) {
                    try {
                        ArrayList<File> list;
                        ZipEntry entry = enu.nextElement();
                        String name = entry.getName();
                        if (name.indexOf("META-INF/") != -1 || name.indexOf("CVS") != -1 || name.indexOf(".svn") != -1) continue;
                        if (!this.libResources.containsKey(name)) {
                            this.libResources.put(name, entry.isDirectory() ? new MDFolder(this, name) : new MDFile(this, name));
                        }
                        if ((list = (ArrayList<File>)map.get(name)) == null) {
                            list = new ArrayList<File>();
                            map.put(name, list);
                        }
                        list.add(this.baseMetadataJars[i]);
                    }
                    catch (Throwable t) {
                        LogTool.logError("\u6253\u5f00\u538b\u7f29\u6587\u4ef6\u65f6\u51fa\u9519", t);
                    }
                }
                continue;
            }
            catch (IOException e) {
                LogTool.logError("\u8bfb\u53d6\u538b\u7f29\u6587\u4ef6\u65f6\u51fa\u9519", e);
                continue;
            }
            finally {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.zipEntryMap == null) {
            this.zipEntryMap = new Hashtable();
        } else {
            this.zipEntryMap.clear();
        }
        Maps.foreach(map, new Func2V<String, List<File>>(){

            @Override
            public void invoke(String path, List<File> value) {
                MDProject.this.zipEntryMap.put(path, value.toArray(new File[value.size()]));
            }
        });
        map.clear();
        System.out.println("initLibs take time:" + (System.currentTimeMillis() - t0));
    }

    @Override
    public File getMDFile(String path) {
        return new File(this.getSrcMetadataDir(), path);
    }

    @Override
    public IMDFolder getRoot() {
        return new MDFolder(this, "");
    }

    @Override
    public IMDFolder getPrefixRoot() {
        String p = this.getPrefix();
        if (!(p = StringUtils.replace((String)p, (String)".", (String)"/")).endsWith("/")) {
            p = p + "/";
        }
        return new MDFolder(this, p);
    }

    @Override
    public void dispose() {
        MDResourceUtil.fireResourceDeleted(this);
        SimpleMDUtil.removeInstance(this);
        if (MDResourceUtil.getLatestProject() == this) {
            MDResourceUtil.setLatestProject(null);
        }
        this.isDisposed = true;
        if (this.isContextInited()) {
            XMLAccessEngine.clearEngines((Context)this.getORMContext());
            if (this.context.getORMContext() != null) {
                this.context.getORMContext().remove((Object)"DEVMETADATALOADER");
            }
            if (ContextManager.getContext() == this.context.getORMContext()) {
                ContextManager.setContext(null);
                ContextManager.setContext2(null);
            }
        }
        this.clearCache();
        this.libResources.clear();
        this.libResources = null;
        if (this.zipEntryMap != null) {
            this.zipEntryMap.clear();
            this.zipEntryMap = null;
        }
        this.eclipse_prj = null;
        MDResourceUtil.removeMDProject(this.projectRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExtSolution() {
        MDProject mDProject = this;
        synchronized (mDProject) {
            return this.isExtSolution;
        }
    }

    @Override
    public synchronized void reset() {
        this.initLibs();
        this.initToolContext();
    }

    @Override
    public boolean isContextInited() {
        return this.context != null;
    }

    @Override
    public IMDProject getMDProject() {
        return this;
    }

    @Override
    public String getSuffix(BOSObjectType type) {
        if (type == null) {
            return null;
        }
        return (String)this.getSuffixes().get(type.toString());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MDProject)) {
            return false;
        }
        MDProject other = (MDProject)obj;
        if (this.isDisposed != other.isDisposed) {
            return false;
        }
        return this.toFile().equals(other.toFile());
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getLibResources() {
        MDProject mDProject = this;
        synchronized (mDProject) {
            if (this.libResources.isEmpty()) {
                this.initLibs();
            }
        }
        return this.libResources;
    }

    @Override
    public final boolean hasChild(String parentPath) {
        File[] files;
        File root = new File(this.getBaseMetadataDir(), parentPath);
        if (root.exists() && (files = root.listFiles()) != null && files.length > 0) {
            return true;
        }
        Map map = this.getLibResources();
        for (IMDResource res : map.values()) {
            if (!MDProject.isChildOf(parentPath, res.getPath(), false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized IMDResource[] listChild(String parentPath, boolean recursion, boolean includeFile, boolean includeDir) {
        ArrayList<IMDResource> list = new ArrayList<IMDResource>();
        Map map = this.getLibResources();
        HashSet<String> set = new HashSet<String>();
        for (IMDResource res : map.values()) {
            if (res instanceof IMDFile && !includeFile || res instanceof IMDFolder && !includeDir || !MDProject.isChildOf(parentPath, res.getPath(), !recursion)) continue;
            list.add(res);
            set.add(res.getPath());
        }
        File root = new File(this.getSrcMetadataDir(), parentPath);
        if (root.exists()) {
            File[] files = PFileUtils.listFile(root, recursion, includeFile, includeDir, excludeFileName);
            for (int i = 0; i < files.length; ++i) {
                String path = MDResourceUtil.getMDPath((IMDProject)this, files[i]);
                if (set.contains(path)) continue;
                set.add(path);
                if (files[i].isDirectory()) {
                    list.add(new MDFolder(this, path));
                    continue;
                }
                list.add(new MDFile(this, path));
            }
        }
        if (includeFile && !includeDir) {
            return list.toArray(new IMDFile[list.size()]);
        }
        if (!includeFile && includeDir) {
            return list.toArray(new IMDFolder[list.size()]);
        }
        return list.toArray(new IMDResource[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String path) {
        if (this.isModified(path)) {
            return true;
        }
        path = MDResourceUtil.getMDPath((IMDProject)this, path);
        MDProject mDProject = this;
        synchronized (mDProject) {
            if (this.zipEntryMap == null) {
                this.initLibs();
            }
        }
        return this.zipEntryMap.containsKey(path);
    }

    @Override
    public boolean isModified(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return false;
        }
        path = MDResourceUtil.getMDPath((IMDProject)this, path);
        File lFile = new File(this.getSrcMetadataDir(), path);
        return lFile.exists();
    }

    private static boolean isChildOf(String parent, String child, boolean onlyDirect) {
        if (!"".equals(parent) && !child.startsWith(parent) || child.equals(parent)) {
            return false;
        }
        if (!onlyDirect) {
            return true;
        }
        if ((child = child.substring(parent.length())).endsWith("/")) {
            child = child.substring(0, child.length() - 1);
        }
        return child.indexOf(47) == -1;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.projectRoot.hashCode();
        return result;
    }

    @Override
    public boolean isValidateProject() {
        if (this.isDisposed) {
            LogTool.logError("\u6587\u4ef6\u5f15\u7528\u5de5\u7a0b\u662f\u7f13\u5b58\u6216\u88ab\u79fb\u9664[P/" + this.name + "],\u8bf7\u5728\u89c6\u56fe\u4e0a\u6253\u5f00\u5bf9\u5e94\u6587\u4ef6", null);
            return false;
        }
        return SolutionHelper.validSolutionProject(this.eclipse_prj);
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }
}

