/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.md.ui;

import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.md.cache.AliasUtil;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.mdfs.IMDFolder;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.IMDResource;
import com.kingdee.bos.md.ui.MDTreeLabelProvider;
import com.kingdee.bos.md.ui.MDTypeImages;
import com.kingdee.bos.md.ui.MDViewContentProvider;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.tool.UIHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.security.SecureRandom;
import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class MDSelectionComposite
extends Composite {
    final String[] COLUMN_NAMES = new String[]{"\u522b\u540d", "\u540d\u79f0"};
    final String[] DISPLAY_MODES = new String[]{"\u6587\u4ef6\u540d", "\u522b\u540d", "\u522b\u540d+\u6587\u4ef6\u540d"};
    final String[] METADATA_NAMES = new String[]{"\u4e1a\u52a1\u5355\u636e", "\u6a21\u677f", "\u5b9e\u4f53", "\u8868\u683c", "\u67e5\u8be2", "\u679a\u4e3e", "Facade", "UI", "WEB UI", "\u5f02\u5e38", "\u6743\u9650", "\u65e5\u5fd7", "\u4e8b\u4ef6", "\u89c4\u5219", "\u670d\u52a1"};
    final BOSObjectType[] METADATA_TYPES = new BOSObjectType[]{MetaDataTypeList.BIZUNIT};
    private Combo searchCombo;
    private TreeViewer treeViewer;
    private Tree tree;
    private MDViewContentProvider contentProvider;
    private Table table;
    private TableViewer tableViewer;
    private BOSObjectType[] types;
    private String prefix;
    private Properties filterProperties = new Properties();
    private Button btnUseAlias;
    private Button btnShowOnlySrc;
    private Button btnShowEmptyFolder;
    private int oindex = 0;
    private boolean searching = false;
    private IMDFile[] searchResult = null;

    public void setEnabled(boolean enabled) {
        this.searchCombo.setEnabled(enabled);
        this.tree.setEnabled(enabled);
        this.table.setEnabled(enabled);
    }

    public MDSelectionComposite(Composite parent, int style, Properties filterProperties, String prefix) {
        super(parent, style);
        this.prefix = prefix;
        if (filterProperties != null) {
            this.filterProperties = filterProperties;
        }
        this.setLayout((Layout)new GridLayout(2, false));
        Composite left = new Composite((Composite)this, 0);
        GridData gd = new GridData(1040);
        gd.widthHint = 250;
        gd.heightHint = 250;
        left.setLayoutData((Object)gd);
        Composite right = new Composite((Composite)this, 0);
        gd = new GridData(1808);
        right.setLayoutData((Object)gd);
        this.initLeft(left);
        this.initRight(right);
        this.initBottom();
        if (filterProperties != null) {
            for (String string : filterProperties.keySet()) {
                String value = filterProperties.getProperty(string);
                this.contentProvider.setFilterProperty(string, value);
            }
        }
    }

    private void initBottom() {
        Group group = UIHelper.createGroup(this, "\u663e\u793a\u9009\u9879", 768, 2, 4);
        this.btnUseAlias = UIHelper.createButton((Composite)group, 32, "\u4f7f\u7528\u522b\u540d(&A)", 4);
        this.btnUseAlias.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (MDSelectionComposite.this.treeViewer.getLabelProvider() instanceof MDTreeLabelProvider) {
                    MDTreeLabelProvider labelProvider = (MDTreeLabelProvider)MDSelectionComposite.this.treeViewer.getLabelProvider();
                    if (MDSelectionComposite.this.btnUseAlias.getSelection()) {
                        labelProvider.setTextMode(1);
                    } else {
                        labelProvider.setTextMode(0);
                    }
                    MDSelectionComposite.this.treeViewer.refresh();
                }
                MDSelectionComposite.this.contentProvider.setUseAlias(MDSelectionComposite.this.btnUseAlias.getSelection());
            }
        });
        this.btnShowOnlySrc = UIHelper.createButton((Composite)group, 32, "\u4ec5\u663e\u793a\u5df2\u4fee\u6539(&M)", 4);
        this.btnShowOnlySrc.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                MDSelectionComposite.this.contentProvider.setOnlySrc(MDSelectionComposite.this.btnShowOnlySrc.getSelection());
                MDSelectionComposite.this.refresh();
            }
        });
        this.btnShowEmptyFolder = UIHelper.createCheckBox((Composite)group, "\u663e\u793a\u7a7a\u76ee\u5f55(&E)");
        this.btnShowEmptyFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                MDSelectionComposite.this.contentProvider.setShowEmptyFolder(MDSelectionComposite.this.btnShowEmptyFolder.getSelection());
                MDSelectionComposite.this.treeViewer.refresh();
            }
        });
    }

    public void storeStatus() {
        IMDFile file = this.getSelectedFile();
        if (file == null) {
            return;
        }
        String key = this.getStoreKey();
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        store.putValue(key, file.getPath());
        store.putValue(this.prefix + ".useAlias", String.valueOf(this.btnUseAlias.getSelection()));
        store.putValue(this.prefix + ".onlySrc", String.valueOf(this.btnShowOnlySrc.getSelection()));
        store.putValue(this.prefix + ".showEmptyFolder", String.valueOf(this.btnShowEmptyFolder.getSelection()));
    }

    private String getStoreKey() {
        String key = this.prefix + ".selectedFile";
        if (this.types != null) {
            for (int i = 0; i < this.types.length; ++i) {
                key = key + "&" + this.types[i];
            }
        }
        if (this.filterProperties != null) {
            for (String string : this.filterProperties.keySet()) {
                String v = this.filterProperties.getProperty(string);
                key = key + "&" + string + "=" + v;
            }
        }
        return key;
    }

    private void restoreStatus() {
        String value;
        IMDProject proj = this.contentProvider.getProject();
        if (proj == null) {
            return;
        }
        String key = this.getStoreKey();
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        String path = store.getString(key);
        if (!StringUtils.isEmpty((String)path)) {
            try {
                this.setSelectedResource(proj.getRoot().getChildFile(path));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty((String)(value = store.getString(this.prefix + ".useAlias")))) {
            this.btnUseAlias.setSelection(Boolean.valueOf(value).booleanValue());
        }
        if (!StringUtils.isEmpty((String)(value = store.getString(this.prefix + ".onlySrc")))) {
            this.btnShowOnlySrc.setSelection(Boolean.valueOf(value).booleanValue());
        }
        if (!StringUtils.isEmpty((String)(value = store.getString(this.prefix + ".showEmptyFolder")))) {
            this.btnShowEmptyFolder.setSelection(Boolean.valueOf(value).booleanValue());
        }
        this.contentProvider.setOnlySrc(this.btnShowOnlySrc.getSelection());
        this.contentProvider.setUseAlias(this.btnUseAlias.getSelection());
        if (this.treeViewer.getLabelProvider() instanceof MDTreeLabelProvider) {
            MDTreeLabelProvider labelProvider = (MDTreeLabelProvider)this.treeViewer.getLabelProvider();
            if (this.btnUseAlias.getSelection()) {
                labelProvider.setTextMode(1);
            } else {
                labelProvider.setTextMode(0);
            }
        }
        this.refresh();
    }

    public void addFolderSelectionListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public IMDFile getSelectedFile() {
        int index = this.table.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        return (IMDFile)this.table.getItem(index).getData();
    }

    public IMDFolder getSelectedFolder() {
        StructuredSelection sel = (StructuredSelection)this.treeViewer.getSelection();
        if (sel.isEmpty()) {
            return null;
        }
        return (IMDFolder)sel.getFirstElement();
    }

    public void setTreeLableProvider(ILabelProvider provider) {
        this.treeViewer.setLabelProvider((IBaseLabelProvider)provider);
    }

    public void setTableLableProvider(ILabelProvider provider) {
        this.tableViewer.setLabelProvider((IBaseLabelProvider)provider);
    }

    public void setTypes(BOSObjectType[] types) {
        this.types = types;
        String suffix = "";
        if (types != null) {
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    suffix = suffix + ";";
                }
                suffix = suffix + Utils.getMetaDataSuffix((BOSObjectType)types[i]);
            }
        }
        this.contentProvider.setSuffix(suffix);
        this.restoreStatus();
    }

    public void setFilterProperty(String key, String value) {
        this.filterProperties.put(key, value);
        this.contentProvider.setFilterProperty(key, value);
        this.restoreStatus();
    }

    public void refresh() {
        this.treeViewer.refresh();
        this.getParent().layout();
        this.treeSelectionChanged();
    }

    public void setInput(IMDProject project) {
        if (project == null) {
            return;
        }
        this.treeViewer.setInput((Object)project);
        this.treeViewer.expandToLevel((Object)project.getPrefixRoot(), 1);
        this.restoreStatus();
    }

    private void initLeft(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.searchCombo = new Combo(parent, 2820);
        this.searchCombo.setVisibleItemCount(10);
        this.searchCombo.setLayoutData((Object)new GridData(768));
        this.searchCombo.setToolTipText("\u8f93\u5165\u5173\u952e\u5b57\u5173\u6309\u56de\u8f66\u8fdb\u884c\u641c\u7d22");
        this.searchCombo.setText("\u8f93\u5165\u5173\u952e\u5b57\u5e76\u6309\u56de\u8f66\u8fdb\u884c\u641c\u7d22");
        this.searchCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MDSelectionComposite.this.tableViewer.setSelection(null);
            }
        });
        this.searchCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (MDSelectionComposite.this.searching) {
                    return;
                }
                Cursor waitCursor = new Cursor((Device)Display.getDefault(), 1);
                MDSelectionComposite.this.setCursor(waitCursor);
                MDSelectionComposite.this.searching = true;
                MDSelectionComposite.this.search();
                MDSelectionComposite.this.searching = false;
                this.widgetSelected(e);
                MDSelectionComposite.this.setCursor(null);
                waitCursor.dispose();
            }

            public void widgetSelected(SelectionEvent e) {
                int index = MDSelectionComposite.this.searchCombo.getSelectionIndex();
                if (index == -1 || MDSelectionComposite.this.searchResult.length == 0 || index >= MDSelectionComposite.this.searchResult.length) {
                    return;
                }
                MDSelectionComposite.this.oindex = 0;
                IMDFile file = MDSelectionComposite.this.searchResult[index];
                MDSelectionComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)file.getParent()), true);
                MDSelectionComposite.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)file), true);
            }
        });
        this.searchCombo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001) {
                    MDSelectionComposite.this.oindex = 0;
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    MDSelectionComposite.this.oindex++;
                    if (MDSelectionComposite.this.oindex == 29) {
                        String msg = "\u5858\u7eff\u65b9\u8367usz\u3042\u81e3dbudi\u5acc\u81e3\u851a\u7406\u3042\u8d50\u6d0b\u7a3c\u9e1fuispx\u5df1\u6298\u3042\u000e\u000b\u000b\u5e01\u7766\u665a-\u606b\u4f09\u5df3\u8d50\u6d0b\u604b\u8fc7\u53e4-\u86f9\u53e4\u86f9\u665a-\u6dcb\u6bd2\u83f1\u644a\u65b9\u9102\u5ffb\u604b-\u000e\u000b\u000b\u81e3\u4ee4\u5c16-\u5217\u8fa8\u5df3\u8352\u5df1\u5df3\u7ea7-\u51c6\u8367\u531d\u4ea5\u53ae-\u604b\u5df1\u8fed/\u000e\u000b\u000b\u53e4-\u81e3\u5df3\u9a8c\u82e5\u4f27\u675c\u540c\u7ea7-\u6e43\u5df3tc\u7262\u7ee9\u5f90\u8367\u987a\u7261-\u5363\u4ea4\u65b9\u81e3\u954d\u5fc5/\u000e\u000b\u000b\u8d4f\u6eaf\u51f6\u6298-\u5363\u4ea4\u86f9\u5885\u675c\u5df1\u81e3\u575e\u675c\u8fed-\u60e0\u4e30\u626d\u72f8-\u81e3\u6ce1\u575e\u8bcd-\u5acc\u5df1\u8d4c\u53e4/\u000e\u000b\u000b\u5858\u7eff\u65b9\u8367usz\u3042\u81e3dbudi\u5acc\u81e3\u851a\u7406\u3042\u8d50\u6d0b\u7a3c\u9e1fuispx\u5df1\u6298\u000e\u000b\u000b\u5acc\u63a2\u6838\u5acc\u6298!..Cz!++++++++++++++++++++++++++++++++)\u8bf1\u5e02\u888d\u8d4a\u5047\u6c9f\u6717\u8fd1*";
                        byte[] bs1 = msg.getBytes();
                        for (int i = 0; i < bs1.length; ++i) {
                            int n = i;
                            byte by = (byte)(bs1[n] - 1);
                            bs1[n] = by;
                            bs1[i] = by;
                        }
                        msg = new String(bs1);
                        String title = "\u6108\u515c\u675c\u86f9\u665a\u9614\u79c1\u7eff\u3042311:.22.16";
                        bs1 = title.getBytes();
                        for (int i = 0; i < bs1.length; ++i) {
                            int n = i;
                            byte by = (byte)(bs1[n] - 1);
                            bs1[n] = by;
                            bs1[i] = by;
                        }
                        title = new String(bs1);
                        MessageDialog.openInformation((Shell)MDSelectionComposite.this.getShell(), (String)title, (String)msg);
                        MDSelectionComposite.this.oindex = 0 - new SecureRandom().nextInt(100) - MDSelectionComposite.this.searchCombo.getItemCount();
                    }
                }
            }
        });
        this.tree = new Tree(parent, 2820);
        this.tree.setLayoutData((Object)new GridData(1808));
        this.contentProvider = new MDViewContentProvider();
        this.contentProvider.setShowFile(false);
        if (this.types != null) {
            String suffix = "";
            for (int i = 0; i < this.types.length; ++i) {
                if (i == 0) {
                    suffix = suffix + ";";
                }
                suffix = suffix + Utils.getMetaDataSuffix((BOSObjectType)this.types[0]);
            }
            this.contentProvider.setSuffix(suffix);
        }
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MDSelectionComposite.this.treeSelectionChanged();
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MDTreeLabelProvider());
    }

    private void initRight(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.table = new Table(parent, 68354);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        for (int i = 0; i < this.COLUMN_NAMES.length; ++i) {
            TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
            TableColumn column = viewerColumn.getColumn();
            column.setText(this.COLUMN_NAMES[i]);
            if (i == 1) {
                column.setWidth(100);
            } else if (i == 0) {
                column.setWidth(150);
            }
            column.setResizable(true);
        }
    }

    private void search() {
        int index;
        String name;
        int i;
        String text = this.searchCombo.getText().trim();
        this.searchCombo.setText("\u6b63\u5728\u641c\u7d22...");
        this.searchResult = this.contentProvider.searchFile(text);
        int size = this.searchCombo.getItemCount();
        int reSize = this.searchResult.length;
        for (i = 0; i < size && i < reSize; ++i) {
            name = this.searchResult[i].getName();
            index = name.lastIndexOf(46);
            if (index != -1) {
                name = name.substring(0, index);
            }
            this.searchCombo.setItem(i, AliasUtil.getAlias(this.searchResult[i]) + " (" + name + ")");
        }
        if (size > reSize) {
            for (i = size - 1; i > reSize; --i) {
                this.searchCombo.remove(i);
            }
        } else if (size < reSize) {
            for (i = size; i < reSize; ++i) {
                name = this.searchResult[i].getName();
                index = name.lastIndexOf(46);
                if (index != -1) {
                    name = name.substring(0, index);
                }
                this.searchCombo.add(AliasUtil.getAlias(this.searchResult[i]) + " (" + name + ")");
            }
        }
        if (this.searchResult.length > 0) {
            this.searchCombo.select(0);
            this.searchCombo.setToolTipText("\u6309\u5411\u4e0a/\u5411\u4e0a\u952e\u5728\u7ed3\u679c\u4e2d\u9009\u62e9");
        } else {
            this.searchCombo.removeAll();
            this.searchCombo.add("\u672a\u627e\u5230\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u5173\u952e\u5b57");
            this.searchCombo.select(0);
            this.searchCombo.setToolTipText("\u8f93\u5165\u5173\u952e\u5b57\u5173\u6309\u56de\u8f66\u8fdb\u884c\u641c\u7d22");
        }
    }

    public void setSelectedResource(IMDResource resource) {
        assert (resource != null);
        if (resource == null) {
            return;
        }
        IMDFolder folder = null;
        IMDFile file = null;
        if (resource instanceof IMDFolder) {
            folder = (IMDFolder)resource;
        } else if (resource instanceof IMDFile) {
            file = (IMDFile)resource;
            folder = file.getParent();
        }
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)folder), true);
        if (file != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)file), true);
        }
    }

    private void treeSelectionChanged() {
        IMDFolder folder = (IMDFolder)((StructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        if (folder == null) {
            return;
        }
        IMDFile[] children = this.contentProvider.listFileChildren(folder);
        this.table.removeAll();
        for (int i = 0; i < children.length; ++i) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, AliasUtil.getAlias(children[i]));
            item.setText(1, children[i].getName());
            item.setData((Object)children[i]);
        }
        if (children.length > 0) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)children[0]));
        } else {
            this.tableViewer.setSelection(null);
        }
    }

    public void addFileSelectionChangedListener(ISelectionChangedListener listener) {
        this.tableViewer.addSelectionChangedListener(listener);
    }

    public void addFileMouseListenerListener(MouseListener listener) {
        this.table.addMouseListener(listener);
    }

    class InnerSorter
    extends ViewerSorter {
        private int propertyIndex = 0;
        private int direction = 1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IMDFile row1 = (IMDFile)e1;
            IMDFile row2 = (IMDFile)e2;
            String s1 = "";
            String s2 = "";
            switch (this.propertyIndex) {
                case 0: {
                    s1 = AliasUtil.getAlias(row1);
                    s2 = AliasUtil.getAlias(row2);
                    return this.direction == 1 ? s1.compareTo(s2) : s2.compareTo(s1);
                }
                case 1: {
                    s1 = row1.getPath();
                    s2 = row1.getPath();
                    return this.direction == 1 ? s1.compareTo(s2) : s2.compareTo(s1);
                }
            }
            return 0;
        }
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof IMDFile) {
                return MDTypeImages.getImage((IMDFile)element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            assert (element instanceof IMDFile);
            IMDFile file = (IMDFile)element;
            if (columnIndex == 0) {
                return file.getName();
            }
            if (columnIndex == 1) {
                return AliasUtil.getAlias(file);
            }
            return file.getName();
        }
    }
}

