/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool;

import com.kingdee.util.StringUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PreferenceUtil {
    public static void storeValue(Combo combo, Object obj, String comboKey) {
        String text;
        String[] items = combo.getItems();
        String paths = text = combo.getText();
        for (int i = 0; i < items.length; ++i) {
            if (items[i].equals(text)) continue;
            paths = paths + ";" + items[i];
        }
        String key = PreferenceUtil.getKey(obj, comboKey) + ".items";
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        store.putValue(key, paths);
    }

    public static boolean restoreValue(Combo combo, Object obj, String comboKey) {
        String key = PreferenceUtil.getKey(obj, comboKey) + ".items";
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        String paths = store.getString(key);
        if (!StringUtils.isEmpty((String)paths)) {
            combo.setItems(paths.split(";"));
            combo.select(0);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean restoreSelectedValue(Combo combo, Object obj, String comboKey) {
        String key = PreferenceUtil.getKey(obj, comboKey) + ".text";
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        String value = store.getString(key);
        String[] items = combo.getItems();
        int index = -1;
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].equals(value)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            if (items.length <= 0) return false;
            combo.select(0);
            return true;
        } else {
            combo.select(index);
        }
        return true;
    }

    public static void storeSelectedValue(Combo combo, Object obj, String comboKey) {
        if (combo.getSelectionIndex() == -1) {
            return;
        }
        String value = combo.getItem(combo.getSelectionIndex());
        String key = PreferenceUtil.getKey(obj, comboKey) + ".text";
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        store.putValue(key, value);
    }

    public static void storeValue(Text text, Object obj, String textKey) {
        String value = text.getText();
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        String key = PreferenceUtil.getKey(obj, textKey) + ".text";
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        store.putValue(key, value);
    }

    public static String restoreValue(Object obj, String key) {
        key = PreferenceUtil.getKey(obj, key);
        return PlatformUI.getPreferenceStore().getString(key);
    }

    public static void storeValue(Object obj, String key, String value) {
        key = PreferenceUtil.getKey(obj, key);
        PlatformUI.getPreferenceStore().putValue(key, value);
    }

    public static boolean restoreValue(Text text, Object obj, String textKey) {
        String key = PreferenceUtil.getKey(obj, textKey) + ".text";
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        String value = store.getString(key);
        if (StringUtils.isEmpty((String)value)) {
            return false;
        }
        text.setText(value);
        return true;
    }

    public static String getKey(Object obj, String k) {
        if (k == null) {
            k = "";
        }
        if (obj != null) {
            k = obj.getClass().getName() + "." + k;
        }
        return k;
    }

    public static void storeValue(Button button, Object obj, String btnKey) {
        String value;
        if (button == null) {
            return;
        }
        String string = value = button.getSelection() ? "true" : "false";
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        String key = PreferenceUtil.getKey(obj, btnKey) + ".selection";
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        store.putValue(key, value);
    }

    public static boolean restoreValue(Button button, Object obj, String btnKey) {
        String key = PreferenceUtil.getKey(obj, btnKey) + ".selection";
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        String value = store.getString(key);
        if (StringUtils.isEmpty((String)value)) {
            return false;
        }
        button.setSelection(Boolean.valueOf(value).booleanValue());
        return true;
    }

    public static void restoreValue(Button button, Object obj, String btnKey, boolean defaultValue) {
        String key = PreferenceUtil.getKey(obj, btnKey) + ".selection";
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        String value = store.getString(key);
        if (StringUtils.isEmpty((String)value)) {
            button.setSelection(defaultValue);
        } else {
            button.setSelection(Boolean.valueOf(value).booleanValue());
        }
    }
}

