/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool;

import com.kingdee.bos.dao.xml.impl.AbstractMDValue;
import com.kingdee.bos.md.mdfs.IMDFile;
import com.kingdee.bos.md.multipageeditor.IMDFileEditorInput;
import com.kingdee.bos.metadata.MetaDataOptions;
import com.kingdee.bos.tool.FileUtils;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.check.VerifyExtensionPointProcess;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.utils.EditorHelper;
import com.kingdee.bos.tool.views.verify.CheckReport;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ToolCommonPlugin
extends AbstractUIPlugin {
    private static CheckReport checkReport = new CheckReport();
    private static ToolCommonPlugin plugin;
    private ResourceBundle resourceBundle;
    private static Properties debugProperties;
    private static ThreadLocal TIME_THREAD_LOCAL;
    private static ThreadLocal SID_THREAD_LOCAL;

    public ToolCommonPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.kingdee.bos.tool.ToolComonPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        AbstractMDValue.setDefaultUserDefined((!ToolCommonPlugin.isDevelopVersion() ? 1 : 0) != 0);
    }

    public static Shell getShell() {
        return plugin.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return ToolCommonPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        return ToolCommonPlugin.getDefault().internalGetActivePage();
    }

    public static IMDFile getActiveEditFile() {
        IWorkbenchPage page = ToolCommonPlugin.getActivePage();
        if (page != null && page.getActiveEditor() != null && page.getActiveEditor().getEditorInput() instanceof IMDFileEditorInput) {
            return ((IMDFileEditorInput)page.getActiveEditor().getEditorInput()).getFile();
        }
        return null;
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = this.getWorkbench().getWorkbenchWindows();
            if (windows == null || windows.length == 0) {
                return null;
            }
            window = windows[0];
            return window.getActivePage();
        }
        return window.getActivePage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        VerifyExtensionPointProcess.process();
        MetaDataOptions.setDevelopVersion((boolean)ToolCommonPlugin.isDevelopVersion());
        String pr = FileLocator.toFileURL((URL)ToolCommonPlugin.getPlugInURL(".")).getFile();
        File infoFile = new File(pr + "/debug.options");
        if (infoFile.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(infoFile);
                debugProperties.load(fileInputStream);
            }
            catch (Exception ex) {
                try {
                    LogTool.logError("load debug options error!", ex);
                }
                catch (Throwable throwable) {
                    FileUtils.close(fileInputStream);
                    throw throwable;
                }
                FileUtils.close(fileInputStream);
            }
            FileUtils.close(fileInputStream);
        }
        try {
            InputStream in = null;
            StringBuffer sb = new StringBuffer();
            ZipFile jar = null;
            try {
                if (new File(pr + "/toolcommon.jar").exists()) {
                    jar = new JarFile(new File(pr + "/toolcommon.jar"));
                    in = ((JarFile)jar).getInputStream(((JarFile)jar).getEntry("META-INF/MANIFEST.MF"));
                } else {
                    in = new FileInputStream(pr + "/META-INF/MANIFEST.MF");
                }
                byte[] bs = new byte[2048];
                int len = in.read(bs);
                while (len != -1) {
                    sb.append(new String(bs, 0, len));
                    len = in.read(bs);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {
                        LogTool.logError("load info error", e);
                    }
                }
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (Exception e) {
                        LogTool.logError("load info error", e);
                    }
                }
            }
            String s = this.findPart(sb, "BuildNumber:");
            if (s != null) {
                System.getProperties().put("tool_build_id", s.trim());
            }
            if ((s = this.findPart(sb, "Specification-Version:")) != null) {
                System.getProperties().put("tool_version", s.trim());
            }
        }
        catch (Exception ex) {
            LogTool.logError("load info error", ex);
        }
        Workbench.getInstance().addWorkbenchListener(new IWorkbenchListener(){

            public void postShutdown(IWorkbench workbench) {
            }

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                try {
                    IEditorPart[] editors = EditorHelper.findOpenEditors(null, false);
                    if (editors.length > 0) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        for (int i = 0; i < editors.length; ++i) {
                            page.closeEditor(editors[i], false);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return true;
            }
        });
    }

    private String findPart(StringBuffer sb, String partName) {
        int sPos = sb.indexOf(partName);
        if (sPos == -1) {
            return null;
        }
        int ePos = sb.indexOf("\n", sPos += partName.length());
        if (ePos == -1) {
            return null;
        }
        return sb.substring(sPos, ePos);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static ToolCommonPlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = ToolCommonPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static URL getPlugInURL(String name) throws IDEException {
        try {
            URL installURL = ToolCommonPlugin.getDefault().getBundle().getEntry("/");
            URL url = new URL(installURL, name);
            return url;
        }
        catch (MalformedURLException e) {
            throw new IDEException((Throwable)e);
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static void showConsole() {
        IWorkbenchPage page = ToolCommonPlugin.getActivePage();
        try {
            page.showView("com.kingdee.bos.tool.console.Console").setFocus();
        }
        catch (PartInitException e) {
            LogTool.logError("", e);
        }
    }

    public static void showVerifyView() {
        IWorkbenchPage page = ToolCommonPlugin.getActivePage();
        try {
            page.showView("com.kingdee.bos.tool.views.VerifyMessageView").setFocus();
        }
        catch (PartInitException e) {
            LogTool.logError("", e);
        }
    }

    public static void startWatch() {
        if ("true".equals(debugProperties.getProperty("debug.enable"))) {
            Stack<Long> stack = (Stack<Long>)TIME_THREAD_LOCAL.get();
            if (stack == null) {
                stack = new Stack<Long>();
                TIME_THREAD_LOCAL.set(stack);
            }
            stack.push(new Long(System.currentTimeMillis()));
            if (SID_THREAD_LOCAL.get() == null) {
                SID_THREAD_LOCAL.set(new Long(0L));
            }
        }
    }

    public static void stopWatch() {
        if (!"true".equals(debugProperties.getProperty("debug.enable"))) {
            return;
        }
        Stack stack = (Stack)TIME_THREAD_LOCAL.get();
        if (stack == null || stack.isEmpty()) {
            return;
        }
        Long seq = (Long)SID_THREAD_LOCAL.get();
        Long start = (Long)stack.pop();
        long end = System.currentTimeMillis();
        long es = end - start;
        if (debugProperties.getProperty("debug.time.filter") != null) {
            try {
                long filter = Long.parseLong(debugProperties.getProperty("debug.time.filter"));
                if (es < filter) {
                    return;
                }
            }
            catch (Exception filter) {
                // empty catch block
            }
        }
        StackTraceElement element = new Throwable().getStackTrace()[1];
        String clsName = element.getClassName();
        String methodName = element.getMethodName();
        ToolCommonPlugin.getDefault().getLog().log((IStatus)new Status(1, "BOS_DEBUG_TS", "[" + seq + "/" + stack.size() + "][" + es + "][" + methodName + "@" + clsName + "]"));
        if (stack.isEmpty()) {
            SID_THREAD_LOCAL.set(new Long(seq + 1L));
        }
    }

    public static boolean isDevelopVersion() {
        boolean isDevVer = false;
        try {
            Class<?> cls = Class.forName("com.kingdee.bos.license.BOSLicenseUtils");
            Object obj = cls.newInstance();
            Method method = cls.getMethod("isDevelopVersion", null);
            Object val = method.invoke(obj, null);
            isDevVer = val != null && val instanceof Boolean ? (Boolean)val : true;
        }
        catch (ClassNotFoundException e) {
            LogTool.logError("error", e);
            isDevVer = true;
        }
        catch (InstantiationException e) {
            LogTool.logError("error", e);
            isDevVer = false;
        }
        catch (IllegalAccessException e) {
            LogTool.logError("error", e);
            isDevVer = false;
        }
        catch (SecurityException e) {
            LogTool.logError("error", e);
            isDevVer = false;
        }
        catch (NoSuchMethodException e) {
            LogTool.logError("error", e);
            isDevVer = true;
        }
        catch (IllegalArgumentException e) {
            LogTool.logError("error", e);
            isDevVer = false;
        }
        catch (InvocationTargetException e) {
            LogTool.logError("error", e);
            isDevVer = false;
        }
        return isDevVer;
    }

    public static CheckReport getCheckReport() {
        return checkReport;
    }

    static {
        debugProperties = new Properties();
        TIME_THREAD_LOCAL = new ThreadLocal();
        SID_THREAD_LOCAL = new ThreadLocal();
    }
}

