/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.actions;

import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.actions.SelectionDispatchAction;
import com.kingdee.bos.tool.actions.WorkbenchRunnableAdapter;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class OpenProjectAction
extends SelectionDispatchAction
implements IResourceChangeListener {
    private static final int EMPTY_SELECTION = 1;
    private static final int ELEMENT_SELECTION = 2;
    private int fMode;
    private OpenResourceAction fWorkbenchAction = new OpenResourceAction(this.getShell());

    public OpenProjectAction(IWorkbenchSite site) {
        super(site);
        this.setText(this.fWorkbenchAction.getText());
        this.setToolTipText(this.fWorkbenchAction.getToolTipText());
        this.setEnabled(this.hasCloseProjects());
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.fWorkbenchAction.resourceChanged(event);
        switch (this.fMode) {
            case 2: {
                this.setEnabled(this.fWorkbenchAction.isEnabled());
                break;
            }
            case 1: {
                this.internalResourceChanged(event);
            }
        }
    }

    private void internalResourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
            for (int i = 0; i < projDeltas.length; ++i) {
                IResourceDelta projDelta = projDeltas[i];
                if ((projDelta.getFlags() & 0x4000) == 0) continue;
                this.setEnabled(this.hasCloseProjects());
                return;
            }
        }
    }

    protected void selectionChanged(ISelection selection) {
        this.setEnabled(this.hasCloseProjects());
        this.fMode = 1;
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            this.setEnabled(this.hasCloseProjects());
            this.fMode = 1;
            return;
        }
        this.fWorkbenchAction.selectionChanged(selection);
        this.setEnabled(this.fWorkbenchAction.isEnabled());
        this.fMode = 2;
    }

    protected void run(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            this.internalRun();
            return;
        }
        this.initSolution(selection);
        this.fWorkbenchAction.run();
    }

    private void internalRun() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), new ILabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return element.toString();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        dialog.setTitle("\u6253\u5f00\u9879\u76ee");
        dialog.setMessage("\u6253\u5f00\u5df2\u7ecf\u5173\u95ed\u7684\u9879\u76ee");
        dialog.setElements(this.getClosedProjects());
        dialog.setMultipleSelection(true);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        Object[] projects = dialog.getResult();
        IWorkspaceRunnable runnable = this.createRunnable(projects);
        ProgressMonitorDialog pd = new ProgressMonitorDialog(this.getShell());
        try {
            pd.run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(runnable));
        }
        catch (Exception e) {
            LogTool.logError("", e);
        }
    }

    private void initSolution(IStructuredSelection selection) {
    }

    private IWorkspaceRunnable createRunnable(final Object[] projects) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", projects.length);
                IStatus errorStatus = null;
                for (int i = 0; i < projects.length; ++i) {
                    IProject project = (IProject)projects[i];
                    try {
                        project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        continue;
                    }
                    catch (CoreException e) {
                        errorStatus.merge(e.getStatus());
                    }
                }
                monitor.done();
                if (errorStatus != null) {
                    throw new CoreException(errorStatus);
                }
            }
        };
    }

    private Object[] getClosedProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>(5);
        for (int i = 0; i < projects.length; ++i) {
            IProject project = projects[i];
            if (project.isOpen()) continue;
            result.add(project);
        }
        return result.toArray();
    }

    private boolean hasCloseProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (projects[i].isOpen()) continue;
            return true;
        }
        return false;
    }
}

