/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.check.impl;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.sql.formater.DrSQLFormater;
import com.kingdee.bos.tool.check.VerifyReport;
import com.kingdee.bos.tool.check.VerifyUnit;
import java.math.BigDecimal;
import java.util.HashSet;

public class BaseCheckTableField
extends VerifyUnit {
    @Override
    public boolean check(VerifyReport report) {
        assert (this.getTarget() instanceof AbstractTableInfo);
        AbstractTableInfo table = (AbstractTableInfo)this.getTarget();
        MetaDataInfo md = new MetaDataInfo();
        md.setPackage(table.getPackage());
        md.setName(table.getName());
        md.setMetaDataType(table.getBOSType().toString());
        ColumnCollection columns = table.getColumns();
        if (columns.size() <= 0) {
            report.addError(md, "No column defined.");
            return false;
        }
        HashSet<String> set = new HashSet<String>();
        int columnSize = 0;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            DrSQLFormater formater = DrSQLFormater.instance;
            ColumnInfo column = columns.get(i);
            String n = column.getName();
            if (!formater.isValidateColumnName(n)) {
                report.addError(md, column.getName() + " is invalid column name.");
                return false;
            }
            set.add(column.getName().toUpperCase());
            if (column.getTypeName().equals((Object)SQLType.CHAR)) {
                if (column.getLength() > 254 || column.getLength() <= 0) {
                    report.addError(md, column.getName() + " has invalid type length.");
                    return false;
                }
                columnSize += column.getLength();
            } else if (column.getTypeName().equals((Object)SQLType.NCHAR)) {
                if (column.getLength() > 254 || column.getLength() <= 0) {
                    report.addError(md, column.getName() + " has invalid type length.");
                    return false;
                }
                columnSize += column.getLength() * 2;
            } else if (column.getTypeName().equals((Object)SQLType.VARCHAR)) {
                if (column.getLength() > 4000 || column.getLength() <= 0) {
                    report.addError(md, column.getName() + " has invalid type length.");
                    return false;
                }
                columnSize += column.getLength();
            } else if (column.getTypeName().equals((Object)SQLType.NVARCHAR)) {
                if (column.getLength() > 2000 || column.getLength() <= 0) {
                    report.addError(md, column.getName() + " has invalid type length.");
                    return false;
                }
                columnSize += column.getLength() * 2;
            } else if (column.getTypeName().equals((Object)SQLType.CLOB)) {
                if (column.getLength() > 0x40000000 || column.getLength() <= 0) {
                    report.addError(md, column.getName() + " has invalid type length.");
                    return false;
                }
            } else if (column.getTypeName().equals((Object)SQLType.BINARY) || column.getTypeName().equals((Object)SQLType.VARBINARY)) {
                if (column.getLength() > 2000 || column.getLength() <= 0) {
                    report.addError(md, column.getName() + " has invalid type length.");
                    return false;
                }
            } else if (column.getTypeName().equals((Object)SQLType.BLOB)) {
                if (column.getLength() > Integer.MAX_VALUE || column.getLength() <= 0) {
                    report.addError(md, column.getName() + " has invalid type length.");
                    return false;
                }
            } else if (column.getTypeName().equals((Object)SQLType.NUMERIC)) {
                if (column.getLength() > 38 || column.getLength() <= 0) {
                    report.addError(md, column.getName() + " has invalid precision.");
                    return false;
                }
                if (column.getScale() > column.getPrecision() || column.getScale() < 0) {
                    report.addError(md, column.getName() + " has invalid scale.");
                    return false;
                }
                columnSize += 17;
            }
            if (column.getDefaultValue() != null) {
                if (column.getTypeName().equals((Object)SQLType.INT)) {
                    if (Integer.getInteger(column.getDefaultValue()) == null) {
                        report.addError(md, column.getName() + " has invalid default value.");
                        return false;
                    }
                } else if (column.getTypeName().equals((Object)SQLType.NUMERIC)) {
                    try {
                        new BigDecimal(column.getDefaultValue());
                    }
                    catch (NumberFormatException e) {
                        report.addError(md, column.getName() + " has invalid default value.");
                        return false;
                    }
                }
            }
            if (!column.isMultilingual() || column.isNullable()) continue;
            report.addError(md, column.getName() + " supply multiLanguage, must be nullable.");
            return false;
        }
        if (set.size() < columns.size()) {
            report.addError(md, table.getName() + " has same name column.");
            return false;
        }
        if (columnSize > 8000) {
            report.addError(md, "Total of all column's byte size is more than 8000.");
            return false;
        }
        return true;
    }
}

