/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.context;

import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.tool.utils.XMLResourceManager;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.jdom2.Element;

public class SolutionDescription {
    public static final String SOLUTION_FILENAME = ".solution.xml";
    public static final String SOLUTION_NAME = "name";
    public static final String SOLUTION_SOURCE = "source";
    public static final String SOLUTION_RESOURCE = "resource";
    public static final String SOLUTION_IS_EXT_SOLUTION = "isExtendSolution";
    public static final String SOLUTION_IS_NEW_SOLUTION = "isNewSolution";
    public static final String SOLUTION_STD_DIRS = "stdDirs";
    public static final String SOLUTION_EXT_DIRS = "extDirs";
    public static final String SOLUTION_STD_DIR = "stdDir";
    public static final String SOLUTION_EXT_DIR = "extDir";
    public static final String EXT_SOLUTION_BASE_TEMP_DIR = "basetemp";
    public static final String EXT_SOLUTION_EXPORT_TEMP_DIR = "exporttemp";
    private String solutionName;
    private String srcName;
    private String resName;
    private boolean isExtSolution;
    private boolean isNewSolution;
    private Vector stdDirs = new Vector();
    private Vector extDirs = new Vector();

    private SolutionDescription() {
    }

    public static SolutionDescription getSolutionDescriptor(IMDProject project) {
        List extDirsList;
        Element extDirsEle;
        List stdDirsList;
        assert (project != null);
        File file = new File(project.toFile(), SOLUTION_FILENAME);
        if (!file.exists()) {
            return null;
        }
        Element eroot = XMLResourceManager.loadFromXML((String)file.getAbsolutePath());
        if (eroot == null) {
            return null;
        }
        SolutionDescription description = new SolutionDescription();
        description.solutionName = eroot.getChild(SOLUTION_NAME) == null ? eroot.getAttributeValue(SOLUTION_NAME) : eroot.getChild(SOLUTION_NAME).getText();
        description.srcName = eroot.getChild(SOLUTION_SOURCE) == null ? eroot.getAttributeValue(SOLUTION_SOURCE) : eroot.getChild(SOLUTION_SOURCE).getText();
        description.resName = eroot.getChild(SOLUTION_RESOURCE) == null ? eroot.getAttributeValue(SOLUTION_RESOURCE) : eroot.getChild(SOLUTION_RESOURCE).getText();
        description.isExtSolution = eroot.getChild(SOLUTION_IS_EXT_SOLUTION) == null ? false : Boolean.valueOf(eroot.getChild(SOLUTION_IS_EXT_SOLUTION).getText());
        description.isNewSolution = eroot.getChild(SOLUTION_IS_NEW_SOLUTION) == null ? false : Boolean.valueOf(eroot.getChild(SOLUTION_IS_NEW_SOLUTION).getText());
        Element stdDirsEle = eroot.getChild(SOLUTION_STD_DIRS);
        if (stdDirsEle != null && (stdDirsList = stdDirsEle.getChildren(SOLUTION_STD_DIR)) != null) {
            int j = stdDirsList.size();
            for (int i = 0; i < j; ++i) {
                Element stdDirEle = (Element)stdDirsList.get(i);
                if (stdDirEle == null) continue;
                description.stdDirs.add(stdDirEle.getText());
            }
        }
        if ((extDirsEle = eroot.getChild(SOLUTION_EXT_DIRS)) != null && (extDirsList = extDirsEle.getChildren(SOLUTION_EXT_DIR)) != null) {
            int j = extDirsList.size();
            for (int i = 0; i < j; ++i) {
                Element extDirEle = (Element)extDirsList.get(i);
                if (extDirEle == null) continue;
                description.extDirs.add(extDirEle.getText());
            }
        }
        return description;
    }

    public static SolutionDescription getSolutionDescriptor(IProject project) {
        List extDirsList;
        Element extDirsEle;
        List stdDirsList;
        assert (project != null);
        IFile file = project.getFile(SOLUTION_FILENAME);
        if (file == null || !file.exists() && !new File(file.getLocation().toOSString()).exists()) {
            return null;
        }
        String filename = file.getLocation().toOSString();
        if (StringUtils.isEmpty((String)filename)) {
            return null;
        }
        Element eroot = XMLResourceManager.loadFromXML((String)filename);
        if (eroot == null) {
            return null;
        }
        SolutionDescription description = new SolutionDescription();
        description.solutionName = eroot.getChild(SOLUTION_NAME) == null ? eroot.getAttributeValue(SOLUTION_NAME) : eroot.getChild(SOLUTION_NAME).getText();
        description.srcName = eroot.getChild(SOLUTION_SOURCE) == null ? eroot.getAttributeValue(SOLUTION_SOURCE) : eroot.getChild(SOLUTION_SOURCE).getText();
        description.resName = eroot.getChild(SOLUTION_RESOURCE) == null ? eroot.getAttributeValue(SOLUTION_RESOURCE) : eroot.getChild(SOLUTION_RESOURCE).getText();
        description.isExtSolution = eroot.getChild(SOLUTION_IS_EXT_SOLUTION) == null ? false : Boolean.valueOf(eroot.getChild(SOLUTION_IS_EXT_SOLUTION).getText());
        description.isNewSolution = eroot.getChild(SOLUTION_IS_NEW_SOLUTION) == null ? false : Boolean.valueOf(eroot.getChild(SOLUTION_IS_NEW_SOLUTION).getText());
        Element stdDirsEle = eroot.getChild(SOLUTION_STD_DIRS);
        if (stdDirsEle != null && (stdDirsList = stdDirsEle.getChildren(SOLUTION_STD_DIR)) != null) {
            int j = stdDirsList.size();
            for (int i = 0; i < j; ++i) {
                Element stdDirEle = (Element)stdDirsList.get(i);
                if (stdDirEle == null) continue;
                description.stdDirs.add(stdDirEle.getText());
            }
        }
        if ((extDirsEle = eroot.getChild(SOLUTION_EXT_DIRS)) != null && (extDirsList = extDirsEle.getChildren(SOLUTION_EXT_DIR)) != null) {
            int j = extDirsList.size();
            for (int i = 0; i < j; ++i) {
                Element extDirEle = (Element)extDirsList.get(i);
                if (extDirEle == null) continue;
                description.extDirs.add(extDirEle.getText());
            }
        }
        return description;
    }

    public String getResName() {
        return this.resName;
    }

    public String getSolutionName() {
        return this.solutionName;
    }

    public String getSrcName() {
        return this.srcName;
    }

    public Vector getExtDirs() {
        return this.extDirs;
    }

    public boolean isExtSolution() {
        return this.isExtSolution;
    }

    public Vector getStdDirs() {
        return this.stdDirs;
    }

    public boolean isNewSolution() {
        return this.isNewSolution;
    }
}

