/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dao;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.engine.MDNotFoundException;
import com.kingdee.bos.engine.MDSaveException;
import com.kingdee.bos.md.dao.MDORMUtil;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.context.IToolContext;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.util.BOSObjectType;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class ORMStudioBridger {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.tool.dao.ORMStudioBridger");

    public static IObjectValue load(IFolder folder, IMetaDataPK metaDataPK, BOSObjectType bosType) throws IDEException {
        IFile file = ORMStudioBridger.getFileByPK(folder, metaDataPK, bosType);
        return ORMStudioBridger.load(file);
    }

    public static IObjectValue load(IProject project, BOSObjectType bosType, IMetaDataPK metaDataPK) throws IDEException {
        IToolContext ctx = ToolContextManager.getContext(project);
        IFolder folder = project.getFolder(ctx.getSrcName());
        IDevMetadataLoader loader = ToolContextManager.getMetadataLoader(folder);
        AbstractMetaDataValue ov = null;
        try {
            ov = loader.loadMetadata(bosType, metaDataPK);
        }
        catch (MDNotFoundException e) {
            logger.error((Object)e, (Throwable)e);
            throw new IDEException((Throwable)e);
        }
        return ov;
    }

    public static IObjectValue[] loadFromFolder(IFolder folder, BOSObjectType bosType, boolean deep) throws IDEException {
        IToolContext ctx;
        String srcName;
        IProject project = folder.getProject();
        String folderStr = folder.getLocation().toPortableString();
        if ((folderStr = folderStr.substring(project.getLocation().toPortableString().length())).startsWith("/") || folderStr.startsWith("\\")) {
            folderStr = folderStr.substring(1);
        }
        if ((folderStr = folderStr.substring((srcName = (ctx = ToolContextManager.getContext(project)).isExtSolution() ? (String)ctx.getExtDirs().get(0) : ctx.getSrcName()).length())).startsWith("/") || folderStr.startsWith("\\")) {
            folderStr = folderStr.substring(1);
        }
        folderStr = folderStr.replaceAll("/", ".");
        IDevMetadataLoader loader = ToolContextManager.getMetadataLoader(folder);
        try {
            return loader.loadMetadataByPackage(bosType, folderStr, deep);
        }
        catch (MDNotFoundException e) {
            logger.error((Object)"error:", (Throwable)e);
            throw new IDEException("\u8f7d\u5165\u5143\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    public static IObjectValue load(IFile file) throws IDEException {
        if (file == null) {
            return null;
        }
        try {
            return MDORMUtil.load(MDResourceUtil.toMDFile(file));
        }
        catch (MDNotFoundException e) {
            throw new IDEException((Throwable)e);
        }
    }

    public static IObjectValue getValue(IProject project, BOSObjectType bosType, IMetaDataPK pk) throws IDEException {
        return ORMStudioBridger.load(project, bosType, pk);
    }

    public static void store(IFolder folder, IObjectValue model) throws IDEException {
        if (folder == null || model == null) {
            return;
        }
        IDevMetadataLoader loader = null;
        if (model instanceof SolutionInfo) {
            ToolContextManager.removeLoader(folder.getProject());
            loader = ToolContextManager.getMetadataLoader(folder);
            loader.initSolution((SolutionInfo)model);
        }
        try {
            loader = ToolContextManager.getMetadataLoader(folder);
            loader.saveMetadata((AbstractMetaDataValue)model);
        }
        catch (MDSaveException e) {
            logger.error((Object)e, (Throwable)e);
            throw new IDEException(e.getMessage(), (Throwable)e);
        }
    }

    public static void updataSolution(IFolder folder, IObjectValue model) throws IDEException {
        if (folder == null || model == null) {
            return;
        }
        IDevMetadataLoader loader = null;
        try {
            loader = ToolContextManager.getMetadataLoader(folder);
            loader.saveMetadata((AbstractMetaDataValue)model);
        }
        catch (MDSaveException e) {
            logger.error((Object)e, (Throwable)e);
            throw new IDEException(e.getMessage(), (Throwable)e);
        }
    }

    public static IMetaDataPK getFilePK(IResource res) {
        if (res == null) {
            return null;
        }
        IFolder folder = ORMStudioBridger.getFolder(res);
        if (folder == null) {
            return null;
        }
        String folderStr = folder.getLocation().toPortableString();
        String resStr = res.getLocation().toPortableString();
        resStr = resStr.replaceFirst(folderStr, "");
        String fileName = res.getName();
        String pkStr = "";
        if (res instanceof IFolder) {
            pkStr = resStr;
            if (pkStr.startsWith("/") || pkStr.startsWith("\\")) {
                pkStr = pkStr.substring(1);
            }
            fileName = "";
        } else {
            int index = resStr.lastIndexOf(47);
            if (index > 1) {
                pkStr = resStr.substring(1, index);
            }
            if ((index = fileName.indexOf(46)) > -1) {
                fileName = fileName.substring(0, index);
            }
        }
        pkStr = pkStr.replaceAll("/", ".");
        return new MetaDataPK(pkStr, fileName);
    }

    public static IFile getFileByPK(IFolder folder, IMetaDataPK pk, BOSObjectType bosType) {
        if (folder == null || pk == null || bosType == null) {
            return null;
        }
        String pkName = pk.getPackage();
        StringTokenizer st = new StringTokenizer(pkName, ".");
        IFolder ffolder = folder;
        IFolder pfolder = folder;
        while (st.hasMoreTokens()) {
            pfolder = ffolder = pfolder.getFolder(st.nextToken());
        }
        String fileName = pk.getName();
        String suf = Utils.getMetaDataSuffix((BOSObjectType)bosType);
        fileName = fileName + suf;
        return ffolder.getFile(fileName);
    }

    public static IFolder getFolder(IResource res) {
        int index;
        if (res == null) {
            return null;
        }
        IProject pro = res.getProject();
        if (pro == null || pro.getLocation() == null) {
            return null;
        }
        String proStr = pro.getLocation().toPortableString();
        String iniFolderStr = res.getLocation().toPortableString();
        String folderStr = iniFolderStr.replaceFirst(proStr, "");
        if (folderStr.startsWith("/")) {
            folderStr = folderStr.substring(1);
        }
        if ((index = folderStr.indexOf(47)) > -1) {
            folderStr = folderStr.substring(0, index);
        }
        if (folderStr != null && folderStr.equals("")) {
            IToolContext ctx = ToolContextManager.getContext(pro);
            folderStr = ctx.isExtSolution() ? (String)ctx.getExtDirs().get(0) : ctx.getSrcName();
        }
        IFolder rfolder = pro.getFolder(folderStr);
        return rfolder;
    }

    public static BOSObjectType getBOSTypeByFileName(String fileName) {
        String ext;
        String extension;
        if (fileName == null || fileName.length() < 1) {
            return null;
        }
        int dot = fileName.lastIndexOf(".");
        if (dot != -1 && fileName.length() > dot + 1 && (extension = fileName.substring(dot + 1)) != null && extension.length() > 1 && (ext = Utils.getBOSTypeBySuffix((String)extension)) != null) {
            return BOSObjectType.create((String)ext);
        }
        return null;
    }
}

