/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dao;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.xml.Utils;
import com.kingdee.bos.dao.xml.XMLLoader;
import com.kingdee.bos.engine.IDevMetadataLoader;
import com.kingdee.bos.md.mdfs.IMDProject;
import com.kingdee.bos.md.mdfs.MDResourceUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.tool.common.IDEException;
import com.kingdee.bos.tool.context.ToolContextManager;
import com.kingdee.bos.tool.dao.Messages;
import com.kingdee.bos.tool.dao.ORMStudioBridger;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class ObjectValueHelper {
    private static IObjectValue getModel(IObjectValue model, String key, BOSObjectType[] types) throws IDEException {
        if (model == null) {
            return null;
        }
        String[] keys = StringUtils.split((String)key, (String)".");
        int size = keys.length - 1;
        for (int i = 0; i < size; ++i) {
            Object obj = model.get(keys[i]);
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof IObjectValue)) {
                throw new IDEException("IObjectValue.[" + keys[i] + Messages.ObjectValueHelper_ShuXingDeZhiBuWeiIOBJECTVALUELeiXing);
            }
            if (types != null && types.length > i) {
                BOSObjectType bosType = types[i];
                if (!((IObjectValue)obj).getBOSType().equals((Object)bosType)) {
                    return null;
                }
            }
            model = (IObjectValue)obj;
        }
        return model;
    }

    public static String getStringFromModel(IObjectValue model, String key) throws IDEException {
        return ObjectValueHelper.getStringFromModel(model, key, null);
    }

    public static String getStringFromModel(IObjectValue model, String key, BOSObjectType[] types) throws IDEException {
        if ((model = ObjectValueHelper.getModel(model, key, types)) != null) {
            String[] keys = StringUtils.split((String)key, (String)".");
            return model.getString(keys[keys.length - 1]);
        }
        return null;
    }

    public static boolean getBooleanFromModel(IObjectValue model, String key) throws IDEException {
        return ObjectValueHelper.getBooleanFromModel(model, key, null);
    }

    public static boolean getBooleanFromModel(IObjectValue model, String key, BOSObjectType[] types) throws IDEException {
        if ((model = ObjectValueHelper.getModel(model, key, types)) != null) {
            String[] keys = StringUtils.split((String)key, (String)".");
            return model.getBoolean(keys[keys.length - 1]);
        }
        return false;
    }

    public static Object getObjectFromModel(IObjectValue model, String key) throws IDEException {
        return ObjectValueHelper.getObjectFromModel(model, key, null);
    }

    public static Object getObjectFromModel(IObjectValue model, String key, BOSObjectType[] types) throws IDEException {
        if ((model = ObjectValueHelper.getModel(model, key, types)) != null) {
            String[] keys = StringUtils.split((String)key, (String)".");
            return model.get(keys[keys.length - 1]);
        }
        return null;
    }

    public static void setObjectIntoModel(IObjectValue model, String key, Object value, IFile file) throws IDEException {
        ObjectValueHelper.setObjectIntoModel(model, key, null, value, file);
    }

    public static void setObjectIntoModel(IObjectValue model, String key, BOSObjectType[] types, Object value, IFile file) throws IDEException {
        if (model == null) {
            return;
        }
        String[] keys = StringUtils.split((String)key, (String)".");
        boolean isMultiLang = false;
        Locale locale = ToolContextManager.getContext(file.getProject()).getORMContext().getLocale();
        int size = keys.length - 1;
        for (int i = 0; i < size; ++i) {
            Object obj = model.get(keys[i]);
            if (obj == null || !(obj instanceof IObjectValue)) {
                if (types == null || types.length <= i) {
                    return;
                }
                obj = Utils.createInfo((BOSObjectType)types[i]);
                try {
                    Context ctx = ToolContextManager.getORMContext(file.getProject());
                    XMLLoader loader = MDResourceUtil.getXMLLoader(ctx);
                    EntityObjectInfo meta = loader.loadMeta(model.getBOSType());
                    PropertyInfo property = meta.getPropertyByName(key);
                    if (property != null) {
                        isMultiLang = property.getBoolean("isMultilingual");
                    }
                }
                catch (DataAccessException e) {
                    throw new IDEException((Throwable)e);
                }
                if (isMultiLang) {
                    model.put(keys[i], obj, locale);
                } else {
                    model.put(keys[i], obj);
                }
            }
            if (!(obj instanceof IObjectValue)) {
                throw new IDEException("IObjectValue.[" + keys[i] + Messages.ObjectValueHelper_ShuXingDeZhiBuWeiIOBJECTVALUELeiXing);
            }
            if (types != null && types.length > i && !((IObjectValue)obj).getBOSType().equals((Object)types[i])) {
                obj = Utils.createInfo((BOSObjectType)types[i]);
                model.put(keys[i], obj);
            }
            model = (IObjectValue)obj;
        }
        try {
            IDevMetadataLoader loader2 = ToolContextManager.getMetadataLoader(ORMStudioBridger.getFolder((IResource)file));
            XMLLoader loader = loader2.getMetametaLoader();
            EntityObjectInfo meta = loader.loadMeta(model.getBOSType());
            PropertyInfo property = meta.getPropertyByName(key);
            if (property != null) {
                isMultiLang = property.getBoolean("isMultilingual");
            }
        }
        catch (DataAccessException e) {
            throw new IDEException((Throwable)e);
        }
        if (isMultiLang) {
            model.put(keys[keys.length - 1], value, locale);
        } else {
            model.put(keys[keys.length - 1], value);
        }
    }

    public static void setObjectIntoModel(IObjectValue model, String key, BOSObjectType[] types, Object value, IMDProject project) throws IDEException {
        if (model == null) {
            return;
        }
        String[] keys = StringUtils.split((String)key, (String)".");
        boolean isMultiLang = false;
        Locale locale = project.getORMContext().getLocale();
        int size = keys.length - 1;
        for (int i = 0; i < size; ++i) {
            Object obj = model.get(keys[i]);
            if (obj == null || !(obj instanceof IObjectValue)) {
                if (types == null || types.length <= i) {
                    return;
                }
                obj = Utils.createInfo((BOSObjectType)types[i]);
                try {
                    Context ctx = project.getORMContext();
                    XMLLoader loader = MDResourceUtil.getXMLLoader(ctx);
                    EntityObjectInfo meta = loader.loadMeta(model.getBOSType());
                    PropertyInfo property = meta.getPropertyByName(key);
                    if (property != null) {
                        isMultiLang = property.getBoolean("isMultilingual");
                    }
                }
                catch (DataAccessException e) {
                    throw new IDEException((Throwable)e);
                }
                if (isMultiLang) {
                    model.put(keys[i], obj, locale);
                } else {
                    model.put(keys[i], obj);
                }
            }
            if (!(obj instanceof IObjectValue)) {
                throw new IDEException("IObjectValue.[" + keys[i] + Messages.ObjectValueHelper_ShuXingDeZhiBuWeiIOBJECTVALUELeiXing);
            }
            if (types != null && types.length > i && !((IObjectValue)obj).getBOSType().equals((Object)types[i])) {
                obj = Utils.createInfo((BOSObjectType)types[i]);
                model.put(keys[i], obj);
            }
            model = (IObjectValue)obj;
        }
        try {
            IDevMetadataLoader loader2 = project.getMetadataLoader();
            XMLLoader loader = loader2.getMetametaLoader();
            EntityObjectInfo meta = loader.loadMeta(model.getBOSType());
            PropertyInfo property = meta.getPropertyByName(keys[keys.length - 1]);
            if (property != null) {
                isMultiLang = property.getBoolean("isMultilingual");
            }
        }
        catch (DataAccessException e) {
            throw new IDEException((Throwable)e);
        }
        if (isMultiLang) {
            model.put(keys[keys.length - 1], value, locale);
        } else {
            model.put(keys[keys.length - 1], value);
        }
    }
}

