/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.dbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexCollection;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.bos.tool.dbupdate.report.ColumnReportCollection;
import com.kingdee.bos.tool.dbupdate.report.ColumnReportItem;
import com.kingdee.bos.tool.dbupdate.report.ForeignKeyReportCollection;
import com.kingdee.bos.tool.dbupdate.report.ForeignKeyReportItem;
import com.kingdee.bos.tool.dbupdate.report.IndexReportCollection;
import com.kingdee.bos.tool.dbupdate.report.IndexReportItem;
import com.kingdee.bos.tool.dbupdate.report.PrimaryKeyReportItem;
import com.kingdee.bos.tool.dbupdate.report.Report;
import com.kingdee.bos.tool.dbupdate.report.ReportUtil;
import com.kingdee.bos.tool.dbupdate.report.TableReportCollection;
import com.kingdee.bos.tool.dbupdate.report.TableReportItem;
import java.util.Enumeration;
import java.util.Hashtable;

public class DBSchemaCompare {
    public static Report compareForMapping(AbstractTableInfo[] oldTables, AbstractTableInfo[] newTables) {
        Report diffReport = new Report();
        TableReportCollection tableReportCollection = diffReport.getTableReportCollection();
        int n = newTables.length;
        for (int i = 0; i < n; ++i) {
            TableReportItem tableReportItem = new TableReportItem();
            tableReportItem.setOldTable(oldTables[i]);
            tableReportItem.setNewTable(newTables[i]);
            if (oldTables[i] == null && newTables[i] == null) continue;
            if (oldTables[i] != null && newTables[i] != null) {
                tableReportItem.setItemName(newTables[i].getName());
                DBSchemaCompare.compareTable(tableReportItem);
            } else if (newTables[i] != null) {
                tableReportItem.setItemName(newTables[i].getName());
                tableReportItem.setReportState(0);
            } else if (oldTables[i] != null) {
                tableReportItem.setItemName(oldTables[i].getName());
                tableReportItem.setReportState(1);
            }
            tableReportItem.setTempTableName(ReportUtil.getTempTableName(tableReportItem));
            tableReportCollection.add(tableReportItem);
        }
        return diffReport;
    }

    public static Report compareForNoMapping(AbstractTableInfo[] oldTables, AbstractTableInfo[] newTables) {
        TableReportItem tableReportItem;
        int i;
        Report diffReport = new Report();
        TableReportCollection tableReportCollection = diffReport.getTableReportCollection();
        Hashtable<String, TableReportItem> tableReport = new Hashtable<String, TableReportItem>();
        int m = oldTables.length;
        for (i = 0; i < m; ++i) {
            if (oldTables[i] == null) continue;
            AbstractTableInfo oldTable = oldTables[i];
            tableReportItem = new TableReportItem();
            AbstractTableInfo newTable = null;
            int n = newTables.length;
            for (int j = 0; j < n; ++j) {
                if (newTables[j] == null || !oldTable.getName().equals(newTables[j].getName())) continue;
                newTable = newTables[j];
                break;
            }
            if (newTable != null) {
                tableReportItem.setOldTable(oldTable);
                tableReportItem.setNewTable(newTable);
                DBSchemaCompare.compareTable(tableReportItem);
            } else {
                tableReportItem.setOldTable(oldTable);
                tableReportItem.setReportState(1);
                DBSchemaCompare.compareSingleTable(tableReportItem);
            }
            tableReportItem.setItemName(oldTable.getName());
            tableReport.put(oldTable.getName().toUpperCase(), tableReportItem);
        }
        m = newTables.length;
        for (i = 0; i < m; ++i) {
            AbstractTableInfo newTable;
            if (newTables[i] == null || tableReport.containsKey((newTable = newTables[i]).getName().toUpperCase())) continue;
            tableReportItem = new TableReportItem();
            tableReportItem.setItemName(newTable.getName());
            tableReportItem.setNewTable(newTable);
            tableReportItem.setReportState(0);
            DBSchemaCompare.compareSingleTable(tableReportItem);
            tableReport.put(newTable.getName(), tableReportItem);
        }
        DBSchemaCompare.addTableReportItem(tableReportCollection, tableReport);
        return diffReport;
    }

    protected static void compareSingleTable(TableReportItem tableReportItem) {
        DBSchemaCompare.compareSingleTableColumn(tableReportItem);
        DBSchemaCompare.compareSingleTablePK(tableReportItem);
        DBSchemaCompare.compareSingleTableIndex(tableReportItem);
        DBSchemaCompare.compareSingleTableFK(tableReportItem);
    }

    protected static void compareSingleTableColumn(TableReportItem tableReportItem) {
        AbstractTableInfo table = null;
        int state = tableReportItem.getReportState();
        if (state == 0) {
            table = tableReportItem.getNewTable();
        } else if (state == 1) {
            table = tableReportItem.getOldTable();
        }
        if (table != null && table.getColumns() != null) {
            int n = table.getColumns().size();
            for (int i = 0; i < n; ++i) {
                ColumnInfo column = table.getColumns().get(i);
                ColumnReportItem item = new ColumnReportItem();
                item.setItemName(column.getName());
                item.setReportState(state);
                if (state == 0) {
                    item.setNewColumn(column);
                } else if (state == 1) {
                    item.setOldColumn(column);
                }
                tableReportItem.getColumnReportCollection().add(item);
            }
        }
    }

    protected static void compareSingleTablePK(TableReportItem tableReportItem) {
        AbstractTableInfo table = null;
        int state = tableReportItem.getReportState();
        if (state == 0) {
            table = tableReportItem.getNewTable();
        } else if (state == 1) {
            table = tableReportItem.getOldTable();
        }
        if (table != null && table.getPrimaryKey() != null) {
            PrimaryKeyInfo pk = table.getPrimaryKey();
            PrimaryKeyReportItem item = new PrimaryKeyReportItem();
            item.setItemName(pk.getName());
            item.setReportState(state);
            if (state == 0) {
                item.setNewPK(pk);
            } else if (state == 1) {
                item.setOldPK(pk);
            }
            tableReportItem.setPrimaryKeyReportItem(item);
        }
    }

    protected static void compareSingleTableIndex(TableReportItem tableReportItem) {
        AbstractTableInfo table = null;
        int state = tableReportItem.getReportState();
        if (state == 0) {
            table = tableReportItem.getNewTable();
        } else if (state == 1) {
            table = tableReportItem.getOldTable();
        }
        if (table != null && table.getIndexes() != null) {
            int n = table.getIndexes().size();
            for (int i = 0; i < n; ++i) {
                IndexInfo index = table.getIndexes().get(i);
                IndexReportItem item = new IndexReportItem();
                item.setItemName(index.getName());
                item.setReportState(state);
                if (state == 0) {
                    item.setNewIndex(index);
                } else if (state == 1) {
                    item.setOldIndex(index);
                }
                tableReportItem.getIndexReportCollection().add(item);
            }
        }
    }

    protected static void compareSingleTableFK(TableReportItem tableReportItem) {
        AbstractTableInfo table = null;
        int state = tableReportItem.getReportState();
        if (state == 0) {
            table = tableReportItem.getNewTable();
        } else if (state == 1) {
            table = tableReportItem.getOldTable();
        }
        if (table != null && table.getForeignKeys() != null) {
            int n = table.getForeignKeys().size();
            for (int i = 0; i < n; ++i) {
                ForeignKeyInfo fk = table.getForeignKeys().get(i);
                ForeignKeyReportItem item = new ForeignKeyReportItem();
                item.setItemName(fk.getName());
                item.setReportState(state);
                if (state == 0) {
                    item.setNewFK(fk);
                } else if (state == 1) {
                    item.setOldFK(fk);
                }
                tableReportItem.getForeignKeyReportCollection().add(item);
            }
        }
    }

    protected static void compareTable(TableReportItem tableReportItem) {
        DBSchemaCompare.compareColumn(tableReportItem);
        DBSchemaCompare.comparePK(tableReportItem);
        DBSchemaCompare.compareIndex(tableReportItem);
        DBSchemaCompare.compareFK(tableReportItem);
        DBSchemaCompare.compareView(tableReportItem);
        if (tableReportItem.getOldTable().getName().equalsIgnoreCase(tableReportItem.getNewTable().getName()) && tableReportItem.isSubSame()) {
            tableReportItem.setReportState(3);
        } else {
            tableReportItem.setReportState(2);
        }
    }

    protected static void compareColumn(TableReportItem tableReportItem) {
        ColumnReportItem item;
        int i;
        Hashtable<String, ColumnReportItem> columnsReport = new Hashtable<String, ColumnReportItem>();
        ColumnCollection oldColumns = tableReportItem.getOldTable().getColumns();
        ColumnCollection newColumns = tableReportItem.getNewTable().getColumns();
        boolean isSame = true;
        int m = oldColumns.size();
        for (i = 0; i < m; ++i) {
            ColumnInfo oldColumn = oldColumns.get(i);
            item = new ColumnReportItem();
            item.setItemName(oldColumn.getName());
            ColumnInfo newColumn = null;
            int n = newColumns.size();
            for (int j = 0; j < n; ++j) {
                if (!newColumns.get(j).getName().equalsIgnoreCase(oldColumn.getName())) continue;
                newColumn = newColumns.get(j);
                break;
            }
            if (newColumn != null) {
                item.setOldColumn(oldColumn);
                item.setNewColumn(newColumn);
                if (newColumn.equalsDB((Object)oldColumn)) {
                    item.setReportState(3);
                } else {
                    item.setReportState(2);
                    isSame = false;
                }
            } else {
                item.setOldColumn(oldColumn);
                item.setReportState(1);
                isSame = false;
            }
            columnsReport.put(oldColumn.getName().toUpperCase(), item);
        }
        m = newColumns.size();
        for (i = 0; i < m; ++i) {
            ColumnInfo newColumn = newColumns.get(i);
            if (columnsReport.containsKey(newColumn.getName().toUpperCase())) continue;
            item = new ColumnReportItem();
            item.setNewColumn(newColumn);
            item.setReportState(0);
            isSame = false;
            columnsReport.put(newColumn.getName().toUpperCase(), item);
        }
        if (!isSame) {
            tableReportItem.setSubSame(false);
        }
        DBSchemaCompare.addColumnReportItem(tableReportItem, columnsReport);
    }

    protected static void comparePK(TableReportItem tableReportItem) {
        PrimaryKeyReportItem reportItem = new PrimaryKeyReportItem();
        PrimaryKeyInfo oldPK = tableReportItem.getOldTable().getPrimaryKey();
        PrimaryKeyInfo newPK = tableReportItem.getNewTable().getPrimaryKey();
        boolean isSame = true;
        if (newPK != null && oldPK != null) {
            reportItem.setItemName(newPK.getName());
            if (newPK.equalsDB((Object)oldPK)) {
                reportItem.setReportState(3);
            } else {
                reportItem.setReportState(2);
                isSame = false;
            }
        } else {
            if (newPK == null && oldPK == null) {
                return;
            }
            if (oldPK != null) {
                reportItem.setItemName(oldPK.getName());
                reportItem.setReportState(1);
                isSame = false;
            } else if (newPK != null) {
                reportItem.setItemName(newPK.getName());
                reportItem.setReportState(0);
                isSame = false;
            }
        }
        reportItem.setOldPK(oldPK);
        reportItem.setNewPK(newPK);
        if (!isSame) {
            tableReportItem.setSubSame(false);
        }
        tableReportItem.setPrimaryKeyReportItem(reportItem);
    }

    protected static void compareView(TableReportItem tableReportItem) {
    }

    protected static void compareFK(TableReportItem tableReportItem) {
        ForeignKeyReportItem item;
        int i;
        Hashtable<String, ForeignKeyReportItem> fkReport = new Hashtable<String, ForeignKeyReportItem>();
        ForeignKeyCollection oldForeignKeys = tableReportItem.getOldTable().getForeignKeys();
        ForeignKeyCollection newForeignKeys = tableReportItem.getNewTable().getForeignKeys();
        boolean isSame = true;
        int m = oldForeignKeys.size();
        for (i = 0; i < m; ++i) {
            ForeignKeyInfo oldFK = oldForeignKeys.get(i);
            item = new ForeignKeyReportItem();
            item.setItemName(oldFK.getName());
            ForeignKeyInfo newFK = null;
            int n = newForeignKeys.size();
            for (int j = 0; j < n; ++j) {
                if (!newForeignKeys.get(j).equalsName((Object)oldFK)) continue;
                newFK = newForeignKeys.get(j);
                break;
            }
            if (newFK != null) {
                item.setOldFK(oldFK);
                item.setNewFK(newFK);
                if (newFK.equalsDB((Object)oldFK)) {
                    item.setReportState(3);
                } else {
                    item.setReportState(2);
                    isSame = false;
                }
            } else {
                item.setOldFK(oldFK);
                item.setReportState(1);
                isSame = false;
            }
            fkReport.put(oldFK.getName().toUpperCase(), item);
        }
        m = newForeignKeys.size();
        for (i = 0; i < m; ++i) {
            ForeignKeyInfo newFK = newForeignKeys.get(i);
            if (fkReport.containsKey(newFK.getName().toUpperCase())) continue;
            isSame = true;
            item = new ForeignKeyReportItem();
            item.setItemName(newFK.getName());
            item.setNewFK(newFK);
            item.setReportState(0);
            fkReport.put(newFK.getName().toUpperCase(), item);
        }
        if (!isSame) {
            tableReportItem.setSubSame(false);
        }
        DBSchemaCompare.addFKReportItem(tableReportItem, fkReport);
    }

    protected static void compareIndex(TableReportItem tableReportItem) {
        IndexReportItem item;
        int i;
        Hashtable<String, IndexReportItem> indexReport = new Hashtable<String, IndexReportItem>();
        IndexCollection oldIndexes = tableReportItem.getOldTable().getIndexes();
        IndexCollection newIndexes = tableReportItem.getNewTable().getIndexes();
        boolean isSame = true;
        int m = oldIndexes.size();
        for (i = 0; i < m; ++i) {
            IndexInfo oldIndex = oldIndexes.get(i);
            item = new IndexReportItem();
            IndexInfo newIndex = null;
            int n = newIndexes.size();
            for (int j = 0; j < n; ++j) {
                if (!newIndexes.get(j).equalsName((Object)oldIndex)) continue;
                newIndex = newIndexes.get(j);
                break;
            }
            if (newIndex != null) {
                item.setOldIndex(oldIndex);
                item.setNewIndex(newIndex);
                if (newIndex.equalsDB((Object)oldIndex)) {
                    item.setReportState(3);
                } else {
                    item.setReportState(2);
                    isSame = false;
                }
            } else {
                item.setOldIndex(oldIndex);
                item.setReportState(1);
                isSame = false;
            }
            item.setItemName(oldIndex.getName());
            indexReport.put(oldIndex.getName().toUpperCase(), item);
        }
        m = newIndexes.size();
        for (i = 0; i < m; ++i) {
            IndexInfo newIndex = newIndexes.get(i);
            if (indexReport.containsKey(newIndex.getName().toUpperCase())) continue;
            isSame = false;
            item = new IndexReportItem();
            item.setItemName(newIndex.getName());
            item.setNewIndex(newIndex);
            item.setReportState(0);
            indexReport.put(newIndex.getName().toUpperCase(), item);
        }
        if (!isSame) {
            tableReportItem.setSubSame(false);
        }
        DBSchemaCompare.addIndexReportItem(tableReportItem, indexReport);
    }

    protected static void addColumnReportItem(TableReportItem tableReportItem, Hashtable ht) {
        ColumnReportCollection reportCollection = tableReportItem.getColumnReportCollection();
        Enumeration e = ht.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String itemName = (String)e.nextElement();
            reportCollection.add((ColumnReportItem)ht.get(itemName));
            ++i;
        }
    }

    protected static void addFKReportItem(TableReportItem tableReportItem, Hashtable ht) {
        ForeignKeyReportCollection reportCollection = tableReportItem.getForeignKeyReportCollection();
        Enumeration e = ht.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String itemName = (String)e.nextElement();
            reportCollection.add((ForeignKeyReportItem)ht.get(itemName));
            ++i;
        }
    }

    protected static void addIndexReportItem(TableReportItem tableReportItem, Hashtable ht) {
        IndexReportCollection reportCollection = tableReportItem.getIndexReportCollection();
        Enumeration e = ht.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String itemName = (String)e.nextElement();
            reportCollection.add((IndexReportItem)ht.get(itemName));
            ++i;
        }
    }

    protected static void addTableReportItem(TableReportCollection tableReportCollection, Hashtable ht) {
        Enumeration e = ht.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            String itemName = (String)e.nextElement();
            TableReportItem item = (TableReportItem)ht.get(itemName);
            item.setTempTableName(ReportUtil.getTempTableName(item));
            tableReportCollection.add(item);
            ++i;
        }
        DBUtils.sortReport(tableReportCollection);
    }
}

