/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.dbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyCollection;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.tool.dbupdate.report.ColumnReportItem;
import com.kingdee.bos.tool.dbupdate.report.TableReportCollection;
import com.kingdee.bos.tool.dbupdate.report.TableReportItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

public class DBUtils {
    public static void sortReport(TableReportCollection items) {
        int i;
        ArrayList<TableReportItem> list = new ArrayList<TableReportItem>();
        int n = items.size();
        for (i = 0; i < n; ++i) {
            list.add(items.get(i));
        }
        Collections.sort(list);
        items.clear();
        n = list.size();
        for (i = 0; i < n; ++i) {
            items.add((TableReportItem)list.get(i));
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void excuteUpdateSQL(Connection cn, String sql) throws SQLException {
        block12: {
            block11: {
                stmt = null;
                s = "";
                if (cn instanceof KDConnection) ** GOTO lbl22
                databaseType = cn.getMetaData().getDatabaseProductName();
                if (databaseType != null && databaseType.length() > 0) break block11;
                cn.rollback();
                SQLUtils.cleanup((Statement)stmt);
                return;
            }
            try {
                block13: {
                    type = DbType.getValue((String)databaseType);
                    if (type == 1) {
                        s = TransUtil.Translate((String)sql, (int)1);
                    } else if (DBUtils.isOracle(type)) {
                        s = TransUtil.Translate((String)sql, (int)2);
                    } else if (type == 3) {
                        s = TransUtil.Translate((String)sql, (int)3);
                    }
                    break block13;
lbl22:
                    // 1 sources

                    s = sql;
                }
                stmt = cn.createStatement();
                stmt.execute(s);
            }
            catch (SqlTranslateException s) {
                cn.rollback();
                SQLUtils.cleanup(stmt);
                break block12;
            }
            catch (SQLException sqle) {
                try {
                    throw sqle;
                }
                catch (Throwable var6_8) {
                    cn.rollback();
                    SQLUtils.cleanup(stmt);
                    throw var6_8;
                }
            }
            cn.rollback();
            SQLUtils.cleanup((Statement)stmt);
        }
    }

    public static boolean dbHaveData(Connection cn, String tableName, String columnName) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        boolean haveData = false;
        try {
            int num;
            String sql = "";
            sql = columnName == null ? sql + "SELECT COUNT(*) FROM " + tableName : sql + "SELECT COUNT('" + columnName + "') FROM " + tableName;
            stmt = DBUtils.createPreparedStatement(cn, sql, new String[0]);
            rs = stmt.executeQuery();
            if (rs.next() && (num = rs.getInt(1)) > 0) {
                haveData = true;
            }
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((ResultSet)rs);
        return haveData;
    }

    public static boolean dbTableExisted(Connection cn, String tableName) throws SQLException {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        boolean existed = false;
        try {
            String databaseType = cn.getMetaData().getDatabaseProductName();
            int type = DbType.getValue((String)databaseType);
            if (DBUtils.isOracle(type)) {
                String sql = "SELECT TABLE_NAME FROM USER_TABLES  WHERE TABLE_NAME =?";
                stmt = DBUtils.createPreparedStatement(cn, "SELECT TABLE_NAME FROM USER_TABLES  WHERE TABLE_NAME =?", tableName.toUpperCase());
                rs = stmt.executeQuery();
            } else if (type == 1) {
                String sql = "SELECT NAME FROM SYSIBM.SYSTABLES WHERE TYPE='T' AND NAME=?";
                stmt = DBUtils.createPreparedStatement(cn, "SELECT NAME FROM SYSIBM.SYSTABLES WHERE TYPE='T' AND NAME=?", tableName.toUpperCase());
                rs = stmt.executeQuery();
            } else {
                rs = cn.getMetaData().getTables(null, null, tableName, new String[]{"TABLE"});
            }
            existed = rs.next();
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)stmt);
        return existed;
    }

    public static Vector getAllTableName(Connection cn) throws SQLException {
        ResultSet rs = null;
        Vector<String> vector = new Vector<String>(0);
        try {
            String databaseType = cn.getMetaData().getDatabaseProductName();
            int type = DbType.getValue((String)databaseType);
            rs = DBUtils.isOracle(type) ? cn.getMetaData().getTables(null, KSqlUtil.getOracleCurrentUser((Connection)cn), null, new String[]{"TABLE"}) : cn.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                vector.addElement(rs.getString("TABLE_NAME"));
            }
        }
        catch (SQLException sqle) {
            try {
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        Collections.sort(vector);
        return vector;
    }

    public static SQLType getSQLType(short dataType) {
        switch (dataType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return SQLType.INT;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return SQLType.NUMERIC;
            }
            case 1: {
                return SQLType.CHAR;
            }
            case 12: {
                return SQLType.VARCHAR;
            }
            case -1: {
                return SQLType.CLOB;
            }
            case 91: 
            case 92: 
            case 93: {
                return SQLType.DATETIME;
            }
            case -2: {
                return SQLType.BINARY;
            }
            case -3: {
                return SQLType.VARBINARY;
            }
            case -4: {
                return SQLType.BLOB;
            }
            case 2004: {
                return SQLType.BLOB;
            }
            case 2005: {
                return SQLType.CLOB;
            }
        }
        return null;
    }

    public static String getColSQL(int databaseType, ColumnInfo col) throws SQLException {
        String strdef;
        String sql = "";
        String sqlpost = DBUtils.getColDataType(databaseType, col);
        if (col.getDefaultValue() != null && !col.getDefaultValue().equals("") && !(strdef = DBUtils.getColDefaultValue(databaseType, col)).equals("")) {
            sqlpost = sqlpost + " DEFAULT " + strdef;
        }
        if (!col.isNullable()) {
            sqlpost = sqlpost + " NOT NULL ";
        }
        sql = col.getName() + " " + sqlpost;
        return sql;
    }

    public static String getColDataType(int databaseType, ColumnInfo col) throws SQLException {
        String sql = col.getTypeName().getName();
        int dataLength = col.getLength();
        if (col.getTypeName().equals((Object)SQLType.CHAR) || col.getTypeName().equals((Object)SQLType.VARCHAR) || col.getTypeName().equals((Object)SQLType.NCHAR) || col.getTypeName().equals((Object)SQLType.NVARCHAR) || col.getTypeName().equals((Object)SQLType.CLOB) || col.getTypeName().equals((Object)SQLType.BLOB) || col.getTypeName().equals((Object)SQLType.NCLOB) || col.getTypeName().equals((Object)SQLType.BINARY) || col.getTypeName().equals((Object)SQLType.VARBINARY)) {
            sql = sql + "(" + dataLength + ")";
        } else if (col.getTypeName().equals((Object)SQLType.NUMERIC)) {
            sql = sql + "(" + col.getPrecision() + "," + col.getScale() + ")";
        } else if (!col.getTypeName().equals((Object)SQLType.INT)) {
            if (col.getTypeName().equals((Object)SQLType.DATETIME)) {
                sql = "DateTime";
            } else {
                throw new SQLException("invalid col.DataType", col.getTypeName().getName());
            }
        }
        return sql;
    }

    public static boolean isOracle(int type) {
        return type == 2 || type == 8 || type == 7;
    }

    public static boolean isDB2(int type) {
        return 1 == type || 9 == type;
    }

    public static boolean isMSSQL(int type) {
        return 3 == type;
    }

    public static boolean isMySQL(int type) {
        return 6 == type;
    }

    public static boolean isSybase(int type) {
        return 4 == type;
    }

    public static boolean isPostgresSql(int type) {
        return 5 == type;
    }

    public static boolean isDM(int type) {
        return 11 == type;
    }

    public static boolean isKingbase(int type) {
        return 12 == type;
    }

    public static int getDbType(Connection cn) throws SQLException {
        String databaseType = cn.getMetaData().getDatabaseProductName().toUpperCase();
        return DbType.getValue((String)databaseType);
    }

    public static String getColDefaultValue(int databaseType, ColumnInfo col) throws SQLException {
        if (col.getDefaultValue().equals("")) {
            return "";
        }
        String sql = null;
        if (col.getTypeName().equals((Object)SQLType.NCHAR) || col.getTypeName().equals((Object)SQLType.NVARCHAR) || col.getTypeName().equals((Object)SQLType.NCLOB)) {
            if (col.getDefaultValue().startsWith("('") && col.getDefaultValue().endsWith("')")) {
                sql = col.getDefaultValue().trim();
                sql = sql.length() - 4 == 0 ? "" : StringUtils.replace((String)sql.substring(2, sql.length() - 2), (String)"'", (String)"''");
                sql = DBUtils.isOracle(databaseType) ? "N'" + sql + "'" : "'" + sql + "'";
            } else if ((col.getDefaultValue().startsWith("(N'") || col.getDefaultValue().startsWith("(n'")) && col.getDefaultValue().endsWith("')")) {
                sql = col.getDefaultValue().trim();
                sql = sql.length() - 5 == 0 ? "" : StringUtils.replace((String)sql.substring(3, sql.length() - 2), (String)"'", (String)"''");
                sql = DBUtils.isOracle(databaseType) ? "N'" + sql + "'" : "'" + sql + "'";
            } else if (col.getDefaultValue().startsWith("'") && col.getDefaultValue().endsWith("'")) {
                sql = col.getDefaultValue().trim();
                sql = sql.length() - 2 == 0 ? "" : StringUtils.replace((String)sql.substring(1, sql.length() - 1), (String)"'", (String)"''");
                sql = DBUtils.isOracle(databaseType) ? "N'" + sql + "'" : "'" + sql + "'";
            } else if ((col.getDefaultValue().startsWith("N'") || col.getDefaultValue().startsWith("n'")) && col.getDefaultValue().endsWith("'")) {
                sql = col.getDefaultValue().trim();
                sql = sql.length() - 3 == 0 ? "" : StringUtils.replace((String)sql.substring(2, sql.length() - 1), (String)"'", (String)"''");
                sql = DBUtils.isOracle(databaseType) ? "N'" + sql + "'" : "'" + sql + "'";
            } else {
                sql = DBUtils.isOracle(databaseType) ? "N'" + StringUtils.replace((String)col.getDefaultValue(), (String)"'", (String)"''") + "'" : "'" + StringUtils.replace((String)col.getDefaultValue(), (String)"'", (String)"''") + "'";
            }
        } else if (col.getTypeName().equals((Object)SQLType.CHAR) || col.getTypeName().equals((Object)SQLType.VARCHAR) || col.getTypeName().equals((Object)SQLType.CLOB) || col.getTypeName().equals((Object)SQLType.DATETIME)) {
            if (col.getDefaultValue().startsWith("('") && col.getDefaultValue().endsWith("')")) {
                sql = col.getDefaultValue().trim();
                sql = sql.length() - 4 == 0 ? "" : StringUtils.replace((String)sql.substring(2, sql.length() - 2), (String)"'", (String)"''");
                sql = "'" + sql + "'";
            } else if ((col.getDefaultValue().startsWith("(N'") || col.getDefaultValue().startsWith("(n'")) && col.getDefaultValue().endsWith("')")) {
                sql = col.getDefaultValue().trim();
                sql = sql.length() - 5 == 0 ? "" : StringUtils.replace((String)sql.substring(3, sql.length() - 2), (String)"'", (String)"''");
                sql = "'" + sql + "'";
            } else if (col.getDefaultValue().startsWith("'") && col.getDefaultValue().endsWith("'")) {
                sql = col.getDefaultValue().trim();
                sql = sql.length() - 2 == 0 ? "" : StringUtils.replace((String)sql.substring(1, sql.length() - 1), (String)"'", (String)"''");
                sql = "'" + sql + "'";
            } else if ((col.getDefaultValue().startsWith("N'") || col.getDefaultValue().startsWith("n'")) && col.getDefaultValue().endsWith("')")) {
                sql = col.getDefaultValue().trim();
                sql = sql.length() - 3 == 0 ? "" : StringUtils.replace((String)sql.substring(2, sql.length() - 2), (String)"'", (String)"''");
                sql = "'" + sql + "'";
            } else {
                sql = "'" + StringUtils.replace((String)col.getDefaultValue(), (String)"'", (String)"''") + "'";
            }
        } else if (col.getTypeName().equals((Object)SQLType.BLOB) || col.getTypeName().equals((Object)SQLType.BINARY) || col.getTypeName().equals((Object)SQLType.VARBINARY) || col.getTypeName().equals((Object)SQLType.NUMERIC) || col.getTypeName().equals((Object)SQLType.INT)) {
            sql = col.getDefaultValue().startsWith("(") && col.getDefaultValue().endsWith(")") ? ((sql = col.getDefaultValue().trim()).length() - 2 == 0 ? "" : sql.substring(1, sql.length() - 1)) : col.getDefaultValue().trim();
        } else {
            throw new SQLException("invalid col.DataType", col.getTypeName().getName());
        }
        return sql;
    }

    public static ColumnInfo getColumnByName(AbstractTableInfo table, String columnName) {
        int s = table.getColumns().size();
        for (int i = 0; i < s; ++i) {
            ColumnInfo col = table.getColumns().get(i);
            if (!col.getName().toUpperCase().equals(columnName.toUpperCase())) continue;
            return col;
        }
        return null;
    }

    public static void fillIndex(ResultSet rs, AbstractTableInfo table) throws SQLException {
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            if (indexName == null || table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
            IndexInfo index = null;
            for (int i = 0; i < table.getIndexes().size(); ++i) {
                if (!table.getIndexes().get(i).getName().equals(indexName)) continue;
                index = table.getIndexes().get(i);
                break;
            }
            if (index == null) {
                index = new IndexInfo();
                index.setName(rs.getString("INDEX_NAME"));
                index.setUnique(!rs.getBoolean("NON_UNIQUE"));
                table.getIndexes().add(index);
            }
            IndexColumnInfo indexColumn = new IndexColumnInfo();
            indexColumn.setColumn(DBUtils.getColumnByName(table, rs.getString("COLUMN_NAME")));
            indexColumn.setSortType(rs.getString("ASC_OR_DESC").equals("A") ? SortType.ASCEND : SortType.DESCEND);
            index.getIndexColumns().add(indexColumn);
        }
    }

    public static ForeignKeyCollection getRefFKList(Connection cn, String tableName) throws SQLException {
        ForeignKeyCollection fkList = new ForeignKeyCollection();
        ResultSet rs = cn.getMetaData().getExportedKeys(null, null, tableName);
        while (rs.next()) {
            String fkName = rs.getString("FK_NAME");
            ForeignKeyInfo fk = null;
            for (int i = 0; i < fkList.size(); ++i) {
                if (!fkList.get(i).getName().equals(fkName)) continue;
                fk = fkList.get(i);
                break;
            }
            if (fk == null) {
                fk = new ForeignKeyInfo();
                AbstractTableInfo refTable = new AbstractTableInfo();
                refTable.setName(rs.getString("FKTABLE_NAME"));
                fk.setRefTable(refTable);
                fk.setName(fkName);
                fkList.add(fk);
            }
            FKColumnPairInfo fkcol = new FKColumnPairInfo();
            ColumnInfo fkcolumn = new ColumnInfo();
            fkcolumn.setName(rs.getString("FKCOLUMN_NAME"));
            fkcol.setForeignKeyColumn(fkcolumn);
            ColumnInfo pkcolumn = new ColumnInfo();
            pkcolumn.setName(rs.getString("PKCOLUMN_NAME"));
            fkcol.setPrimaryKeyColumn(pkcolumn);
            fk.getFKColumnPairs().add(fkcol);
        }
        SQLUtils.cleanup((ResultSet)rs);
        return fkList;
    }

    public static Connection getNativeConnection(Connection cn) {
        Connection nativeCn = null;
        if (cn instanceof KDConnection) {
            KDConnection kdCn = (KDConnection)cn;
            nativeCn = kdCn.getNativeConnection();
            return nativeCn;
        }
        return cn;
    }

    public static boolean isColumnChangeValid(Connection cn, String tableName, ColumnReportItem item) throws SQLException {
        ColumnInfo oldColumn = item.getOldColumn();
        ColumnInfo newColumn = item.getNewColumn();
        if (DBUtils.dbHaveData(cn, tableName, oldColumn.getName())) {
            SQLType oldType = oldColumn.getTypeName();
            SQLType newType = newColumn.getTypeName();
            if (newColumn.getLength() < oldColumn.getLength() || oldColumn.getTypeName().equals((Object)SQLType.NUMERIC) && (newColumn.getPrecision() < oldColumn.getPrecision() || newColumn.getScale() < oldColumn.getScale())) {
                item.setLengthSub(true);
            }
            if (!newColumn.isNullable() && oldColumn.isNullable()) {
                item.setNull2NotNull(true);
            }
            if (!newType.equals((Object)oldType)) {
                if (oldType.equals((Object)SQLType.INT) && newType.equals((Object)SQLType.NUMERIC)) {
                    item.setTypeConvertState(1);
                } else if (oldType.equals((Object)SQLType.CHAR) && newType.equals((Object)SQLType.NUMERIC)) {
                    item.setTypeConvertState(2);
                } else if (oldType.equals((Object)SQLType.VARCHAR) && newType.equals((Object)SQLType.NUMERIC)) {
                    item.setTypeConvertState(3);
                } else if (oldType.equals((Object)SQLType.NUMERIC) && newType.equals((Object)SQLType.INT)) {
                    item.setTypeConvertState(4);
                } else if (oldType.equals((Object)SQLType.CHAR) && newType.equals((Object)SQLType.INT)) {
                    item.setTypeConvertState(5);
                } else if (oldType.equals((Object)SQLType.VARCHAR) && newType.equals((Object)SQLType.INT)) {
                    item.setTypeConvertState(6);
                } else if (oldType.equals((Object)SQLType.INT) && newType.equals((Object)SQLType.CHAR)) {
                    item.setTypeConvertState(7);
                } else if (oldType.equals((Object)SQLType.NUMERIC) && newType.equals((Object)SQLType.CHAR)) {
                    item.setTypeConvertState(8);
                } else if (oldType.equals((Object)SQLType.VARCHAR) && newType.equals((Object)SQLType.CHAR)) {
                    item.setTypeConvertState(9);
                } else if (oldType.equals((Object)SQLType.INT) && newType.equals((Object)SQLType.VARCHAR)) {
                    item.setTypeConvertState(10);
                } else if (oldType.equals((Object)SQLType.NUMERIC) && newType.equals((Object)SQLType.VARCHAR)) {
                    item.setTypeConvertState(11);
                } else if (oldType.equals((Object)SQLType.CHAR) && newType.equals((Object)SQLType.VARCHAR)) {
                    item.setTypeConvertState(12);
                } else if (oldType.equals((Object)SQLType.NCHAR) && newType.equals((Object)SQLType.CHAR)) {
                    item.setTypeConvertState(13);
                } else if (oldType.equals((Object)SQLType.NVARCHAR) && newType.equals((Object)SQLType.CHAR)) {
                    item.setTypeConvertState(14);
                } else if (oldType.equals((Object)SQLType.NCHAR) && newType.equals((Object)SQLType.VARCHAR)) {
                    item.setTypeConvertState(15);
                } else if (oldType.equals((Object)SQLType.NVARCHAR) && newType.equals((Object)SQLType.VARCHAR)) {
                    item.setTypeConvertState(16);
                } else if (oldType.equals((Object)SQLType.CHAR) && newType.equals((Object)SQLType.NCHAR)) {
                    item.setTypeConvertState(17);
                } else if (oldType.equals((Object)SQLType.VARCHAR) && newType.equals((Object)SQLType.NCHAR)) {
                    item.setTypeConvertState(18);
                } else if (oldType.equals((Object)SQLType.NVARCHAR) && newType.equals((Object)SQLType.NCHAR)) {
                    item.setTypeConvertState(19);
                } else if (oldType.equals((Object)SQLType.CHAR) && newType.equals((Object)SQLType.NVARCHAR)) {
                    item.setTypeConvertState(20);
                } else if (oldType.equals((Object)SQLType.VARCHAR) && newType.equals((Object)SQLType.NVARCHAR)) {
                    item.setTypeConvertState(21);
                } else if (oldType.equals((Object)SQLType.NCHAR) && newType.equals((Object)SQLType.NVARCHAR)) {
                    item.setTypeConvertState(22);
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    public static PreparedStatement createPreparedStatement(Connection cn, String sql, String param) throws SQLException {
        PreparedStatement stmt = cn.prepareStatement(sql);
        stmt.setString(1, param);
        return stmt;
    }

    public static PreparedStatement createPreparedStatement(Connection cn, String sql, String[] params) throws SQLException {
        if (params == null) {
            throw new SQLException(sql + " \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        PreparedStatement stmt = cn.prepareStatement(sql);
        for (int i = 0; i < params.length; ++i) {
            stmt.setString(i + 1, params[i]);
        }
        return stmt;
    }
}

