/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.kdbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataViewCollection;
import com.kingdee.bos.metadata.data.DataViewInfo;
import com.kingdee.bos.metadata.data.FKColumnPairInfo;
import com.kingdee.bos.metadata.data.ForeignKeyInfo;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.tool.LogTool;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.bos.tool.dbupdate.kdbtools.KDBUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;

public class DB2DAOUtil {
    public static AbstractTableInfo getTable(Connection cn, String tableName) throws SQLException {
        String sql;
        PreparedStatement stmt;
        ResultSet rs;
        if (cn instanceof KDConnection) {
            cn = ((KDConnection)cn).getNativeConnection();
        }
        if (!(rs = (stmt = DBUtils.createPreparedStatement(cn, sql = "SELECT NAME FROM SYSIBM.SYSTABLES WHERE TYPE='T' AND NAME=?", tableName.toUpperCase(Locale.ENGLISH))).executeQuery()).next()) {
            return null;
        }
        AbstractTableInfo table = new AbstractTableInfo();
        table.setName(tableName);
        DB2DAOUtil.fillColumnInfo(cn, table);
        DB2DAOUtil.fillPKInfo(cn, table);
        DB2DAOUtil.fillIndexInfo(cn, table);
        DB2DAOUtil.fillFKInfo(cn, table);
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return table;
    }

    private static void fillColumnInfo(Connection cn, AbstractTableInfo table) throws SQLException {
        String tableName = table.getName().toUpperCase(Locale.ENGLISH);
        String sql = "SELECT * FROM SYSIBM.SYSCOLUMNS WHERE TBNAME=?";
        PreparedStatement stmt = DBUtils.createPreparedStatement(cn, sql, tableName);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            ColumnInfo col = new ColumnInfo();
            col.setName(rs.getString("NAME").trim());
            col.setTypeName(DB2DAOUtil.getSQLType(rs.getString("COLTYPE")));
            col.setDefaultValue(rs.getString("DEFAULT"));
            col.setLength(rs.getInt("LONGLENGTH"));
            col.setNullable(rs.getString("NULLS").equals("Y"));
            col.setPrecision(rs.getInt("LONGLENGTH"));
            col.setScale(rs.getInt("SCALE"));
            table.getColumns().add(col);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    private static void fillPKInfo(Connection cn, AbstractTableInfo table) throws SQLException {
        String tableName = table.getName().toUpperCase(Locale.ENGLISH);
        String sql = "SELECT NAME,COLNAMES FROM SYSIBM.SYSINDEXES WHERE UNIQUERULE ='P' AND NAME NOT LIKE 'SQL%' AND TBNAME=?";
        PreparedStatement stmt = DBUtils.createPreparedStatement(cn, sql, tableName);
        ResultSet rs = stmt.executeQuery();
        boolean hasPK = false;
        if (rs.next()) {
            hasPK = true;
        } else {
            sql = "SELECT NAME,COLNAMES FROM SYSIBM.SYSINDEXES WHERE UNIQUERULE ='U' AND NAME NOT LIKE 'SQL%' AND TBNAME=? AND (NAME LIKE 'CPK_%' OR NAME LIKE 'PK_%')";
            stmt = DBUtils.createPreparedStatement(cn, sql, tableName);
            rs = stmt.executeQuery();
            hasPK = rs.next();
        }
        if (hasPK) {
            PrimaryKeyInfo pk = new PrimaryKeyInfo();
            table.setPrimaryKey(pk);
            pk.setName(rs.getString("NAME"));
            String strPK = rs.getString("COLNAMES");
            strPK = StringUtils.replace((String)strPK, (String)"+", (String)",");
            strPK = StringUtils.replace((String)strPK, (String)"-", (String)",");
            strPK = strPK.substring(1);
            String[] PKColumns = StringUtils.split((String)strPK, (String)",");
            for (int i = 0; i < PKColumns.length; ++i) {
                ColumnInfo col = DBUtils.getColumnByName(table, PKColumns[i]);
                PKColumnInfo pkcol = new PKColumnInfo();
                pkcol.setColumn(col);
                pk.getPKColumns().add(pkcol);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    private static void fillIndexInfo(Connection cn, AbstractTableInfo table) throws SQLException {
        String tableName = table.getName().toUpperCase(Locale.ENGLISH);
        String sql = "SELECT NAME,COLNAMES,UNIQUERULE FROM SYSIBM.SYSINDEXES WHERE NAME NOT LIKE 'SQL%' AND SYSTEM_REQUIRED = 0 AND TBNAME=?";
        PreparedStatement stmt = DBUtils.createPreparedStatement(cn, sql, tableName);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            String indexName = rs.getString("NAME");
            if (table.getPrimaryKey() != null && table.getPrimaryKey().getName().equals(indexName)) continue;
            IndexInfo index = new IndexInfo();
            index.setName(rs.getString("NAME"));
            index.setUnique(rs.getString("UNIQUERULE").equals("U"));
            String strIdx = rs.getString("COLNAMES");
            strIdx = StringUtils.replace((String)strIdx, (String)"+", (String)",+");
            strIdx = StringUtils.replace((String)strIdx, (String)"-", (String)",-");
            strIdx = strIdx.substring(1);
            String[] idxColumns = StringUtils.split((String)strIdx, (String)",");
            for (int i = 0; i < idxColumns.length; ++i) {
                IndexColumnInfo indexColumn = new IndexColumnInfo();
                String columnName = idxColumns[i].substring(1).trim();
                indexColumn.setColumn(DBUtils.getColumnByName(table, columnName.trim()));
                if (idxColumns[i].substring(0, 1).equals("-")) {
                    indexColumn.setSortType(SortType.DESCEND);
                }
                index.getIndexColumns().add(indexColumn);
            }
            table.getIndexes().add(index);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    private static void fillFKInfo(Connection cn, AbstractTableInfo table) throws SQLException {
        String tableName = table.getName().toUpperCase(Locale.ENGLISH);
        String sql = "SELECT * FROM SYSIBM.SYSRELS WHERE RELNAME NOT LIKE 'SQL%' AND TBNAME=?";
        PreparedStatement stmt = DBUtils.createPreparedStatement(cn, sql, tableName);
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            ForeignKeyInfo prevFK = new ForeignKeyInfo();
            AbstractTableInfo refTable = new AbstractTableInfo();
            refTable.setName(rs.getString("REFTBNAME"));
            prevFK.setRefTable(refTable);
            prevFK.setName(rs.getString("RELNAME"));
            String fkcolumns = rs.getString("FKCOLNAMES").trim();
            String pkcolumns = rs.getString("PKCOLNAMES").trim();
            while (!fkcolumns.equals("") && !pkcolumns.equals("")) {
                ColumnInfo pkcolumn;
                String colname;
                FKColumnPairInfo fkcol = new FKColumnPairInfo();
                int spaceindex = fkcolumns.indexOf(" ");
                if (spaceindex > 0) {
                    colname = fkcolumns.substring(0, spaceindex);
                    fkcol.setForeignKeyColumn(KDBUtils.getColumnByName(table, colname));
                    fkcolumns = fkcolumns.substring(spaceindex).trim();
                } else {
                    colname = fkcolumns;
                    fkcol.setForeignKeyColumn(KDBUtils.getColumnByName(table, colname));
                    fkcolumns = "";
                }
                spaceindex = pkcolumns.indexOf(" ");
                if (spaceindex > 0) {
                    colname = pkcolumns.substring(0, spaceindex);
                    pkcolumn = new ColumnInfo();
                    pkcolumn.setName(colname);
                    fkcol.setPrimaryKeyColumn(pkcolumn);
                    pkcolumns = pkcolumns.substring(spaceindex).trim();
                } else {
                    colname = pkcolumns;
                    pkcolumn = new ColumnInfo();
                    pkcolumn.setName(colname);
                    fkcol.setPrimaryKeyColumn(pkcolumn);
                    pkcolumns = "";
                }
                prevFK.getFKColumnPairs().add(fkcol);
            }
            table.getForeignKeys().add(prevFK);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    protected static SQLType getSQLType(String typeName) {
        if ((typeName = typeName.trim().toUpperCase(Locale.ENGLISH)).equals("TIME")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("TIMESTMP")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("INTEGER")) {
            return SQLType.INT;
        }
        if (typeName.equals("SMALLINT")) {
            return SQLType.INT;
        }
        if (typeName.equals("FLOAT")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("VARCHAR")) {
            return SQLType.VARCHAR;
        }
        if (typeName.equals("LONGVAR")) {
            return SQLType.CLOB;
        }
        if (typeName.equals("DECIMAL")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("GRAPHIC")) {
            return SQLType.NCHAR;
        }
        if (typeName.equals("VARGRAPH")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("VARG")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("LONGVARG")) {
            return SQLType.NCLOB;
        }
        if (typeName.equals("BIGINT")) {
            return SQLType.INT;
        }
        if (typeName.equals("DOUBLE")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("CHAR")) {
            return SQLType.CHAR;
        }
        LogTool.logError("Unknown SQL TYPE:" + typeName + ", Treat as NVARCHAR", new Exception("Unknown SQL TYPE"));
        return SQLType.NVARCHAR;
    }

    public static void adjustTables(Connection cn, AbstractTableInfo[] tables) throws SQLException {
        for (int i = 0; i < tables.length; ++i) {
            DB2DAOUtil.adjustTable(cn, tables[i]);
        }
    }

    public static void adjustTable(Connection cn, AbstractTableInfo table) throws SQLException {
        DataViewCollection dataViews = table.getDataViews();
        if (dataViews != null && dataViews.size() > 0) {
            String sql = "SELECT NAME FROM SYSIBM.SYSTABLES WHERE TYPE='V' AND NAME= ?";
            PreparedStatement stmt = cn.prepareStatement(sql);
            for (int i = 0; i < dataViews.size(); ++i) {
                DataViewInfo dataView = dataViews.get(i);
                String name = dataView.getName();
                if (StringUtils.isEmpty((String)name)) continue;
                stmt.setString(1, name);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    dataView.setExtendedProperty("view_exists", "true");
                }
                rs.close();
            }
            SQLUtils.cleanup(null, (Statement)stmt);
        }
    }
}

