/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.kdbtools;

import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.IndexColumnInfo;
import com.kingdee.bos.metadata.data.IndexInfo;
import com.kingdee.bos.metadata.data.PKColumnInfo;
import com.kingdee.bos.metadata.data.PrimaryKeyInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.tool.dbupdate.dbtools.DBUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DmDAOUtil {
    public static AbstractTableInfo getTable(Connection cn, String tableName) throws SQLException {
        if (cn instanceof KDConnection) {
            cn = ((KDConnection)cn).getNativeConnection();
        }
        String sql = "Select TABLE_NAME FROM USER_TABLES WHERE TABLE_NAME = ?";
        PreparedStatement stmt = cn.prepareStatement(sql);
        stmt.setString(1, tableName.toUpperCase());
        ResultSet rs = stmt.executeQuery();
        if (!rs.next()) {
            return null;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        AbstractTableInfo table = new AbstractTableInfo();
        table.setName(tableName);
        DmDAOUtil.fillColumnInfo(cn, table);
        DmDAOUtil.fillPKInfo(cn, table);
        DmDAOUtil.fillIndexInfo(cn, table);
        DmDAOUtil.fillFKInfo(cn, table);
        return table;
    }

    private static void fillColumnInfo(Connection cn, AbstractTableInfo table) throws SQLException {
        String tableName = table.getName().toUpperCase();
        String sql = "SELECT * FROM USER_TAB_COLUMNS WHERE TABLE_NAME=?";
        PreparedStatement stmt = cn.prepareStatement(sql);
        stmt.setString(1, tableName.toUpperCase());
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            ColumnInfo col = new ColumnInfo();
            col.setName(rs.getString("COLUMN_NAME"));
            String typeName = rs.getString("DATA_TYPE");
            if (typeName.equals("NUMBER") && rs.getInt("DATA_SCALE") == 0) {
                typeName = "LONG";
            }
            SQLType dataType = DmDAOUtil.getSQLType(typeName);
            col.setTypeName(dataType);
            String strDef = rs.getString("DATA_DEFAULT");
            if ("null".equalsIgnoreCase(strDef)) {
                strDef = null;
            }
            if (strDef != null && strDef.length() != 0 && (strDef = strDef.trim()).startsWith("( ") && strDef.endsWith(" )")) {
                strDef = "(" + strDef.substring(2, strDef.length() - 4).trim() + ")";
            }
            col.setDefaultValue(strDef);
            int length = rs.getInt("DATA_LENGTH");
            if (typeName.equals("NVARCHAR2") || typeName.equals("NCHAR") || typeName.equals("NCLOB")) {
                length = rs.getInt("CHAR_LENGTH");
            }
            col.setLength(length);
            col.setNullable(rs.getString("NULLABLE").equals("Y"));
            col.setPrecision(rs.getInt("DATA_PRECISION"));
            col.setScale(rs.getInt("DATA_SCALE"));
            table.getColumns().add(col);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    private static void fillPKInfo(Connection conn, AbstractTableInfo table) throws SQLException {
        String tableName = table.getName().toUpperCase();
        String sql = "/*dialect*/select USER as NAME from dual";
        PreparedStatement st = null;
        st = conn.prepareStatement(sql);
        ResultSet rs1 = st.executeQuery();
        String user = "";
        if (rs1.next()) {
            user = rs1.getString("NAME");
        }
        SQLUtils.cleanup((ResultSet)rs1, (Statement)st);
        DatabaseMetaData metadata = conn.getMetaData();
        ResultSet rs2 = metadata.getPrimaryKeys(null, user, tableName);
        if (rs2.next()) {
            PrimaryKeyInfo pk = new PrimaryKeyInfo();
            pk.setName(rs2.getString("PK_NAME"));
            table.setPrimaryKey(pk);
            ColumnInfo col = DBUtils.getColumnByName(table, rs2.getString("COLUMN_NAME"));
            PKColumnInfo pkcol = new PKColumnInfo();
            pkcol.setColumn(col);
            pk.getPKColumns().add(pkcol);
            while (rs2.next()) {
                col = DBUtils.getColumnByName(table, rs2.getString("COLUMN_NAME"));
                pkcol = new PKColumnInfo();
                pkcol.setColumn(col);
                pk.getPKColumns().add(pkcol);
            }
        }
        SQLUtils.cleanup((ResultSet)rs2, null);
    }

    private static void fillIndexInfo(Connection conn, AbstractTableInfo table) throws SQLException {
        String sql = "/*dialect*/select USER as NAME from dual";
        PreparedStatement st = conn.prepareStatement(sql);
        ResultSet rs1 = st.executeQuery();
        String user = "";
        if (rs1.next()) {
            user = rs1.getString("NAME");
        }
        SQLUtils.cleanup((ResultSet)rs1, (Statement)st);
        DatabaseMetaData metadata = conn.getMetaData();
        String tableName = table.getName().toUpperCase();
        ResultSet rs2 = metadata.getIndexInfo(null, user, tableName, true, true);
        while (rs2.next()) {
            IndexInfo index = new IndexInfo();
            index.setName(rs2.getString("INDEX_NAME"));
            index.setUnique(rs2.getString("NON_UNIQUE").equals("1"));
            IndexColumnInfo indexColumn = new IndexColumnInfo();
            ColumnInfo colInfo = new ColumnInfo();
            colInfo.setName(rs2.getString("COLUMN_NAME"));
            indexColumn.setColumn(colInfo);
            index.getIndexColumns().add(indexColumn);
            index.setExtendedProperty("HAS_CONSTRAINT", index.getName());
            table.getIndexes().add(index);
        }
        SQLUtils.cleanup((ResultSet)rs2, null);
    }

    private static void fillFKInfo(Connection cn, AbstractTableInfo table) throws SQLException {
    }

    protected static SQLType getSQLType(String typeName) {
        if (typeName.equals("VARCHAR2")) {
            return SQLType.VARCHAR;
        }
        if (typeName.equals("NVARCHAR2")) {
            return SQLType.NVARCHAR;
        }
        if (typeName.equals("NUMBER")) {
            return SQLType.NUMERIC;
        }
        if (typeName.equals("LONG")) {
            return SQLType.INT;
        }
        if (typeName.equals("DATE")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("TIMESTAMP(6)")) {
            return SQLType.DATETIME;
        }
        if (typeName.equals("CHAR")) {
            return SQLType.CHAR;
        }
        if (typeName.equals("NCHAR")) {
            return SQLType.NCHAR;
        }
        if (typeName.equals("CLOB")) {
            return SQLType.CLOB;
        }
        if (typeName.equals("NCLOB")) {
            return SQLType.NCLOB;
        }
        if (typeName.equals("BLOB")) {
            return SQLType.BLOB;
        }
        if (typeName.equals("RAW")) {
            return SQLType.BINARY;
        }
        if (typeName.equals("LONG RAW")) {
            return SQLType.VARBINARY;
        }
        System.out.println("Unknown SQL TYPE:" + typeName + ", Treat as NVARCHAR, Unknown SQL TYPE");
        return SQLType.NVARCHAR;
    }

    public static void adjustTables(Connection cn, AbstractTableInfo[] tables) throws SQLException {
        for (int i = 0; i < tables.length; ++i) {
            DmDAOUtil.adjustTable(cn, tables[i]);
        }
    }

    public static void adjustTable(Connection cn, AbstractTableInfo table) throws SQLException {
    }
}

