/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.tool.dbupdate.ui;

import com.kingdee.bos.tool.dbupdate.report.ColumnReportCollection;
import com.kingdee.bos.tool.dbupdate.report.ColumnReportItem;
import com.kingdee.bos.tool.dbupdate.report.ForeignKeyReportCollection;
import com.kingdee.bos.tool.dbupdate.report.ForeignKeyReportItem;
import com.kingdee.bos.tool.dbupdate.report.IndexReportCollection;
import com.kingdee.bos.tool.dbupdate.report.IndexReportItem;
import com.kingdee.bos.tool.dbupdate.report.PrimaryKeyReportItem;
import com.kingdee.bos.tool.dbupdate.report.ReportUtil;
import com.kingdee.bos.tool.dbupdate.report.TableReportItem;
import com.kingdee.bos.tool.dbupdate.ui.DBSynchronizer;
import com.kingdee.bos.tool.dbupdate.ui.DBSynchronizerMessages;
import com.kingdee.bos.tool.dbupdate.ui.TableCellModifier;
import com.kingdee.bos.tool.dbupdate.ui.TableLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class TableDiffDialog
extends TitleAreaDialog {
    private CTabFolder tabFolder;
    private StyledText txt;
    private Text txtTempTableName;
    private TableReportItem item;
    private ColumnReportCollection columns;
    private PrimaryKeyReportItem pk;
    private IndexReportCollection indexes;
    private ForeignKeyReportCollection fks;
    private Table columnTable;
    private Table pkTable;
    private Table indexTable;
    private Table fkTable;
    private TableViewer columnTableViewer;
    private TableViewer pkTableViewer;
    private TableViewer indexTableViewer;
    private TableViewer fkTableViewer;
    public static final String[] columnNames = new String[]{DBSynchronizerMessages.Master, DBSynchronizerMessages.Compare, DBSynchronizerMessages.Target};
    public static final String[] compareStateList = new String[]{"<", ">", "<>", "=", "?"};
    int style = 101124;
    private static final String TABLEDIFF = "TableDiff";
    private static final String TABLEDIFFREPORT = "TableDiffReport";
    private static final String TAB_COLUMN = "Column";
    private static final String TAB_PK = "PK";
    private static final String TAB_INDEX = "Index";
    private static final String TAB_FK = "FK";
    private static final String TAB_OTHER = "Other";
    private static final String TEMP_TABLE_NAME = "TempTableName";

    public TableDiffDialog(Shell parentShell, TableReportItem item) {
        super(parentShell);
        this.item = item;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(DBSynchronizerMessages.TableDiff);
        this.setTitle(DBSynchronizerMessages.TableDiffReport);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        composite.setLayout((Layout)gl);
        this.tabFolder = new CTabFolder(composite, 0x800080);
        data = new GridData(1808);
        data.heightHint = 120;
        this.tabFolder.setLayoutData((Object)data);
        this.createColumnItem();
        this.createPKItem();
        this.createIndexItem();
        this.createFKItem();
        this.createOtherItem();
        this.txt = new StyledText(composite, 2816);
        this.txt.setEditable(false);
        data = new GridData(1808);
        data.heightHint = 120;
        this.txt.setLayoutData((Object)data);
        this.initData();
        this.registerListeners();
        this.getShell().open();
        return composite;
    }

    private void createColumnItem() {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(DBSynchronizerMessages.Column);
        Composite container = new Composite((Composite)this.tabFolder, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        container.setLayout((Layout)gl);
        this.columnTable = new Table(container, this.style);
        this.columnTableViewer = new TableViewer(this.columnTable);
        this.createTable(this.columnTable, this.columnTableViewer, 1);
        item.setControl((Control)container);
    }

    private void createPKItem() {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(DBSynchronizerMessages.PK);
        Composite container = new Composite((Composite)this.tabFolder, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        container.setLayout((Layout)gl);
        this.pkTable = new Table(container, this.style);
        this.pkTableViewer = new TableViewer(this.pkTable);
        this.createTable(this.pkTable, this.pkTableViewer, 2);
        item.setControl((Control)container);
    }

    private void createIndexItem() {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(DBSynchronizerMessages.Index);
        Composite container = new Composite((Composite)this.tabFolder, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        container.setLayout((Layout)gl);
        this.indexTable = new Table(container, this.style);
        this.indexTableViewer = new TableViewer(this.indexTable);
        this.createTable(this.indexTable, this.indexTableViewer, 3);
        item.setControl((Control)container);
    }

    private void createFKItem() {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(DBSynchronizerMessages.FK);
        Composite container = new Composite((Composite)this.tabFolder, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        container.setLayout((Layout)gl);
        this.fkTable = new Table(container, this.style);
        this.fkTableViewer = new TableViewer(this.fkTable);
        this.createTable(this.fkTable, this.fkTableViewer, 4);
        item.setControl((Control)container);
    }

    private void createOtherItem() {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(DBSynchronizerMessages.Other);
        Composite container = new Composite((Composite)this.tabFolder, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        container.setLayout((Layout)gl);
        Label lab = new Label(container, 0);
        lab.setText(DBSynchronizerMessages.TempTableName);
        GridData data = new GridData();
        lab.setLayoutData((Object)data);
        this.txtTempTableName = new Text(container, 2048);
        data = new GridData(768);
        this.txtTempTableName.setLayoutData((Object)data);
        item.setControl((Control)container);
    }

    protected void okPressed() {
        super.okPressed();
    }

    private void createTable(Table table, TableViewer tableViewer, int type) {
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        table.setLayoutData((Object)data);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.createColumns(table);
        this.createTableViewer(table, tableViewer, type);
    }

    private void createColumns(Table table) {
        TableColumn column = new TableColumn(table, 0x1000000, 0);
        column.setText(columnNames[0]);
        column.setWidth(200);
        column = new TableColumn(table, 0x1000000, 1);
        column.setText(columnNames[1]);
        column.setWidth(100);
        column = new TableColumn(table, 0x1000000, 2);
        column.setText(columnNames[2]);
        column.setWidth(200);
    }

    private void createTableViewer(Table table, TableViewer tableViewer, int type) {
        tableViewer.setUseHashlookup(true);
        tableViewer.setColumnProperties(columnNames);
        CellEditor[] editors = new CellEditor[columnNames.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)table);
        editors[0] = textEditor;
        editors[1] = new ComboBoxCellEditor((Composite)table, compareStateList, 8);
        textEditor = new TextCellEditor((Composite)table);
        editors[2] = textEditor;
        tableViewer.setCellEditors(editors);
        TableLabelProvider tableLabelProvider = new TableLabelProvider();
        tableLabelProvider.type = type;
        tableViewer.setLabelProvider((IBaseLabelProvider)tableLabelProvider);
        TableContentProvider tableContentProvider = new TableContentProvider();
        tableContentProvider.type = type;
        tableViewer.setContentProvider((IContentProvider)tableContentProvider);
        TableCellModifier tableCellModifier = new TableCellModifier(tableViewer);
        tableCellModifier.type = type;
        tableViewer.setCellModifier((ICellModifier)tableCellModifier);
    }

    private void clear() {
        this.columnTable.removeAll();
        this.pkTable.removeAll();
        this.indexTable.removeAll();
        this.fkTable.removeAll();
    }

    private void initData() {
        if (this.item == null) {
            return;
        }
        this.columns = this.item.getColumnReportCollection();
        this.pk = this.item.getPrimaryKeyReportItem();
        this.indexes = this.item.getIndexReportCollection();
        this.fks = this.item.getForeignKeyReportCollection();
        this.fieldsLoad();
    }

    private void fieldsLoad() {
        this.columnTableViewer.setInput((Object)this.columns);
        this.pkTableViewer.setInput((Object)this.pk);
        this.indexTableViewer.setInput((Object)this.indexes);
        this.fkTableViewer.setInput((Object)this.fks);
        this.txtTempTableName.setText(this.item.getTempTableName());
    }

    private void registerListeners() {
        this.columnTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                TableDiffDialog.this.showColumnCompareInfo();
            }
        });
        this.pkTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                TableDiffDialog.this.showPKCompareInfo();
            }
        });
        this.indexTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                TableDiffDialog.this.showIndexCompareInfo();
            }
        });
        this.fkTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                TableDiffDialog.this.showFKCompareInfo();
            }
        });
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableDiffDialog.this.clearFocus();
            }

            public void widgetSelected(SelectionEvent e) {
                TableDiffDialog.this.clearFocus();
            }
        });
        this.txtTempTableName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TableDiffDialog.this.txtTempTableName.getText().length() > 30) {
                    TableDiffDialog.this.showLengthTooLongWarning();
                }
                TableDiffDialog.this.item.setTempTableName(TableDiffDialog.this.txtTempTableName.getText());
            }
        });
    }

    protected void showLengthTooLongWarning() {
        MessageDialog dlg = new MessageDialog(DBSynchronizer.getShell(), "warning", null, DBSynchronizerMessages.LengthTooLongWarning, 2, new String[]{"OK"}, 0);
        dlg.create();
        dlg.open();
    }

    private void clearFocus() {
        this.txt.setText("");
        this.columnTable.deselect(this.columnTable.getSelectionIndex());
        this.pkTable.deselect(this.pkTable.getSelectionIndex());
        this.indexTable.deselect(this.indexTable.getSelectionIndex());
        this.fkTable.deselect(this.fkTable.getSelectionIndex());
    }

    private void showColumnCompareInfo() {
        this.txt.setText("");
        int selectIndex = this.columnTable.getSelectionIndex();
        if (this.columnTable.getItem(selectIndex) != null && this.columnTable.getItem(selectIndex).getData() != null) {
            ColumnReportItem item = (ColumnReportItem)this.columnTable.getItem(selectIndex).getData();
            String compareContent = ReportUtil.getColumnCompareDesc(item);
            this.txt.setText(compareContent);
        }
    }

    private void showPKCompareInfo() {
        this.txt.setText("");
        int selectIndex = this.pkTable.getSelectionIndex();
        if (this.pkTable.getItem(selectIndex) != null && this.pkTable.getItem(selectIndex).getData() != null) {
            PrimaryKeyReportItem item = (PrimaryKeyReportItem)this.pkTable.getItem(selectIndex).getData();
            String compareContent = ReportUtil.getPKCompareDesc(item);
            this.txt.setText(compareContent);
        }
    }

    private void showIndexCompareInfo() {
        this.txt.setText("");
        int selectIndex = this.indexTable.getSelectionIndex();
        if (this.indexTable.getItem(selectIndex) != null && this.indexTable.getItem(selectIndex).getData() != null) {
            IndexReportItem item = (IndexReportItem)this.indexTable.getItem(selectIndex).getData();
            String compareContent = ReportUtil.getIndexCompareDesc(item);
            this.txt.setText(compareContent);
        }
    }

    private void showFKCompareInfo() {
        this.txt.setText("");
        int selectIndex = this.fkTable.getSelectionIndex();
        if (this.fkTable.getItem(selectIndex) != null && this.fkTable.getItem(selectIndex).getData() != null) {
            ForeignKeyReportItem item = (ForeignKeyReportItem)this.fkTable.getItem(selectIndex).getData();
            String compareContent = ReportUtil.getFKCompareDesc(item);
            this.txt.setText(compareContent);
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        public int type = 1;

        private TableContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (this.type == 2) {
                return new Object[]{TableDiffDialog.this.pk};
            }
            if (this.type == 3) {
                return TableDiffDialog.this.indexes.toArray();
            }
            if (this.type == 4) {
                return TableDiffDialog.this.fks.toArray();
            }
            return TableDiffDialog.this.columns.toArray();
        }
    }
}

